/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.actions;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.fileChooser.FileChooserPanel;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.actions.FileChooserAction;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.fileChooser.ex.FileChooserKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.ui.UIBundle;
import com.intellij.util.ui.IoErrorText;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public final class FileDeleteAction
extends FileChooserAction {
    @Deprecated(forRemoval=true)
    public FileDeleteAction() {
    }

    public FileDeleteAction(@NlsActions.ActionText String text2, @NlsActions.ActionDescription String description, Icon icon2) {
        super(text2, description, icon2);
    }

    @Override
    protected void update(@NotNull FileChooserPanel panel2, @NotNull AnActionEvent e) {
        if (panel2 == null) {
            FileDeleteAction.$$$reportNull$$$0(0);
        }
        if (e == null) {
            FileDeleteAction.$$$reportNull$$$0(1);
        }
        boolean visible = FileDeleteAction.isEnabled(e);
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(visible && (!(e.getInputEvent() instanceof KeyEvent) || !(e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT) instanceof JTextField)) && !panel2.selectedPaths().isEmpty());
    }

    @Override
    protected void actionPerformed(@NotNull FileChooserPanel panel2, @NotNull AnActionEvent e) {
        List paths;
        if (panel2 == null) {
            FileDeleteAction.$$$reportNull$$$0(2);
        }
        if (e == null) {
            FileDeleteAction.$$$reportNull$$$0(3);
        }
        if ((paths = panel2.selectedPaths()).isEmpty()) {
            return;
        }
        Project project2 = e.getProject();
        boolean ok = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)UIBundle.message((String)"file.chooser.delete.title", (Object[])new Object[0]), (String)UIBundle.message((String)"file.chooser.delete.confirm", (Object[])new Object[0])).yesText(ApplicationBundle.message((String)"button.delete", (Object[])new Object[0]))).noText(CommonBundle.getCancelButtonText())).icon(UIUtil.getWarningIcon())).ask(project2);
        if (!ok) {
            return;
        }
        try {
            String progress = IdeBundle.message((String)"progress.deleting", (Object[])new Object[0]);
            panel2.reloadAfter(() -> (Path)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<Path, IOException>(this, e.getProject(), panel2.getComponent(), progress, true){

                protected Path compute(@NotNull ProgressIndicator indicator2) throws IOException {
                    if (indicator2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    for (Path path : paths) {
                        if (indicator2.isCanceled()) break;
                        indicator2.setText(path.toString());
                        NioFiles.deleteRecursively((Path)path, p -> {
                            indicator2.checkCanceled();
                            indicator2.setText2(path.relativize((Path)p).toString());
                        });
                    }
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/fileChooser/actions/FileDeleteAction$1", "compute"));
                }
            }));
        }
        catch (IOException ex) {
            Messages.showErrorDialog((Component)panel2.getComponent(), (String)IoErrorText.message((Throwable)ex), (String)CommonBundle.getErrorTitle());
        }
    }

    private static boolean isEnabled(AnActionEvent e) {
        return e.getData(FileChooserKeys.DELETE_ACTION_AVAILABLE) != Boolean.FALSE;
    }

    @Override
    protected void update(@NotNull FileSystemTree fileChooser, @NotNull AnActionEvent e) {
        if (fileChooser == null) {
            FileDeleteAction.$$$reportNull$$$0(4);
        }
        if (e == null) {
            FileDeleteAction.$$$reportNull$$$0(5);
        }
        boolean visible = FileDeleteAction.isEnabled(e);
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(visible && (!(e.getInputEvent() instanceof KeyEvent) || !(e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT) instanceof JTextField)) && new VirtualFileDeleteProvider().canDeleteElement(e.getDataContext()));
    }

    @Override
    protected void actionPerformed(@NotNull FileSystemTree fileChooser, @NotNull AnActionEvent e) {
        if (fileChooser == null) {
            FileDeleteAction.$$$reportNull$$$0(6);
        }
        if (e == null) {
            FileDeleteAction.$$$reportNull$$$0(7);
        }
        new VirtualFileDeleteProvider().deleteElement(e.getDataContext());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileChooser";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/fileChooser/actions/FileDeleteAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

