/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.ex;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.fileChooser.ex.FileDrop;
import com.intellij.openapi.fileChooser.ex.FileLookup;
import com.intellij.openapi.fileChooser.ex.FileNodeDescriptor;
import com.intellij.openapi.fileChooser.ex.FileSystemTreeImpl;
import com.intellij.openapi.fileChooser.ex.FileTextFieldImpl;
import com.intellij.openapi.fileChooser.ex.LocalFsFinder;
import com.intellij.openapi.fileChooser.ex.TextFieldAction;
import com.intellij.openapi.fileChooser.impl.FileChooserFactoryImpl;
import com.intellij.openapi.fileChooser.impl.FileChooserUsageCollector;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SideBorder;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.IconUtil;
import com.intellij.util.SlowOperations;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileChooserDialogImpl
extends DialogWrapper
implements FileChooserDialog,
PathChooserDialog {
    public static final String FILE_CHOOSER_SHOW_PATH_PROPERTY = "FileChooser.ShowPath";
    protected final FileChooserDescriptor myChooserDescriptor;
    protected FileSystemTreeImpl myFileSystemTree;
    private Project myProject;
    private VirtualFile[] myChosenFiles;
    private JPanel myNorthPanel;
    private TextFieldAction myTextFieldAction;
    protected FileTextFieldImpl myPathTextField;
    private ComboBox<String> myPath;
    private MergingUpdateQueue myUiUpdater;
    private boolean myTreeIsUpdating;
    private final Map<String, LocalFileSystem.WatchRequest> myRequests;

    public FileChooserDialogImpl(@NotNull FileChooserDescriptor descriptor2, @Nullable Project project2) {
        if (descriptor2 == null) {
            FileChooserDialogImpl.$$$reportNull$$$0(0);
        }
        super(project2, true);
        this.myChosenFiles = VirtualFile.EMPTY_ARRAY;
        this.myRequests = new HashMap<String, LocalFileSystem.WatchRequest>();
        this.myChooserDescriptor = descriptor2;
        this.myProject = project2;
        this.setTitle(FileChooserDialogImpl.getChooserTitle(descriptor2));
    }

    public FileChooserDialogImpl(@NotNull FileChooserDescriptor descriptor2, @NotNull Component parent) {
        if (descriptor2 == null) {
            FileChooserDialogImpl.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            FileChooserDialogImpl.$$$reportNull$$$0(2);
        }
        this(descriptor2, parent, null);
    }

    public FileChooserDialogImpl(@NotNull FileChooserDescriptor descriptor2, @NotNull Component parent, @Nullable Project project2) {
        if (descriptor2 == null) {
            FileChooserDialogImpl.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            FileChooserDialogImpl.$$$reportNull$$$0(4);
        }
        super(parent, true);
        this.myChosenFiles = VirtualFile.EMPTY_ARRAY;
        this.myRequests = new HashMap<String, LocalFileSystem.WatchRequest>();
        this.myChooserDescriptor = descriptor2;
        this.myProject = project2;
        this.setTitle(FileChooserDialogImpl.getChooserTitle(descriptor2));
    }

    @NlsContexts.DialogTitle
    private static String getChooserTitle(FileChooserDescriptor descriptor2) {
        String title2 = descriptor2.getTitle();
        return title2 != null ? title2 : UIBundle.message((String)"file.chooser.default.title", (Object[])new Object[0]);
    }

    public VirtualFile @NotNull [] choose(@Nullable Project project2, VirtualFile ... toSelect) {
        if (toSelect == null) {
            FileChooserDialogImpl.$$$reportNull$$$0(5);
        }
        this.init();
        if (this.myProject == null && project2 != null) {
            this.myProject = project2;
        }
        if (toSelect.length == 1) {
            this.restoreSelection(toSelect[0]);
        } else if (toSelect.length == 0) {
            this.restoreSelection(null);
        } else {
            this.selectInTree(toSelect, true, true);
        }
        this.show();
        FileChooserUsageCollector.log(this, this.myChooserDescriptor, this.myChosenFiles);
        if (this.myChosenFiles == null) {
            FileChooserDialogImpl.$$$reportNull$$$0(6);
        }
        return this.myChosenFiles;
    }

    public void choose(@Nullable VirtualFile toSelect, @NotNull Consumer<? super List<VirtualFile>> callback) {
        if (callback == null) {
            FileChooserDialogImpl.$$$reportNull$$$0(7);
        }
        this.init();
        this.restoreSelection(toSelect);
        this.show();
        FileChooserUsageCollector.log(this, this.myChooserDescriptor, this.myChosenFiles);
        if (this.myChosenFiles.length > 0) {
            callback.consume(Arrays.asList(this.myChosenFiles));
        } else if (callback instanceof FileChooser.FileChooserConsumer) {
            ((FileChooser.FileChooserConsumer)callback).cancelled();
        }
    }

    protected void restoreSelection(@Nullable VirtualFile toSelect) {
        VirtualFile file2 = FileChooserUtil.getFileToSelect(this.myChooserDescriptor, this.myProject, toSelect);
        if (file2 != null && file2.isValid()) {
            this.myPathTextField.setText(this.getPresentableUrl(file2), true, () -> this.selectInTree(new VirtualFile[]{file2}, false, false));
        }
    }

    @ApiStatus.Internal
    void storeSelection(@Nullable VirtualFile file2) {
        if (file2 != null) {
            FileChooserUtil.updateRecentPaths(this.myProject, file2);
        }
    }

    protected DefaultActionGroup createActionGroup() {
        this.registerTreeActionShortcut("FileChooser.Delete");
        this.registerTreeActionShortcut("FileChooser.Refresh");
        DefaultActionGroup group2 = new DefaultActionGroup();
        for (AnAction action2 : ((DefaultActionGroup)ActionManager.getInstance().getAction("FileChooserToolbar")).getChildActionsOrStubs()) {
            group2.addAction(action2);
        }
        for (AnAction action2 : ((DefaultActionGroup)ActionManager.getInstance().getAction("FileChooserSettings")).getChildActionsOrStubs()) {
            ActionStub stub;
            if (!(action2 instanceof ActionStub) || !"FileChooser.ShowHidden".equals((stub = (ActionStub)action2).getId())) continue;
            action2.getTemplatePresentation().setIcon(AllIcons.Actions.ToggleVisibility);
            group2.addAction(action2);
        }
        return group2;
    }

    private void registerTreeActionShortcut(String actionId) {
        JTree tree2 = this.myFileSystemTree.getTree();
        AnAction action2 = ActionManager.getInstance().getAction(actionId);
        action2.registerCustomShortcutSet(action2.getShortcutSet(), (JComponent)tree2, this.getDisposable());
    }

    @Nullable
    protected final JComponent createTitlePane() {
        String description = this.myChooserDescriptor.getDescription();
        if (StringUtil.isEmptyOrSpaces((String)description)) {
            return null;
        }
        JLabel label2 = new JLabel(description);
        label2.setBorder(BorderFactory.createCompoundBorder((Border)new SideBorder(UIUtil.getPanelBackground().darker(), 8), (Border)JBUI.Borders.empty((int)0, (int)5, (int)10, (int)5)));
        return label2;
    }

    @NotNull
    protected FileLookup.Finder createFinder() {
        return new LocalFsFinder();
    }

    protected JComponent createCenterPanel() {
        MyPanel panel2 = new MyPanel();
        this.myUiUpdater = new MergingUpdateQueue("FileChooserUpdater", 200, false, (JComponent)panel2);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myUiUpdater);
        UiNotifyConnector.installOn((Component)panel2, (Activatable)this.myUiUpdater);
        panel2.setBorder((Border)JBUI.Borders.empty());
        this.createTree();
        DefaultActionGroup group2 = this.createActionGroup();
        ActionToolbar toolBar = ActionManager.getInstance().createActionToolbar("FileChooserDialog", (ActionGroup)group2, true);
        toolBar.setTargetComponent((JComponent)panel2);
        JPanel toolbarPanel2 = new JPanel(new BorderLayout());
        toolbarPanel2.add((Component)toolBar.getComponent(), "Center");
        this.myTextFieldAction = new TextFieldAction(){

            public void linkSelected(LinkLabel aSource, Object aLinkData) {
                FileChooserDialogImpl.this.toggleShowTextField();
            }
        };
        toolbarPanel2.add((Component)((Object)this.myTextFieldAction), "East");
        JPanel extraToolbarPanel = this.createExtraToolbarPanel();
        if (extraToolbarPanel != null) {
            toolbarPanel2.add((Component)extraToolbarPanel, "South");
        }
        this.myPath = new ComboBox((Object[])FileChooserUtil.getRecentPaths().toArray(ArrayUtilRt.EMPTY_STRING_ARRAY));
        this.myPath.setEditable(true);
        this.myPath.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label2, value, index) -> {
            label2.setText(value);
            try (AccessToken ignore = SlowOperations.knownIssue((String)"IDEA-338208, EA-831292");){
                VirtualFile file2 = LocalFileSystem.getInstance().findFileByIoFile(new File((String)value));
                label2.setIcon(file2 == null ? EmptyIcon.ICON_16 : IconUtil.getIcon((VirtualFile)file2, (int)2, null));
            }
        }));
        JTextField pathEditor = (JTextField)this.myPath.getEditor().getEditorComponent();
        FileLookup.LookupFilter filter2 = f -> this.myChooserDescriptor.isFileVisible(((LocalFsFinder.VfsFile)f).getFile(), this.myFileSystemTree.areHiddensShown());
        this.myPathTextField = new FileTextFieldImpl(pathEditor, this.createFinder(), filter2, FileChooserFactoryImpl.getMacroMap(), this.getDisposable()){

            @Override
            protected void onTextChanged(String newValue) {
                FileChooserDialogImpl.this.myUiUpdater.cancelAllUpdates();
                FileChooserDialogImpl.this.updateTreeFromPath(newValue);
            }
        };
        this.myNorthPanel = new JPanel(new BorderLayout());
        this.myNorthPanel.add((Component)toolbarPanel2, "North");
        this.updateTextFieldShowing();
        panel2.add((Component)this.myNorthPanel, "North");
        this.registerMouseListener((ActionGroup)group2);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myFileSystemTree.getTree());
        panel2.add((Component)scrollPane, "Center");
        panel2.setPreferredSize((Dimension)JBUI.size((int)400));
        JLabel dndLabel = new JLabel(UIBundle.message((String)"file.chooser.tooltip.drag.drop", (Object[])new Object[0]), 0);
        dndLabel.setFont((Font)JBUI.Fonts.miniFont());
        dndLabel.setForeground(UIUtil.getLabelDisabledForeground());
        panel2.add((Component)dndLabel, "South");
        ApplicationManager.getApplication().getMessageBus().connect(this.getDisposable()).subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener(this){

            public void applicationActivated(@NotNull IdeFrame ideFrame) {
                if (ideFrame == null) {
                    3.$$$reportNull$$$0(0);
                }
                SaveAndSyncHandler.getInstance().maybeRefresh(ModalityState.current());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideFrame", "com/intellij/openapi/fileChooser/ex/FileChooserDialogImpl$3", "applicationActivated"));
            }
        });
        return panel2;
    }

    @Nullable
    protected JPanel createExtraToolbarPanel() {
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        if (FileChooserDialogImpl.isToShowTextField()) {
            return this.myPathTextField != null ? this.myPathTextField.getField() : null;
        }
        return this.myFileSystemTree != null ? this.myFileSystemTree.getTree() : null;
    }

    public final void dispose() {
        LocalFileSystem.getInstance().removeWatchedRoots(this.myRequests.values());
        super.dispose();
    }

    private boolean isTextFieldActive() {
        return this.myPathTextField.getField().getRootPane() != null;
    }

    protected void doOKAction() {
        List<VirtualFile> selectedFiles2;
        VirtualFile[] files2;
        if (!this.isOKActionEnabled()) {
            return;
        }
        if (this.isTextFieldActive()) {
            String text2 = this.myPathTextField.getTextFieldText();
            FileLookup.LookupFile file2 = this.myPathTextField.getFile();
            if (text2 == null || file2 == null || !file2.exists()) {
                this.setErrorText(IdeBundle.message((String)"dialog.message.specified.path.cannot.be.found", (Object[])new Object[0]), this.myPathTextField.getField());
                return;
            }
        }
        if ((files2 = VfsUtilCore.toVirtualFileArray(FileChooserUtil.getChosenFiles(this.myChooserDescriptor, selectedFiles2 = Arrays.asList(this.getSelectedFilesInt())))).length == 0) {
            this.myChosenFiles = VirtualFile.EMPTY_ARRAY;
            this.close(1);
            return;
        }
        try {
            this.myChooserDescriptor.validateSelectedFiles(files2);
        }
        catch (Exception e) {
            Messages.showErrorDialog((Component)this.getContentPane(), (String)e.getMessage(), (String)this.getTitle());
            return;
        }
        this.myChosenFiles = files2;
        this.storeSelection(files2[files2.length - 1]);
        super.doOKAction();
    }

    public final void doCancelAction() {
        this.myChosenFiles = VirtualFile.EMPTY_ARRAY;
        super.doCancelAction();
    }

    protected JTree createTree() {
        Tree internalTree = this.createInternalTree();
        this.myFileSystemTree = new FileSystemTreeImpl(this.myProject, this.myChooserDescriptor, internalTree, null, null, null);
        internalTree.setRootVisible(this.myChooserDescriptor.isTreeRootVisible());
        internalTree.setShowsRootHandles(true);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myFileSystemTree);
        this.myFileSystemTree.addOkAction(this::doOKAction);
        JTree tree2 = this.myFileSystemTree.getTree();
        if (!Registry.is((String)"file.chooser.async.tree.model")) {
            tree2.setCellRenderer((TreeCellRenderer)new NodeRenderer());
        }
        tree2.getSelectionModel().addTreeSelectionListener(new FileTreeSelectionListener());
        tree2.addTreeExpansionListener(new FileTreeExpansionListener());
        this.setOKActionEnabled(false);
        this.myFileSystemTree.addListener(selection -> {
            if (this.myTreeIsUpdating) {
                this.myTreeIsUpdating = false;
            }
            this.updatePathFromTree(selection, false);
        }, this.getDisposable());
        new FileDrop(tree2, new FileDrop.Target(){

            @Override
            public FileChooserDescriptor getDescriptor() {
                return FileChooserDialogImpl.this.myChooserDescriptor;
            }

            @Override
            public boolean isHiddenShown() {
                return FileChooserDialogImpl.this.myFileSystemTree.areHiddensShown();
            }

            @Override
            public void dropFiles(List<? extends VirtualFile> files2) {
                if (!FileChooserDialogImpl.this.myChooserDescriptor.isChooseMultiple() && !files2.isEmpty()) {
                    FileChooserDialogImpl.this.selectInTree(new VirtualFile[]{files2.get(0)}, true, true);
                } else {
                    FileChooserDialogImpl.this.selectInTree(VfsUtilCore.toVirtualFileArray(files2), true, true);
                }
            }
        });
        return tree2;
    }

    @NotNull
    protected Tree createInternalTree() {
        return new Tree();
    }

    private void registerMouseListener(ActionGroup group2) {
        this.myFileSystemTree.registerMouseListener(group2);
    }

    private VirtualFile[] getSelectedFilesInt() {
        if (this.myTreeIsUpdating || !this.myUiUpdater.isEmpty()) {
            VirtualFile file2;
            FileLookup.LookupFile toFind;
            if (this.isTextFieldActive() && !StringUtil.isEmpty((String)this.myPathTextField.getTextFieldText()) && (toFind = this.myPathTextField.getFile()) instanceof LocalFsFinder.VfsFile && toFind.exists() && (file2 = ((LocalFsFinder.VfsFile)toFind).getFile()) != null) {
                return new VirtualFile[]{file2};
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        return this.myFileSystemTree.getSelectedFiles();
    }

    private static boolean isToShowTextField() {
        return PropertiesComponent.getInstance().getBoolean(FILE_CHOOSER_SHOW_PATH_PROPERTY, true);
    }

    private static void setToShowTextField(boolean toShowTextField) {
        PropertiesComponent.getInstance().setValue(FILE_CHOOSER_SHOW_PATH_PROPERTY, Boolean.toString(toShowTextField));
    }

    public void toggleShowTextField() {
        FileChooserDialogImpl.setToShowTextField(!FileChooserDialogImpl.isToShowTextField());
        this.updateTextFieldShowing();
    }

    @NotNull
    @NlsSafe
    protected String getPresentableUrl(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            FileChooserDialogImpl.$$$reportNull$$$0(8);
        }
        String string = VfsUtil.getReadableUrl((VirtualFile)virtualFile);
        if (string == null) {
            FileChooserDialogImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    private void updateTextFieldShowing() {
        this.myTextFieldAction.update();
        this.myNorthPanel.remove((Component)this.myPath);
        if (FileChooserDialogImpl.isToShowTextField()) {
            ArrayList<VirtualFile> selection = new ArrayList<VirtualFile>();
            if (this.myFileSystemTree.getSelectedFile() != null) {
                selection.add(this.myFileSystemTree.getSelectedFile());
            }
            this.updatePathFromTree(selection, true);
            this.myNorthPanel.add((Component)this.myPath, "Center");
        } else {
            this.setErrorText(null);
        }
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myPathTextField.getField(), true));
        this.myNorthPanel.revalidate();
        this.myNorthPanel.repaint();
    }

    private void updatePathFromTree(List<? extends VirtualFile> selection, boolean now) {
        if (!FileChooserDialogImpl.isToShowTextField() || this.myTreeIsUpdating) {
            return;
        }
        String text2 = "";
        if (!selection.isEmpty()) {
            text2 = this.getPresentableUrl(selection.get(0));
        } else {
            List roots = this.myChooserDescriptor.getRoots();
            if (!this.myFileSystemTree.getTree().isRootVisible() && roots.size() == 1) {
                text2 = this.getPresentableUrl((VirtualFile)roots.get(0));
            }
        }
        if (text2.isEmpty()) {
            return;
        }
        String old = this.myPathTextField.getTextFieldText();
        if (old == null || old.equals(text2)) {
            return;
        }
        int index = old.length() - 1;
        if (index == text2.length() && File.separatorChar == old.charAt(index) && old.startsWith(text2)) {
            return;
        }
        this.myPathTextField.setText(text2, now, () -> {
            this.myPathTextField.getField().selectAll();
            this.setErrorText(null);
        });
    }

    private void updateTreeFromPath(final String text2) {
        if (!FileChooserDialogImpl.isToShowTextField()) {
            return;
        }
        if (this.myPathTextField.isPathUpdating()) {
            return;
        }
        if (text2 == null) {
            return;
        }
        this.myUiUpdater.queue(new Update("treeFromPath.1"){

            public void run() {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    final FileLookup.LookupFile toFind = FileChooserDialogImpl.this.myPathTextField.getFile();
                    if (toFind instanceof LocalFsFinder.VfsFile && toFind.exists()) {
                        FileChooserDialogImpl.this.myUiUpdater.queue(new Update("treeFromPath.2"){

                            public void run() {
                                FileChooserDialogImpl.this.selectInTree(((LocalFsFinder.VfsFile)toFind).getFile(), text2);
                            }
                        });
                    }
                });
            }
        });
    }

    private void selectInTree(VirtualFile vFile, String fromText) {
        if (vFile != null && vFile.isValid()) {
            if (fromText == null || fromText.equalsIgnoreCase(this.myPathTextField.getTextFieldText())) {
                this.selectInTree(new VirtualFile[]{vFile}, false, fromText == null);
            }
        } else {
            this.reportFileNotFound();
        }
    }

    private void selectInTree(VirtualFile[] array, boolean requestFocus, boolean updatePathNeeded) {
        this.myTreeIsUpdating = true;
        List<VirtualFile> fileList = Arrays.asList(array);
        if (!Set.of(this.myFileSystemTree.getSelectedFiles()).containsAll(fileList)) {
            this.myFileSystemTree.select(array, () -> {
                VirtualFile parent;
                if (!this.myFileSystemTree.areHiddensShown() && !Set.of(this.myFileSystemTree.getSelectedFiles()).containsAll(fileList)) {
                    this.myFileSystemTree.showHiddens(true);
                    this.selectInTree(array, requestFocus, updatePathNeeded);
                    return;
                }
                if (array.length == 1 && !Set.of(this.myFileSystemTree.getSelectedFiles()).containsAll(fileList) && (parent = array[0].getParent()) != null && parent.isValid()) {
                    this.selectInTree(new VirtualFile[]{parent}, requestFocus, updatePathNeeded);
                    return;
                }
                this.reportFileNotFound();
                if (updatePathNeeded) {
                    this.updatePathFromTree(fileList, true);
                }
                if (requestFocus) {
                    SwingUtilities.invokeLater(() -> this.myFileSystemTree.getTree().requestFocus());
                }
            });
        } else {
            this.reportFileNotFound();
            if (updatePathNeeded) {
                this.updatePathFromTree(fileList, true);
            }
        }
    }

    private void reportFileNotFound() {
        this.myTreeIsUpdating = false;
        this.setErrorText(null);
    }

    protected String getDimensionServiceKey() {
        return "FileChooserDialogImpl";
    }

    protected String getHelpId() {
        return "select.path.dialog";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSelect";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileChooser/ex/FileChooserDialogImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileChooser/ex/FileChooserDialogImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "choose";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "choose";
                break;
            }
            case 6: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableUrl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9 -> new IllegalStateException(string);
        };
    }

    protected final class MyPanel
    extends JPanel
    implements UiDataProvider {
        final PasteProvider myPasteProvider;

        public MyPanel() {
            super(new BorderLayout(0, 0));
            this.myPasteProvider = new PasteProvider(){

                @NotNull
                public ActionUpdateThread getActionUpdateThread() {
                    ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                    if (actionUpdateThread == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return actionUpdateThread;
                }

                public void performPaste(@NotNull DataContext dataContext2) {
                    if (dataContext2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (FileChooserDialogImpl.this.myPathTextField != null) {
                        String path = 1.calculatePath();
                        FileChooserDialogImpl.this.myPathTextField.setText(path, true, null);
                        FileChooserDialogImpl.this.updateTreeFromPath(path);
                    }
                }

                @Nullable
                private static String calculatePath() {
                    List<File> fileList;
                    Transferable contents = CopyPasteManager.getInstance().getContents();
                    if (contents != null && (fileList = FileCopyPasteUtil.getFileList(contents)) != null && !fileList.isEmpty()) {
                        return fileList.get(0).getAbsolutePath();
                    }
                    return null;
                }

                public boolean isPastePossible(@NotNull DataContext dataContext2) {
                    if (dataContext2 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return this.isPasteEnabled(dataContext2);
                }

                public boolean isPasteEnabled(@NotNull DataContext dataContext2) {
                    if (dataContext2 == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return FileCopyPasteUtil.isFileListFlavorAvailable() && 1.calculatePath() != null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 2;
                        case 1, 2, 3 -> 3;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/openapi/fileChooser/ex/FileChooserDialogImpl$MyPanel$1";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "dataContext";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getActionUpdateThread";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/openapi/fileChooser/ex/FileChooserDialogImpl$MyPanel$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "performPaste";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "isPastePossible";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray;
                            objectArray[2] = "isPasteEnabled";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalStateException(string);
                        case 1, 2, 3 -> new IllegalArgumentException(string);
                    };
                }
            };
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                MyPanel.$$$reportNull$$$0(0);
            }
            sink.set(FileSystemTree.DATA_KEY, (Object)FileChooserDialogImpl.this.myFileSystemTree);
            sink.set(CommonDataKeys.VIRTUAL_FILE_ARRAY, FileChooserDialogImpl.this.myFileSystemTree == null ? null : FileChooserDialogImpl.this.myFileSystemTree.getSelectedFiles());
            sink.set(PlatformDataKeys.PASTE_PROVIDER, (Object)this.myPasteProvider);
            DataSink.uiDataSnapshot((DataSink)sink, dataId -> FileChooserDialogImpl.this.myChooserDescriptor.getUserData(dataId));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/openapi/fileChooser/ex/FileChooserDialogImpl$MyPanel", "uiDataSnapshot"));
        }
    }

    private final class FileTreeSelectionListener
    implements TreeSelectionListener {
        private FileTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath[] paths = e.getPaths();
            boolean enabled2 = true;
            for (TreePath treePath : paths) {
                VirtualFile file2;
                if (!e.isAddedPath(treePath) || (file2 = FileSystemTreeImpl.getVirtualFile(treePath)) != null && FileChooserDialogImpl.this.myChooserDescriptor.isFileSelectable(file2)) continue;
                enabled2 = false;
            }
            FileChooserDialogImpl.this.setOKActionEnabled(enabled2);
        }
    }

    private final class FileTreeExpansionListener
    implements TreeExpansionListener {
        private FileTreeExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            LocalFileSystem.WatchRequest watchRequest;
            String rootPath;
            VirtualFile file2;
            Object userObject;
            Object[] path = event.getPath().getPath();
            if (path.length == 2 && path[1] instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)path[1]).getUserObject()) instanceof FileNodeDescriptor && (file2 = ((FileNodeDescriptor)((Object)userObject)).getElement().getFile()) != null && file2.isDirectory() && FileChooserDialogImpl.this.myRequests.get(rootPath = file2.getPath()) == null && (watchRequest = LocalFileSystem.getInstance().addRootToWatch(rootPath, true)) != null) {
                FileChooserDialogImpl.this.myRequests.put(rootPath, watchRequest);
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
        }
    }
}

