/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.tree;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.execution.wsl.WslIjentAvailabilityService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileChooser.tree.FileNode;
import com.intellij.openapi.fileChooser.tree.FileRefresher;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.ui.tree.MapBasedTree;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.AbstractTreeModel;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.lang.reflect.Method;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public final class FileTreeModel
extends AbstractTreeModel
implements InvokerSupplier {
    private static final Logger LOG = Logger.getInstance(FileTreeModel.class);
    private final Invoker invoker;
    private final State state;
    private volatile List<Root> roots;

    public FileTreeModel(@NotNull FileChooserDescriptor descriptor2, FileRefresher refresher) {
        if (descriptor2 == null) {
            FileTreeModel.$$$reportNull$$$0(0);
        }
        this(descriptor2, refresher, true, false, true);
    }

    public FileTreeModel(@NotNull FileChooserDescriptor descriptor2, FileRefresher refresher, boolean sortDirectories, boolean sortArchives, boolean useReadAction) {
        if (descriptor2 == null) {
            FileTreeModel.$$$reportNull$$$0(1);
        }
        if (refresher != null) {
            Disposer.register((Disposable)this, (Disposable)refresher);
        }
        this.invoker = useReadAction ? Invoker.forBackgroundThreadWithReadAction((Disposable)this) : Invoker.forBackgroundThreadWithoutReadAction((Disposable)this);
        this.state = new State(descriptor2, refresher, sortDirectories, sortArchives, this);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                FileTreeModel.this.invoker.invoke(() -> FileTreeModel.this.process(events));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/fileChooser/tree/FileTreeModel$1", "after"));
            }
        });
    }

    public void invalidate() {
        this.invoker.invoke(() -> {
            if (this.roots != null) {
                for (Root root : this.roots) {
                    root.tree.invalidate();
                }
            }
            this.treeStructureChanged(this.state.path, null, null);
        });
    }

    @NotNull
    public Invoker getInvoker() {
        Invoker invoker = this.invoker;
        if (invoker == null) {
            FileTreeModel.$$$reportNull$$$0(2);
        }
        return invoker;
    }

    public Object getRoot() {
        if (this.state.path != null) {
            return this.state;
        }
        if (this.roots == null) {
            this.roots = this.state.getRoots();
        }
        return 1 == this.roots.size() ? this.roots.get(0) : null;
    }

    public Object getChild(Object object, int index) {
        MapBasedTree.Entry<Node> entry;
        if (object == this.state) {
            if (this.roots == null) {
                this.roots = this.state.getRoots();
            }
            if (0 <= index && index < this.roots.size()) {
                return this.roots.get(index);
            }
        } else if (object instanceof Node && (entry = this.getEntry((Node)object, true)) != null) {
            Node child = entry.getChild(index);
            child.ensureInitialized();
            return child;
        }
        return null;
    }

    public int getChildCount(Object object) {
        MapBasedTree.Entry<Node> entry;
        if (object == this.state) {
            if (this.roots == null) {
                this.roots = this.state.getRoots();
            }
            return this.roots.size();
        }
        if (object instanceof Node && (entry = this.getEntry((Node)object, true)) != null) {
            return entry.getChildCount();
        }
        return 0;
    }

    public boolean isLeaf(Object object) {
        MapBasedTree.Entry<Node> entry;
        if (object instanceof Node && (entry = this.getEntry((Node)object, false)) != null) {
            return entry.isLeaf();
        }
        return false;
    }

    public int getIndexOfChild(Object object, Object child) {
        MapBasedTree.Entry<Node> entry;
        if (object == this.state) {
            if (this.roots == null) {
                this.roots = this.state.getRoots();
            }
            for (int i2 = 0; i2 < this.roots.size(); ++i2) {
                if (child != this.roots.get(i2)) continue;
                return i2;
            }
        } else if (object instanceof Node && child instanceof Node && (entry = this.getEntry((Node)object, true)) != null) {
            return entry.getIndexOf((Node)child);
        }
        return -1;
    }

    private boolean hasEntry(VirtualFile file2) {
        if (file2 == null) {
            return false;
        }
        if (this.roots != null) {
            for (Root root : this.roots) {
                MapBasedTree.Entry<Node> entry = root.tree.findEntry(file2);
                if (entry == null) continue;
                return true;
            }
        }
        return false;
    }

    private MapBasedTree.Entry<Node> getEntry(Node node, boolean loadChildren) {
        if (this.roots != null) {
            for (Root root : this.roots) {
                MapBasedTree.Entry<Node> entry = root.tree.getEntry(node);
                if (entry == null) continue;
                if (loadChildren && entry.isLoadingRequired()) {
                    root.updateChildren(this.state, entry);
                }
                return entry;
            }
        }
        return null;
    }

    private void process(List<? extends VFileEvent> events) {
        if (this.roots == null) {
            return;
        }
        HashSet<VirtualFile> parents = new HashSet<VirtualFile>();
        for (VFileEvent vFileEvent : events) {
            VirtualFile file2;
            if (vFileEvent instanceof VFilePropertyChangeEvent) continue;
            if (vFileEvent instanceof VFileCreateEvent) {
                VFileCreateEvent create2 = (VFileCreateEvent)vFileEvent;
                if (!this.hasEntry(create2.getParent())) continue;
                parents.add(create2.getParent());
                continue;
            }
            if (vFileEvent instanceof VFileCopyEvent) {
                VFileCopyEvent copy = (VFileCopyEvent)vFileEvent;
                if (!this.hasEntry(copy.getNewParent())) continue;
                parents.add(copy.getNewParent());
                continue;
            }
            if (vFileEvent instanceof VFileMoveEvent) {
                VFileMoveEvent move = (VFileMoveEvent)vFileEvent;
                if (this.hasEntry(move.getNewParent())) {
                    parents.add(move.getNewParent());
                }
                if (!this.hasEntry(move.getOldParent())) continue;
                parents.add(move.getOldParent());
                continue;
            }
            if (!(vFileEvent instanceof VFileDeleteEvent) || !this.hasEntry(file2 = vFileEvent.getFile())) continue;
            parents.add((VirtualFile)(this.hasEntry(file2 = file2.getParent()) ? file2 : null));
        }
        for (VirtualFile virtualFile : parents) {
            for (Root root : this.roots) {
                boolean contained;
                MapBasedTree.Entry<Node> entry = root.tree.findEntry(virtualFile);
                if (entry == null || entry.isLoadingRequired()) continue;
                MapBasedTree.UpdateResult<Node> update2 = root.updateChildren(this.state, entry);
                boolean removed = !update2.getRemoved().isEmpty();
                boolean inserted = !update2.getInserted().isEmpty();
                boolean bl = contained = !update2.getContained().isEmpty();
                if (!removed && !inserted && !contained) continue;
                if (!removed && inserted) {
                    if (this.listeners.isEmpty()) continue;
                    this.listeners.treeNodesInserted(update2.getEvent((Object)this, entry, update2.getInserted()));
                    continue;
                }
                if (!inserted && removed) {
                    if (this.listeners.isEmpty()) continue;
                    this.listeners.treeNodesRemoved(update2.getEvent((Object)this, entry, update2.getRemoved()));
                    continue;
                }
                this.treeStructureChanged(entry, null, null);
            }
        }
    }

    private static VirtualFile findFile(String path) {
        return LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)path));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileChooser/tree/FileTreeModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileChooser/tree/FileTreeModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvoker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static final class State {
        private final TreePath path;
        private final FileChooserDescriptor descriptor;
        private final FileRefresher refresher;
        private final boolean sortDirectories;
        private final boolean sortArchives;
        private final List<VirtualFile> roots;
        private final FileTreeModel model;

        private State(FileChooserDescriptor descriptor2, FileRefresher refresher, boolean sortDirectories, boolean sortArchives, FileTreeModel model2) {
            this.descriptor = descriptor2;
            this.refresher = refresher;
            this.sortDirectories = sortDirectories;
            this.sortArchives = sortArchives;
            this.roots = State.getRoots(descriptor2);
            this.path = this.roots != null && 1 == this.roots.size() ? null : new TreePath(this);
            this.model = model2;
        }

        private int compare(VirtualFile one, VirtualFile two) {
            if (one == null && two == null) {
                return 0;
            }
            if (one == null) {
                return -1;
            }
            if (two == null) {
                return 1;
            }
            if (this.sortDirectories) {
                boolean isArchive;
                boolean isDirectory = one.isDirectory();
                if (isDirectory != two.isDirectory()) {
                    return isDirectory ? -1 : 1;
                }
                if (!isDirectory && this.sortArchives && this.descriptor.isChooseJarContents() && (isArchive = FileElement.isArchive((VirtualFile)one)) != FileElement.isArchive((VirtualFile)two)) {
                    return isArchive ? -1 : 1;
                }
            }
            return StringUtil.naturalCompare((String)one.getName(), (String)two.getName());
        }

        private static boolean isValid(VirtualFile file2) {
            return file2 != null && file2.isValid();
        }

        private boolean isVisible(VirtualFile file2) {
            return State.isValid(file2) && this.descriptor.isFileVisible(file2, this.descriptor.isShowHiddenFiles());
        }

        private boolean isLeaf(VirtualFile file2) {
            if (file2 == null || file2.isDirectory()) {
                return false;
            }
            return !this.descriptor.isChooseJarContents() || !FileElement.isArchive((VirtualFile)file2);
        }

        private VirtualFile[] getChildren(VirtualFile file2) {
            if (!State.isValid(file2)) {
                return null;
            }
            if (file2.isDirectory()) {
                return file2.getChildren();
            }
            if (!this.descriptor.isChooseJarContents() || !FileElement.isArchive((VirtualFile)file2)) {
                return null;
            }
            String path = file2.getPath() + "!/";
            VirtualFile jar = JarFileSystem.getInstance().findFileByPath(path);
            return jar == null ? VirtualFile.EMPTY_ARRAY : jar.getChildren();
        }

        private @Unmodifiable List<Root> getRoots() {
            List<VirtualFile> files2;
            if (!this.model.invoker.isValidThread()) {
                LOG.error((Throwable)new IllegalStateException(Thread.currentThread().getName()));
            }
            if ((files2 = this.roots) == null) {
                files2 = this.getSystemRoots();
            }
            if (files2.isEmpty()) {
                return Collections.emptyList();
            }
            return ContainerUtil.map(files2, file2 -> new Root(this, (VirtualFile)file2));
        }

        private static List<VirtualFile> getRoots(FileChooserDescriptor descriptor2) {
            List list2 = ContainerUtil.filter((Collection)descriptor2.getRoots(), State::isValid);
            return list2.isEmpty() && descriptor2.isShowFileSystemRoots() ? null : list2;
        }

        @NotNull
        private List<VirtualFile> getSystemRoots() {
            if (WslIjentAvailabilityService.getInstance().useIjentForWslNioFileSystem()) {
                return State.toVirtualFiles(FileSystems.getDefault().getRootDirectories());
            }
            return this.getSystemsRootLegacy();
        }

        @NotNull
        private List<VirtualFile> getSystemsRootLegacy() {
            List distributions = List.of();
            if (WSLUtil.isSystemCompatible() && Experiments.getInstance().isFeatureEnabled("wsl.p9.show.roots.in.file.chooser")) {
                List lastDistributions;
                WslDistributionManager distributionManager = WslDistributionManager.getInstance();
                distributions = lastDistributions = ContainerUtil.notNullize(distributionManager.getLastInstalledDistributions());
                LOG.debug("WSL distributions: ", new Object[]{distributions});
                distributionManager.getInstalledDistributionsFuture().thenAccept(newDistributions -> {
                    if (newDistributions.equals(lastDistributions)) {
                        LOG.debug("WSL distributions are up-to-date");
                        return;
                    }
                    LOG.debug("New WSL distributions: ", new Object[]{newDistributions});
                    this.model.invoker.invokeLater(() -> this.setRoots(State.getLocalAndWslRoots(newDistributions)));
                });
            }
            return State.getLocalAndWslRoots(distributions);
        }

        @NotNull
        private static List<VirtualFile> getLocalAndWslRoots(@NotNull List<? extends WSLDistribution> distributions) {
            if (distributions == null) {
                State.$$$reportNull$$$0(0);
            }
            return State.toVirtualFiles(ContainerUtil.concat((List)ContainerUtil.newArrayList(FileSystems.getDefault().getRootDirectories()), (List)ContainerUtil.map(distributions, WSLDistribution::getUNCRootPath)));
        }

        private void setRoots(@NotNull List<VirtualFile> newRootFiles) {
            List<Root> oldRoots;
            if (newRootFiles == null) {
                State.$$$reportNull$$$0(1);
            }
            if ((oldRoots = this.model.roots) == null) {
                LOG.error("Roots have not been calculated yet, new roots won't be set due to a possible race condition");
                return;
            }
            List<VirtualFile> oldRootFiles = State.toRootFiles(oldRoots);
            if (LOG.isDebugEnabled()) {
                LOG.debug("New roots: " + String.valueOf(newRootFiles) + ", old roots: " + String.valueOf(oldRootFiles));
            }
            this.removeRoots(oldRoots, State.findNewElementIndices(oldRootFiles, newRootFiles));
            List<Root> rootsToAdd = newRootFiles.stream().filter(root -> !oldRootFiles.contains(root)).map(root -> new Root(this, (VirtualFile)root)).collect(Collectors.toList());
            this.addRoots(this.model.roots, rootsToAdd);
        }

        private static @Unmodifiable @NotNull List<VirtualFile> toRootFiles(@NotNull List<Root> roots) {
            if (roots == null) {
                State.$$$reportNull$$$0(2);
            }
            List list2 = ContainerUtil.map(roots, FileNode::getFile);
            if (list2 == null) {
                State.$$$reportNull$$$0(3);
            }
            return list2;
        }

        private void removeRoots(@NotNull List<Root> roots, int[] indicesToRemove) {
            if (roots == null) {
                State.$$$reportNull$$$0(4);
            }
            if (indicesToRemove.length > 0) {
                List<Root> rootsToRemove = Arrays.stream(indicesToRemove).mapToObj(ind -> (Root)roots.get(ind)).toList();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Removing " + String.valueOf(State.toRootFiles(rootsToRemove)));
                }
                this.model.roots = ContainerUtil.filter(roots, root -> !rootsToRemove.contains(root));
                this.model.treeNodesRemoved(this.path, indicesToRemove, rootsToRemove.toArray());
            }
        }

        private void addRoots(@NotNull List<Root> roots, @NotNull List<Root> rootsToAdd) {
            if (roots == null) {
                State.$$$reportNull$$$0(5);
            }
            if (rootsToAdd == null) {
                State.$$$reportNull$$$0(6);
            }
            if (!rootsToAdd.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding " + String.valueOf(State.toRootFiles(rootsToAdd)));
                }
                this.model.roots = List.copyOf(ContainerUtil.concat(roots, rootsToAdd));
                this.model.treeNodesInserted(this.path, IntStream.range(roots.size(), roots.size() + rootsToAdd.size()).toArray(), rootsToAdd.toArray());
            }
        }

        private static <E> int[] findNewElementIndices(@NotNull List<E> a, @NotNull List<E> b) {
            if (a == null) {
                State.$$$reportNull$$$0(7);
            }
            if (b == null) {
                State.$$$reportNull$$$0(8);
            }
            IntArrayList newIndices = new IntArrayList();
            for (int i2 = 0; i2 < a.size(); ++i2) {
                if (b.contains(a.get(i2))) continue;
                newIndices.add(i2);
            }
            return newIndices.toIntArray();
        }

        @NotNull
        private static List<VirtualFile> toVirtualFiles(@NotNull Iterable<? extends Path> paths) {
            if (paths == null) {
                State.$$$reportNull$$$0(9);
            }
            List<VirtualFile> list2 = StreamSupport.stream(paths.spliterator(), false).map(root -> LocalFileSystem.getInstance().findFileByNioFile(root)).filter(State::isValid).collect(Collectors.toList());
            if (list2 == null) {
                State.$$$reportNull$$$0(10);
            }
            return list2;
        }

        public String toString() {
            return this.descriptor.getTitle();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "distributions";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newRootFiles";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 3: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileChooser/tree/FileTreeModel$State";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootsToAdd";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "a";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "b";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paths";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileChooser/tree/FileTreeModel$State";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toRootFiles";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toVirtualFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getLocalAndWslRoots";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setRoots";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "toRootFiles";
                    break;
                }
                case 3: 
                case 10: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "removeRoots";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addRoots";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "findNewElementIndices";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "toVirtualFiles";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 10 -> new IllegalStateException(string);
            };
        }
    }

    private static class Node
    extends FileNode {
        @Nullable
        private final FileRefresher myRefresher;
        private boolean myInitialized;
        private boolean invalid;

        private Node(State state2, VirtualFile file2) {
            super(file2);
            this.myRefresher = state2.refresher;
            this.updateContent(state2);
        }

        private boolean updateContent(State state2) {
            VirtualFile file2 = this.getFile();
            if (file2 == null) {
                return this.updateName(state2.descriptor.getTitle());
            }
            Icon icon2 = state2.descriptor.getIcon(file2);
            String name2 = state2.descriptor.getName(file2);
            String comment2 = state2.descriptor.getComment(file2);
            if (name2 == null || comment2 == null) {
                name2 = file2.getPresentableName();
            }
            boolean updated = false;
            if (this.updateIcon(icon2)) {
                updated = true;
            }
            if (this.updateName(name2)) {
                updated = true;
            }
            if (this.updateComment(comment2)) {
                updated = true;
            }
            if (this.updateValid(file2.isValid())) {
                updated = true;
            }
            if (this.updateHidden(FileElement.isFileHidden((VirtualFile)file2))) {
                updated = true;
            }
            if (this.updateSpecial(file2.is(VFileProperty.SPECIAL))) {
                updated = true;
            }
            if (this.updateSymlink(file2.is(VFileProperty.SYMLINK))) {
                updated = true;
            }
            if (this.updateWritable(file2.isWritable())) {
                updated = true;
            }
            return updated;
        }

        public String toString() {
            return this.getName();
        }

        void ensureInitialized() {
            if (this.myInitialized) {
                return;
            }
            this.myInitialized = true;
            if (this.myRefresher != null && !this.myRefresher.isRecursive()) {
                this.myRefresher.register(this.getFile());
            }
        }
    }

    private static final class Root
    extends Node {
        private final MapBasedTree<VirtualFile, Node> tree;

        private Root(State state2, VirtualFile file2) {
            super(state2, file2);
            this.tree = new MapBasedTree<VirtualFile, Node>(false, node -> node.getFile(), state2.path);
            this.tree.onInsert(node -> Root.markDirtyInternal(node.getFile()));
            this.tree.updateRoot((Pair<Node, Boolean>)Pair.create((Object)this, (Object)state2.isLeaf(file2)));
        }

        private static void markDirtyInternal(VirtualFile file2) {
            Method method;
            if (file2 instanceof VirtualFileSystemEntry && (method = ReflectionUtil.getDeclaredMethod(VirtualFileSystemEntry.class, (String)"markDirtyInternal", (Class[])new Class[0])) != null) {
                try {
                    method.invoke((Object)file2, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private MapBasedTree.UpdateResult<Node> updateChildren(State state2, MapBasedTree.Entry<Node> parent) {
            VirtualFile[] children2 = state2.getChildren(parent.getNode().getFile());
            if (children2 == null) {
                return this.tree.update(parent, null);
            }
            if (children2.length == 0) {
                return this.tree.update(parent, Collections.emptyList());
            }
            return this.tree.update(parent, Arrays.stream(children2).filter(state2::isVisible).sorted(state2::compare).map(file2 -> {
                MapBasedTree.Entry<Node> entry = this.tree.findEntry((VirtualFile)file2);
                return entry != null && parent == entry.getParentPath() ? Pair.create((Object)entry.getNode(), (Object)entry.isLeaf()) : Pair.create((Object)new Node(state2, (VirtualFile)file2), (Object)state2.isLeaf((VirtualFile)file2));
            }).collect(Collectors.toList()));
        }
    }
}

