/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.impl.DockableEditor;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainerKt;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWindowKt;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.DockableContent;
import com.intellij.ui.docking.DragSession;
import com.intellij.ui.docking.impl.DockManagerImpl;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.ui.UIUtil;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/fileEditor/impl/EditorTabbedContainerDragOutDelegate;", "Lcom/intellij/ui/tabs/TabInfo$DragOutDelegate;", "window", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "editorTabs", "Lcom/intellij/ui/tabs/impl/JBTabsImpl;", "<init>", "(Lcom/intellij/openapi/fileEditor/impl/EditorWindow;Lcom/intellij/ui/tabs/impl/JBTabsImpl;)V", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "session", "Lcom/intellij/ui/docking/DragSession;", "dragOutStarted", "", "mouseEvent", "Ljava/awt/event/MouseEvent;", "info", "Lcom/intellij/ui/tabs/TabInfo;", "processDragOut", "event", "source", "dragOutFinished", "dragOutCancelled", "intellij.platform.ide.impl"})
public final class EditorTabbedContainerDragOutDelegate
implements TabInfo.DragOutDelegate {
    @NotNull
    private final EditorWindow window;
    @NotNull
    private final JBTabsImpl editorTabs;
    @Nullable
    private VirtualFile file;
    @Nullable
    private DragSession session;

    public EditorTabbedContainerDragOutDelegate(@NotNull EditorWindow window, @NotNull JBTabsImpl editorTabs) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter((Object)editorTabs, (String)"editorTabs");
        this.window = window;
        this.editorTabs = editorTabs;
    }

    public void dragOutStarted(@NotNull MouseEvent mouseEvent, @NotNull TabInfo info) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Image img = JBTabsImpl.Companion.getComponentImage(info);
        Object object = info.getObject();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.VirtualFile");
        VirtualFile file2 = (VirtualFile)object;
        int dragStartIndex = this.editorTabs.getIndexOf(info);
        boolean isPinnedAtStart = info.isPinned();
        TabInfo tabInfo = this.window.getTabToSelect$intellij_platform_ide_impl(info, file2, dragStartIndex);
        if (tabInfo != null) {
            TabInfo it = tabInfo;
            boolean bl = false;
            WriteIntentReadAction.run(() -> EditorTabbedContainerDragOutDelegate.dragOutStarted$lambda$0$0(this, it));
        }
        info.setHidden(true);
        this.file = file2;
        file2.putUserData(EditorWindow.Companion.getDRAG_START_INDEX_KEY$intellij_platform_ide_impl(), (Object)dragStartIndex);
        file2.putUserData(EditorWindow.Companion.getDRAG_START_LOCATION_HASH_KEY$intellij_platform_ide_impl(), (Object)System.identityHashCode(this.editorTabs));
        file2.putUserData(EditorWindow.DRAG_START_PINNED_KEY, (Object)isPinnedAtStart);
        Presentation presentation2 = new Presentation(info.getText());
        presentation2.setIcon(info.getIcon());
        List<FileEditor> editors = EditorWindowKt.getComposite(info).getAllEditors();
        boolean isSingletonEditorInWindow = EditorTabbedContainerKt.isSingletonEditorInWindow(editors);
        this.session = DockManager.getInstance((Project)this.window.getManager().getProject()).createDragSession(mouseEvent, (DockableContent)new DockableEditor(img, file2, presentation2, this.window.getSize(), this.window.isFilePinned(file2), isSingletonEditorInWindow, DockManagerImpl.Companion.isNorthPanelAvailable(editors)));
    }

    public void processDragOut(@NotNull MouseEvent event, @NotNull TabInfo source) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        DragSession dragSession = this.session;
        Intrinsics.checkNotNull((Object)dragSession);
        dragSession.process(event);
    }

    /*
     * Unable to fully structure code
     */
    public void dragOutFinished(@NotNull MouseEvent event, @NotNull TabInfo source) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (UIUtil.isControlKeyDown((MouseEvent)event)) ** GOTO lbl-1000
        v0 = this.session;
        Intrinsics.checkNotNull((Object)v0);
        if (v0.getResponse(event) == DockContainer.ContentResponse.ACCEPT_COPY) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = copy = false;
        }
        if (copy) {
            source.setHidden(false);
        } else {
            v2 = this.file;
            Intrinsics.checkNotNull((Object)v2);
            file = v2;
            file.putUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN, (Object)true);
            this.window.getManager().closeFile$intellij_platform_ide_impl(this.window, EditorWindowKt.getComposite(source), false);
        }
        v3 = this.session;
        Intrinsics.checkNotNull((Object)v3);
        v3.process(event);
        if (!copy) {
            v4 = this.file;
            Intrinsics.checkNotNull((Object)v4);
            v4.putUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN, null);
        }
        this.file = null;
        this.session = null;
    }

    public void dragOutCancelled(@NotNull TabInfo source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        source.setHidden(false);
        DragSession dragSession = this.session;
        if (dragSession != null) {
            DragSession it = dragSession;
            boolean bl = false;
            it.cancel();
            this.session = null;
        }
        this.file = null;
    }

    private static final void dragOutStarted$lambda$0$0(EditorTabbedContainerDragOutDelegate this$0, TabInfo $it) {
        this$0.window.setCurrentCompositeAndSelectTab$intellij_platform_ide_impl($it);
    }
}

