/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginConflictReporter;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginUtil;
import com.intellij.ide.plugins.PluginUtils;
import com.intellij.ide.plugins.StartupAbortedException;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.lang.Language;
import com.intellij.model.SideEffectGuard;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.DefaultPluginDescriptor;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypesBundle;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.UserBinaryFileType;
import com.intellij.openapi.fileTypes.UserFileType;
import com.intellij.openapi.fileTypes.ex.ExternalizableFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.fileTypes.impl.AlarmAdapterKt;
import com.intellij.openapi.fileTypes.impl.ConflictingFileTypeMappingTracker;
import com.intellij.openapi.fileTypes.impl.DetectedByContentFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.fileTypes.impl.FileTypeAssocTableUtil;
import com.intellij.openapi.fileTypes.impl.FileTypeBean;
import com.intellij.openapi.fileTypes.impl.FileTypeDetectionService;
import com.intellij.openapi.fileTypes.impl.FileTypeOverrider;
import com.intellij.openapi.fileTypes.impl.IgnoredFileCache;
import com.intellij.openapi.fileTypes.impl.RemovedMappingTracker;
import com.intellij.openapi.fileTypes.impl.copy1.IgnoredPatternSet;
import com.intellij.openapi.options.NonLazySchemeProcessor;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserExtensionsStateService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithAssignedFileType;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.CachedFileType;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.StubVirtualFile;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ResourceUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Unit;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.MutableSharedFlow;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;

@State(name="FileTypeManager", storages={@Storage(value="filetypes.xml")}, additionalExportDirectory="filetypes", category=SettingsCategory.CODE)
public class FileTypeManagerImpl
extends FileTypeManagerEx
implements PersistentStateComponent<Element>,
ExtensionPointListener<FileTypeBean> {
    @ApiStatus.Internal
    public static final ExtensionPointName<FileTypeBean> EP_NAME = new ExtensionPointName("com.intellij.fileType");
    private static final Logger LOG = Logger.getInstance(FileTypeManagerImpl.class);
    @ApiStatus.Internal
    public static final int VERSION = 19;
    @ApiStatus.Internal
    public static final List<String> DEFAULT_IGNORED = List.of("*.pyc", "*.pyo", "*.rbc", "*.yarb", "*~", ".DS_Store", ".git", ".hg", ".mypy_cache", ".pytest_cache", ".ruff_cache", ".svn", "CVS", "__pycache__", "_svn", "vssver.scc", "vssver2.scc");
    static final String FILE_SPEC = "filetypes";
    private static final String ELEMENT_EXTENSION_MAP = "extensionMap";
    private static final String ELEMENT_FILETYPE = "filetype";
    private static final String ELEMENT_IGNORE_FILES = "ignoreFiles";
    private static final String ATTRIBUTE_LIST = "list";
    private static final String ATTRIBUTE_VERSION = "version";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_DESCRIPTION = "description";
    private static final String[] FILE_TYPES_WITH_PREDEFINED_EXTENSIONS = new String[]{"JSP", "JSPX", "DTD", "HTML", "Properties", "XHTML"};
    private volatile CachedFileTypes CACHED;
    private final Set<FileTypeWithDescriptor> defaultTypes;
    @ApiStatus.Internal
    @VisibleForTesting
    public final FileTypeDetectionService detectionService;
    private FileTypeIdentifiableByVirtualFile[] specialFileTypes;
    FileTypeAssocTable<FileTypeWithDescriptor> patternsTable;
    private final IgnoredPatternSet ignoredPatterns;
    private final IgnoredFileCache myIgnoredFileCache;
    private final FileTypeAssocTable<FileType> initialAssociations;
    private final Map<FileNameMatcher, String> unresolvedMappings;
    private final Map<String, String> unresolvedHashBangs;
    private final RemovedMappingTracker removedMappingTracker;
    private final ConflictingFileTypeMappingTracker conflictingMappingTracker;
    private final Map<String, FileTypeBean> pendingFileTypes;
    private final FileTypeAssocTable<FileTypeBean> pendingAssociations;
    private final ReadWriteLock myPendingInitializationLock;
    private final Map<PluginDescriptor, Set<FileTypeWithDescriptor>> fileTypesPerPlugin;
    private final MutableSharedFlow<Unit> checkDuplicatedAlarm;
    @Nullable
    private Consumer<? super ConflictingFileTypeMappingTracker.ResolveConflictResult> conflictResultConsumer;
    private final Map<String, StandardFileType> standardFileTypes;
    private final SchemeManager<FileTypeWithDescriptor> schemeManager;
    private FileTypeOverrider[] fileTypeOverriderCache;
    @ApiStatus.Internal
    public final Set<String> INSTANTIATED;
    @TestOnly
    @ApiStatus.Internal
    public boolean toLog;

    @ApiStatus.Internal
    public FileTypeManagerImpl(@NotNull CoroutineScope coroutineScope) throws IOException {
        if (coroutineScope == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(0);
        }
        this.defaultTypes = CollectionFactory.createSmallMemoryFootprintSet();
        this.specialFileTypes = FileTypeIdentifiableByVirtualFile.EMPTY_ARRAY;
        this.patternsTable = FileTypeAssocTableUtil.newScalableFileTypeAssocTable();
        this.ignoredPatterns = new IgnoredPatternSet(DEFAULT_IGNORED);
        this.myIgnoredFileCache = new IgnoredFileCache(name2 -> this.ignoredPatterns.isIgnored((CharSequence)name2));
        this.initialAssociations = FileTypeAssocTableUtil.newScalableFileTypeAssocTable();
        this.unresolvedMappings = new HashMap<FileNameMatcher, String>();
        this.unresolvedHashBangs = new HashMap<String, String>();
        this.removedMappingTracker = new RemovedMappingTracker();
        this.conflictingMappingTracker = new ConflictingFileTypeMappingTracker(this.removedMappingTracker);
        this.pendingFileTypes = new LinkedHashMap<String, FileTypeBean>();
        this.pendingAssociations = FileTypeAssocTableUtil.newScalableFileTypeAssocTable();
        this.myPendingInitializationLock = new ReentrantReadWriteLock();
        this.fileTypesPerPlugin = new ConcurrentHashMap<PluginDescriptor, Set<FileTypeWithDescriptor>>();
        this.standardFileTypes = new LinkedHashMap<String, StandardFileType>();
        this.INSTANTIATED = PluginManagerCore.isUnitTestMode ? ConcurrentHashMap.newKeySet() : null;
        this.detectionService = new FileTypeDetectionService(this, coroutineScope);
        NonLazySchemeProcessor<FileTypeWithDescriptor, FileTypeWithDescriptor> abstractTypesProcessor = new NonLazySchemeProcessor<FileTypeWithDescriptor, FileTypeWithDescriptor>(){

            @NotNull
            public FileTypeWithDescriptor readScheme(@NotNull Element element, boolean duringLoad) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!duringLoad) {
                    FileTypeManagerImpl.this.fireBeforeFileTypesChanged();
                }
                IdeaPluginDescriptor pluginDescriptor = FileTypeManagerImpl.coreIdeaPluginDescriptor();
                AbstractFileType type = (AbstractFileType)FileTypeManagerImpl.this.loadFileType("filetypes.xml", element, (PluginDescriptor)pluginDescriptor, PluginAdvertiserExtensionsStateService.Companion.getInstance(), false);
                if (!duringLoad) {
                    FileTypeManagerImpl.this.fireFileTypesChanged((FileType)type, null);
                }
                return new FileTypeWithDescriptor((FileType)type, (PluginDescriptor)pluginDescriptor);
            }

            @NotNull
            public SchemeState getState(@NotNull FileTypeWithDescriptor ftd) {
                if (ftd == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!(ftd.fileType() instanceof AbstractFileType) || !FileTypeManagerImpl.shouldSave(ftd.fileType())) {
                    SchemeState schemeState = SchemeState.NON_PERSISTENT;
                    if (schemeState == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return schemeState;
                }
                if (!FileTypeManagerImpl.this.defaultTypes.contains(ftd)) {
                    SchemeState schemeState = SchemeState.POSSIBLY_CHANGED;
                    if (schemeState == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return schemeState;
                }
                SchemeState schemeState = ((AbstractFileType)ftd.fileType()).isModified() ? SchemeState.POSSIBLY_CHANGED : SchemeState.NON_PERSISTENT;
                if (schemeState == null) {
                    1.$$$reportNull$$$0(4);
                }
                return schemeState;
            }

            @NotNull
            public Element writeScheme(@NotNull FileTypeWithDescriptor ftd) {
                if (ftd == null) {
                    1.$$$reportNull$$$0(5);
                }
                Element root = new Element(FileTypeManagerImpl.ELEMENT_FILETYPE);
                AbstractFileType fileType2 = (AbstractFileType)ftd.fileType();
                root.setAttribute("binary", String.valueOf(fileType2.isBinary()));
                if (!Strings.isEmpty((String)fileType2.getDefaultExtension())) {
                    root.setAttribute("default_extension", fileType2.getDefaultExtension());
                }
                root.setAttribute(FileTypeManagerImpl.ATTRIBUTE_DESCRIPTION, fileType2.getDescription());
                root.setAttribute(FileTypeManagerImpl.ATTRIBUTE_NAME, fileType2.getName());
                fileType2.writeExternal(root);
                Element map2 = new Element(FileTypeManagerImpl.ELEMENT_EXTENSION_MAP);
                FileTypeManagerImpl.this.writeExtensionsMap(map2, ftd, false);
                if (!map2.getChildren().isEmpty()) {
                    root.addContent(map2);
                }
                Element element = root;
                if (element == null) {
                    1.$$$reportNull$$$0(6);
                }
                return element;
            }

            public void onSchemeDeleted(@NotNull FileTypeWithDescriptor scheme) {
                if (scheme == null) {
                    1.$$$reportNull$$$0(7);
                }
                ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.nonModal(), () -> {
                    Application app = ApplicationManager.getApplication();
                    app.runWriteAction(() -> FileTypeManagerImpl.this.fireBeforeFileTypesChanged());
                    FileTypeManagerImpl.this.patternsTable.removeAllAssociations((Object)scheme);
                    app.runWriteAction(() -> FileTypeManagerImpl.this.fireFileTypesChanged(null, scheme.fileType()));
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3, 4, 6 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ftd";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scheme";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getState";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "writeScheme";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "readScheme";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getState";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: {
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "writeScheme";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "onSchemeDeleted";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3, 4, 6 -> new IllegalStateException(string);
                };
            }
        };
        this.schemeManager = SchemeManagerFactory.getInstance().create(FILE_SPEC, (SchemeProcessor)abstractTypesProcessor, null, null, SettingsCategory.CODE);
        this.checkDuplicatedAlarm = AlarmAdapterKt.singleAlarm(400, coroutineScope, this::checkUnique);
        EP_NAME.addExtensionPointListener((ExtensionPointListener)this, (Disposable)this);
        FileTypeOverrider.EP_NAME.addExtensionPointListener(coroutineScope, (ExtensionPointListener)new ExtensionPointListener<FileTypeOverrider>(){

            public void extensionAdded(FileTypeOverrider extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(0);
                }
                FileTypeManagerImpl.this.fileTypeOverriderCache = null;
            }

            public void extensionRemoved(FileTypeOverrider extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                FileTypeManagerImpl.this.fileTypeOverriderCache = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "pluginDescriptor";
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @ApiStatus.Internal
    public void extensionAdded(@NotNull FileTypeBean fileTypeBean, @NotNull PluginDescriptor pluginDescriptor) {
        if (fileTypeBean == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(1);
        }
        if (pluginDescriptor == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(2);
        }
        this.fireBeforeFileTypesChanged();
        FileTypeManagerImpl.initializeMatchers(pluginDescriptor, fileTypeBean);
        FileTypeBean pendingFileTypeBean = (FileTypeBean)this.withReadLock(() -> this.pendingFileTypes.get(fileTypeBean.name));
        if (pendingFileTypeBean != null) {
            this.instantiateFileTypeBean(pendingFileTypeBean);
        }
        FileType fileType2 = this.mergeOrInstantiateFileTypeBean(fileTypeBean);
        this.fireFileTypesChanged(fileType2, null);
    }

    @ApiStatus.Internal
    public void extensionRemoved(@NotNull FileTypeBean extension, @NotNull PluginDescriptor pluginDescriptor) {
        if (extension == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(3);
        }
        if (pluginDescriptor == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(4);
        }
        if (extension.implementationClass != null) {
            FileType fileType2 = this.findFileTypeByName(extension.name);
            if (fileType2 != null) {
                this.doUnregisterFileType(fileType2, pluginDescriptor);
            }
        } else {
            StandardFileType stdFileType = this.standardFileTypes.get(extension.name);
            if (stdFileType != null) {
                this.unregisterMatchers(stdFileType, extension);
            }
        }
    }

    @TestOnly
    @ApiStatus.Internal
    public void listenAsyncVfsEvents() {
        VirtualFileManager.getInstance().addAsyncFileListener(this.detectionService::prepareChange, (Disposable)this);
    }

    @ApiStatus.Internal
    @NotNull
    public static IdeaPluginDescriptor coreIdeaPluginDescriptor() {
        IdeaPluginDescriptor ideaPluginDescriptor = Objects.requireNonNull(PluginManagerCore.getPlugin((PluginId)PluginManagerCore.CORE_ID), "The core plugin is amiss");
        if (ideaPluginDescriptor == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(5);
        }
        return ideaPluginDescriptor;
    }

    private void unregisterMatchers(@NotNull StandardFileType stdFileType, @NotNull FileTypeBean extension) {
        if (stdFileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(6);
        }
        if (extension == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            stdFileType.matchers.removeAll(extension.getMatchers());
            for (FileNameMatcher matcher : extension.getMatchers()) {
                this.patternsTable.removeAssociation(matcher, (Object)stdFileType.getDescriptor());
            }
            this.fireFileTypesChanged(stdFileType.fileType, null);
        });
    }

    private void initStandardFileTypes() {
        block7: {
            this.instantiatePendingFileTypes();
            this.loadFileTypeBeans();
            FileTypeFactory.FILE_TYPE_FACTORY_EP.processWithPluginDescriptor((factory, pluginDescriptor) -> {
                try {
                    factory.createFileTypes((FileTypeConsumer)new PluginFileTypeConsumer((PluginDescriptor)pluginDescriptor));
                }
                catch (StartupAbortedException | ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new StartupAbortedException("Cannot create file types", (Throwable)new PluginException(e, pluginDescriptor.getPluginId()));
                }
                return Unit.INSTANCE;
            });
            PluginAdvertiserExtensionsStateService pluginAdvertiserExtensionsStateService = PluginAdvertiserExtensionsStateService.Companion.getInstance();
            for (StandardFileType pair : this.standardFileTypes.values()) {
                if (this.schemeManager.findSchemeByName(pair.fileType.getName()) != null) continue;
                this.registerFileTypeWithoutNotification(pair.fileType, pair.pluginDescriptor, pair.matchers, pluginAdvertiserExtensionsStateService, true);
            }
            try {
                byte[] defaultFileTypeData = ResourceUtil.getResourceAsBytes((String)"defaultFileTypes.xml", (ClassLoader)FileTypeManagerImpl.class.getClassLoader());
                if (defaultFileTypeData == null) break block7;
                Element defaultFileTypesElement = JDOMUtil.load((byte[])defaultFileTypeData);
                IdeaPluginDescriptor coreIdeaPluginDescriptor = FileTypeManagerImpl.coreIdeaPluginDescriptor();
                for (Element e : defaultFileTypesElement.getChildren()) {
                    if (FILE_SPEC.equals(e.getName())) {
                        for (Element element : e.getChildren(ELEMENT_FILETYPE)) {
                            String fileTypeName = element.getAttributeValue(ATTRIBUTE_NAME);
                            if (this.pendingFileTypes.get(fileTypeName) != null) continue;
                            this.loadFileType("defaultFileTypes.xml", element, (PluginDescriptor)coreIdeaPluginDescriptor, pluginAdvertiserExtensionsStateService, true);
                        }
                        continue;
                    }
                    if (!ELEMENT_EXTENSION_MAP.equals(e.getName())) continue;
                    this.readGlobalMappings(e, true);
                }
                if (PlatformUtils.isIdeaCommunity()) {
                    Element extensionMap = new Element(ELEMENT_EXTENSION_MAP);
                    extensionMap.addContent(new Element("mapping").setAttribute("ext", "jspx").setAttribute("type", "XML"));
                    extensionMap.addContent(new Element("mapping").setAttribute("ext", "tagx").setAttribute("type", "XML"));
                    this.readGlobalMappings(extensionMap, true);
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    @ApiStatus.Internal
    public void clearStandardFileTypesBeforeTest() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myPendingInitializationLock.writeLock().lock();
        try {
            String name2;
            this.pendingAssociations.clear();
            this.pendingFileTypes.clear();
            for (Map.Entry<String, StandardFileType> entry : this.standardFileTypes.entrySet()) {
                name2 = entry.getKey();
                StandardFileType stdType = entry.getValue();
                FileType type = stdType.fileType;
                FileTypeWithDescriptor ftd = stdType.getDescriptor();
                for (FileNameMatcher matcher : stdType.matchers) {
                    this.removeAssociation(ftd, matcher, false);
                }
                this.schemeManager.removeScheme(name2);
                this.removeFromDuplicates(type, ftd.pluginDescriptor());
            }
            this.standardFileTypes.clear();
            for (FileTypeWithDescriptor ftd : this.defaultTypes) {
                name2 = ftd.getName();
                FileType defaultType = ftd.fileType();
                List<FileNameMatcher> matchers = this.getAssociations(defaultType);
                for (FileNameMatcher matcher : matchers) {
                    this.removeAssociation(ftd, matcher, false);
                }
                this.schemeManager.removeScheme(name2);
                this.removeFromDuplicates(defaultType, ftd.pluginDescriptor());
            }
            this.defaultTypes.clear();
        }
        finally {
            this.myPendingInitializationLock.writeLock().unlock();
        }
    }

    private void removeFromDuplicates(@NotNull FileType type, @NotNull PluginDescriptor pluginDescriptor) {
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(8);
        }
        if (pluginDescriptor == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(9);
        }
        this.fileTypesPerPlugin.computeIfAbsent(pluginDescriptor, __ -> ConcurrentCollectionFactory.createConcurrentSet()).removeIf(descriptor2 -> descriptor2.fileType().equals((Object)type));
    }

    private void loadFileTypeBeans() {
        List fileTypeBeans = EP_NAME.getExtensionList();
        for (FileTypeBean bean : fileTypeBeans) {
            FileTypeManagerImpl.initializeMatchers(bean.getPluginDescriptor(), bean);
        }
        for (FileTypeBean bean : fileTypeBeans) {
            if (bean.implementationClass == null) continue;
            if (this.pendingFileTypes.containsKey(bean.name)) {
                FileTypeManagerImpl.handleFileTypesConflict(bean, this.pendingFileTypes.get(bean.name));
                continue;
            }
            this.pendingFileTypes.put(bean.name, bean);
            for (FileNameMatcher matcher : bean.getMatchers()) {
                this.pendingAssociations.addAssociation(matcher, (Object)bean);
            }
        }
        for (FileTypeBean bean : fileTypeBeans) {
            if (bean.implementationClass != null) continue;
            FileTypeBean oldBean = this.pendingFileTypes.get(bean.name);
            if (oldBean == null) {
                LOG.error((Throwable)new PluginException("Trying to add extensions to non-registered file type " + bean.name, bean.getPluginId()));
                continue;
            }
            oldBean.addMatchers(bean.getMatchers());
            for (FileNameMatcher matcher : bean.getMatchers()) {
                this.pendingAssociations.addAssociation(matcher, (Object)oldBean);
            }
        }
    }

    private static void handleFileTypesConflict(@NotNull FileTypeBean bean, @NotNull FileTypeBean otherBean) {
        PluginConflictReporter conflictReporter;
        Application application;
        if (bean == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(10);
        }
        if (otherBean == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(11);
        }
        if ((application = ApplicationManager.getApplication()) != null && (conflictReporter = (PluginConflictReporter)application.getService(PluginConflictReporter.class)) != null) {
            HashSet<PluginId> conflictingPlugins = new HashSet<PluginId>();
            conflictingPlugins.add(bean.getPluginId());
            conflictingPlugins.add(otherBean.getPluginId());
            boolean hasConflictWithPlatform = PluginManagerCore.CORE_ID.equals((Object)bean.getPluginId()) || PluginManagerCore.CORE_ID.equals((Object)otherBean.getPluginId());
            conflictReporter.reportConflict(conflictingPlugins, hasConflictWithPlatform);
            return;
        }
        LOG.error((Throwable)new PluginException("Trying to override already registered file type '" + bean.name + "'", bean.getPluginId()));
    }

    private static void initializeMatchers(@NotNull Object context, @NotNull FileTypeBean bean) {
        if (context == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(12);
        }
        if (bean == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(13);
        }
        bean.addMatchers(FileTypeManagerImpl.parseExtensions(context, Strings.notNullize((String)bean.extensions)));
        bean.addMatchers(FileTypeManagerImpl.parse(context, Strings.notNullize((String)bean.fileNames), token -> new ExactFileNameMatcher(token)));
        bean.addMatchers(FileTypeManagerImpl.parse(context, Strings.notNullize((String)bean.fileNamesCaseInsensitive), token -> new ExactFileNameMatcher(token, true)));
        bean.addMatchers(FileTypeManagerImpl.parse(context, Strings.notNullize((String)bean.patterns), token -> FileNameMatcherFactory.getInstance().createMatcher(token)));
    }

    private void instantiatePendingFileTypes() {
        Collection fileTypes = (Collection)this.withReadLock(() -> new ArrayList<FileTypeBean>(this.pendingFileTypes.values()));
        for (FileTypeBean fileTypeBean : fileTypes) {
            this.mergeOrInstantiateFileTypeBean(fileTypeBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private FileType mergeOrInstantiateFileTypeBean(@NotNull FileTypeBean fileTypeBean) {
        if (fileTypeBean == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(14);
        }
        this.myPendingInitializationLock.writeLock().lock();
        StandardFileType type = this.standardFileTypes.get(fileTypeBean.name);
        if (type == null) {
            FileType fileType2 = FileTypeManagerImpl.getFileTypeOrUnknown(this.instantiateFileTypeBean(fileTypeBean));
            FileType fileType3 = fileType2;
            if (fileType3 == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(15);
            }
            return fileType3;
        }
        type.matchers.addAll(fileTypeBean.getMatchers());
        for (FileNameMatcher matcher : fileTypeBean.getMatchers()) {
            this.patternsTable.addAssociation(matcher, (Object)type.getDescriptor());
        }
        FileType fileType4 = type.fileType;
        FileType fileType5 = fileType4;
        if (fileType5 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(16);
        }
        return fileType5;
        finally {
            this.myPendingInitializationLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private FileTypeWithDescriptor instantiateFileTypeBean(@NotNull FileTypeBean bean) {
        if (bean == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(17);
        }
        this.myPendingInitializationLock.writeLock().lock();
        try {
            FileTypeWithDescriptor ftd;
            String fileTypeName = bean.name;
            StandardFileType type = this.standardFileTypes.get(fileTypeName);
            if (type != null) {
                type.matchers.addAll(bean.getMatchers());
                for (FileNameMatcher matcher : bean.getMatchers()) {
                    this.patternsTable.addAssociation(matcher, (Object)type.getDescriptor());
                }
                FileTypeWithDescriptor fileTypeWithDescriptor = type.getDescriptor();
                return fileTypeWithDescriptor;
            }
            if (!this.pendingFileTypes.containsKey(fileTypeName) && (ftd = (FileTypeWithDescriptor)this.schemeManager.findSchemeByName(fileTypeName)) != null && !(ftd.fileType() instanceof AbstractFileType)) {
                FileTypeWithDescriptor matcher = ftd;
                return matcher;
            }
            PluginId pluginId = bean.getPluginDescriptor().getPluginId();
            FileType fileType2 = null;
            try {
                Class aClass = ApplicationManager.getApplication().loadClass(bean.implementationClass, bean.getPluginDescriptor());
                Field field = FileTypeManagerImpl.getField(bean, aClass);
                if (field != null) {
                    field.setAccessible(true);
                    fileType2 = (FileType)field.get(null);
                }
                if (fileType2 == null) {
                    if (this.INSTANTIATED != null && !this.INSTANTIATED.add(fileTypeName)) {
                        throw new IllegalStateException("File type '" + fileTypeName + "' instantiated twice. Descriptor=" + String.valueOf(bean.getPluginDescriptor()) + "; fieldName=" + bean.fieldName + ". Maybe adding this to the class '" + bean.implementationClass + "' will help: `private static final " + bean.implementationClass + " INSTANCE = new " + bean.implementationClass + "()`");
                    }
                    fileType2 = (FileType)ApplicationManager.getApplication().instantiateClass(bean.implementationClass, bean.getPluginDescriptor());
                }
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                FileTypeWithDescriptor field = null;
                this.myPendingInitializationLock.writeLock().unlock();
                return field;
            }
            if (!fileType2.getName().equals(fileTypeName)) {
                LOG.error((Throwable)new PluginException("Incorrect name specified in <fileType>, should be " + fileType2.getName() + ", actual " + fileTypeName, pluginId));
            }
            if (fileType2 instanceof LanguageFileType) {
                String expectedLanguage;
                LanguageFileType languageFileType = (LanguageFileType)fileType2;
                String string = expectedLanguage = languageFileType.isSecondary() ? null : languageFileType.getLanguage().getID();
                if (!Objects.equals(bean.language, expectedLanguage)) {
                    LOG.error((Throwable)new PluginException("Incorrect language specified in <fileType> for " + fileType2.getName() + ", should be " + expectedLanguage + ", actual " + bean.language, pluginId));
                }
            }
            StandardFileType standardFileType = new StandardFileType(fileType2, bean.getPluginDescriptor(), bean.getMatchers());
            this.standardFileTypes.put(bean.name, standardFileType);
            PluginAdvertiserExtensionsStateService pluginAdvertiserExtensionsStateService = PluginAdvertiserExtensionsStateService.Companion.getInstance();
            this.registerFileTypeWithoutNotification(fileType2, bean.getPluginDescriptor(), standardFileType.matchers, pluginAdvertiserExtensionsStateService, true);
            if (bean.hashBangs != null) {
                for (String hashBang : StringUtil.split((String)bean.hashBangs, (String)";")) {
                    this.patternsTable.addHashBangPattern(hashBang, (Object)new FileTypeWithDescriptor(fileType2, bean.getPluginDescriptor()));
                    this.initialAssociations.addHashBangPattern(hashBang, (Object)fileType2);
                }
            }
            this.pendingAssociations.removeAllAssociations((Object)bean);
            this.pendingFileTypes.remove(fileTypeName);
            FileTypeWithDescriptor fileTypeWithDescriptor = new FileTypeWithDescriptor(fileType2, bean.getPluginDescriptor());
            return fileTypeWithDescriptor;
        }
        finally {
            this.myPendingInitializationLock.writeLock().unlock();
        }
    }

    @Nullable
    private static Field getField(@NotNull FileTypeBean bean, Class<Object> aClass) throws NoSuchFieldException {
        Field[] declaredFields;
        if (bean == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(18);
        }
        if (bean.fieldName != null) {
            try {
                return aClass.getDeclaredField(bean.fieldName);
            }
            catch (NoSuchFieldException e) {
                PluginException ex = PluginException.createByClass((String)("File type " + aClass.getName() + " has no field " + bean.fieldName), (Throwable)e, aClass);
                LOG.error((Throwable)ex);
                throw e;
            }
        }
        Field field = null;
        for (Field declaredField : declaredFields = aClass.getDeclaredFields()) {
            if (!Modifier.isStatic(declaredField.getModifiers()) || declaredField.getType() != aClass) continue;
            if (field == null) {
                field = declaredField;
                continue;
            }
            field = null;
            break;
        }
        return field;
    }

    boolean toLog() {
        return this.toLog;
    }

    void log(@NonNls String message) {
        LOG.debug(message + " - " + String.valueOf(Thread.currentThread()));
    }

    @TestOnly
    @ApiStatus.Internal
    public void drainReDetectQueue() {
        this.detectionService.drainReDetectQueue();
    }

    @TestOnly
    @ApiStatus.Internal
    @NotNull
    public Collection<VirtualFile> dumpReDetectQueue() {
        Collection<VirtualFile> collection = this.detectionService.dumpReDetectQueue();
        if (collection == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(19);
        }
        return collection;
    }

    @TestOnly
    @ApiStatus.Internal
    public void reDetectAsync(boolean enable2) {
        this.detectionService.reDetectAsync(enable2);
    }

    @NotNull
    public FileType getStdFileType(@NotNull String name2) {
        if (name2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(20);
        }
        this.instantiatePendingFileTypeByName(name2);
        StandardFileType stdFileType = (StandardFileType)this.withReadLock(() -> this.standardFileTypes.get(name2));
        Object object = stdFileType != null ? stdFileType.fileType : PlainTextFileType.INSTANCE;
        if (object == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(21);
        }
        return object;
    }

    @ApiStatus.Internal
    @NotNull
    public List<FileNameMatcher> getStandardMatchers(@NotNull FileType type) {
        StandardFileType stdFileType;
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(22);
        }
        List<Object> list2 = (stdFileType = this.standardFileTypes.get(type.getName())) != null ? stdFileType.matchers : Collections.emptyList();
        if (list2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(23);
        }
        return list2;
    }

    private void instantiatePendingFileTypeByName(@NotNull String name2) {
        FileTypeBean bean;
        if (name2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(24);
        }
        if ((bean = (FileTypeBean)this.withReadLock(() -> this.pendingFileTypes.get(name2))) != null) {
            this.instantiateFileTypeBean(bean);
        }
    }

    @ApiStatus.Internal
    public void initializeComponent() {
        this.initStandardFileTypes();
        if (!this.pendingFileTypes.isEmpty()) {
            this.instantiatePendingFileTypes();
        }
        if (!this.unresolvedMappings.isEmpty()) {
            for (StandardFileType standardFileType : this.standardFileTypes.values()) {
                this.registerReDetectedMappings(standardFileType);
            }
        }
        if (!this.unresolvedMappings.isEmpty()) {
            for (StandardFileType standardFileType : this.standardFileTypes.values()) {
                this.bindUnresolvedMappings(standardFileType);
            }
        }
        if (!this.unresolvedMappings.isEmpty()) {
            for (Map.Entry entry : this.unresolvedMappings.entrySet()) {
                this.tryToResolveMapping((String)entry.getValue(), (FileNameMatcher)entry.getKey());
            }
        }
        if (!this.unresolvedHashBangs.isEmpty()) {
            HashMap<String, String> hashBangs = new HashMap<String, String>(this.unresolvedHashBangs);
            this.unresolvedHashBangs.clear();
            this.registerHashBangs(hashBangs, false);
        }
        boolean isAtLeastOneStandardFileTypeHasBeenRead = false;
        for (FileTypeWithDescriptor ftd : this.schemeManager.loadSchemes()) {
            isAtLeastOneStandardFileTypeHasBeenRead |= this.initialAssociations.hasAssociationsFor((Object)ftd.fileType());
        }
        if (isAtLeastOneStandardFileTypeHasBeenRead) {
            this.restoreStandardFileExtensions();
        }
    }

    private void tryToResolveMapping(@NotNull String typeName, @NotNull FileNameMatcher matcher) {
        FileTypeWithDescriptor ftd;
        if (typeName == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(25);
        }
        if (matcher == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(26);
        }
        if ((ftd = this.getFileTypeWithDescriptorByName(typeName)) != null) {
            this.associate(ftd, matcher, false);
        }
    }

    @NotNull
    public FileType getFileTypeByFileName(@NotNull String fileName) {
        if (fileName == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(27);
        }
        FileType fileType2 = this.getFileTypeByFileName((CharSequence)fileName);
        if (fileType2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(28);
        }
        return fileType2;
    }

    @NotNull
    public FileType getFileTypeByFileName(@NotNull CharSequence fileName) {
        FileTypeBean pendingFileType;
        if (fileName == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(29);
        }
        if ((pendingFileType = (FileTypeBean)this.withReadLock(() -> (FileTypeBean)this.pendingAssociations.findAssociatedFileType(fileName))) != null) {
            return FileTypeManagerImpl.getFileTypeOrUnknown(this.instantiateFileTypeBean(pendingFileType));
        }
        FileTypeWithDescriptor ftd = (FileTypeWithDescriptor)this.withReadLock(() -> (FileTypeWithDescriptor)this.patternsTable.findAssociatedFileType(fileName));
        return FileTypeManagerImpl.getFileTypeOrUnknown(ftd);
    }

    public void removePlainTextAssociationsForFile(@NotNull CharSequence fileName) {
        if (fileName == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(30);
        }
        ThreadingAssertions.assertEventDispatchThread();
        SideEffectGuard.checkSideEffectAllowed((SideEffectGuard.EffectType)SideEffectGuard.EffectType.SETTINGS);
        this.myPendingInitializationLock.writeLock().lock();
        try {
            this.makeFileTypesChange("removePlainTextAssociationsForFile(" + String.valueOf(fileName) + ")", () -> this.patternsTable.removeAssociationsForFile(fileName, (Object)FileTypeWithDescriptor.allFor((FileType)PlainTextFileType.INSTANCE)));
        }
        finally {
            this.myPendingInitializationLock.writeLock().unlock();
        }
    }

    @ApiStatus.Internal
    public void freezeFileTypeTemporarilyIn(@NotNull VirtualFile file2, @NotNull Runnable runnable2) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(31);
        }
        if (runnable2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(32);
        }
        this.freezeFileTypeTemporarilyWithProvidedValueIn(file2, null, runnable2);
    }

    @ApiStatus.Internal
    public void freezeFileTypeTemporarilyWithProvidedValueIn(@NotNull VirtualFile file2, @Nullable FileType cachedFileType, @NotNull Runnable runnable2) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(33);
        }
        if (runnable2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(34);
        }
        FileType fileType2 = file2.isDirectory() ? null : (cachedFileType == null ? file2.getFileType() : cachedFileType);
        this.cacheFileTypesInside(() -> {
            if (fileType2 != null && file2 instanceof VirtualFileWithId) {
                VirtualFileWithId vfid = (VirtualFileWithId)file2;
                this.CACHED.fileTypes().put(vfid.getId(), (Object)fileType2);
            }
            runnable2.run();
        });
    }

    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(35);
        }
        FileType fileType2 = this.getFileTypeByFile(file2, null);
        if (fileType2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(36);
        }
        return fileType2;
    }

    public boolean isFileOfType(@NotNull VirtualFile virtualFile, @NotNull FileType requestedFileType) {
        FileType fileType2;
        FileType temporarilyFixedFileType;
        if (virtualFile == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(37);
        }
        if (requestedFileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(38);
        }
        if ((temporarilyFixedFileType = this.getTemporarilyFixedFileType(virtualFile)) != null) {
            return temporarilyFixedFileType.equals((Object)requestedFileType);
        }
        FileTypeOverrider[] overriders = this.fileTypeOverriderCache;
        if (overriders == null) {
            this.fileTypeOverriderCache = overriders = (FileTypeOverrider[])FileTypeOverrider.EP_NAME.getExtensions();
        }
        for (FileTypeOverrider overrider : overriders) {
            FileType overriddenFileType = overrider.getOverriddenFileType(virtualFile);
            if (overriddenFileType == null) continue;
            return overriddenFileType.equals((Object)requestedFileType);
        }
        if (virtualFile instanceof VirtualFileWithAssignedFileType && (fileType2 = ((VirtualFileWithAssignedFileType)virtualFile).getAssignedFileType()) != null) {
            return fileType2.equals((Object)requestedFileType);
        }
        if (requestedFileType instanceof FileTypeIdentifiableByVirtualFile && ((FileTypeIdentifiableByVirtualFile)requestedFileType).isMyFileType(virtualFile)) {
            return true;
        }
        fileType2 = this.getFileTypeByFileName(virtualFile.getNameSequence());
        if (fileType2 == UnknownFileType.INSTANCE) {
            fileType2 = null;
        }
        if (fileType2 == null && virtualFile instanceof FakeVirtualFile && ScratchUtil.isScratch((VirtualFile)virtualFile.getParent())) {
            return PlainTextFileType.INSTANCE.equals(requestedFileType);
        }
        if (fileType2 == null || fileType2 == DetectedByContentFileType.INSTANCE) {
            FileType detected = this.detectionService.getOrDetectFromContent(virtualFile, null, fileType2);
            if (detected == UnknownFileType.INSTANCE && fileType2 == DetectedByContentFileType.INSTANCE) {
                return DetectedByContentFileType.INSTANCE.equals(requestedFileType);
            }
            return requestedFileType.equals((Object)detected);
        }
        return requestedFileType.equals((Object)fileType2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void cacheFileTypesInside(@NotNull Runnable runnable2) {
        CachedFileTypes cached;
        if (runnable2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(39);
        }
        FileTypeManagerImpl fileTypeManagerImpl = this;
        synchronized (fileTypeManagerImpl) {
            cached = this.CACHED;
            if (cached == null) {
                this.CACHED = cached = new CachedFileTypes((ConcurrentIntObjectMap<FileType>)ConcurrentCollectionFactory.createConcurrentIntObjectMap(), new AtomicInteger(1));
            } else {
                cached.useCount().incrementAndGet();
            }
        }
        try {
            runnable2.run();
        }
        finally {
            fileTypeManagerImpl = this;
            synchronized (fileTypeManagerImpl) {
                if (cached.useCount().decrementAndGet() == 0) {
                    this.CACHED = null;
                }
            }
        }
    }

    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile virtualFile, byte @Nullable [] content2) {
        FileType temporarilyFixedFileType;
        if (virtualFile == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(40);
        }
        if ((temporarilyFixedFileType = this.getTemporarilyFixedFileType(virtualFile)) != null) {
            FileType fileType2 = temporarilyFixedFileType;
            if (fileType2 == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(41);
            }
            return fileType2;
        }
        FileTypeOverrider[] overriders = this.fileTypeOverriderCache;
        if (overriders == null) {
            this.fileTypeOverriderCache = overriders = (FileTypeOverrider[])FileTypeOverrider.EP_NAME.getExtensions();
        }
        for (FileTypeOverrider overrider : overriders) {
            FileType overriddenFileType = overrider.getOverriddenFileType(virtualFile);
            if (overriddenFileType == null) continue;
            FileType fileType3 = overriddenFileType;
            if (fileType3 == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(42);
            }
            return fileType3;
        }
        FileType fileType4 = this.getByFile(virtualFile);
        if (virtualFile instanceof StubVirtualFile) {
            if (fileType4 == null && content2 == null && virtualFile instanceof FakeVirtualFile && ScratchUtil.isScratch((VirtualFile)virtualFile.getParent())) {
                PlainTextFileType plainTextFileType = PlainTextFileType.INSTANCE;
                if (plainTextFileType == null) {
                    FileTypeManagerImpl.$$$reportNull$$$0(43);
                }
                return plainTextFileType;
            }
        } else if (fileType4 == null || fileType4 == DetectedByContentFileType.INSTANCE) {
            fileType4 = this.internalContinueToDetectFileTypeByFile(virtualFile, content2, fileType4);
        }
        FileType result2 = fileType4 == null ? UnknownFileType.INSTANCE : fileType4;
        CachedFileTypes cached = this.CACHED;
        if (cached != null && virtualFile instanceof VirtualFileWithId) {
            VirtualFileWithId vfid = (VirtualFileWithId)virtualFile;
            cached.fileTypes().put(vfid.getId(), (Object)result2);
        }
        FileType fileType5 = result2;
        if (fileType5 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(44);
        }
        return fileType5;
    }

    @ApiStatus.Internal
    @NotNull
    protected FileType internalContinueToDetectFileTypeByFile(@NotNull VirtualFile file2, byte @Nullable [] content2, @Nullable FileType fileTypeByName) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(45);
        }
        FileType fileType2 = this.detectionService.getOrDetectFromContent(file2, content2, fileTypeByName);
        if (fileType2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(46);
        }
        return fileType2;
    }

    private FileType getTemporarilyFixedFileType(@NotNull VirtualFile file2) {
        FileType fileType2;
        CachedFileTypes cached;
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(47);
        }
        if ((cached = this.CACHED) != null && file2 instanceof VirtualFileWithId) {
            VirtualFileWithId vfid = (VirtualFileWithId)file2;
            fileType2 = (FileType)cached.fileTypes().get(vfid.getId());
        } else {
            fileType2 = null;
        }
        return fileType2;
    }

    @Nullable
    FileType getByFile(@NotNull VirtualFile file2) {
        FileType fileType2;
        FileType temporarilyFixedFileType;
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(48);
        }
        if ((temporarilyFixedFileType = this.getTemporarilyFixedFileType(file2)) != null) {
            return temporarilyFixedFileType;
        }
        if (file2 instanceof VirtualFileWithAssignedFileType && (fileType2 = ((VirtualFileWithAssignedFileType)file2).getAssignedFileType()) != null) {
            return fileType2;
        }
        for (FileType specialType : this.specialFileTypes) {
            if (!specialType.isMyFileType(file2)) continue;
            if (this.toLog()) {
                this.log("getByFile(" + file2.getName() + "): Special file type: " + specialType.getName());
            }
            return specialType;
        }
        fileType2 = this.getFileTypeByFileName(file2.getNameSequence());
        if (fileType2 == UnknownFileType.INSTANCE) {
            if (DetectedByContentFileType.isMyFileType(file2)) {
                return DetectedByContentFileType.INSTANCE;
            }
            fileType2 = null;
        }
        if (this.toLog()) {
            this.log("F: getByFile(" + file2.getName() + ") By name file type: " + (fileType2 == null ? null : fileType2.getName()));
        }
        return fileType2;
    }

    public FileType findFileTypeByName(@NotNull String fileTypeName) {
        FileType type;
        if (fileTypeName == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(49);
        }
        if ((type = this.getStdFileType(fileTypeName)) != PlainTextFileType.INSTANCE || fileTypeName.equals(type.getName())) {
            return type;
        }
        for (FileTypeWithDescriptor ftd : this.getAllFileTypeWithDescriptors()) {
            if (!fileTypeName.equals(ftd.fileType().getName())) continue;
            return ftd.fileType();
        }
        return null;
    }

    @NotNull
    private List<FileTypeWithDescriptor> getAllFileTypeWithDescriptors() {
        List list2 = this.schemeManager.getAllSchemes();
        if (list2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(50);
        }
        return list2;
    }

    @Nullable
    public LanguageFileType findFileTypeByLanguage(@NotNull Language language) {
        FileTypeBean bean;
        if (language == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(51);
        }
        if ((bean = (FileTypeBean)this.withReadLock(() -> {
            for (FileTypeBean b : this.pendingFileTypes.values()) {
                if (!language.getID().equals(b.language)) continue;
                return b;
            }
            return null;
        })) != null) {
            FileTypeWithDescriptor descriptor2 = this.instantiateFileTypeBean(bean);
            return descriptor2 != null ? (LanguageFileType)descriptor2.fileType() : null;
        }
        return (LanguageFileType)this.withReadLock(() -> language.findMyFileType((FileType[])ContainerUtil.map2Array(this.getAllFileTypeWithDescriptors(), (Object[])FileType.EMPTY_ARRAY, ftd -> ftd.fileType())));
    }

    @NotNull
    public FileType getFileTypeByExtension(@NotNull String extension) {
        if (extension == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(52);
        }
        FileType fileType2 = this.getFileTypeWithDescriptorByExtension(extension).fileType();
        if (fileType2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(53);
        }
        return fileType2;
    }

    @ApiStatus.Internal
    @NotNull
    public FileTypeWithDescriptor getFileTypeWithDescriptorByExtension(@NotNull String extension) {
        FileTypeBean pendingFileType;
        if (extension == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(54);
        }
        if ((pendingFileType = (FileTypeBean)this.withReadLock(() -> (FileTypeBean)this.pendingAssociations.findByExtension((CharSequence)extension))) != null) {
            FileTypeWithDescriptor type = this.instantiateFileTypeBean(pendingFileType);
            FileTypeWithDescriptor fileTypeWithDescriptor = type == null ? FileTypeManagerImpl.coreDescriptorFor(UnknownFileType.INSTANCE) : type;
            if (fileTypeWithDescriptor == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(55);
            }
            return fileTypeWithDescriptor;
        }
        FileTypeWithDescriptor descriptor2 = (FileTypeWithDescriptor)this.withReadLock(() -> (FileTypeWithDescriptor)this.patternsTable.findByExtension((CharSequence)extension));
        FileTypeWithDescriptor fileTypeWithDescriptor = descriptor2 == null ? FileTypeManagerImpl.coreDescriptorFor(UnknownFileType.INSTANCE) : descriptor2;
        if (fileTypeWithDescriptor == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(56);
        }
        return fileTypeWithDescriptor;
    }

    @TestOnly
    public void registerFileType(@NotNull FileType type, @NotNull List<? extends FileNameMatcher> defaultAssociations, @NotNull Disposable disposable, @NotNull PluginDescriptor pluginDescriptor) {
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(57);
        }
        if (defaultAssociations == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(58);
        }
        if (disposable == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(59);
        }
        if (pluginDescriptor == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(60);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new IllegalStateException();
        }
        this.doRegisterFileType(type, defaultAssociations);
        Disposer.register((Disposable)disposable, () -> this.doUnregisterFileType(type, pluginDescriptor));
    }

    private void doRegisterFileType(FileType type, List<? extends FileNameMatcher> defaultAssociations) {
        PluginAdvertiserExtensionsStateService pluginAdvertiserExtensionsStateService = PluginAdvertiserExtensionsStateService.Companion.getInstance();
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.fireBeforeFileTypesChanged();
            this.registerFileTypeWithoutNotification(type, FileTypeManagerImpl.detectPluginDescriptor(type).pluginDescriptor(), defaultAssociations, pluginAdvertiserExtensionsStateService, true);
            this.fireFileTypesChanged(type, null);
        });
    }

    @TestOnly
    public void unregisterFileType(@NotNull FileType fileType2, @NotNull PluginDescriptor pluginDescriptor) {
        if (fileType2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(61);
        }
        if (pluginDescriptor == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(62);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new IllegalStateException();
        }
        this.doUnregisterFileType(fileType2, pluginDescriptor);
    }

    private void doUnregisterFileType(@NotNull FileType fileType2, @NotNull PluginDescriptor pluginDescriptor) {
        if (fileType2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(63);
        }
        if (pluginDescriptor == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(64);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.fireBeforeFileTypesChanged();
            this.unregisterFileTypeWithoutNotification(fileType2);
            this.standardFileTypes.remove(fileType2.getName());
            if (fileType2 instanceof LanguageFileType) {
                Language language = ((LanguageFileType)fileType2).getLanguage();
                if (fileType2.getClass().getClassLoader().equals(language.getClass().getClassLoader())) {
                    language.unregisterLanguage(pluginDescriptor);
                }
            }
            if (this.INSTANTIATED != null) {
                this.INSTANTIATED.remove(fileType2.getName());
            }
            this.fireFileTypesChanged(null, fileType2);
        });
    }

    private void unregisterFileTypeWithoutNotification(@NotNull FileType fileType2) {
        if (fileType2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(65);
        }
        PluginDescriptor pluginDescriptor = this.findPluginDescriptor(fileType2);
        FileTypeWithDescriptor ftd = FileTypeWithDescriptor.allFor(fileType2);
        List matchers = this.patternsTable.getAssociations((Object)ftd);
        this.removedMappingTracker.removeIf(mapping -> mapping.getFileTypeName().equals(fileType2.getName()) || matchers.contains(mapping.getFileNameMatcher()));
        this.patternsTable.removeAllAssociations((Object)ftd);
        this.initialAssociations.removeAllAssociations((Object)fileType2);
        this.schemeManager.removeScheme(fileType2.getName());
        if (fileType2 instanceof FileTypeIdentifiableByVirtualFile) {
            FileTypeIdentifiableByVirtualFile fakeFileType = (FileTypeIdentifiableByVirtualFile)fileType2;
            this.specialFileTypes = (FileTypeIdentifiableByVirtualFile[])ArrayUtil.remove((Object[])this.specialFileTypes, (Object)fakeFileType, (ArrayFactory)FileTypeIdentifiableByVirtualFile.ARRAY_FACTORY);
        }
        if (pluginDescriptor != null) {
            this.removeFromDuplicates(fileType2, pluginDescriptor);
        }
    }

    public FileType @NotNull [] getRegisteredFileTypes() {
        FileType[] fileTypeArray = (FileType[])ContainerUtil.map2Array(this.getRegisteredFileTypeWithDescriptors(), FileType.class, ftd -> ftd.fileType);
        if (fileTypeArray == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(66);
        }
        return fileTypeArray;
    }

    @ApiStatus.Internal
    @NotNull
    public List<FileTypeWithDescriptor> getRegisteredFileTypeWithDescriptors() {
        this.instantiatePendingFileTypes();
        return this.getAllFileTypeWithDescriptors();
    }

    @NotNull
    public String getExtension(@NotNull String fileName) {
        if (fileName == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(67);
        }
        String string = FileUtilRt.getExtension((String)fileName);
        if (string == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(68);
        }
        return string;
    }

    @NotNull
    public String getIgnoredFilesList() {
        Set<String> masks = this.ignoredPatterns.getIgnoreMasks();
        String string = masks.isEmpty() ? "" : String.join((CharSequence)";", masks);
        if (string == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(69);
        }
        return string;
    }

    public void setIgnoredFilesList(@NotNull String list2) {
        if (list2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(70);
        }
        this.makeFileTypesChange("ignored files list updated: " + list2, () -> {
            this.clearIgnoredFileCache();
            this.ignoredPatterns.setIgnoreMasks(list2);
        });
    }

    public boolean isIgnoredFilesListEqualToCurrent(@NotNull String list2) {
        if (list2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(71);
        }
        HashSet<String> tempSet = new HashSet<String>(list2.length() / 3);
        StringTokenizer tokenizer = new StringTokenizer(list2, ";");
        while (tokenizer.hasMoreTokens()) {
            tempSet.add(tokenizer.nextToken());
        }
        return tempSet.equals(this.ignoredPatterns.getIgnoreMasks());
    }

    public boolean isFileIgnored(@NotNull String name2) {
        if (name2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(72);
        }
        return this.ignoredPatterns.isIgnored(name2);
    }

    public boolean isFileIgnored(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(73);
        }
        return this.myIgnoredFileCache.isFileIgnored(file2);
    }

    @NotNull
    public List<FileNameMatcher> getAssociations(@NotNull FileType type) {
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(74);
        }
        this.instantiatePendingFileTypeByName(type.getName());
        List list2 = (List)this.withReadLock(() -> this.patternsTable.getAssociations((Object)FileTypeWithDescriptor.allFor(type)));
        if (list2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(75);
        }
        return list2;
    }

    public void associate(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(76);
        }
        if (matcher == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(77);
        }
        this.associate(FileTypeManagerImpl.detectPluginDescriptor(type), matcher, true);
    }

    @ApiStatus.Internal
    @NotNull
    public static FileTypeWithDescriptor detectPluginDescriptor(@NotNull FileType type) {
        PluginDescriptor pluginDescriptor;
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(78);
        }
        if ((pluginDescriptor = PluginUtils.getPluginDescriptorOrPlatformByClassName((String)type.getClass().getName())) == null) {
            pluginDescriptor = FileTypeManagerImpl.coreIdeaPluginDescriptor();
        }
        return new FileTypeWithDescriptor(type, pluginDescriptor);
    }

    @NotNull
    private static FileType getFileTypeOrUnknown(@Nullable FileTypeWithDescriptor ftd) {
        FileType fileType2 = ftd == null ? UnknownFileType.INSTANCE : ftd.fileType();
        if (fileType2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(79);
        }
        return fileType2;
    }

    public void removeAssociation(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(80);
        }
        if (matcher == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(81);
        }
        this.removeAssociation(FileTypeManagerImpl.detectPluginDescriptor(type), matcher, true);
    }

    public void fireBeforeFileTypesChanged() {
        FileTypeEvent event = new FileTypeEvent((Object)this, null, null);
        ((FileTypeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC)).beforeFileTypesChanged(event);
    }

    public void fireFileTypesChanged() {
        this.fireFileTypesChanged(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeFileTypesChange(@NotNull String debugReasonMessage, @NotNull Runnable command) {
        PluginId pluginId;
        if (debugReasonMessage == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(82);
        }
        if (command == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(83);
        }
        LOG.info("File types changed: " + debugReasonMessage + (String)((pluginId = PluginUtil.getInstance().findPluginId(new Throwable())) != null ? ". Caused by plugin '" + pluginId.getIdString() + "'." : ""));
        this.fireBeforeFileTypesChanged();
        try {
            command.run();
        }
        finally {
            this.fireFileTypesChanged();
        }
    }

    private void fireFileTypesChanged(@Nullable FileType addedFileType, @Nullable FileType removedFileType) {
        this.detectionService.clearCaches();
        CachedFileType.clearCache();
        ((FileTypeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC)).fileTypesChanged(new FileTypeEvent((Object)this, addedFileType, removedFileType));
    }

    public void loadState(@NotNull Element state2) {
        if (state2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(84);
        }
        int savedVersion = StringUtilRt.parseInt((String)state2.getAttributeValue(ATTRIBUTE_VERSION), (int)0);
        for (Element element : state2.getChildren()) {
            if (ELEMENT_IGNORE_FILES.equals(element.getName())) {
                this.ignoredPatterns.setIgnoreMasks(Strings.notNullize((String)element.getAttributeValue(ATTRIBUTE_LIST)));
                continue;
            }
            if (!ELEMENT_EXTENSION_MAP.equals(element.getName())) continue;
            this.readGlobalMappings(element, false);
        }
        this.migrateFromOldVersion(savedVersion);
        this.clearIgnoredFileCache();
        this.detectionService.loadState(state2);
    }

    void clearIgnoredFileCache() {
        this.myIgnoredFileCache.clearCache();
    }

    private void migrateFromOldVersion(int savedVersion) {
        if (savedVersion < 4) {
            if (savedVersion == 0) {
                this.addIgnore(".svn");
            }
            if (savedVersion < 2) {
                this.restoreStandardFileExtensions();
            }
            this.addIgnore("*.pyc");
            this.addIgnore("*.pyo");
            this.addIgnore(".git");
        }
        if (savedVersion < 6) {
            this.addIgnore("_svn");
        }
        if (savedVersion < 7) {
            this.addIgnore(".hg");
        }
        if (savedVersion < 8) {
            this.addIgnore("*~");
        }
        if (savedVersion < 9) {
            this.addIgnore("__pycache__");
        }
        if (savedVersion < 11) {
            this.addIgnore("*.rbc");
        }
        if (savedVersion < 13) {
            this.unignoreMask("*.lib");
        }
        if (savedVersion < 15) {
            this.unignoreMask(".bundle");
        }
        if (savedVersion < 16) {
            this.unignoreMask(".tox");
        }
        if (savedVersion < 17) {
            this.addIgnore("*.rbc");
        }
        if (savedVersion < 18) {
            this.unignoreMask("*.hprof");
        }
        if (savedVersion < 19) {
            this.addIgnore(".mypy_cache");
            this.addIgnore(".ruff_cache");
            this.addIgnore(".pytest_cache");
        }
    }

    private void unignoreMask(@NotNull String maskToRemove) {
        if (maskToRemove == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(85);
        }
        LinkedHashSet<String> masks = new LinkedHashSet<String>(this.ignoredPatterns.getIgnoreMasks());
        masks.remove(maskToRemove);
        this.ignoredPatterns.clearPatterns();
        for (String each : masks) {
            this.ignoredPatterns.addIgnoreMask(each);
        }
    }

    private void readGlobalMappings(@NotNull Element e, boolean isAddToInit) {
        if (e == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(86);
        }
        this.removedMappingTracker.load(e);
        for (Pair<FileNameMatcher, String> association : AbstractFileType.readAssociations(e)) {
            String fileTypeName = (String)association.getSecond();
            FileNameMatcher matcher = (FileNameMatcher)association.getFirst();
            FileTypeWithDescriptor ftd = this.getFileTypeWithDescriptorByName(fileTypeName);
            FileType type = ftd == null ? null : ftd.fileType();
            FileTypeBean pendingFileTypeBean = (FileTypeBean)this.pendingAssociations.findAssociatedFileType(matcher);
            if (pendingFileTypeBean != null) {
                this.instantiateFileTypeBean(pendingFileTypeBean);
            }
            if (type == null) {
                this.unresolvedMappings.put(matcher, fileTypeName);
                continue;
            }
            if (PlainTextFileType.INSTANCE.equals(type)) {
                FileType newFileType;
                FileTypeWithDescriptor textFtd = (FileTypeWithDescriptor)this.patternsTable.findAssociatedFileType(matcher);
                FileType fileType2 = newFileType = textFtd == null ? null : textFtd.fileType();
                if (newFileType != null && newFileType != PlainTextFileType.INSTANCE && newFileType != UnknownFileType.INSTANCE) {
                    this.removedMappingTracker.add(matcher, newFileType.getName(), false);
                }
            }
            this.associate(ftd, matcher, false);
            if (!isAddToInit) continue;
            this.initialAssociations.addAssociation(matcher, (Object)type);
        }
        Map<String, String> hashBangs = FileTypeManagerImpl.readHashBangs(e);
        this.registerHashBangs(hashBangs, isAddToInit);
        for (RemovedMappingTracker.RemovedMapping mapping : this.removedMappingTracker.getRemovedMappings()) {
            FileTypeWithDescriptor ftd = this.getFileTypeWithDescriptorByName(mapping.getFileTypeName());
            if (ftd == null) continue;
            this.removeAssociation(ftd, mapping.getFileNameMatcher(), false);
        }
    }

    private void registerHashBangs(@NotNull Map<String, String> hashBangs, boolean isAddToInit) {
        if (hashBangs == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(87);
        }
        for (Map.Entry<String, String> entry : hashBangs.entrySet()) {
            String hashBang = entry.getKey();
            String typeName = entry.getValue();
            FileTypeWithDescriptor ftd = this.getFileTypeWithDescriptorByName(typeName);
            if (ftd == null) {
                this.unresolvedHashBangs.put(hashBang, typeName);
                continue;
            }
            this.patternsTable.addHashBangPattern(hashBang, (Object)ftd);
            if (!isAddToInit) continue;
            this.initialAssociations.addHashBangPattern(hashBang, (Object)ftd.fileType());
        }
    }

    @NotNull
    private static Map<String, String> readHashBangs(@NotNull Element e) {
        if (e == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(88);
        }
        List children2 = e.getChildren("hashBang");
        HashMap<String, String> result2 = new HashMap<String, String>();
        for (Element hashBangTag : children2) {
            String hashBangPattern;
            String typeName = hashBangTag.getAttributeValue("type");
            if (typeName == null || (hashBangPattern = hashBangTag.getAttributeValue("value")) == null) continue;
            result2.put(hashBangPattern, typeName);
        }
        HashMap<String, String> hashMap = result2;
        if (hashMap == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(89);
        }
        return hashMap;
    }

    private void addIgnore(@NotNull String ignoreMask) {
        if (ignoreMask == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(90);
        }
        this.ignoredPatterns.addIgnoreMask(ignoreMask);
    }

    private void restoreStandardFileExtensions() {
        for (String name2 : FILE_TYPES_WITH_PREDEFINED_EXTENSIONS) {
            StandardFileType stdFileType = this.standardFileTypes.get(name2);
            if (stdFileType == null) continue;
            FileType fileType2 = stdFileType.fileType;
            for (FileNameMatcher matcher : this.patternsTable.getAssociations((Object)FileTypeWithDescriptor.allFor(fileType2))) {
                FileType defaultFileType = (FileType)this.initialAssociations.findAssociatedFileType(matcher);
                if (defaultFileType == null || defaultFileType == fileType2) continue;
                this.removeAssociation(FileTypeManagerImpl.coreDescriptorFor(fileType2), matcher, false);
                this.associate(FileTypeManagerImpl.coreDescriptorFor(defaultFileType), matcher, false);
            }
            for (FileNameMatcher matcher : this.initialAssociations.getAssociations((Object)fileType2)) {
                this.associate(FileTypeManagerImpl.coreDescriptorFor(fileType2), matcher, false);
            }
        }
    }

    @ApiStatus.Internal
    @NotNull
    public Element getState() {
        Element element = (Element)this.withReadLock(() -> {
            String typeName;
            Element state2 = new Element("state");
            ArrayList<String> ignoreFiles = new ArrayList<String>(this.ignoredPatterns.getIgnoreMasks());
            ignoreFiles.sort(null);
            if (!FileTypeManagerImpl.isEqualToDefaultIgnoreMasks(ignoreFiles)) {
                state2.addContent(new Element(ELEMENT_IGNORE_FILES).setAttribute(ATTRIBUTE_LIST, String.join((CharSequence)";", ignoreFiles)));
            }
            Element extensionMap = new Element(ELEMENT_EXTENSION_MAP);
            ArrayList<FileTypeWithDescriptor> notExternalizableFileTypes = new ArrayList<FileTypeWithDescriptor>();
            for (FileTypeWithDescriptor fileTypeDescriptor : this.getAllFileTypeWithDescriptors()) {
                if (fileTypeDescriptor.fileType() instanceof AbstractFileType && !this.defaultTypes.contains(fileTypeDescriptor)) continue;
                notExternalizableFileTypes.add(fileTypeDescriptor);
            }
            if (!notExternalizableFileTypes.isEmpty()) {
                notExternalizableFileTypes.sort(Comparator.comparing(it -> it.fileType().getName()));
                for (FileTypeWithDescriptor ftd : notExternalizableFileTypes) {
                    this.writeExtensionsMap(extensionMap, ftd, true);
                }
            }
            this.removedMappingTracker.save(extensionMap);
            if (!this.unresolvedMappings.isEmpty()) {
                ArrayList<Map.Entry<FileNameMatcher, String>> entries2 = new ArrayList<Map.Entry<FileNameMatcher, String>>(this.unresolvedMappings.entrySet());
                entries2.sort(Comparator.comparing(e -> ((FileNameMatcher)e.getKey()).getPresentableString()));
                for (Map.Entry entry : entries2) {
                    FileNameMatcher fileNameMatcher = (FileNameMatcher)entry.getKey();
                    typeName = (String)entry.getValue();
                    Element content2 = AbstractFileType.writeMapping(typeName, fileNameMatcher, true);
                    if (content2 == null) continue;
                    extensionMap.addContent(content2);
                }
            }
            if (!this.unresolvedHashBangs.isEmpty()) {
                ArrayList<Map.Entry<String, String>> entries2 = new ArrayList<Map.Entry<String, String>>(this.unresolvedHashBangs.entrySet());
                entries2.sort(Map.Entry.comparingByKey());
                for (Map.Entry entry : entries2) {
                    String pattern = (String)entry.getKey();
                    typeName = (String)entry.getValue();
                    FileTypeManagerImpl.writeHashBang(extensionMap, pattern, typeName);
                }
            }
            if (!extensionMap.getChildren().isEmpty()) {
                state2.addContent(extensionMap);
            }
            if (!state2.getChildren().isEmpty()) {
                state2.setAttribute(ATTRIBUTE_VERSION, String.valueOf(19));
            }
            return state2;
        });
        if (element == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(91);
        }
        return element;
    }

    private static boolean isEqualToDefaultIgnoreMasks(@NotNull List<String> newList) {
        if (newList == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(92);
        }
        if (newList.size() != DEFAULT_IGNORED.size()) {
            return false;
        }
        int n = DEFAULT_IGNORED.size();
        for (int i2 = 0; i2 < n; ++i2) {
            if (DEFAULT_IGNORED.get(i2).equalsIgnoreCase(newList.get(i2))) continue;
            return false;
        }
        return true;
    }

    private void writeExtensionsMap(@NotNull Element extensionMap, @NotNull FileTypeWithDescriptor ftd, boolean specifyTypeName) {
        if (extensionMap == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(93);
        }
        if (ftd == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(94);
        }
        FileType type = ftd.fileType();
        List associations = this.patternsTable.getAssociations((Object)ftd);
        HashSet<FileNameMatcher> defaultAssociations = new HashSet<FileNameMatcher>(this.initialAssociations.getAssociations((Object)type));
        for (FileNameMatcher matcher2 : associations) {
            Element content2;
            boolean isDefaultAssociationContains = defaultAssociations.remove(matcher2);
            if (isDefaultAssociationContains || !FileTypeManagerImpl.shouldSave(type) || (content2 = AbstractFileType.writeMapping(type.getName(), matcher2, specifyTypeName)) == null) continue;
            extensionMap.addContent(content2);
        }
        List readOnlyHashBangs = this.initialAssociations.getHashBangPatterns((Object)type);
        List hashBangPatterns = this.patternsTable.getHashBangPatterns((Object)ftd);
        for (String hashBangPattern : ContainerUtil.sorted((Collection)hashBangPatterns)) {
            if (readOnlyHashBangs.contains(hashBangPattern)) continue;
            FileTypeManagerImpl.writeHashBang(extensionMap, hashBangPattern, type.getName());
        }
        List<FileNameMatcher> removedMappings = this.removedMappingTracker.getMappingsForFileType(type.getName());
        defaultAssociations.removeIf(matcher -> removedMappings.contains(matcher));
        this.removedMappingTracker.saveRemovedMappingsForFileType(extensionMap, type.getName(), defaultAssociations, specifyTypeName);
    }

    private static void writeHashBang(@NotNull Element extensionMap, @NotNull String hashBangPattern, @NotNull String typeName) {
        if (extensionMap == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(95);
        }
        if (hashBangPattern == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(96);
        }
        if (typeName == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(97);
        }
        Element hashBangTag = new Element("hashBang");
        hashBangTag.setAttribute("value", hashBangPattern);
        hashBangTag.setAttribute("type", typeName);
        extensionMap.addContent(hashBangTag);
    }

    private FileTypeWithDescriptor getFileTypeWithDescriptorByName(@NotNull String name2) {
        if (name2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(98);
        }
        this.instantiatePendingFileTypeByName(name2);
        return (FileTypeWithDescriptor)this.withReadLock(() -> (FileTypeWithDescriptor)this.schemeManager.findSchemeByName(name2));
    }

    @NotNull
    private static List<FileNameMatcher> parseExtensions(@NotNull Object context, @NotNull String semicolonDelimitedExtensions) {
        if (context == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(99);
        }
        if (semicolonDelimitedExtensions == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(100);
        }
        return FileTypeManagerImpl.parse(context, semicolonDelimitedExtensions, ext -> new ExtensionFileNameMatcher(ext));
    }

    @NotNull
    private static List<FileNameMatcher> parse(@NotNull Object context, @NotNull String semicolonDelimitedTokens, @NotNull Function<? super String, ? extends FileNameMatcher> matcherFactory) {
        if (context == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(101);
        }
        if (semicolonDelimitedTokens == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(102);
        }
        if (matcherFactory == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(103);
        }
        if (semicolonDelimitedTokens.isEmpty()) {
            List<FileNameMatcher> list2 = Collections.emptyList();
            if (list2 == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(104);
            }
            return list2;
        }
        StringTokenizer tokenizer = new StringTokenizer(semicolonDelimitedTokens, ";", false);
        ArrayList<FileNameMatcher> list3 = new ArrayList<FileNameMatcher>(StringUtil.countChars((CharSequence)semicolonDelimitedTokens, (char)';') + 1);
        while (tokenizer.hasMoreTokens()) {
            String ext = tokenizer.nextToken().trim();
            if (ext.isEmpty()) {
                throw new InvalidDataException("Token must not be empty but got: '" + semicolonDelimitedTokens + "' in " + String.valueOf(context));
            }
            list3.add(matcherFactory.apply(ext));
        }
        ArrayList<FileNameMatcher> arrayList = list3;
        if (arrayList == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(105);
        }
        return arrayList;
    }

    private void registerFileTypeWithoutNotification(@NotNull FileType newFileType, @NotNull PluginDescriptor newPluginDescriptor, @NotNull List<? extends FileNameMatcher> newMatchers, @NotNull PluginAdvertiserExtensionsStateService pluginAdvertiserExtensionsStateService, boolean addScheme) {
        if (newFileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(106);
        }
        if (newPluginDescriptor == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(107);
        }
        if (newMatchers == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(108);
        }
        if (pluginAdvertiserExtensionsStateService == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(109);
        }
        FileTypeWithDescriptor newFtd = new FileTypeWithDescriptor(newFileType, newPluginDescriptor);
        if (addScheme) {
            FileTypeWithDescriptor oldFileType = (FileTypeWithDescriptor)this.schemeManager.findSchemeByName(newFileType.getName());
            if (oldFileType != null) {
                if (!(oldFileType.fileType() instanceof AbstractFileType)) {
                    throw new IllegalArgumentException(String.valueOf(newFileType) + " already registered");
                }
                this.removeFromDuplicates(oldFileType.fileType(), oldFileType.pluginDescriptor());
            }
            this.schemeManager.addScheme((Object)newFtd);
            this.pendingFileTypes.remove(newFileType.getName());
            this.pendingAssociations.removeAllAssociations(bean -> bean.name.equals(newFileType.getName()));
            this.checkFileTypeNamesUniqueness(newFtd);
        }
        List<FileNameMatcher> mappingsRemovedFromNew = this.removedMappingTracker.getMappingsForFileType(newFileType.getName());
        for (FileNameMatcher fileNameMatcher : newMatchers) {
            FileType oldFileType;
            ConflictingFileTypeMappingTracker.ResolveConflictResult result2;
            List mappingsRemovedFromOld;
            if (mappingsRemovedFromNew.contains(fileNameMatcher)) continue;
            FileTypeWithDescriptor oldFtd = (FileTypeWithDescriptor)this.patternsTable.findAssociatedFileType(fileNameMatcher);
            List<Object> list2 = mappingsRemovedFromOld = oldFtd == null ? Collections.emptyList() : this.removedMappingTracker.getMappingsForFileType(oldFtd.getName());
            if (mappingsRemovedFromOld.contains(fileNameMatcher)) {
                ConflictingFileTypeMappingTracker.ResolveConflictResult result3 = new ConflictingFileTypeMappingTracker.ResolveConflictResult(newFtd, "", "", true);
            } else {
                result2 = this.conflictingMappingTracker.warnAndResolveConflict(fileNameMatcher, oldFtd, newFtd);
                if (oldFtd != null) {
                    LOG.debug(String.valueOf(fileNameMatcher) + " had a conflict between " + String.valueOf(oldFtd) + " and " + String.valueOf(newFtd) + " and the winner is ... ... ... " + String.valueOf(result2));
                }
            }
            if (!result2.approved() && this.conflictResultConsumer != null) {
                this.conflictResultConsumer.accept(result2);
            }
            FileTypeWithDescriptor resolvedFtd = result2.resolved();
            FileType fileType2 = oldFileType = oldFtd == null ? null : oldFtd.fileType();
            if (!resolvedFtd.equals(oldFtd)) {
                this.patternsTable.addAssociation(fileNameMatcher, (Object)resolvedFtd);
                if (result2.approved() && oldFileType != null) {
                    this.removedMappingTracker.add(fileNameMatcher, oldFileType.getName(), true);
                }
            } else if (oldFileType instanceof AbstractFileType && result2.approved()) {
                this.patternsTable.addAssociation(fileNameMatcher, (Object)newFtd);
            }
            this.initialAssociations.addAssociation(fileNameMatcher, (Object)newFileType);
        }
        if (newFileType instanceof FileTypeIdentifiableByVirtualFile) {
            this.specialFileTypes = (FileTypeIdentifiableByVirtualFile[])ArrayUtil.append((Object[])this.specialFileTypes, (Object)((FileTypeIdentifiableByVirtualFile)newFileType), (ArrayFactory)FileTypeIdentifiableByVirtualFile.ARRAY_FACTORY);
        }
        pluginAdvertiserExtensionsStateService.registerLocalPlugin(newMatchers, newPluginDescriptor);
    }

    private void checkFileTypeNamesUniqueness(@NotNull FileTypeWithDescriptor newDescriptor) {
        if (newDescriptor == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(110);
        }
        this.fileTypesPerPlugin.computeIfAbsent(newDescriptor.pluginDescriptor(), __ -> ConcurrentHashMap.newKeySet()).add(newDescriptor);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.checkUnique();
        } else {
            this.checkDuplicatedAlarm.tryEmit((Object)Unit.INSTANCE);
        }
    }

    private void checkUnique() {
        for (Map.Entry<PluginDescriptor, Set<FileTypeWithDescriptor>> entry : this.fileTypesPerPlugin.entrySet()) {
            FileTypeManagerImpl.checkUnique(entry.getValue());
        }
    }

    private static void checkUnique(@NotNull Set<FileTypeWithDescriptor> descriptors2) {
        if (descriptors2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(111);
        }
        ConcurrentHashMap names = new ConcurrentHashMap();
        ConcurrentHashMap displayNames = new ConcurrentHashMap();
        ConcurrentHashMap descriptions = new ConcurrentHashMap();
        for (FileTypeWithDescriptor descriptor2 : descriptors2) {
            FileTypeManagerImpl.checkUnique(descriptor2, names, "getName", FileType::getName);
            FileTypeManagerImpl.checkUnique(descriptor2, displayNames, "getDisplayName", FileType::getDisplayName);
            FileTypeManagerImpl.checkUnique(descriptor2, descriptions, "getDescription", FileType::getDescription);
        }
    }

    private static void checkUnique(@NotNull FileTypeWithDescriptor newFileTypeWithDescriptor, @NotNull Map<? super String, FileTypeWithDescriptor> names, @NotNull String getterName, @NotNull Function<? super FileType, String> nameExtractor) {
        FileType newFileType;
        String name2;
        FileTypeWithDescriptor prevFileTypeWithDescriptor;
        if (newFileTypeWithDescriptor == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(112);
        }
        if (names == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(113);
        }
        if (getterName == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(114);
        }
        if (nameExtractor == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(115);
        }
        if ((prevFileTypeWithDescriptor = names.put(name2 = nameExtractor.apply((FileType)(newFileType = newFileTypeWithDescriptor.fileType())), newFileTypeWithDescriptor)) != null && prevFileTypeWithDescriptor.fileType() instanceof AbstractFileType == newFileType instanceof AbstractFileType) {
            PluginDescriptor pluginToBlame;
            String error = "\n" + String.valueOf(prevFileTypeWithDescriptor) + " (" + String.valueOf(prevFileTypeWithDescriptor.fileType().getClass()) + ") and\n" + String.valueOf(newFileTypeWithDescriptor) + " (" + String.valueOf(newFileType.getClass()) + ")\n both have the same ." + getterName + "(): '" + name2 + "'. Please override either one's " + getterName + "() to something unique.";
            PluginDescriptor pluginDescriptor = pluginToBlame = prevFileTypeWithDescriptor.pluginDescriptor().isBundled() ? newFileTypeWithDescriptor.pluginDescriptor() : prevFileTypeWithDescriptor.pluginDescriptor();
            if (prevFileTypeWithDescriptor.pluginDescriptor().isBundled() || newFileTypeWithDescriptor.pluginDescriptor().isBundled()) {
                LOG.error((Throwable)new PluginException(error, pluginToBlame.getPluginId()));
            } else {
                LOG.warn((Throwable)new PluginException(error, pluginToBlame.getPluginId()));
            }
        }
    }

    private void bindUnresolvedMappings(@NotNull StandardFileType standardFileType) {
        if (standardFileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(116);
        }
        for (FileNameMatcher matcher : new ArrayList<FileNameMatcher>(this.unresolvedMappings.keySet())) {
            String name2 = this.unresolvedMappings.get(matcher);
            if (!standardFileType.fileType.getName().equals(name2)) continue;
            this.patternsTable.addAssociation(matcher, (Object)standardFileType.getDescriptor());
            this.unresolvedMappings.remove(matcher);
        }
        for (FileNameMatcher matcher : this.removedMappingTracker.getMappingsForFileType(standardFileType.fileType.getName())) {
            this.removeAssociation(FileTypeWithDescriptor.allFor(standardFileType.fileType), matcher, false);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static FileTypeWithDescriptor coreDescriptorFor(@NotNull FileType fileType2) {
        if (fileType2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(117);
        }
        return new FileTypeWithDescriptor(fileType2, (PluginDescriptor)FileTypeManagerImpl.coreIdeaPluginDescriptor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private FileType loadFileType(@NotNull Object context, @NotNull Element typeElement, @NotNull PluginDescriptor pluginDescriptor, @NotNull PluginAdvertiserExtensionsStateService pluginAdvertiserExtensionsStateService, boolean isDefault) {
        Object type;
        FileTypeWithDescriptor ftd;
        if (context == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(118);
        }
        if (typeElement == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(119);
        }
        if (pluginDescriptor == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(120);
        }
        if (pluginAdvertiserExtensionsStateService == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(121);
        }
        String fileTypeName = typeElement.getAttributeValue(ATTRIBUTE_NAME);
        String extensionsStr = (String)ObjectUtils.notNull((Object)typeElement.getAttributeValue("extensions"), (Object)"");
        if (isDefault && !extensionsStr.isEmpty()) {
            extensionsStr = this.filterAlreadyRegisteredExtensions(extensionsStr);
        }
        FileTypeWithDescriptor fileTypeWithDescriptor = ftd = isDefault && fileTypeName != null ? this.getFileTypeWithDescriptorByName(fileTypeName) : null;
        if (ftd != null) {
            FileType fileType2 = ftd.fileType();
            if (fileType2 == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(122);
            }
            return fileType2;
        }
        Element element = typeElement.getChild("highlighting");
        if (element == null) {
            type = UserBinaryFileType.INSTANCE;
        } else {
            SyntaxTable table2 = AbstractFileType.readSyntaxTable(element);
            type = new AbstractFileType(table2);
            ((AbstractFileType)type).initSupport();
        }
        @NlsSafe String fileTypeDescr = typeElement.getAttributeValue(ATTRIBUTE_DESCRIPTION);
        if (isDefault && fileTypeDescr != null && fileTypeDescr.contains("syntax highlighting only")) {
            fileTypeDescr = fileTypeDescr.replace("syntax highlighting only", FileTypesBundle.message("filetype.default.syntax.highlighting.only.description", new Object[0]));
        }
        this.myPendingInitializationLock.writeLock().lock();
        String iconPath = typeElement.getAttributeValue("icon");
        FileTypeManagerImpl.setFileTypeAttributes(type, fileTypeName, fileTypeDescr, iconPath);
        this.registerFileTypeWithoutNotification((FileType)type, pluginDescriptor, FileTypeManagerImpl.parseExtensions(context, extensionsStr), pluginAdvertiserExtensionsStateService, isDefault);
        if (isDefault) {
            this.defaultTypes.add(new FileTypeWithDescriptor((FileType)type, pluginDescriptor));
            if (type instanceof ExternalizableFileType) {
                ((ExternalizableFileType)type).markDefaultSettings();
            }
        } else {
            Element extensions = typeElement.getChild(ELEMENT_EXTENSION_MAP);
            if (extensions != null) {
                FileTypeWithDescriptor newFtd = new FileTypeWithDescriptor((FileType)type, pluginDescriptor);
                for (Pair<FileNameMatcher, String> association : AbstractFileType.readAssociations(extensions)) {
                    this.associate(newFtd, (FileNameMatcher)association.getFirst(), false);
                }
                for (RemovedMappingTracker.RemovedMapping removedAssociation : RemovedMappingTracker.readRemovedMappings(extensions)) {
                    this.removeAssociation(newFtd, removedAssociation.getFileNameMatcher(), false);
                }
            }
        }
        Object object = type;
        Object object2 = object;
        if (object2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(123);
        }
        return object2;
        finally {
            this.myPendingInitializationLock.writeLock().unlock();
        }
    }

    @NotNull
    private String filterAlreadyRegisteredExtensions(@NotNull String semicolonDelimited) {
        if (semicolonDelimited == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(124);
        }
        StringTokenizer tokenizer = new StringTokenizer(semicolonDelimited, ";", false);
        StringBuilder builder = null;
        while (tokenizer.hasMoreTokens()) {
            String extension = tokenizer.nextToken().trim();
            if (this.pendingAssociations.findByExtension((CharSequence)extension) != null || this.getFileTypeByExtension(extension) != UnknownFileType.INSTANCE) continue;
            if (builder == null) {
                builder = new StringBuilder();
            } else if (!builder.isEmpty()) {
                builder.append(";");
            }
            builder.append(extension);
        }
        String string = builder == null ? "" : builder.toString();
        if (string == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(125);
        }
        return string;
    }

    private static void setFileTypeAttributes(@NotNull UserFileType<?> fileType2, @Nullable String name2, @NlsContexts.Label @Nullable String description, @Nullable String iconPath) {
        if (fileType2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(126);
        }
        if (!Strings.isEmptyOrSpaces((CharSequence)iconPath)) {
            fileType2.setIconPath(iconPath);
        }
        if (description != null) {
            fileType2.setDescription(description);
        }
        if (name2 != null) {
            fileType2.setName(name2);
        }
    }

    private static boolean shouldSave(@NotNull FileType fileType2) {
        if (fileType2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(127);
        }
        return fileType2 != UnknownFileType.INSTANCE && !fileType2.isReadOnly();
    }

    @ApiStatus.Internal
    @NotNull
    public FileTypeAssocTable<FileTypeWithDescriptor> getExtensionMap() {
        this.instantiatePendingFileTypes();
        FileTypeAssocTable<FileTypeWithDescriptor> fileTypeAssocTable = this.patternsTable;
        if (fileTypeAssocTable == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(128);
        }
        return fileTypeAssocTable;
    }

    @ApiStatus.Internal
    public void setPatternsTable(@NotNull Set<FileTypeWithDescriptor> fileTypes, @NotNull FileTypeAssocTable<FileTypeWithDescriptor> assocTable) {
        if (fileTypes == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(129);
        }
        if (assocTable == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(130);
        }
        Map removedMappings = this.getExtensionMap().getRemovedMappings(assocTable, fileTypes);
        String message = "set patterns table called: file types " + String.valueOf(fileTypes) + ", ass. table:" + String.valueOf(assocTable);
        this.makeFileTypesChange(message, () -> {
            for (FileTypeWithDescriptor existing : this.getRegisteredFileTypeWithDescriptors()) {
                if (fileTypes.contains(existing)) continue;
                this.schemeManager.removeScheme((Object)existing);
            }
            for (FileTypeWithDescriptor ftd : fileTypes) {
                this.schemeManager.addScheme((Object)ftd);
                if (!(ftd.fileType() instanceof AbstractFileType)) continue;
                ((AbstractFileType)ftd.fileType()).initSupport();
            }
            this.patternsTable = assocTable.copy();
        });
        this.removedMappingTracker.removeIf(mapping -> {
            String fileTypeName = mapping.getFileTypeName();
            FileTypeWithDescriptor fileType2 = this.getFileTypeWithDescriptorByName(fileTypeName);
            FileNameMatcher matcher = mapping.getFileNameMatcher();
            return fileType2 != null && assocTable.isAssociatedWith((Object)fileType2, matcher);
        });
        for (Map.Entry entry : removedMappings.entrySet()) {
            this.removedMappingTracker.add((FileNameMatcher)entry.getKey(), ((FileTypeWithDescriptor)entry.getValue()).fileType().getName(), true);
        }
    }

    void associate(@NotNull FileTypeWithDescriptor ftd, @NotNull FileNameMatcher matcher, boolean fireChange) {
        if (ftd == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(131);
        }
        if (matcher == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(132);
        }
        FileType fileType2 = ftd.fileType();
        this.removedMappingTracker.removeIf(mapping -> matcher.equals((Object)mapping.getFileNameMatcher()) && fileType2.getName().equals(mapping.getFileTypeName()));
        if (!this.patternsTable.isAssociatedWith((Object)ftd, matcher)) {
            Runnable command = () -> this.patternsTable.addAssociation(matcher, (Object)ftd);
            if (fireChange) {
                this.makeFileTypesChange("file type '" + String.valueOf(ftd.fileType()) + "' associated with '" + String.valueOf(matcher) + "'", command);
            } else {
                command.run();
            }
        }
    }

    private void removeAssociation(@NotNull FileTypeWithDescriptor ftd, @NotNull FileNameMatcher matcher, boolean fireChange) {
        if (ftd == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(133);
        }
        if (matcher == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(134);
        }
        if (this.patternsTable.isAssociatedWith((Object)ftd, matcher)) {
            Runnable command = () -> this.patternsTable.removeAssociation(matcher, (Object)ftd);
            if (fireChange) {
                this.makeFileTypesChange("file type '" + String.valueOf(ftd.fileType()) + "' association with '" + String.valueOf(matcher) + "' has been removed", command);
            } else {
                command.run();
            }
        }
    }

    public FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file2, @NotNull Project project2) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(135);
        }
        if (project2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(136);
        }
        return FileTypeChooser.getKnownFileTypeOrAssociate(file2, project2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerReDetectedMappings(@NotNull StandardFileType pair) {
        if (pair == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(137);
        }
        this.myPendingInitializationLock.writeLock().lock();
        try {
            FileType fileType2 = pair.fileType;
            if (fileType2 == PlainTextFileType.INSTANCE) {
                return;
            }
            for (FileNameMatcher matcher : pair.matchers) {
                this.registerReDetectedMapping(fileType2.getName(), matcher);
                if (!(matcher instanceof ExtensionFileNameMatcher)) continue;
                ExtensionFileNameMatcher extMatcher = (ExtensionFileNameMatcher)matcher;
                this.registerReDetectedMapping(fileType2.getName(), (FileNameMatcher)new ExactFileNameMatcher("." + extMatcher.getExtension()));
            }
        }
        finally {
            this.myPendingInitializationLock.writeLock().unlock();
        }
    }

    private void registerReDetectedMapping(@NotNull String fileTypeName, @NotNull FileNameMatcher matcher) {
        String typeName;
        if (fileTypeName == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(138);
        }
        if (matcher == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(139);
        }
        if ((typeName = this.unresolvedMappings.get(matcher)) != null && !typeName.equals(fileTypeName)) {
            if (!this.removedMappingTracker.hasRemovedMapping(matcher)) {
                this.removedMappingTracker.add(matcher, fileTypeName, false);
            }
            this.unresolvedMappings.remove(matcher);
            this.tryToResolveMapping(typeName, matcher);
        }
    }

    private <T, E extends Throwable> T withReadLock(@NotNull ThrowableComputable<T, E> computable) throws E {
        if (computable == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(140);
        }
        return (T)ConcurrencyUtil.withLock((Lock)this.myPendingInitializationLock.readLock(), computable);
    }

    @VisibleForTesting
    @ApiStatus.Internal
    @NotNull
    public RemovedMappingTracker getRemovedMappingTracker() {
        RemovedMappingTracker removedMappingTracker = this.removedMappingTracker;
        if (removedMappingTracker == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(141);
        }
        return removedMappingTracker;
    }

    @ApiStatus.Internal
    public PluginDescriptor findPluginDescriptor(@NotNull FileType fileType2) {
        if (fileType2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(142);
        }
        for (FileTypeWithDescriptor ftd : this.getAllFileTypeWithDescriptors()) {
            if (!ftd.fileType().equals((Object)fileType2)) continue;
            return ftd.pluginDescriptor();
        }
        return null;
    }

    @TestOnly
    @ApiStatus.Internal
    public void setConflictResultConsumer(@Nullable Consumer<? super ConflictingFileTypeMappingTracker.ResolveConflictResult> consumer) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new IllegalStateException();
        }
        this.conflictResultConsumer = consumer;
    }

    @ApiStatus.Internal
    public String toString() {
        return super.toString() + " FileTypeManagerImpl{myDetectionService=" + String.valueOf(this.detectionService) + ", CACHED=" + String.valueOf(this.CACHED) + ", defaultTypes=" + String.valueOf(this.defaultTypes) + ", specialFileTypes=" + Arrays.toString(this.specialFileTypes) + ", patternsTable=" + String.valueOf(this.patternsTable) + ", ignoredPatterns=" + String.valueOf(this.ignoredPatterns) + ", myIgnoredFileCache=" + String.valueOf(this.myIgnoredFileCache) + ", initialAssociations=" + String.valueOf(this.initialAssociations) + ", unresolvedMappings=" + String.valueOf(this.unresolvedMappings) + ", unresolvedHashBangs=" + String.valueOf(this.unresolvedHashBangs) + ", removedMappingTracker=" + String.valueOf(this.removedMappingTracker) + ", conflictingMappingTracker=" + String.valueOf(this.conflictingMappingTracker) + ", pendingFileTypes=" + String.valueOf(this.pendingFileTypes) + ", pendingAssociations=" + String.valueOf(this.pendingAssociations) + ", myPendingInitializationLock=" + String.valueOf(this.myPendingInitializationLock) + ", fileTypesPerPlugin=" + String.valueOf(this.fileTypesPerPlugin) + ", checkDuplicatedAlarm=" + String.valueOf(this.checkDuplicatedAlarm) + ", conflictResultConsumer=" + String.valueOf(this.conflictResultConsumer) + ", standardFileTypes=" + String.valueOf(this.standardFileTypes) + ", schemeManager=" + String.valueOf(this.schemeManager) + ", fileTypeOverriderCache=" + Arrays.toString(this.fileTypeOverriderCache) + ", INSTANTIATED=" + String.valueOf(this.INSTANTIATED) + ", toLog=" + this.toLog + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 15, 16, 19, 21, 23, 28, 36, 41, 42, 43, 44, 46, 50, 53, 55, 56, 66, 68, 69, 75, 79, 89, 91, 104, 105, 122, 123, 125, 128, 141 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeBean";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 60: 
            case 62: 
            case 64: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 3: 
            case 7: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 5: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 28: 
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 50: 
            case 53: 
            case 55: 
            case 56: 
            case 66: 
            case 68: 
            case 69: 
            case 75: 
            case 79: 
            case 89: 
            case 91: 
            case 104: 
            case 105: 
            case 122: 
            case 123: 
            case 125: 
            case 128: 
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stdFileType";
                break;
            }
            case 8: 
            case 22: 
            case 57: 
            case 74: 
            case 76: 
            case 78: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 13: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherBean";
                break;
            }
            case 12: 
            case 99: 
            case 101: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 20: 
            case 24: 
            case 72: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_NAME;
                break;
            }
            case 25: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 26: 
            case 77: 
            case 81: 
            case 132: 
            case 134: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 27: 
            case 29: 
            case 30: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 31: 
            case 33: 
            case 35: 
            case 45: 
            case 47: 
            case 48: 
            case 73: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 32: 
            case 34: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestedFileType";
                break;
            }
            case 49: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeName";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultAssociations";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 61: 
            case 63: 
            case 65: 
            case 117: 
            case 126: 
            case 127: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 70: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_LIST;
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugReasonMessage";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maskToRemove";
                break;
            }
            case 86: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashBangs";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoreMask";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newList";
                break;
            }
            case 93: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_EXTENSION_MAP;
                break;
            }
            case 94: 
            case 131: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ftd";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashBangPattern";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semicolonDelimitedExtensions";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semicolonDelimitedTokens";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcherFactory";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileType";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPluginDescriptor";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMatchers";
                break;
            }
            case 109: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginAdvertiserExtensionsStateService";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDescriptor";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileTypeWithDescriptor";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getterName";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameExtractor";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "standardFileType";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semicolonDelimited";
                break;
            }
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypes";
                break;
            }
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assocTable";
                break;
            }
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "coreIdeaPluginDescriptor";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeOrInstantiateFileTypeBean";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpReDetectQueue";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getStdFileType";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getStandardMatchers";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByFileName";
                break;
            }
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByFile";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "internalContinueToDetectFileTypeByFile";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFileTypeWithDescriptors";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByExtension";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeWithDescriptorByExtension";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisteredFileTypes";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredFilesList";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociations";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeOrUnknown";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "readHashBangs";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 122: 
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFileType";
                break;
            }
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAlreadyRegisteredExtensions";
                break;
            }
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionMap";
                break;
            }
            case 141: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemovedMappingTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "extensionAdded";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extensionRemoved";
                break;
            }
            case 5: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 28: 
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 50: 
            case 53: 
            case 55: 
            case 56: 
            case 66: 
            case 68: 
            case 69: 
            case 75: 
            case 79: 
            case 89: 
            case 91: 
            case 104: 
            case 105: 
            case 122: 
            case 123: 
            case 125: 
            case 128: 
            case 141: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "unregisterMatchers";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeFromDuplicates";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "handleFileTypesConflict";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "initializeMatchers";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "mergeOrInstantiateFileTypeBean";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "instantiateFileTypeBean";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getField";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getStdFileType";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getStandardMatchers";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "instantiatePendingFileTypeByName";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "tryToResolveMapping";
                break;
            }
            case 27: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByFileName";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "removePlainTextAssociationsForFile";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "freezeFileTypeTemporarilyIn";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "freezeFileTypeTemporarilyWithProvidedValueIn";
                break;
            }
            case 35: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByFile";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isFileOfType";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "cacheFileTypesInside";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "internalContinueToDetectFileTypeByFile";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getTemporarilyFixedFileType";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getByFile";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "findFileTypeByName";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "findFileTypeByLanguage";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByExtension";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeWithDescriptorByExtension";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "registerFileType";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "unregisterFileType";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "doUnregisterFileType";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "unregisterFileTypeWithoutNotification";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "setIgnoredFilesList";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredFilesListEqualToCurrent";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isFileIgnored";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getAssociations";
                break;
            }
            case 76: 
            case 77: 
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "associate";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "detectPluginDescriptor";
                break;
            }
            case 80: 
            case 81: 
            case 133: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "removeAssociation";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "makeFileTypesChange";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "unignoreMask";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "readGlobalMappings";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "registerHashBangs";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "readHashBangs";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "addIgnore";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "isEqualToDefaultIgnoreMasks";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "writeExtensionsMap";
                break;
            }
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "writeHashBang";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeWithDescriptorByName";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "parseExtensions";
                break;
            }
            case 101: 
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "registerFileTypeWithoutNotification";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "checkFileTypeNamesUniqueness";
                break;
            }
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "checkUnique";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "bindUnresolvedMappings";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "coreDescriptorFor";
                break;
            }
            case 118: 
            case 119: 
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "loadFileType";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "filterAlreadyRegisteredExtensions";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "setFileTypeAttributes";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "shouldSave";
                break;
            }
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "setPatternsTable";
                break;
            }
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "getKnownFileTypeOrAssociate";
                break;
            }
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "registerReDetectedMappings";
                break;
            }
            case 138: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "registerReDetectedMapping";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "withReadLock";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "findPluginDescriptor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 15, 16, 19, 21, 23, 28, 36, 41, 42, 43, 44, 46, 50, 53, 55, 56, 66, 68, 69, 75, 79, 89, 91, 104, 105, 122, 123, 125, 128, 141 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public record FileTypeWithDescriptor(@NotNull FileType fileType, @NotNull PluginDescriptor pluginDescriptor) implements Scheme
    {
        @NotNull
        private final FileType fileType;
        @NotNull
        private final PluginDescriptor pluginDescriptor;
        private static final PluginDescriptor WILD_CARD = new DefaultPluginDescriptor("WILD_CARD");

        public FileTypeWithDescriptor(@NotNull FileType fileType2, @NotNull PluginDescriptor pluginDescriptor) {
            if (fileType2 == null) {
                FileTypeWithDescriptor.$$$reportNull$$$0(0);
            }
            if (pluginDescriptor == null) {
                FileTypeWithDescriptor.$$$reportNull$$$0(1);
            }
        }

        @Override
        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && this.fileType().equals((Object)((FileTypeWithDescriptor)o).fileType());
        }

        @Override
        public int hashCode() {
            return this.fileType().hashCode();
        }

        @Override
        public String toString() {
            return String.valueOf(this.fileType()) + " from '" + String.valueOf(this.pluginDescriptor() == WILD_CARD ? "*" : (PluginManagerCore.CORE_ID.equals((Object)this.pluginDescriptor().getPluginId()) ? "CORE" : this.pluginDescriptor())) + "'";
        }

        @ApiStatus.Internal
        @NotNull
        public static FileTypeWithDescriptor allFor(@NotNull FileType fileType2) {
            if (fileType2 == null) {
                FileTypeWithDescriptor.$$$reportNull$$$0(2);
            }
            return new FileTypeWithDescriptor(fileType2, WILD_CARD);
        }

        @NotNull
        public String getName() {
            String string = this.fileType().getName();
            if (string == null) {
                FileTypeWithDescriptor.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public FileType fileType() {
            FileType fileType2 = this.fileType;
            if (fileType2 == null) {
                FileTypeWithDescriptor.$$$reportNull$$$0(4);
            }
            return fileType2;
        }

        @NotNull
        public PluginDescriptor pluginDescriptor() {
            PluginDescriptor pluginDescriptor = this.pluginDescriptor;
            if (pluginDescriptor == null) {
                FileTypeWithDescriptor.$$$reportNull$$$0(5);
            }
            return pluginDescriptor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$FileTypeWithDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$FileTypeWithDescriptor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fileType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "pluginDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "allFor";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    private record StandardFileType(@NotNull FileType fileType, @NotNull PluginDescriptor pluginDescriptor, @NotNull List<FileNameMatcher> matchers) {
        @NotNull
        private final FileType fileType;
        @NotNull
        private final PluginDescriptor pluginDescriptor;
        @NotNull
        private final List<FileNameMatcher> matchers;

        private StandardFileType(@NotNull FileType fileType2, @NotNull PluginDescriptor pluginDescriptor, @NotNull List<FileNameMatcher> matchers) {
            if (fileType2 == null) {
                StandardFileType.$$$reportNull$$$0(0);
            }
            if (pluginDescriptor == null) {
                StandardFileType.$$$reportNull$$$0(1);
            }
            if (matchers == null) {
                StandardFileType.$$$reportNull$$$0(2);
            }
        }

        @NotNull
        private FileTypeWithDescriptor getDescriptor() {
            return new FileTypeWithDescriptor(this.fileType, this.pluginDescriptor);
        }

        @NotNull
        public FileType fileType() {
            FileType fileType2 = this.fileType;
            if (fileType2 == null) {
                StandardFileType.$$$reportNull$$$0(3);
            }
            return fileType2;
        }

        @NotNull
        public PluginDescriptor pluginDescriptor() {
            PluginDescriptor pluginDescriptor = this.pluginDescriptor;
            if (pluginDescriptor == null) {
                StandardFileType.$$$reportNull$$$0(4);
            }
            return pluginDescriptor;
        }

        @NotNull
        public List<FileNameMatcher> matchers() {
            List<FileNameMatcher> list2 = this.matchers;
            if (list2 == null) {
                StandardFileType.$$$reportNull$$$0(5);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matchers";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$StandardFileType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$StandardFileType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fileType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "pluginDescriptor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "matchers";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    private record CachedFileTypes(@NotNull ConcurrentIntObjectMap<FileType> fileTypes, @NotNull AtomicInteger useCount) {
        @NotNull
        private final ConcurrentIntObjectMap<FileType> fileTypes;
        @NotNull
        private final AtomicInteger useCount;

        private CachedFileTypes(@NotNull ConcurrentIntObjectMap<FileType> fileTypes, @NotNull AtomicInteger useCount) {
            if (fileTypes == null) {
                CachedFileTypes.$$$reportNull$$$0(0);
            }
            if (useCount == null) {
                CachedFileTypes.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public ConcurrentIntObjectMap<FileType> fileTypes() {
            ConcurrentIntObjectMap<FileType> concurrentIntObjectMap = this.fileTypes;
            if (concurrentIntObjectMap == null) {
                CachedFileTypes.$$$reportNull$$$0(2);
            }
            return concurrentIntObjectMap;
        }

        @NotNull
        public AtomicInteger useCount() {
            AtomicInteger atomicInteger = this.useCount;
            if (atomicInteger == null) {
                CachedFileTypes.$$$reportNull$$$0(3);
            }
            return atomicInteger;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileTypes";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "useCount";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$CachedFileTypes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$CachedFileTypes";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fileTypes";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "useCount";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private final class PluginFileTypeConsumer
    implements FileTypeConsumer {
        private final PluginDescriptor myPluginDescriptor;

        PluginFileTypeConsumer(PluginDescriptor pluginDescriptor) {
            if (pluginDescriptor == null) {
                PluginFileTypeConsumer.$$$reportNull$$$0(0);
            }
            this.myPluginDescriptor = pluginDescriptor;
        }

        public void consume(@NotNull FileType fileType2) {
            if (fileType2 == null) {
                PluginFileTypeConsumer.$$$reportNull$$$0(1);
            }
            this.register(fileType2, this.myPluginDescriptor, FileTypeManagerImpl.parseExtensions("filetypes.xml/" + fileType2.getName(), fileType2.getDefaultExtension()));
        }

        public void consume(@NotNull FileType fileType2, @NotNull String semicolonDelimitedExtensions) {
            if (fileType2 == null) {
                PluginFileTypeConsumer.$$$reportNull$$$0(2);
            }
            if (semicolonDelimitedExtensions == null) {
                PluginFileTypeConsumer.$$$reportNull$$$0(3);
            }
            this.register(fileType2, this.myPluginDescriptor, FileTypeManagerImpl.parseExtensions("filetypes.xml/" + fileType2.getName(), semicolonDelimitedExtensions));
        }

        public void consume(@NotNull FileType fileType2, FileNameMatcher ... matchers) {
            if (fileType2 == null) {
                PluginFileTypeConsumer.$$$reportNull$$$0(4);
            }
            if (matchers == null) {
                PluginFileTypeConsumer.$$$reportNull$$$0(5);
            }
            this.register(fileType2, this.myPluginDescriptor, Arrays.asList(matchers));
        }

        public FileType getStandardFileTypeByName(@NotNull String name2) {
            StandardFileType type;
            if (name2 == null) {
                PluginFileTypeConsumer.$$$reportNull$$$0(6);
            }
            return (type = FileTypeManagerImpl.this.standardFileTypes.get(name2)) != null ? type.fileType : null;
        }

        private void register(@NotNull FileType fileType2, @NotNull PluginDescriptor pluginDescriptor, @NotNull List<FileNameMatcher> fileNameMatchers) {
            if (fileType2 == null) {
                PluginFileTypeConsumer.$$$reportNull$$$0(7);
            }
            if (pluginDescriptor == null) {
                PluginFileTypeConsumer.$$$reportNull$$$0(8);
            }
            if (fileNameMatchers == null) {
                PluginFileTypeConsumer.$$$reportNull$$$0(9);
            }
            String typeName = fileType2.getName();
            FileTypeManagerImpl.this.instantiatePendingFileTypeByName(typeName);
            for (FileNameMatcher matcher : fileNameMatchers) {
                PluginId pluginId;
                FileTypeBean pendingTypeByMatcher = (FileTypeBean)FileTypeManagerImpl.this.pendingAssociations.findAssociatedFileType(matcher);
                if (pendingTypeByMatcher == null || !PluginManagerCore.CORE_ID.equals((Object)(pluginId = pendingTypeByMatcher.getPluginId()))) continue;
                FileTypeManagerImpl.this.instantiateFileTypeBean(pendingTypeByMatcher);
            }
            StandardFileType type = FileTypeManagerImpl.this.standardFileTypes.get(typeName);
            if (type == null) {
                PluginAdvertiserExtensionsStateService pluginAdvertiserExtensionsStateService = PluginAdvertiserExtensionsStateService.Companion.getInstance();
                FileTypeManagerImpl.this.standardFileTypes.put(typeName, new StandardFileType(fileType2, pluginDescriptor, fileNameMatchers));
                FileTypeManagerImpl.this.registerFileTypeWithoutNotification(fileType2, pluginDescriptor, fileNameMatchers, pluginAdvertiserExtensionsStateService, true);
            } else {
                type.matchers.addAll(fileNameMatchers);
                for (FileNameMatcher matcher : fileNameMatchers) {
                    FileTypeManagerImpl.this.patternsTable.addAssociation(matcher, (Object)type.getDescriptor());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "semicolonDelimitedExtensions";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matchers";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = FileTypeManagerImpl.ATTRIBUTE_NAME;
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileNameMatchers";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$PluginFileTypeConsumer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "consume";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getStandardFileTypeByName";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "register";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class MyAsyncVfsListener
    implements AsyncFileListener {
        MyAsyncVfsListener() {
        }

        @Nullable
        public AsyncFileListener.ChangeApplier prepareChange(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            if (events == null) {
                MyAsyncVfsListener.$$$reportNull$$$0(0);
            }
            return ((FileTypeManagerImpl)FileTypeManager.getInstance()).detectionService.prepareChange(events);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$MyAsyncVfsListener", "prepareChange"));
        }
    }
}

