/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.diagnostic.PluginException;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.customization.ActionUrl;
import com.intellij.ide.ui.customization.CustomisedActionGroup;
import com.intellij.ide.ui.customization.NonCustomizableAction;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionStubBase;
import com.intellij.openapi.actionSystem.ActionWithDelegate;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.impl.ActionGroupStub;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapExtension;
import com.intellij.openapi.keymap.KeymapGroup;
import com.intellij.openapi.keymap.impl.ActionShortcutRestrictions;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActionsTreeUtil {
    private static final Logger LOG = Logger.getInstance(ActionsTreeUtil.class);
    @NonNls
    private static final String EDITOR_PREFIX = "Editor";
    private static final Set<String> ourBrokenActions = new HashSet<String>();

    private ActionsTreeUtil() {
    }

    @Nullable
    public static Presentation getTemplatePresentation(@NotNull @NlsSafe String actionId, @Nullable String boundSourceId) {
        String text2;
        AnAction action2;
        if (actionId == null) {
            ActionsTreeUtil.$$$reportNull$$$0(0);
        }
        Presentation presentation2 = (action2 = ActionManager.getInstance().getActionOrStub(actionId)) == null ? null : action2.getTemplatePresentation();
        String string = text2 = presentation2 == null ? null : presentation2.getText();
        if (StringUtil.isEmpty((String)text2) && ourBrokenActions.add(actionId)) {
            String text22;
            AnAction action22 = action2 instanceof ActionStubBase ? ActionManager.getInstance().getAction(actionId) : null;
            Presentation presentation22 = action22 == null ? null : action22.getTemplatePresentation();
            String string2 = text22 = presentation22 == null ? null : presentation22.getText();
            if (StringUtil.isEmpty((String)text22)) {
                LOG.warn("No text in '" + actionId + "' template presentation" + (String)(boundSourceId != null ? " (bound by " + boundSourceId + ")" : "") + ". Showing its action-id instead");
            } else {
                LOG.info("No text in '" + actionId + "' stub template presentation" + (String)(boundSourceId != null ? " (bound by " + boundSourceId + ")" : "") + ". Creating its instance");
            }
            return presentation22;
        }
        return presentation2;
    }

    @NotNull
    public static Presentation getTemplatePresentation(@NotNull AnAction action2) {
        if (action2 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(1);
        }
        Presentation presentation2 = action2.getTemplatePresentation();
        if (action2 instanceof ActionStubBase) {
            ActionStubBase stub = (ActionStubBase)action2;
            if (StringUtil.isEmpty((String)presentation2.getText())) {
                Presentation presentation3 = Objects.requireNonNullElse(ActionsTreeUtil.getTemplatePresentation(stub.getId(), null), presentation2);
                if (presentation3 == null) {
                    ActionsTreeUtil.$$$reportNull$$$0(2);
                }
                return presentation3;
            }
        }
        Presentation presentation4 = presentation2;
        if (presentation4 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(3);
        }
        return presentation4;
    }

    @NotNull
    public static Map<String, String> createPluginActionsMap() {
        HashSet<PluginId> visited = new HashSet<PluginId>();
        Map result2 = CollectionFactory.createSmallMemoryFootprintMap();
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
            PluginId id2 = descriptor2.getPluginId();
            visited.add(id2);
            if (PluginManagerCore.CORE_ID.equals((Object)id2)) continue;
            for (String actionId : actionManager.getPluginActions(id2)) {
                result2.put(actionId, descriptor2.getName());
            }
        }
        for (PluginId id3 : PluginManagerCore.getPluginSet().buildPluginIdMap().keySet()) {
            if (visited.contains(id3)) continue;
            for (String actionId : actionManager.getPluginActions(id3)) {
                result2.put(actionId, id3.getIdString());
            }
        }
        Map map2 = result2;
        if (map2 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(4);
        }
        return map2;
    }

    @NotNull
    private static Group createPluginsActionsGroup(Condition<? super AnAction> filtered) {
        Group pluginsGroup = new Group(KeyMapBundle.message((String)"plugins.group.title", (Object[])new Object[0]), null);
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        JBIterable plugins2 = JBIterable.of((Object[])PluginManagerCore.getPlugins()).sort(Comparator.comparing(PluginDescriptor::getName));
        Map pluginNames = plugins2.toMap(PluginDescriptor::getPluginId, PluginDescriptor::getName);
        List pluginsIds = plugins2.map(PluginDescriptor::getPluginId).append((Iterable)JBIterable.from(PluginManagerCore.getPluginSet().buildPluginIdMap().keySet()).sort(PluginId::compareTo)).unique().toList();
        for (PluginId pluginId : pluginsIds) {
            String name2;
            Group pluginGroup;
            String[] pluginActions;
            if (PluginManagerCore.CORE_ID.equals((Object)pluginId) || ContainerUtil.exists((Iterable)KeymapExtension.EXTENSION_POINT_NAME.getExtensionList(), e -> e.skipPluginGroup(pluginId)) || (pluginActions = actionManager.getPluginActions(pluginId)).length == 0 || (pluginGroup = ActionsTreeUtil.createPluginActionsGroup(name2 = StringUtil.notNullize((String)((String)pluginNames.get(pluginId)), (String)pluginId.getIdString()), pluginActions, filtered)).getSize() <= 0) continue;
            pluginsGroup.addGroup(pluginGroup);
        }
        Group group2 = pluginsGroup;
        if (group2 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(5);
        }
        return group2;
    }

    @NotNull
    private static Group createPluginActionsGroup(@NlsActions.ActionText String name2, String[] pluginActions, Condition<? super AnAction> filtered) {
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        Group pluginGroup = new Group(name2, null);
        Arrays.sort(pluginActions, Comparator.comparing(ActionsTreeUtil::getTextToCompare));
        for (String actionId : pluginActions) {
            AnAction action2 = actionManager.getActionOrStub(actionId);
            if (ActionsTreeUtil.isNonExecutableActionGroup(actionId, action2) || !ActionsTreeUtil.actionMatchesFilter(filtered, action2)) continue;
            pluginGroup.addActionId(actionId);
        }
        Group group2 = pluginGroup;
        if (group2 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(6);
        }
        return group2;
    }

    private static Group createMainMenuGroup(Condition<? super AnAction> filtered) {
        ActionManager actionManager = ActionManager.getInstance();
        Group group2 = new Group(ActionsTreeUtil.getMainMenuTitle(), "MainMenu", AllIcons.Nodes.KeymapMainMenu);
        ActionGroup mainMenuGroup = (ActionGroup)actionManager.getActionOrStub("MainMenu");
        ActionsTreeUtil.fillGroupIgnorePopupFlag(mainMenuGroup, group2, filtered, actionManager);
        return group2;
    }

    @NotNull
    private static Condition<AnAction> wrapFilter(@Nullable Condition<? super AnAction> filter2, @Nullable Keymap keymap2) {
        ActionManager actionManager = ActionManager.getInstance();
        ActionShortcutRestrictions shortcutRestrictions = ActionShortcutRestrictions.getInstance();
        Condition condition = action2 -> {
            if (action2 == null) {
                return false;
            }
            String id2 = actionManager.getId(action2);
            if (id2 != null) {
                if (!Registry.is((String)"keymap.show.alias.actions")) {
                    boolean bound;
                    String binding = ActionManagerEx.getInstanceEx().getActionBinding(id2);
                    boolean bl = bound = binding != null && actionManager.getAction(binding) != null && !ActionsTreeUtil.hasAssociatedShortcutsInHierarchy(id2, keymap2);
                    if (bound) {
                        return false;
                    }
                }
                if (!shortcutRestrictions.getForActionId((String)id2).allowChanging) {
                    return false;
                }
            }
            return ActionsTreeUtil.actionMatchesFilter((Predicate<? super AnAction>)filter2, action2);
        };
        if (condition == null) {
            ActionsTreeUtil.$$$reportNull$$$0(7);
        }
        return condition;
    }

    private static boolean hasAssociatedShortcutsInHierarchy(String id2, Keymap keymap2) {
        while (keymap2 != null) {
            if (((KeymapImpl)keymap2).hasOwnActionId(id2)) {
                return true;
            }
            keymap2 = keymap2.getParent();
        }
        return false;
    }

    private static void fillGroupIgnorePopupFlag(ActionGroup actionGroup, Group group2, Condition<? super AnAction> filtered, ActionManager actionManager) {
        AnAction[] mainMenuTopGroups;
        for (AnAction action2 : mainMenuTopGroups = ActionsTreeUtil.getActions(actionGroup, actionManager)) {
            Group subGroup;
            if (!(action2 instanceof ActionGroup) || (subGroup = ActionsTreeUtil.createGroup((ActionGroup)action2, false, filtered)).getSize() <= 0) continue;
            group2.addGroup(subGroup);
        }
    }

    public static Group createGroup(ActionGroup actionGroup, boolean forceAsPopup, Condition<? super AnAction> filtered) {
        Presentation presentation2 = ActionsTreeUtil.getTemplatePresentation((AnAction)actionGroup);
        String text2 = presentation2.getText();
        String groupName = StringUtil.isNotEmpty((String)text2) ? text2 : ActionsTreeUtil.getName((AnAction)actionGroup);
        return ActionsTreeUtil.createGroup(actionGroup, groupName, (Supplier<? extends Icon>)presentation2.getIconSupplier(), forceAsPopup, filtered, true);
    }

    @NlsActions.ActionText
    public static String getName(@NotNull AnAction action2) {
        String name2;
        if (action2 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(8);
        }
        if (StringUtil.isNotEmpty((String)(name2 = ActionsTreeUtil.getTemplatePresentation(action2).getText()))) {
            return name2;
        }
        @NlsSafe String id2 = ActionManager.getInstance().getId(action2);
        if (id2 != null) {
            return id2;
        }
        if (action2 instanceof DefaultActionGroup) {
            AnAction[] children2;
            DefaultActionGroup group2 = (DefaultActionGroup)action2;
            if (group2.getChildrenCount() == 0) {
                return IdeBundle.message((String)"action.empty.group.text", (Object[])new Object[0]);
            }
            for (AnAction child : children2 = group2.getChildActionsOrStubs()) {
                if (child instanceof Separator) continue;
                return "group." + ActionsTreeUtil.getName(child);
            }
            return IdeBundle.message((String)"action.empty.unnamed.group.text", (Object[])new Object[0]);
        }
        return action2.getClass().getName();
    }

    public static Group createGroup(ActionGroup actionGroup, @NlsActions.ActionText String groupName, Icon icon2, boolean forceAsPopup, Condition<? super AnAction> filtered) {
        return ActionsTreeUtil.createGroup(actionGroup, groupName, () -> icon2, forceAsPopup, filtered, true);
    }

    public static Group createGroup(ActionGroup actionGroup, @NlsActions.ActionText String groupName, @Nullable @Nullable Supplier<? extends @Nullable Icon> icon2, boolean forceAsPopup, Predicate<? super AnAction> filtered, boolean normalizeSeparators) {
        GroupPopupMode popupMode = forceAsPopup ? GroupPopupMode.FORCE_POPUP : GroupPopupMode.DEFAULT;
        return ActionsTreeUtil.createGroup(actionGroup, groupName, icon2, popupMode, filtered, normalizeSeparators);
    }

    private static Group createGroup(ActionGroup actionGroup, @NlsActions.ActionText String groupName, @Nullable @Nullable Supplier<? extends @Nullable Icon> icon2, GroupPopupMode popupMode, Predicate<? super AnAction> filtered, boolean normalizeSeparators) {
        AnAction[] children2;
        ActionManager actionManager = ActionManager.getInstance();
        Group group2 = new Group(groupName, actionManager.getId((AnAction)actionGroup), icon2);
        for (AnAction action2 : children2 = ActionsTreeUtil.getActions(actionGroup, actionManager)) {
            if (action2 == null) {
                LOG.error(groupName + " contains null actions");
                continue;
            }
            ActionsTreeUtil.addActionImpl(group2, action2, actionManager, popupMode, filtered, normalizeSeparators);
        }
        if (normalizeSeparators) {
            group2.normalizeSeparators();
        }
        return group2;
    }

    private static void addActionImpl(@NotNull Group group2, @NotNull AnAction action2, @NotNull ActionManager actionManager, @NotNull GroupPopupMode popupMode, @Nullable Predicate<? super AnAction> filtered, boolean normalizeSeparators) {
        if (group2 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(9);
        }
        if (action2 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(10);
        }
        if (actionManager == null) {
            ActionsTreeUtil.$$$reportNull$$$0(11);
        }
        if (popupMode == null) {
            ActionsTreeUtil.$$$reportNull$$$0(12);
        }
        if (action2 instanceof ActionGroup) {
            ActionGroup childGroup = (ActionGroup)action2;
            boolean addAsPopup = popupMode == GroupPopupMode.FORCE_POPUP ? true : (popupMode == GroupPopupMode.FORCE_NON_POPUP ? false : childGroup.isPopup() || !Strings.isEmpty((String)ActionsTreeUtil.getTemplatePresentation((AnAction)childGroup).getText()));
            Group subGroup = ActionsTreeUtil.createGroup(childGroup, ActionsTreeUtil.getName(action2), null, popupMode, filtered, normalizeSeparators);
            if (addAsPopup) {
                if (subGroup.getSize() > 0 || ActionsTreeUtil.actionMatchesFilter(filtered, (AnAction)childGroup)) {
                    group2.addGroup(subGroup);
                }
            } else {
                group2.addAll(subGroup);
            }
        } else if (action2 instanceof Separator) {
            if (ActionsTreeUtil.actionMatchesFilter(filtered, action2)) {
                group2.addSeparator();
            }
        } else {
            String id2 = actionManager.getId(action2);
            if (id2 != null && ActionsTreeUtil.actionMatchesFilter(filtered, action2)) {
                group2.addActionId(id2);
            }
        }
    }

    @NotNull
    public static Group createCorrectedGroup(@NotNull ActionGroup actionGroup, @NotNull @NlsActions.ActionText String groupName, @NotNull List<? super String> path, @NotNull List<ActionUrl> actionUrls) {
        if (actionGroup == null) {
            ActionsTreeUtil.$$$reportNull$$$0(13);
        }
        if (groupName == null) {
            ActionsTreeUtil.$$$reportNull$$$0(14);
        }
        if (path == null) {
            ActionsTreeUtil.$$$reportNull$$$0(15);
        }
        if (actionUrls == null) {
            ActionsTreeUtil.$$$reportNull$$$0(16);
        }
        path.add(groupName);
        ActionManager actionManager = ActionManager.getInstance();
        String groupId = actionManager.getId((AnAction)actionGroup);
        Group group2 = new Group(groupName, groupId, ActionsTreeUtil.getTemplatePresentation((AnAction)actionGroup).getIcon());
        ArrayList<AnAction> children2 = new ArrayList<AnAction>(Arrays.asList(ActionsTreeUtil.getActions(actionGroup, actionManager)));
        for (ActionUrl actionUrl : actionUrls) {
            AnAction componentAction;
            Group correctedGroup;
            Object component2 = actionUrl.getComponent();
            if (component2 instanceof Group && Objects.equals((correctedGroup = (Group)component2).getId(), groupId)) {
                group2.setForceShowAsPopup(correctedGroup.isForceShowAsPopup());
            }
            if (!ActionsTreeUtil.areEqual(path, actionUrl) || (componentAction = actionUrl.getComponentAction()) == null) continue;
            if (actionUrl.getActionType() == 1) {
                if (children2.size() > actionUrl.getAbsolutePosition()) {
                    children2.add(actionUrl.getAbsolutePosition(), componentAction);
                    continue;
                }
                children2.add(componentAction);
                continue;
            }
            if (actionUrl.getActionType() != -1 || children2.size() <= actionUrl.getAbsolutePosition()) continue;
            AnAction anAction = (AnAction)children2.get(actionUrl.getAbsolutePosition());
            String actionText = ActionsTreeUtil.getTemplatePresentation(anAction).getText();
            String componentActionText = ActionsTreeUtil.getTemplatePresentation(componentAction).getText();
            if (actionText == null && componentActionText != null && !componentActionText.isEmpty() || actionText != null && !actionText.equals(componentActionText)) continue;
            children2.remove(actionUrl.getAbsolutePosition());
        }
        for (AnAction action2 : children2) {
            if (action2 instanceof NonCustomizableAction) continue;
            if (action2 instanceof ActionGroup) {
                group2.addGroup(ActionsTreeUtil.createCorrectedGroup((ActionGroup)action2, ActionsTreeUtil.getName(action2), path, actionUrls));
                continue;
            }
            if (action2 instanceof Separator) {
                group2.addSeparator();
                continue;
            }
            String id2 = actionManager.getId(action2);
            if (id2 == null) continue;
            group2.addActionId(id2);
        }
        path.remove(path.size() - 1);
        Group group3 = group2;
        if (group3 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(17);
        }
        return group3;
    }

    private static boolean areEqual(@NotNull List<? super String> path, ActionUrl actionUrl) {
        if (path == null) {
            ActionsTreeUtil.$$$reportNull$$$0(18);
        }
        ArrayList<String> groupPath = actionUrl.getGroupPath();
        if (path.size() > groupPath.size()) {
            return false;
        }
        for (int i2 = 0; i2 < path.size(); ++i2) {
            if (Objects.equals(path.get(path.size() - 1 - i2), groupPath.get(groupPath.size() - 1 - i2))) continue;
            return false;
        }
        return true;
    }

    private static Group createEditorActionsGroup(Predicate<? super AnAction> filtered) {
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup editorGroup = (DefaultActionGroup)actionManager.getActionOrStub("EditorActions");
        if (editorGroup == null) {
            throw new AssertionError((Object)"EditorActions group not found");
        }
        ArrayList ids = new ArrayList();
        ActionsTreeUtil.addEditorActions(filtered, editorGroup, ids);
        Collections.sort(ids);
        Group group2 = new Group(KeyMapBundle.message((String)"editor.actions.group.title", (Object[])new Object[0]), "EditorActions", AllIcons.Nodes.KeymapEditor);
        for (String id2 : ids) {
            group2.addActionId(id2);
        }
        return group2;
    }

    private static void addEditorActions(Predicate<? super AnAction> filtered, DefaultActionGroup editorGroup, ArrayList<? super String> ids) {
        AnAction[] editorActions = editorGroup.getChildActionsOrStubs();
        ActionManager actionManager = ActionManager.getInstance();
        for (AnAction editorAction : editorActions) {
            if (editorAction instanceof DefaultActionGroup) {
                ActionsTreeUtil.addEditorActions(filtered, (DefaultActionGroup)editorAction, ids);
                continue;
            }
            String actionId = actionManager.getId(editorAction);
            if (actionId == null || !ActionsTreeUtil.actionMatchesFilter(filtered, editorAction)) continue;
            ids.add(actionId);
        }
    }

    private static void appendGroupsFromExtensions(@Nullable Project project2, Condition<? super AnAction> wrappedFilter, @NotNull Group parentGroup, @NotNull KeymapExtension.KeymapLocation location) {
        if (parentGroup == null) {
            ActionsTreeUtil.$$$reportNull$$$0(19);
        }
        if (location == null) {
            ActionsTreeUtil.$$$reportNull$$$0(20);
        }
        for (KeymapExtension extension : KeymapExtension.EXTENSION_POINT_NAME.getExtensionList()) {
            Group group2;
            if (extension.getGroupLocation() != location || (group2 = ActionsTreeUtil.createExtensionGroup(wrappedFilter, project2, extension)) == null || location == KeymapExtension.KeymapLocation.OTHER && group2.getSize() == 0) continue;
            parentGroup.addGroup(group2);
        }
    }

    private static Group createExtensionGroup(Condition<? super AnAction> filtered, Project project2, KeymapExtension provider) {
        return (Group)provider.createGroup(filtered, project2);
    }

    private static Group createMacrosGroup(Condition<? super AnAction> filtered) {
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        List ids = actionManager.getActionIdList("Macro.");
        Group group2 = new Group(KeyMapBundle.message((String)"macros.group.title", (Object[])new Object[0]), null, (Supplier<? extends Icon>)null);
        for (String id2 : ContainerUtil.sorted((Collection)ids)) {
            if (!ActionsTreeUtil.actionMatchesFilter(filtered, (ActionManager)actionManager, id2)) continue;
            group2.addActionId(id2);
        }
        return group2;
    }

    private static Group createIntentionsGroup(Condition<? super AnAction> filtered) {
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        List ids = actionManager.getActionIdList("IntentionActionAsAction_");
        Group group2 = new Group(KeyMapBundle.message((String)"intentions.group.title", (Object[])new Object[0]), "Intentions", (Supplier<? extends Icon>)null);
        for (String id2 : ContainerUtil.sorted((Collection)ids)) {
            if (!ActionsTreeUtil.actionMatchesFilter(filtered, (ActionManager)actionManager, id2)) continue;
            group2.addActionId(id2);
        }
        return group2;
    }

    private static Group createQuickListsGroup(@Nullable Condition<? super AnAction> filtered, @Nullable String filter2, boolean forceFiltering, QuickList @NotNull [] quickLists) {
        if (quickLists == null) {
            ActionsTreeUtil.$$$reportNull$$$0(21);
        }
        Arrays.sort(quickLists, Comparator.comparing(QuickList::getActionId));
        ActionManager actionManager = ActionManager.getInstance();
        Group group2 = new Group(KeyMapBundle.message((String)"quick.lists.group.title", (Object[])new Object[0]));
        for (QuickList quickList : quickLists) {
            if ((filtered == null || !ActionsTreeUtil.actionMatchesFilter(filtered, actionManager, quickList.getActionId())) && !SearchUtil.INSTANCE.isComponentHighlighted(quickList.getName(), filter2, forceFiltering, null, SearchableOptionsRegistrar.getInstance()) && (filtered != null || !StringUtil.isEmpty((String)filter2))) continue;
            group2.addQuickList(quickList);
        }
        return group2;
    }

    @NotNull
    private static Group createOtherGroup(@Nullable Project project2, @Nullable Condition<? super AnAction> filtered, @NotNull Group mainGroup, @Nullable Keymap keymap2) {
        if (mainGroup == null) {
            ActionsTreeUtil.$$$reportNull$$$0(22);
        }
        ActionManagerImpl actionManager = (ActionManagerImpl)ActionManagerEx.getInstanceEx();
        Group otherGroup = new Group(KeyMapBundle.message((String)"other.group.title", (Object[])new Object[0]), null, () -> AllIcons.Nodes.KeymapOther);
        for (AnAction action2 : ActionsTreeUtil.getActions("Other.KeymapGroup")) {
            ActionsTreeUtil.addAction(otherGroup, action2, (ActionManager)actionManager, filtered, false);
        }
        ActionsTreeUtil.appendGroupsFromExtensions(project2, filtered, otherGroup, KeymapExtension.KeymapLocation.OTHER);
        mainGroup.initIds();
        otherGroup.initIds();
        HashSet<String> result2 = new HashSet<String>();
        if (keymap2 != null) {
            for (String id2 : keymap2.getActionIdList()) {
                if (id2.startsWith(EDITOR_PREFIX) && actionManager.getActionOrStub("$" + id2.substring(6)) != null || id2.startsWith("QuickList.") || mainGroup.containsId(id2) || otherGroup.containsId(id2)) continue;
                result2.add(id2);
            }
        }
        ArrayList<String> namedGroups = new ArrayList<String>();
        for (String id3 : actionManager.getActionIdList("")) {
            AnAction actionOrStub;
            if (ActionsTreeUtil.isNonExecutableActionGroup(id3, actionOrStub = actionManager.getActionOrStub(id3)) || id3.startsWith("QuickList.") || mainGroup.containsId(id3) || otherGroup.containsId(id3) || result2.contains(id3)) continue;
            if (actionOrStub instanceof ActionGroup) {
                namedGroups.add(id3);
                continue;
            }
            result2.add(id3);
        }
        ActionsTreeUtil.filterOtherActionsGroup(result2);
        JBTreeTraverser traverser = JBTreeTraverser.from(o -> actionManager.getParentGroupIds((String)o));
        for (String actionId : namedGroups) {
            if (((JBTreeTraverser)((JBTreeTraverser)traverser.withRoot((Object)actionId)).unique()).traverse().filter(o -> mainGroup.containsId((String)o) || otherGroup.containsId((String)o)).isNotEmpty()) continue;
            result2.add(actionId);
        }
        ContainerUtil.sort(otherGroup.getChildren(), Comparator.comparing(o -> ((Group)o).getName()));
        for (String id4 : ContainerUtil.sorted(result2, Comparator.comparing(o -> ActionsTreeUtil.getTextToCompare(o)))) {
            AnAction actionOrStub = actionManager.getActionOrStub(id4);
            if (actionOrStub != null && !ActionsTreeUtil.isSearchable(actionOrStub) || !ActionsTreeUtil.actionMatchesFilter(filtered, actionOrStub)) continue;
            otherGroup.addActionId(id4);
        }
        Group group2 = otherGroup;
        if (group2 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(23);
        }
        return group2;
    }

    private static boolean isNonExecutableActionGroup(String id2, AnAction actionOrStub) {
        return actionOrStub instanceof ActionGroup && (((ActionGroup)actionOrStub).isPopup() || StringUtil.isEmpty((String)actionOrStub.getTemplatePresentation().getText()) || StringUtil.containsIgnoreCase((String)id2, (String)"Popup") || StringUtil.containsIgnoreCase((String)id2, (String)"Toolbar"));
    }

    public static String getTextToCompare(@NotNull String id2) {
        Presentation presentation2;
        if (id2 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(24);
        }
        String text2 = (presentation2 = ActionsTreeUtil.getTemplatePresentation(id2, null)) == null ? null : presentation2.getText();
        return text2 == null ? id2 : text2;
    }

    private static void filterOtherActionsGroup(Set<String> actions) {
        ActionsTreeUtil.filterOutGroup(actions, "GenerateGroup");
        ActionsTreeUtil.filterOutGroup(actions, "NewGroup");
        ActionsTreeUtil.filterOutGroup(actions, "ChangeScheme");
    }

    private static void filterOutGroup(Set<String> actions, String groupId) {
        if (groupId == null) {
            throw new IllegalArgumentException();
        }
        ActionManager actionManager = ActionManager.getInstance();
        AnAction action2 = actionManager.getActionOrStub(groupId);
        if (action2 instanceof DefaultActionGroup) {
            AnAction[] children2;
            DefaultActionGroup group2 = (DefaultActionGroup)action2;
            for (AnAction child : children2 = group2.getChildActionsOrStubs()) {
                String childId = actionManager.getId(child);
                if (childId == null) continue;
                if (child instanceof DefaultActionGroup) {
                    ActionsTreeUtil.filterOutGroup(actions, childId);
                    continue;
                }
                actions.remove(childId);
            }
        }
    }

    public static DefaultMutableTreeNode createNode(Group group2) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(group2);
        for (Object child : group2.getChildren()) {
            if (child instanceof Group) {
                DefaultMutableTreeNode childNode = ActionsTreeUtil.createNode((Group)child);
                node.add(childNode);
                continue;
            }
            LOG.assertTrue(child != null);
            node.add(new DefaultMutableTreeNode(child));
        }
        return node;
    }

    public static Group createMainGroup(Project project2, Keymap keymap2, QuickList[] quickLists) {
        return ActionsTreeUtil.createMainGroup(project2, keymap2, quickLists, null, false, null);
    }

    @NotNull
    public static Group createMainGroup(@Nullable Project project2, @Nullable Keymap keymap2, QuickList @NotNull [] quickLists, @Nullable String filter2, boolean forceFiltering, @Nullable Condition<? super AnAction> filtered) {
        if (quickLists == null) {
            ActionsTreeUtil.$$$reportNull$$$0(25);
        }
        Condition<AnAction> wrappedFilter = ActionsTreeUtil.wrapFilter(filtered, keymap2);
        Group mainGroup = new Group(KeyMapBundle.message((String)"all.actions.group.title", (Object[])new Object[0]));
        mainGroup.addGroup(ActionsTreeUtil.createEditorActionsGroup(wrappedFilter));
        mainGroup.addGroup(ActionsTreeUtil.createMainMenuGroup(wrappedFilter));
        ActionsTreeUtil.appendGroupsFromExtensions(project2, wrappedFilter, mainGroup, KeymapExtension.KeymapLocation.TOP_LEVEL);
        mainGroup.addGroup(ActionsTreeUtil.createMacrosGroup(wrappedFilter));
        mainGroup.addGroup(ActionsTreeUtil.createIntentionsGroup(wrappedFilter));
        mainGroup.addGroup(ActionsTreeUtil.createQuickListsGroup(wrappedFilter, filter2, forceFiltering, quickLists));
        mainGroup.addGroup(ActionsTreeUtil.createPluginsActionsGroup(wrappedFilter));
        mainGroup.addGroup(ActionsTreeUtil.createOtherGroup(project2, wrappedFilter, mainGroup, keymap2));
        if (!Strings.isEmpty((String)filter2) || filtered != null) {
            ArrayList<Object> list2 = mainGroup.getChildren();
            Iterator i2 = list2.iterator();
            while (i2.hasNext()) {
                Group group2;
                Object o = i2.next();
                if (!(o instanceof Group) || (group2 = (Group)o).getSize() != 0 || SearchUtil.INSTANCE.isComponentHighlighted(group2.getName(), filter2, forceFiltering, null, SearchableOptionsRegistrar.getInstance())) continue;
                i2.remove();
            }
        }
        Group group3 = mainGroup;
        if (group3 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(26);
        }
        return group3;
    }

    @NotNull
    private static Condition<AnAction> createActionFilter(@Nullable String filter2, boolean force) {
        if (filter2 == null) {
            Condition condition = Conditions.alwaysTrue();
            if (condition == null) {
                ActionsTreeUtil.$$$reportNull$$$0(27);
            }
            return condition;
        }
        ActionManager actionManager = ActionManager.getInstance();
        AbbreviationManager abbreviationManager = AbbreviationManager.getInstance();
        String insensitiveFilter = Strings.toLowerCase((String)filter2);
        SearchableOptionsRegistrar searchableOptionsRegistrar = SearchableOptionsRegistrar.getInstance();
        Predicate<String> condition = text2 -> {
            String lowerText = Strings.toLowerCase((String)text2);
            return lowerText != null && (SearchUtil.INSTANCE.isComponentHighlighted(lowerText, insensitiveFilter, force, null, searchableOptionsRegistrar) || lowerText.contains(insensitiveFilter));
        };
        Condition condition2 = action2 -> {
            if (action2 == null) {
                return false;
            }
            Presentation presentation2 = ActionsTreeUtil.getTemplatePresentation(action2);
            if (condition.test(presentation2.getText()) || condition.test(presentation2.getDescription())) {
                return true;
            }
            for (Supplier synonym : action2.getSynonyms()) {
                if (!condition.test((String)synonym.get())) continue;
                return true;
            }
            String actionId = actionManager.getId(action2);
            if (condition.test(actionId)) {
                return true;
            }
            Set abbreviations = actionId == null ? Collections.emptySet() : abbreviationManager.getAbbreviations(actionId);
            for (String abbreviation : abbreviations) {
                if (!condition.test(abbreviation)) continue;
                return true;
            }
            return false;
        };
        if (condition2 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(28);
        }
        return condition2;
    }

    @NotNull
    private static Condition<AnAction> isActionFiltered(@NotNull ActionManager actionManager, @NotNull Keymap keymap2, @NotNull Shortcut shortcut) {
        if (actionManager == null) {
            ActionsTreeUtil.$$$reportNull$$$0(29);
        }
        if (keymap2 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(30);
        }
        if (shortcut == null) {
            ActionsTreeUtil.$$$reportNull$$$0(31);
        }
        return ActionsTreeUtil.isActionFiltered(actionManager, keymap2, (Condition<? super Shortcut>)((Condition)sc -> sc != null && sc.startsWith(shortcut)));
    }

    @NotNull
    public static Condition<AnAction> isActionFiltered(@NotNull ActionManager actionManager, @NotNull Keymap keymap2, @NotNull Condition<? super Shortcut> predicate) {
        if (actionManager == null) {
            ActionsTreeUtil.$$$reportNull$$$0(32);
        }
        if (keymap2 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(33);
        }
        if (predicate == null) {
            ActionsTreeUtil.$$$reportNull$$$0(34);
        }
        Condition condition = action2 -> {
            Shortcut[] actionShortcuts;
            if (action2 == null) {
                return false;
            }
            for (Shortcut actionShortcut : actionShortcuts = keymap2.getShortcuts(actionManager.getId(action2))) {
                if (!predicate.value((Object)actionShortcut)) continue;
                return true;
            }
            return false;
        };
        if (condition == null) {
            ActionsTreeUtil.$$$reportNull$$$0(35);
        }
        return condition;
    }

    public static Condition<AnAction> isActionFiltered(ActionManager actionManager, Keymap keymap2, Shortcut shortcut, String filter2, boolean force) {
        return filter2 != null && !filter2.isEmpty() ? ActionsTreeUtil.createActionFilter(filter2, force) : (shortcut != null ? ActionsTreeUtil.isActionFiltered(actionManager, keymap2, shortcut) : null);
    }

    public static void addAction(KeymapGroup group2, AnAction action2, Condition<? super AnAction> filtered) {
        ActionsTreeUtil.addAction(group2, action2, filtered, false);
    }

    public static void addAction(KeymapGroup group2, AnAction action2, Condition<? super AnAction> filtered, boolean forceNonPopup) {
        ActionsTreeUtil.addAction(group2, action2, ActionManager.getInstance(), filtered, forceNonPopup);
    }

    @ApiStatus.Internal
    public static void addAction(KeymapGroup group2, AnAction action2, ActionManager actionManager, Condition<? super AnAction> filtered, boolean forceNonPopup) {
        GroupPopupMode popupMode = forceNonPopup ? GroupPopupMode.FORCE_NON_POPUP : GroupPopupMode.DEFAULT;
        ActionsTreeUtil.addActionImpl((Group)group2, action2, actionManager, popupMode, filtered, true);
    }

    private static boolean isSearchable(@NotNull AnAction action2) {
        if (action2 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(36);
        }
        if (action2 instanceof ActionGroup) {
            return ((ActionGroup)action2).isSearchable();
        }
        return true;
    }

    public static AnAction @NotNull [] getActions(@NonNls String actionGroup) {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction group2 = actionManager.getActionOrStub(actionGroup);
        if (group2 == null) {
            LOG.error(actionGroup + " not found");
            if (AnAction.EMPTY_ARRAY == null) {
                ActionsTreeUtil.$$$reportNull$$$0(37);
            }
            return AnAction.EMPTY_ARRAY;
        }
        if (!(group2 instanceof ActionGroup)) {
            PluginException.logPluginError((Logger)LOG, (String)(actionGroup + " is not a group"), null, group2.getClass());
            if (AnAction.EMPTY_ARRAY == null) {
                ActionsTreeUtil.$$$reportNull$$$0(38);
            }
            return AnAction.EMPTY_ARRAY;
        }
        return ActionsTreeUtil.getActions((ActionGroup)group2, actionManager);
    }

    private static AnAction @NotNull [] getActions(@NotNull ActionGroup group2, @NotNull ActionManager actionManager) {
        ActionWithDelegate g;
        ActionGroup unwrapped;
        ActionGroup target;
        if (group2 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(39);
        }
        if (actionManager == null) {
            ActionsTreeUtil.$$$reportNull$$$0(40);
        }
        if ((target = group2) instanceof ActionGroupStub) {
            ActionGroupStub stub = (ActionGroupStub)target;
            target = (ActionGroup)actionManager.getAction(stub.getId());
        }
        if (target instanceof DefaultActionGroup) {
            DefaultActionGroup g2 = (DefaultActionGroup)target;
            AnAction[] anActionArray = g2.getChildActionsOrStubs();
            if (anActionArray == null) {
                ActionsTreeUtil.$$$reportNull$$$0(41);
            }
            return anActionArray;
        }
        if (target instanceof CustomisedActionGroup) {
            CustomisedActionGroup g3 = (CustomisedActionGroup)target;
            AnAction[] anActionArray = g3.getDefaultChildrenOrStubs();
            if (anActionArray == null) {
                ActionsTreeUtil.$$$reportNull$$$0(42);
            }
            return anActionArray;
        }
        if (target instanceof ActionWithDelegate && (unwrapped = ActionsTreeUtil.unwrapGroup(g = (ActionWithDelegate)target)) instanceof DefaultActionGroup) {
            DefaultActionGroup u = (DefaultActionGroup)unwrapped;
            AnAction[] anActionArray = u.getChildActionsOrStubs();
            if (anActionArray == null) {
                ActionsTreeUtil.$$$reportNull$$$0(43);
            }
            return anActionArray;
        }
        if (AnAction.EMPTY_ARRAY == null) {
            ActionsTreeUtil.$$$reportNull$$$0(44);
        }
        return AnAction.EMPTY_ARRAY;
    }

    @NotNull
    private static ActionGroup unwrapGroup(@NotNull ActionWithDelegate<?> g) {
        if (g == null) {
            ActionsTreeUtil.$$$reportNull$$$0(45);
        }
        ActionWithDelegate current = g;
        while (current.getDelegate() instanceof ActionWithDelegate) {
            current = (ActionWithDelegate)current.getDelegate();
        }
        ActionGroup actionGroup = (ActionGroup)current.getDelegate();
        if (actionGroup == null) {
            ActionsTreeUtil.$$$reportNull$$$0(46);
        }
        return actionGroup;
    }

    private static boolean actionMatchesFilter(@Nullable Predicate<? super AnAction> filtered, AnAction action2) {
        return filtered == null || filtered.test((AnAction)action2);
    }

    private static boolean actionMatchesFilter(@Nullable Predicate<? super AnAction> filtered, @NotNull ActionManager actionManager, @NotNull String actionId) {
        if (actionManager == null) {
            ActionsTreeUtil.$$$reportNull$$$0(47);
        }
        if (actionId == null) {
            ActionsTreeUtil.$$$reportNull$$$0(48);
        }
        return filtered == null || filtered.test((AnAction)actionManager.getActionOrStub(actionId));
    }

    @Nls
    public static String getMainMenuTitle() {
        return KeyMapBundle.message((String)"main.menu.action.title", (Object[])new Object[0]);
    }

    @Nls
    public static String getMainToolbar() {
        return KeyMapBundle.message((String)"main.toolbar.title", (Object[])new Object[0]);
    }

    @Nls
    public static String getMainToolbarLeft() {
        return ActionsBundle.message((String)"group.MainToolbarLeft.text", (Object[])new Object[0]);
    }

    @Nls
    public static String getMainToolbarCenter() {
        return ActionsBundle.message((String)"group.MainToolbarCenter.text", (Object[])new Object[0]);
    }

    @Nls
    public static String getMainToolbarRight() {
        return ActionsBundle.message((String)"group.MainToolbarRight.text", (Object[])new Object[0]);
    }

    @Nls
    public static String getExperimentalToolbar() {
        return KeyMapBundle.message((String)"experimental.toolbar.title", (Object[])new Object[0]);
    }

    @Nls
    public static String getExperimentalToolbarXamarin() {
        return KeyMapBundle.message((String)"experimental.toolbar.xamarin.title", (Object[])new Object[0]);
    }

    @Nls
    public static String getEditorPopup() {
        return KeyMapBundle.message((String)"editor.popup.menu.title", (Object[])new Object[0]);
    }

    @Nls
    public static String getEditorGutterPopupMenu() {
        return KeyMapBundle.message((String)"editor.gutter.popup.menu", (Object[])new Object[0]);
    }

    @Nls
    public static String getScopeViewPopupMenu() {
        return KeyMapBundle.message((String)"scope.view.popup.menu", (Object[])new Object[0]);
    }

    @Nls
    public static String getNavigationBarPopupMenu() {
        return KeyMapBundle.message((String)"navigation.bar.popup.menu", (Object[])new Object[0]);
    }

    @Nls
    public static String getNavigationBarToolbar() {
        return KeyMapBundle.message((String)"navigation.bar.toolbar", (Object[])new Object[0]);
    }

    @Nls
    public static String getEditorTabPopup() {
        return KeyMapBundle.message((String)"editor.tab.popup.menu.title", (Object[])new Object[0]);
    }

    @Nls
    public static String getProjectViewPopup() {
        return KeyMapBundle.message((String)"project.view.popup.menu.title", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 17, 23, 26, 27, 28, 35, 37, 38, 41, 42, 43, 44, 46 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 17: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/keymap/impl/ui/ActionsTreeUtil";
                break;
            }
            case 9: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 11: 
            case 29: 
            case 32: 
            case 40: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManager";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupMode";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionUrls";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentGroup";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickLists";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainGroup";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keymap";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcut";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/ActionsTreeUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplatePresentation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPluginActionsMap";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPluginsActionsGroup";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPluginActionsGroup";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapFilter";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createCorrectedGroup";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createOtherGroup";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createMainGroup";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionFilter";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "isActionFiltered";
                break;
            }
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTemplatePresentation";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 17: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addActionImpl";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createCorrectedGroup";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "areEqual";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "appendGroupsFromExtensions";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createQuickListsGroup";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createOtherGroup";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getTextToCompare";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createMainGroup";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isActionFiltered";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isSearchable";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "unwrapGroup";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "actionMatchesFilter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 17, 23, 26, 27, 28, 35, 37, 38, 41, 42, 43, 44, 46 -> new IllegalStateException(string);
        };
    }

    private static enum GroupPopupMode {
        FORCE_POPUP,
        FORCE_NON_POPUP,
        DEFAULT;

    }
}

