/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.advanced;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.options.advanced.AdvancedSettingBean;
import com.intellij.openapi.options.advanced.AdvancedSettingType;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.options.advanced.AdvancedSettingsChangeListener;
import com.intellij.openapi.options.advanced.AdvancedSettingsImplKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.serialization.MutableAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@State(name="AdvancedSettings", storages={@Storage(value="advancedSettings.xml", roamingType=RoamingType.DISABLED), @Storage(value="ide.general.xml", deprecated=true, roamingType=RoamingType.DISABLED)}, category=SettingsCategory.TOOLS, exportable=true)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004:\u0001&B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0016J \u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\nH\u0014J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\nH\u0014J\u0010\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\nH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\t2\u0006\u0010\u0019\u001a\u00020\nH\u0002J\u001c\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u001c0\"2\u0006\u0010\u0019\u001a\u00020\nH\u0002J\u000e\u0010#\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\nJ \u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010%\u001a\u00020\u0004H\u0007R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/openapi/options/advanced/AdvancedSettingsImpl;", "Lcom/intellij/openapi/options/advanced/AdvancedSettings;", "Lcom/intellij/openapi/components/PersistentStateComponentWithModificationTracker;", "Lcom/intellij/openapi/options/advanced/AdvancedSettingsImpl$AdvancedSettingsState;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "epCollector", "Lcom/intellij/openapi/util/KeyedExtensionCollector;", "Lcom/intellij/openapi/options/advanced/AdvancedSettingBean;", "", "internalState", "Ljava/util/concurrent/ConcurrentHashMap;", "", "unknownValues", "defaultValueCache", "modificationCount", "", "dispose", "", "getState", "loadState", "state", "getStateModificationCount", "setSetting", "id", "value", "expectType", "Lcom/intellij/openapi/options/advanced/AdvancedSettingType;", "getSetting", "getDefault", "getOption", "getOptionOrNull", "getSettingAndType", "Lkotlin/Pair;", "isNonDefault", "", "revertOnDispose", "AdvancedSettingsState", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nAdvancedSettingsImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdvancedSettingsImpl.kt\ncom/intellij/openapi/options/advanced/AdvancedSettingsImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n*L\n1#1,388:1\n1#2:389\n1#2:396\n126#3:390\n153#3,3:391\n72#4,2:394\n*S KotlinDebug\n*F\n+ 1 AdvancedSettingsImpl.kt\ncom/intellij/openapi/options/advanced/AdvancedSettingsImpl\n*L\n359#1:396\n292#1:390\n292#1:391,3\n359#1:394,2\n*E\n"})
public final class AdvancedSettingsImpl
extends AdvancedSettings
implements PersistentStateComponentWithModificationTracker<AdvancedSettingsState>,
Disposable {
    @NotNull
    private final KeyedExtensionCollector<AdvancedSettingBean, String> epCollector = new KeyedExtensionCollector(AdvancedSettingBean.EP_NAME.getName());
    @NotNull
    private final ConcurrentHashMap<String, Object> internalState = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<String, String> unknownValues = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<String, Object> defaultValueCache = new ConcurrentHashMap();
    private long modificationCount;

    public AdvancedSettingsImpl() {
        AdvancedSettingBean.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<AdvancedSettingBean>(){

            public void extensionAdded(AdvancedSettingBean extension, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                AdvancedSettingsImplKt.access$getLogger$p().info("Extension added " + pluginDescriptor.getPluginId() + ": " + extension.id);
                String string = (String)unknownValues.remove(extension.id);
                if (string == null) {
                    return;
                }
                String rawValue = string;
                ((Map)internalState).put(extension.id, extension.valueFromString(rawValue));
            }

            public void extensionRemoved(AdvancedSettingBean extension, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                AdvancedSettingsImplKt.access$getLogger$p().info("Extension removed " + pluginDescriptor.getPluginId() + ": " + extension.id);
                defaultValueCache.remove(extension.id);
                Object v = internalState.remove(extension.id);
                if (v == null) {
                    return;
                }
                Object currentValue = v;
                ((Map)unknownValues).put(extension.id, extension.valueToString(currentValue));
            }
        }, (Disposable)this);
    }

    public void dispose() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public AdvancedSettingsState getState() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$getState_u24lambda_u240;
        HashMap hashMap;
        if (AdvancedSettingsImplKt.access$getLogger$p().isDebugEnabled()) {
            AdvancedSettingsImplKt.access$getLogger$p().debug("Getting advanced settings state: " + this.internalState);
        }
        AdvancedSettingsState retval = new AdvancedSettingsState();
        HashMap hashMap2 = hashMap = new HashMap(this.unknownValues);
        AdvancedSettingsState advancedSettingsState = retval;
        boolean bl = false;
        Map map2 = this.internalState;
        void var6_7 = $this$getState_u24lambda_u240;
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            String k = (String)entry.getKey();
            Object v = entry.getValue();
            collection.add(TuplesKt.to((Object)k, (Object)this.getOption(k).valueToString(v)));
        }
        var6_7.putAll(MapsKt.toMap((Iterable)((List)destination$iv$iv)));
        advancedSettingsState.setSettings(hashMap);
        return retval;
    }

    public void loadState(@NotNull AdvancedSettingsState state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        if (AdvancedSettingsImplKt.access$getLogger$p().isDebugEnabled()) {
            AdvancedSettingsImplKt.access$getLogger$p().debug("Will load advanced settings state: " + state2.getSettings() + ". Current state: " + this.internalState);
        }
        this.internalState.clear();
        for (Map.Entry<String, String> entry : state2.getSettings().entrySet()) {
            String k = entry.getKey();
            String v = entry.getValue();
            AdvancedSettingBean optionOrNull = this.getOptionOrNull(k);
            Object object = optionOrNull != null ? this.internalState.put(k, optionOrNull.valueFromString(v)) : this.unknownValues.put(k, v);
        }
    }

    public long getStateModificationCount() {
        return this.modificationCount;
    }

    public void setSetting(@NotNull String id2, @NotNull Object value, @NotNull AdvancedSettingType expectType) {
        MutableAccessor mutableAccessor;
        AdvancedSettingBean option2;
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)expectType, (String)"expectType");
        if (AdvancedSettingsImplKt.access$getLogger$p().isDebugEnabled()) {
            AdvancedSettingsImplKt.access$getLogger$p().debug("Will set advanced setting " + id2 + " = " + value + ". Current state: " + this.internalState);
        }
        if ((option2 = this.getOption(id2)).type() != expectType) {
            throw new IllegalArgumentException("Setting type " + option2.type() + " does not match parameter type " + expectType);
        }
        Object instance = option2.getServiceInstance();
        if (instance != null && (mutableAccessor = option2.getAccessor()) != null) {
            MutableAccessor it = mutableAccessor;
            boolean bl = false;
            it.set(instance, value);
            return;
        }
        Object oldValue = this.getSetting(id2);
        if (AdvancedSettingsImplKt.access$getLogger$p().isDebugEnabled()) {
            AdvancedSettingsImplKt.access$getLogger$p().debug("Old value for " + id2 + ": " + oldValue);
        }
        if (Intrinsics.areEqual((Object)option2.getDefaultValueObject(), (Object)value)) {
            if (AdvancedSettingsImplKt.access$getLogger$p().isDebugEnabled()) {
                AdvancedSettingsImplKt.access$getLogger$p().debug("new value \"" + value + "\" for " + id2 + " is the same as default value, removing the setting");
            }
            v0 = this.internalState.remove(id2);
        } else {
            v0 = this.internalState.put(id2, value);
        }
        long l = this.modificationCount;
        this.modificationCount = l + 1L;
        ((AdvancedSettingsChangeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(AdvancedSettingsChangeListener.TOPIC)).advancedSettingChanged(id2, oldValue, value);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Object getSetting(@NotNull String id2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        AdvancedSettingBean option2 = this.getOption(id2);
        Object instance = option2.getServiceInstance();
        if (instance != null) {
            MutableAccessor mutableAccessor = option2.getAccessor();
            if (mutableAccessor != null) {
                MutableAccessor it = mutableAccessor;
                boolean bl = false;
                Object object2 = it.read(instance);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"read(...)");
                return object2;
            }
        }
        if ((object = this.internalState.get(id2)) == null) {
            void $this$getOrPut$iv;
            ConcurrentMap it = this.defaultValueCache;
            String key$iv = id2;
            boolean $i$f$getOrPut = false;
            Object object3 = $this$getOrPut$iv.get(key$iv);
            if (object3 == null) {
                boolean bl = false;
                Object default$iv = this.getOption(id2).getDefaultValueObject();
                boolean bl2 = false;
                object3 = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                if (object3 == null) {
                    object3 = default$iv;
                }
            }
            object = object3;
            Intrinsics.checkNotNullExpressionValue(object3, (String)"getOrPut(...)");
        }
        return object;
    }

    @NotNull
    protected Object getDefault(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        return this.getOption(id2).getDefaultValueObject();
    }

    private final AdvancedSettingBean getOption(String id2) {
        AdvancedSettingBean advancedSettingBean = this.getOptionOrNull(id2);
        if (advancedSettingBean == null) {
            throw new IllegalArgumentException("Can't find advanced setting " + id2);
        }
        return advancedSettingBean;
    }

    private final AdvancedSettingBean getOptionOrNull(String id2) {
        AdvancedSettingBean bean = (AdvancedSettingBean)this.epCollector.findSingle((Object)id2);
        if (bean == null) {
            AdvancedSettingsImplKt.access$getLogger$p().info("Cannot find advanced setting " + id2);
        }
        return bean;
    }

    private final Pair<Object, AdvancedSettingType> getSettingAndType(String id2) {
        return TuplesKt.to((Object)this.getSetting(id2), (Object)this.getOption(id2).type());
    }

    public final boolean isNonDefault(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        return this.internalState.containsKey(id2);
    }

    @TestOnly
    public final void setSetting(@NotNull String id2, @NotNull Object value, @NotNull Disposable revertOnDispose) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)revertOnDispose, (String)"revertOnDispose");
        Pair<Object, AdvancedSettingType> pair = this.getSettingAndType(id2);
        Object oldValue = pair.component1();
        AdvancedSettingType type = (AdvancedSettingType)pair.component2();
        this.setSetting(id2, value, type);
        Disposer.register((Disposable)revertOnDispose, () -> AdvancedSettingsImpl.setSetting$lambda$1(this, id2, oldValue, type));
    }

    private static final void setSetting$lambda$1(AdvancedSettingsImpl this$0, String $id, Object $oldValue, AdvancedSettingType $type) {
        this$0.setSetting($id, $oldValue, $type);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R&\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/options/advanced/AdvancedSettingsImpl$AdvancedSettingsState;", "", "<init>", "()V", "settings", "", "", "getSettings", "()Ljava/util/Map;", "setSettings", "(Ljava/util/Map;)V", "intellij.platform.ide.impl"})
    public static final class AdvancedSettingsState {
        @NotNull
        private Map<String, String> settings = MapsKt.emptyMap();

        @NotNull
        public final Map<String, String> getSettings() {
            return this.settings;
        }

        public final void setSettings(@NotNull Map<String, String> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
            this.settings = map2;
        }
    }
}

