/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.CommonBundle;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.ide.ui.UISettings;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.UiCompatibleDataProvider;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.newEditor.AbstractEditor;
import com.intellij.openapi.options.newEditor.OptionsEditorColleague;
import com.intellij.openapi.options.newEditor.SettingsDialogExtensionsKt;
import com.intellij.openapi.options.newEditor.SettingsEditor;
import com.intellij.openapi.options.newEditor.SettingsFilter;
import com.intellij.openapi.options.newEditor.SettingsTreeView;
import com.intellij.openapi.options.newEditor.SingleSettingEditor;
import com.intellij.openapi.options.newEditor.SpotlightPainter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.border.Border;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SettingsDialog
extends DialogWrapper
implements UiCompatibleDataProvider {
    public static final String DIMENSION_KEY = "SettingsEditor";
    private final String dimensionServiceKey;
    private final AbstractEditor editor;
    private final boolean isApplyButtonNeeded;
    private final boolean isResetButtonNeeded;
    private final JLabel myHintLabel;
    private final boolean myIsModal;

    public SettingsDialog(Project project2, String key, @NotNull Configurable configurable, boolean showApplyButton, boolean showResetButton) {
        if (configurable == null) {
            SettingsDialog.$$$reportNull$$$0(0);
        }
        super(project2, true);
        this.myHintLabel = new JLabel();
        this.dimensionServiceKey = key;
        this.editor = new SingleSettingEditor(this.myDisposable, configurable);
        this.isApplyButtonNeeded = showApplyButton;
        this.isResetButtonNeeded = showResetButton;
        this.myIsModal = true;
        this.init(configurable, project2);
    }

    public SettingsDialog(@NotNull Component parent, String key, @NotNull Configurable configurable, boolean showApplyButton, boolean showResetButton) {
        if (parent == null) {
            SettingsDialog.$$$reportNull$$$0(1);
        }
        if (configurable == null) {
            SettingsDialog.$$$reportNull$$$0(2);
        }
        super(parent, true);
        this.myHintLabel = new JLabel();
        this.dimensionServiceKey = key;
        this.editor = new SingleSettingEditor(this.myDisposable, configurable);
        this.isApplyButtonNeeded = showApplyButton;
        this.isResetButtonNeeded = showResetButton;
        this.myIsModal = true;
        this.init(configurable, null);
    }

    public SettingsDialog(@NotNull Project project2, @NotNull List<? extends ConfigurableGroup> groups, @Nullable Configurable configurable, @Nullable String filter2) {
        if (project2 == null) {
            SettingsDialog.$$$reportNull$$$0(3);
        }
        if (groups == null) {
            SettingsDialog.$$$reportNull$$$0(4);
        }
        this(project2, null, groups, configurable, filter2, true);
    }

    public SettingsDialog(@NotNull Project project2, @Nullable Component parentComponent, @NotNull List<? extends ConfigurableGroup> groups, @Nullable Configurable configurable, @Nullable String filter2) {
        if (project2 == null) {
            SettingsDialog.$$$reportNull$$$0(5);
        }
        if (groups == null) {
            SettingsDialog.$$$reportNull$$$0(6);
        }
        this(project2, parentComponent, groups, configurable, filter2, true);
    }

    SettingsDialog(@NotNull Project project2, @Nullable Component parentComponent, @NotNull List<? extends ConfigurableGroup> groups, @Nullable Configurable configurable, @Nullable String filter2, boolean isModal) {
        if (project2 == null) {
            SettingsDialog.$$$reportNull$$$0(7);
        }
        if (groups == null) {
            SettingsDialog.$$$reportNull$$$0(8);
        }
        super(project2, parentComponent, true, DialogWrapper.IdeModalityType.IDE, true, false);
        this.myHintLabel = new JLabel();
        this.dimensionServiceKey = DIMENSION_KEY;
        this.editor = new SettingsEditor(this.myDisposable, project2, groups, configurable, filter2, () -> this.createHelpButton((Insets)JBInsets.emptyInsets()), isModal, this::treeViewFactory, this::spotlightPainterFactory);
        this.isApplyButtonNeeded = true;
        this.isResetButtonNeeded = false;
        this.myIsModal = isModal;
        this.init(null, project2);
    }

    public final AbstractEditor getEditor() {
        return this.editor;
    }

    @NotNull
    protected SettingsTreeView treeViewFactory(@NotNull SettingsFilter filter2, @NotNull List<? extends ConfigurableGroup> groups) {
        if (filter2 == null) {
            SettingsDialog.$$$reportNull$$$0(9);
        }
        if (groups == null) {
            SettingsDialog.$$$reportNull$$$0(10);
        }
        return new SettingsTreeView(filter2, groups);
    }

    @ApiStatus.Internal
    @NotNull
    protected SpotlightPainter spotlightPainterFactory(@Nullable Project project2, @NotNull JComponent target, @NotNull Disposable parent, @NotNull Function1<? super SpotlightPainter, Unit> updater) {
        if (target == null) {
            SettingsDialog.$$$reportNull$$$0(11);
        }
        if (parent == null) {
            SettingsDialog.$$$reportNull$$$0(12);
        }
        if (updater == null) {
            SettingsDialog.$$$reportNull$$$0(13);
        }
        return new SpotlightPainter(target, updater);
    }

    @Nullable
    protected JComponent createTitlePane() {
        if (this.myIsModal) {
            return null;
        }
        ApplyActionWrapper applyActionWrapper = new ApplyActionWrapper(this.editor.getApplyAction());
        applyActionWrapper.putValue("DefaultAction", Boolean.toString(true));
        applyActionWrapper.putValue("Name", ActionsBundle.message((String)"action.SettingsEditor.SaveChanges.text", (Object[])new Object[0]));
        Action resetAction2 = this.editor.getResetAction();
        List<ApplyActionWrapper> actions = List.of(resetAction2, applyActionWrapper);
        DialogPanel toolbar2 = SettingsDialogExtensionsKt.createEditorToolbar(this, actions);
        return toolbar2;
    }

    private void init(@Nullable Configurable configurable, @Nullable Project project2) {
        JRootPane rootPane;
        ShortcutSet set;
        String name2 = configurable == null ? null : configurable.getDisplayName();
        String hint = project2 != null && project2.isDefault() ? IdeUICustomization.getInstance().projectMessage("template.settings.hint", new Object[0]) : null;
        this.myHintLabel.setText(hint);
        this.setTitle(name2 == null ? CommonBundle.settingsTitle() : name2.replace('\n', ' '));
        if (!this.myIsModal) {
            this.setUndecorated(true);
        }
        if ((set = SettingsDialog.getFindActionShortcutSet()) != null) {
            new SearchTextField.FindAction().registerCustomShortcutSet(set, (JComponent)this.getRootPane(), this.myDisposable);
        }
        this.init();
        if (configurable == null && this.myIsModal && (rootPane = this.getPeer().getRootPane()) != null) {
            rootPane.setMinimumSize((Dimension)new JBDimension(900, 700));
        }
    }

    protected void setHelpTooltip(@NotNull JButton helpButton) {
        if (helpButton == null) {
            SettingsDialog.$$$reportNull$$$0(14);
        }
        if (UISettings.isIdeHelpTooltipEnabled()) {
            new HelpTooltip().setDescription(ActionsBundle.actionDescription((String)"HelpTopics")).installOn((JComponent)helpButton);
        } else {
            super.setHelpTooltip(helpButton);
        }
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            SettingsDialog.$$$reportNull$$$0(15);
        }
        DataSink.uiDataSnapshot((DataSink)sink, (Object)this.editor);
    }

    protected String getDimensionServiceKey() {
        return this.dimensionServiceKey;
    }

    @Nullable
    public Dimension getInitialSize() {
        return this.editor.getDialogInitialSize();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.editor.getPreferredFocusedComponent();
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        DialogWrapper.DialogStyle dialogStyle = DialogWrapper.DialogStyle.COMPACT;
        if (dialogStyle == null) {
            SettingsDialog.$$$reportNull$$$0(16);
        }
        return dialogStyle;
    }

    protected JComponent createCenterPanel() {
        return this.editor;
    }

    @Nullable
    protected JPanel createSouthAdditionalPanel() {
        NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
        panel2.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        panel2.add(this.myHintLabel);
        this.myHintLabel.setEnabled(false);
        return panel2;
    }

    protected void tryAddOptionsListener(OptionsEditorColleague colleague) {
        if (this.editor instanceof SettingsEditor) {
            ((SettingsEditor)this.editor).addOptionsListener(colleague);
        }
    }

    protected Action @NotNull [] createActions() {
        Action reset;
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.getOKAction());
        actions.add(this.getCancelAction());
        Action apply2 = this.editor.getApplyAction();
        if (apply2 != null && this.isApplyButtonNeeded) {
            actions.add(new ApplyActionWrapper(apply2));
        }
        if ((reset = this.editor.getResetAction()) != null && this.isResetButtonNeeded) {
            actions.add(reset);
        }
        if (this.getHelpId() != null) {
            actions.add(this.getHelpAction());
        }
        Action[] actionArray = actions.toArray(new Action[0]);
        if (actionArray == null) {
            SettingsDialog.$$$reportNull$$$0(17);
        }
        return actionArray;
    }

    protected JComponent createSouthPanel() {
        if (!this.myIsModal) {
            return null;
        }
        return super.createSouthPanel();
    }

    @Nullable
    protected String getHelpId() {
        return this.editor.getHelpTopic();
    }

    public void doOKAction() {
        this.applyAndClose(true);
    }

    public void addChildDisposable(@NotNull Disposable disposable) {
        if (disposable == null) {
            SettingsDialog.$$$reportNull$$$0(18);
        }
        Disposer.register((Disposable)this.myDisposable, (Disposable)disposable);
    }

    public void applyAndClose(boolean scheduleSave) {
        Window window = this.getWindow();
        if (window != null) {
            UIUtil.stopFocusedEditing((Window)window);
        }
        if (this.editor.apply()) {
            if (scheduleSave) {
                SaveAndSyncHandler.getInstance().scheduleSave(new SaveAndSyncHandler.SaveTask(null, true));
            }
            super.doOKAction();
        }
    }

    public void doCancelAction(AWTEvent source) {
        if ((source instanceof KeyEvent || source instanceof ActionEvent || source instanceof WindowEvent) && !this.editor.cancel(source)) {
            return;
        }
        super.doCancelAction(source);
    }

    @Nullable
    static ShortcutSet getFindActionShortcutSet() {
        return EventHandler.getShortcuts("Find");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpButton";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/newEditor/SettingsDialog";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/newEditor/SettingsDialog";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "treeViewFactory";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "spotlightPainterFactory";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setHelpTooltip";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 16: 
            case 17: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addChildDisposable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16, 17 -> new IllegalStateException(string);
        };
    }

    private static final class ApplyActionWrapper
    extends AbstractAction {
        @NotNull
        private final Action delegate;

        ApplyActionWrapper(@NotNull Action delegate) {
            AbstractAction abstractAction;
            Object[] keys;
            if (delegate == null) {
                ApplyActionWrapper.$$$reportNull$$$0(0);
            }
            this.delegate = delegate;
            this.superSetEnabled(delegate.isEnabled());
            delegate.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("enabled".equals(evt.getPropertyName())) {
                        this.superSetEnabled((Boolean)evt.getNewValue());
                    }
                }
            });
            if (delegate instanceof AbstractAction && (keys = (abstractAction = (AbstractAction)delegate).getKeys()) != null) {
                for (Object key : keys) {
                    if (!(key instanceof String)) continue;
                    String stringKey = (String)key;
                    this.putValue(stringKey, abstractAction.getValue(stringKey));
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.delegate.actionPerformed(e);
        }

        @Override
        public void setEnabled(boolean newValue) {
            this.delegate.setEnabled(newValue);
        }

        private void superSetEnabled(boolean newValue) {
            super.setEnabled(newValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/openapi/options/newEditor/SettingsDialog$ApplyActionWrapper", "<init>"));
        }
    }
}

