/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.progress.util.ProgressIndicatorListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.messages.Topic;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ProgressSuspender
implements AutoCloseable {
    private static final Key<ProgressSuspender> PROGRESS_SUSPENDER = Key.create((String)"PROGRESS_SUSPENDER");
    @Topic.AppLevel
    public static final Topic<SuspenderListener> TOPIC = new Topic("ProgressSuspender", SuspenderListener.class, Topic.BroadcastDirection.NONE);
    private final Object myLock;
    private static final Application ourApp = ApplicationManager.getApplication();
    private final @NlsContexts.ProgressText @NotNull String mySuspendedText;
    private @NlsContexts.ProgressText @Nullable String myTempReason;
    private final SuspenderListener myPublisher;
    private volatile boolean mySuspended;
    private final CoreProgressManager.CheckCanceledHook myHook;
    private final Set<ProgressIndicator> myProgresses;
    private final Map<ProgressIndicator, Integer> myProgressesInNonSuspendableSections;
    private boolean myClosed;

    private ProgressSuspender(@NotNull ProgressIndicatorEx progress, @NlsContexts.ProgressText @NotNull String suspendedText) {
        if (progress == null) {
            ProgressSuspender.$$$reportNull$$$0(0);
        }
        if (suspendedText == null) {
            ProgressSuspender.$$$reportNull$$$0(1);
        }
        this.myLock = new Object();
        this.myHook = this::freezeIfNeeded;
        this.myProgresses = ConcurrentCollectionFactory.createConcurrentSet();
        this.myProgressesInNonSuspendableSections = new ConcurrentHashMap<ProgressIndicator, Integer>();
        this.mySuspendedText = suspendedText;
        assert (progress.isRunning());
        assert (ProgressIndicatorProvider.getGlobalProgressIndicator() == progress);
        this.myPublisher = (SuspenderListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC);
        this.attachToProgress(progress);
        new ProgressIndicatorListener(){

            @Override
            public void cancelled() {
                ProgressSuspender.this.resumeProcess();
            }
        }.installToProgress(progress);
        this.myPublisher.suspendableProgressAppeared(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Iterator<ProgressIndicator> iterator = this.myLock;
        synchronized (iterator) {
            this.myClosed = true;
            this.mySuspended = false;
            ((ProgressManagerImpl)ProgressManager.getInstance()).removeCheckCanceledHook(this.myHook);
        }
        for (ProgressIndicator progress : this.myProgresses) {
            ((UserDataHolder)progress).putUserData(PROGRESS_SUSPENDER, null);
            this.myPublisher.suspendableProgressRemoved(this, progress);
        }
    }

    @NotNull
    public static ProgressSuspender markSuspendable(@NotNull ProgressIndicatorEx indicator2, @NlsContexts.ProgressText @NotNull String suspendedText) {
        if (indicator2 == null) {
            ProgressSuspender.$$$reportNull$$$0(2);
        }
        if (suspendedText == null) {
            ProgressSuspender.$$$reportNull$$$0(3);
        }
        return new ProgressSuspender(indicator2, suspendedText);
    }

    @Nullable(value="When progress indicator cannot be made suspendable (e.g. EmptyProgressIndicator)")
    public static @Nullable(value="When progress indicator cannot be made suspendable (e.g. EmptyProgressIndicator)") ProgressSuspender markSuspendable(@NotNull ProgressIndicator indicator2, @NlsContexts.ProgressText @NotNull String suspendedText) {
        if (indicator2 == null) {
            ProgressSuspender.$$$reportNull$$$0(4);
        }
        if (suspendedText == null) {
            ProgressSuspender.$$$reportNull$$$0(5);
        }
        if (indicator2 instanceof ProgressIndicatorEx) {
            ProgressIndicatorEx indicatorEx = (ProgressIndicatorEx)indicator2;
            return ProgressSuspender.markSuspendable(indicatorEx, suspendedText);
        }
        return null;
    }

    public void executeNonSuspendableSection(@NotNull ProgressIndicator indicator2, @NotNull Runnable runnable2) {
        if (indicator2 == null) {
            ProgressSuspender.$$$reportNull$$$0(6);
        }
        if (runnable2 == null) {
            ProgressSuspender.$$$reportNull$$$0(7);
        }
        this.myProgressesInNonSuspendableSections.compute(indicator2, (__, number) -> (number == null ? 0 : number) + 1);
        try {
            runnable2.run();
        }
        finally {
            this.myProgressesInNonSuspendableSections.compute(indicator2, (__, number) -> number == null || number <= 1 ? null : Integer.valueOf(number - 1));
        }
    }

    public static ProgressSuspender getSuspender(@NotNull ProgressIndicator indicator2) {
        if (indicator2 == null) {
            ProgressSuspender.$$$reportNull$$$0(8);
        }
        return indicator2 instanceof UserDataHolder ? (ProgressSuspender)((UserDataHolder)indicator2).getUserData(PROGRESS_SUSPENDER) : null;
    }

    public void attachToProgress(@NotNull ProgressIndicatorEx progress) {
        if (progress == null) {
            ProgressSuspender.$$$reportNull$$$0(9);
        }
        this.myProgresses.add((ProgressIndicator)progress);
        ((UserDataHolder)progress).putUserData(PROGRESS_SUSPENDER, (Object)this);
        this.myPublisher.suspendableProgressAppeared(this, (ProgressIndicator)progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NlsContexts.ProgressText
    @NotNull
    public String getSuspendedText() {
        Object object = this.myLock;
        // MONITORENTER : object
        String string = this.myTempReason != null ? this.myTempReason : this.mySuspendedText;
        // MONITOREXIT : object
        if (string != null) return string;
        ProgressSuspender.$$$reportNull$$$0(10);
        return string;
    }

    public boolean isSuspended() {
        return this.mySuspended;
    }

    public boolean isClosed() {
        return this.myClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendProcess(@NlsContexts.ProgressText @Nullable String reason) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.mySuspended || this.myClosed) {
                return;
            }
            this.mySuspended = true;
            this.myTempReason = reason;
            ((ProgressManagerImpl)ProgressManager.getInstance()).addCheckCanceledHook(this.myHook);
        }
        this.myPublisher.suspendedStatusChanged(this);
        ApplicationManager.getApplication().invokeLater(() -> WriteAction.run(() -> {}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeProcess() {
        Object object = this.myLock;
        synchronized (object) {
            if (!this.mySuspended) {
                return;
            }
            this.mySuspended = false;
            this.myTempReason = null;
            ((ProgressManagerImpl)ProgressManager.getInstance()).removeCheckCanceledHook(this.myHook);
            this.myLock.notifyAll();
        }
        this.myPublisher.suspendedStatusChanged(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean freezeIfNeeded(ProgressIndicator current) {
        if (current == null) {
            current = ProgressIndicatorProvider.getGlobalProgressIndicator();
        }
        if (current == null || !this.myProgresses.contains(current)) {
            return false;
        }
        if (this.myProgressesInNonSuspendableSections.containsKey(current)) {
            return false;
        }
        if (ProgressSuspender.isCurrentThreadHoldingKnownLocks()) {
            return false;
        }
        Object object = this.myLock;
        synchronized (object) {
            while (this.mySuspended) {
                try {
                    this.myLock.wait(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return true;
        }
    }

    private static boolean isCurrentThreadHoldingKnownLocks() {
        if (ourApp.isReadAccessAllowed()) {
            return true;
        }
        ThreadInfo[] infos = ManagementFactory.getThreadMXBean().getThreadInfo(new long[]{Thread.currentThread().getId()}, true, false);
        return infos.length > 0 && infos[0].getLockedMonitors().length > 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendedText";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/impl/ProgressSuspender";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/impl/ProgressSuspender";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuspendedText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "markSuspendable";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "executeNonSuspendableSection";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSuspender";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "attachToProgress";
                break;
            }
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10 -> new IllegalStateException(string);
        };
    }

    public static interface SuspenderListener {
        default public void suspendableProgressAppeared(@NotNull ProgressSuspender suspender) {
            if (suspender == null) {
                SuspenderListener.$$$reportNull$$$0(0);
            }
        }

        default public void suspendableProgressAppeared(@NotNull ProgressSuspender suspender, @NotNull ProgressIndicator progressIndicator) {
            if (suspender == null) {
                SuspenderListener.$$$reportNull$$$0(1);
            }
            if (progressIndicator == null) {
                SuspenderListener.$$$reportNull$$$0(2);
            }
        }

        default public void suspendableProgressRemoved(@NotNull ProgressSuspender suspender, @NotNull ProgressIndicator progressIndicator) {
            if (suspender == null) {
                SuspenderListener.$$$reportNull$$$0(3);
            }
            if (progressIndicator == null) {
                SuspenderListener.$$$reportNull$$$0(4);
            }
        }

        default public void suspendedStatusChanged(@NotNull ProgressSuspender suspender) {
            if (suspender == null) {
                SuspenderListener.$$$reportNull$$$0(5);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suspender";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressIndicator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/progress/impl/ProgressSuspender$SuspenderListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "suspendableProgressAppeared";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "suspendableProgressRemoved";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "suspendedStatusChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

