/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbModeStatisticsCollector;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbServiceInitializationCondition;
import com.intellij.openapi.project.MergingTaskQueue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class DumbServiceMergingTaskQueue
extends MergingTaskQueue<DumbModeTask> {
    private static final ExtensionPointName<DumbServiceInitializationCondition> DUMB_SERVICE_INITIALIZATION_CONDITION_EXTENSION_POINT_NAME = ExtensionPointName.create((String)"com.intellij.dumbServiceInitializationCondition");
    private final AtomicBoolean myFirstExecution = new AtomicBoolean(true);

    private void waitRequiredTasksToStartIndexing() {
        if (this.myFirstExecution.compareAndSet(true, false)) {
            Logger logger = Logger.getInstance(DumbServiceMergingTaskQueue.class);
            logger.info("Initializing DumbServiceMergingTaskQueue...");
            for (DumbServiceInitializationCondition condition : DUMB_SERVICE_INITIALIZATION_CONDITION_EXTENSION_POINT_NAME.getExtensionList()) {
                logger.info("Running initialization condition: " + String.valueOf(condition));
                condition.waitForInitialization();
                logger.info("Finished: " + String.valueOf(condition));
            }
        }
    }

    @Nullable
    public QueuedDumbModeTask extractNextTask() {
        return (QueuedDumbModeTask)super.extractNextTask();
    }

    protected QueuedDumbModeTask wrapTask(DumbModeTask task, ProgressIndicatorBase indicator2) {
        return new QueuedDumbModeTask(task, (ProgressIndicatorEx)indicator2);
    }

    @ApiStatus.Internal
    public final class QueuedDumbModeTask
    extends MergingTaskQueue.QueuedTask<DumbModeTask> {
        QueuedDumbModeTask(@NotNull DumbModeTask task, ProgressIndicatorEx progress) {
            if (task == null) {
                QueuedDumbModeTask.$$$reportNull$$$0(0);
            }
            if (progress == null) {
                QueuedDumbModeTask.$$$reportNull$$$0(1);
            }
            super(task, progress);
        }

        @Override
        StructuredIdeActivity registerStageStarted(@NotNull StructuredIdeActivity activity, @NotNull Project project2) {
            if (activity == null) {
                QueuedDumbModeTask.$$$reportNull$$$0(2);
            }
            if (project2 == null) {
                QueuedDumbModeTask.$$$reportNull$$$0(3);
            }
            return DumbModeStatisticsCollector.DUMB_MODE_STAGE_ACTIVITY.startedWithParent(project2, activity, () -> Collections.singletonList(DumbModeStatisticsCollector.STAGE_CLASS.with(((DumbModeTask)this.getTask()).getClass())));
        }

        @Override
        void registerStageFinished(@NotNull StructuredIdeActivity parentActivity, @Nullable StructuredIdeActivity childActivity, @NotNull DumbModeStatisticsCollector.IndexingFinishType finishType) {
            if (parentActivity == null) {
                QueuedDumbModeTask.$$$reportNull$$$0(4);
            }
            if (finishType == null) {
                QueuedDumbModeTask.$$$reportNull$$$0(5);
            }
            if (childActivity != null) {
                childActivity.finished(() -> Arrays.asList(DumbModeStatisticsCollector.FINISH_TYPE.with((Object)finishType), DumbModeStatisticsCollector.STAGE_CLASS.with(((DumbModeTask)this.getTask()).getClass())));
            }
        }

        @Override
        public void beforeTask() {
            DumbServiceMergingTaskQueue.this.waitRequiredTasksToStartIndexing();
        }

        @Override
        String getInfoString() {
            return "(dumb mode task) " + super.getInfoString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progress";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "activity";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentActivity";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "finishType";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/project/DumbServiceMergingTaskQueue$QueuedDumbModeTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerStageStarted";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerStageFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

