/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeUICustomization;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/project/impl/UnableToSaveProjectNotification;", "Lcom/intellij/notification/Notification;", "project", "Lcom/intellij/openapi/project/Project;", "readOnlyFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "files", "getFiles", "()Ljava/util/List;", "setFiles", "(Ljava/util/List;)V", "expire", "", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class UnableToSaveProjectNotification
extends Notification {
    @Nullable
    private Project project;
    @NotNull
    private List<? extends VirtualFile> files;

    public UnableToSaveProjectNotification(@NotNull Project project2, @NotNull List<? extends VirtualFile> readOnlyFiles) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(readOnlyFiles, (String)"readOnlyFiles");
        super("Project Settings", IdeUICustomization.getInstance().projectMessage("notification.title.cannot.save.project", new Object[0]), IdeBundle.message((String)"notification.content.unable.to.save.project.files", (Object[])new Object[0]), NotificationType.ERROR);
        this.setListener(UnableToSaveProjectNotification::_init_$lambda$0);
        this.project = project2;
        this.files = readOnlyFiles;
    }

    @NotNull
    public final List<VirtualFile> getFiles() {
        return this.files;
    }

    public final void setFiles(@NotNull List<? extends VirtualFile> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.files = list2;
    }

    public void expire() {
        this.project = null;
        super.expire();
    }

    private static final void _init_$lambda$0(Notification notification2, HyperlinkEvent hyperlinkEvent) {
        Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
        Intrinsics.checkNotNullParameter((Object)hyperlinkEvent, (String)"<unused var>");
        UnableToSaveProjectNotification unableToSaveProjectNotification = (UnableToSaveProjectNotification)notification2;
        Project p = unableToSaveProjectNotification.project;
        ((UnableToSaveProjectNotification)notification2).expire();
        if (p != null && !p.isDisposed()) {
            p.save();
        }
    }
}

