/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui;

import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.FileAppearanceService;
import com.intellij.openapi.roots.ui.SdkAppearanceService;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import javax.swing.UIManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SdkAppearanceServiceImpl
extends SdkAppearanceService {
    @NotNull
    public CellAppearanceEx forNullSdk(boolean selected) {
        CellAppearanceEx cellAppearanceEx = FileAppearanceService.getInstance().forInvalidUrl(ProjectBundle.message((String)"sdk.missing.item", (Object[])new Object[0]));
        if (cellAppearanceEx == null) {
            SdkAppearanceServiceImpl.$$$reportNull$$$0(0);
        }
        return cellAppearanceEx;
    }

    @NotNull
    public CellAppearanceEx forSdk(@Nullable Sdk sdk, boolean isInComboBox, boolean selected, boolean showVersion) {
        if (sdk == null) {
            CellAppearanceEx cellAppearanceEx = this.forNullSdk(selected);
            if (cellAppearanceEx == null) {
                SdkAppearanceServiceImpl.$$$reportNull$$$0(1);
            }
            return cellAppearanceEx;
        }
        String name2 = sdk.getName();
        SdkType sdkType = (SdkType)sdk.getSdkType();
        boolean hasValidPath = sdkType.sdkHasValidPath(sdk);
        String versionString = showVersion ? sdk.getVersionString() : null;
        CellAppearanceEx cellAppearanceEx = this.forSdk((SdkTypeId)sdkType, name2, versionString, hasValidPath, isInComboBox, selected);
        if (cellAppearanceEx == null) {
            SdkAppearanceServiceImpl.$$$reportNull$$$0(2);
        }
        return cellAppearanceEx;
    }

    @NotNull
    public CellAppearanceEx forSdk(@NotNull SdkTypeId sdkType, @NotNull String name2, @Nullable String versionString, boolean hasValidPath, boolean isInComboBox, boolean selected) {
        if (sdkType == null) {
            SdkAppearanceServiceImpl.$$$reportNull$$$0(3);
        }
        if (name2 == null) {
            SdkAppearanceServiceImpl.$$$reportNull$$$0(4);
        }
        CompositeAppearance appearance = new CompositeAppearance();
        if (sdkType instanceof SdkType) {
            appearance.setIcon(((SdkType)sdkType).getIcon());
        }
        SimpleTextAttributes attributes = SdkAppearanceServiceImpl.getTextAttributes(hasValidPath, selected);
        CompositeAppearance.DequeEnd ending = appearance.getEnding();
        ending.addText(StringUtil.shortenTextWithEllipsis((String)name2, (int)50, (int)0), attributes);
        if (versionString != null && !versionString.equals(name2) && !StringUtil.isEmptyOrSpaces((String)versionString)) {
            SimpleTextAttributes textAttributes = isInComboBox && !selected ? SimpleTextAttributes.SYNTHETIC_ATTRIBUTES : (SystemInfo.isMac && selected ? new SimpleTextAttributes(0, (Color)JBColor.WHITE) : SimpleTextAttributes.GRAY_ATTRIBUTES);
            @NlsSafe String shortVersion = StringUtil.shortenTextWithEllipsis((String)versionString, (int)30, (int)0);
            ending.addComment(shortVersion, textAttributes);
        }
        CompositeAppearance compositeAppearance = ending.getAppearance();
        if (compositeAppearance == null) {
            SdkAppearanceServiceImpl.$$$reportNull$$$0(5);
        }
        return compositeAppearance;
    }

    private static SimpleTextAttributes getTextAttributes(boolean valid, boolean selected) {
        if (!valid) {
            return SimpleTextAttributes.ERROR_ATTRIBUTES;
        }
        if (!(!selected || SystemInfoRt.isWindows && UIManager.getLookAndFeel().getName().contains("Windows"))) {
            return SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES;
        }
        return SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/SdkAppearanceServiceImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "forNullSdk";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "forSdk";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/SdkAppearanceServiceImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forSdk";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

