/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.validation;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.validation.DialogValidation;
import com.intellij.openapi.ui.validation.OperationUtilKt;
import com.intellij.openapi.ui.validation.ValidationUtilKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.UIBundle;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u001a\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d*\u00020\u001fH\u0002\u00a2\u0006\u0002\u0010 \"\u001d\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u001d\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0005\"\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001d\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0005\"\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001d\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0005\"\u001d\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0005\"\u001d\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0005\"\u001d\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0005\"\u000e\u0010\u0016\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001d\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0005\"\u001d\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0005\"%\u0010!\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\"%\u0010%\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010$\"\u001d\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0005\"%\u0010)\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010$\"%\u0010+\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010$\"%\u0010-\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010$\u00a8\u0006/"}, d2={"CHECK_NON_EMPTY", "Lcom/intellij/openapi/ui/validation/DialogValidation$WithParameter;", "Lkotlin/Function0;", "", "getCHECK_NON_EMPTY", "()Lcom/intellij/openapi/ui/validation/DialogValidation$WithParameter;", "CHECK_NO_WHITESPACES", "getCHECK_NO_WHITESPACES", "reservedWordsPattern", "Lkotlin/text/Regex;", "CHECK_NO_RESERVED_WORDS", "getCHECK_NO_RESERVED_WORDS", "namePattern", "firstSymbolNamePattern", "CHECK_NAME_FORMAT", "getCHECK_NAME_FORMAT", "CHECK_NON_EMPTY_DIRECTORY", "getCHECK_NON_EMPTY_DIRECTORY", "CHECK_DIRECTORY", "getCHECK_DIRECTORY", "CHECK_READABLE_DIRECTORY", "getCHECK_READABLE_DIRECTORY", "firstSymbolGroupIdPattern", "CHECK_GROUP_ID_FORMAT", "CHECK_GROUP_ID", "getCHECK_GROUP_ID", "CHECK_ARTIFACT_ID", "getCHECK_ARTIFACT_ID", "getModules", "", "Lcom/intellij/openapi/module/Module;", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)[Lcom/intellij/openapi/module/Module;", "CHECK_FREE_MODULE_NAME", "Lcom/intellij/openapi/ui/validation/DialogValidation$WithTwoParameters;", "getCHECK_FREE_MODULE_NAME", "()Lcom/intellij/openapi/ui/validation/DialogValidation$WithTwoParameters;", "CHECK_FREE_MODULE_PATH", "getCHECK_FREE_MODULE_PATH", "CHECK_FREE_PROJECT_PATH", "getCHECK_FREE_PROJECT_PATH", "CHECK_MODULE_NAME", "getCHECK_MODULE_NAME", "CHECK_MODULE_PATH", "getCHECK_MODULE_PATH", "CHECK_PROJECT_PATH", "getCHECK_PROJECT_PATH", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nvalidations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 validations.kt\ncom/intellij/openapi/ui/validation/ValidationsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n1#2:107\n11561#3:108\n11896#3,3:109\n1761#4,3:112\n*S KotlinDebug\n*F\n+ 1 validations.kt\ncom/intellij/openapi/ui/validation/ValidationsKt\n*L\n87#1:108\n87#1:109,3\n87#1:112,3\n*E\n"})
public final class ValidationsKt {
    @NotNull
    private static final DialogValidation.WithParameter<Function0<String>> CHECK_NON_EMPTY;
    @NotNull
    private static final DialogValidation.WithParameter<Function0<String>> CHECK_NO_WHITESPACES;
    @NotNull
    private static final Regex reservedWordsPattern;
    @NotNull
    private static final DialogValidation.WithParameter<Function0<String>> CHECK_NO_RESERVED_WORDS;
    @NotNull
    private static final Regex namePattern;
    @NotNull
    private static final Regex firstSymbolNamePattern;
    @NotNull
    private static final DialogValidation.WithParameter<Function0<String>> CHECK_NAME_FORMAT;
    @NotNull
    private static final DialogValidation.WithParameter<Function0<String>> CHECK_NON_EMPTY_DIRECTORY;
    @NotNull
    private static final DialogValidation.WithParameter<Function0<String>> CHECK_DIRECTORY;
    @NotNull
    private static final DialogValidation.WithParameter<Function0<String>> CHECK_READABLE_DIRECTORY;
    @NotNull
    private static final Regex firstSymbolGroupIdPattern;
    @NotNull
    private static final DialogValidation.WithParameter<Function0<String>> CHECK_GROUP_ID_FORMAT;
    @NotNull
    private static final DialogValidation.WithParameter<Function0<String>> CHECK_GROUP_ID;
    @NotNull
    private static final DialogValidation.WithParameter<Function0<String>> CHECK_ARTIFACT_ID;
    @NotNull
    private static final DialogValidation.WithTwoParameters<Project, Function0<String>> CHECK_FREE_MODULE_NAME;
    @NotNull
    private static final DialogValidation.WithTwoParameters<Project, Function0<String>> CHECK_FREE_MODULE_PATH;
    @NotNull
    private static final DialogValidation.WithParameter<Function0<String>> CHECK_FREE_PROJECT_PATH;
    @NotNull
    private static final DialogValidation.WithTwoParameters<Project, Function0<String>> CHECK_MODULE_NAME;
    @NotNull
    private static final DialogValidation.WithTwoParameters<Project, Function0<String>> CHECK_MODULE_PATH;
    @NotNull
    private static final DialogValidation.WithTwoParameters<Project, Function0<String>> CHECK_PROJECT_PATH;

    @NotNull
    public static final DialogValidation.WithParameter<Function0<String>> getCHECK_NON_EMPTY() {
        return CHECK_NON_EMPTY;
    }

    @NotNull
    public static final DialogValidation.WithParameter<Function0<String>> getCHECK_NO_WHITESPACES() {
        return CHECK_NO_WHITESPACES;
    }

    @NotNull
    public static final DialogValidation.WithParameter<Function0<String>> getCHECK_NO_RESERVED_WORDS() {
        return CHECK_NO_RESERVED_WORDS;
    }

    @NotNull
    public static final DialogValidation.WithParameter<Function0<String>> getCHECK_NAME_FORMAT() {
        return CHECK_NAME_FORMAT;
    }

    @NotNull
    public static final DialogValidation.WithParameter<Function0<String>> getCHECK_NON_EMPTY_DIRECTORY() {
        return CHECK_NON_EMPTY_DIRECTORY;
    }

    @NotNull
    public static final DialogValidation.WithParameter<Function0<String>> getCHECK_DIRECTORY() {
        return CHECK_DIRECTORY;
    }

    @NotNull
    public static final DialogValidation.WithParameter<Function0<String>> getCHECK_READABLE_DIRECTORY() {
        return CHECK_READABLE_DIRECTORY;
    }

    @NotNull
    public static final DialogValidation.WithParameter<Function0<String>> getCHECK_GROUP_ID() {
        return CHECK_GROUP_ID;
    }

    @NotNull
    public static final DialogValidation.WithParameter<Function0<String>> getCHECK_ARTIFACT_ID() {
        return CHECK_ARTIFACT_ID;
    }

    private static final Module[] getModules(Project $this$getModules) {
        return ModuleManager.Companion.getInstance($this$getModules).getModules();
    }

    @NotNull
    public static final DialogValidation.WithTwoParameters<Project, Function0<String>> getCHECK_FREE_MODULE_NAME() {
        return CHECK_FREE_MODULE_NAME;
    }

    @NotNull
    public static final DialogValidation.WithTwoParameters<Project, Function0<String>> getCHECK_FREE_MODULE_PATH() {
        return CHECK_FREE_MODULE_PATH;
    }

    @NotNull
    public static final DialogValidation.WithParameter<Function0<String>> getCHECK_FREE_PROJECT_PATH() {
        return CHECK_FREE_PROJECT_PATH;
    }

    @NotNull
    public static final DialogValidation.WithTwoParameters<Project, Function0<String>> getCHECK_MODULE_NAME() {
        return CHECK_MODULE_NAME;
    }

    @NotNull
    public static final DialogValidation.WithTwoParameters<Project, Function0<String>> getCHECK_MODULE_PATH() {
        return CHECK_MODULE_PATH;
    }

    @NotNull
    public static final DialogValidation.WithTwoParameters<Project, Function0<String>> getCHECK_PROJECT_PATH() {
        return CHECK_PROJECT_PATH;
    }

    private static final boolean CHECK_NON_EMPTY$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((CharSequence)it).length() == 0;
    }

    private static final boolean CHECK_NO_WHITESPACES$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.contains$default((CharSequence)it, (char)' ', (boolean)false, (int)2, null);
    }

    private static final boolean CHECK_NO_RESERVED_WORDS$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Regex.find$default((Regex)reservedWordsPattern, (CharSequence)it, (int)0, (int)2, null) != null;
    }

    private static final boolean CHECK_NAME_FORMAT$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !namePattern.matches((CharSequence)it);
    }

    private static final boolean CHECK_NAME_FORMAT$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !firstSymbolNamePattern.matches((CharSequence)it);
    }

    private static final String CHECK_NON_EMPTY_DIRECTORY$lambda$0(Path path) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && !((Collection)PathsKt.listDirectoryEntries$default((Path)path, null, (int)1, null)).isEmpty()) {
            Object[] objectArray = new Object[]{PathsKt.getName((Path)path)};
            string = UIBundle.message((String)"label.project.wizard.new.project.directory.not.empty.warning", (Object[])objectArray);
        } else {
            string = null;
        }
        return string;
    }

    private static final String CHECK_DIRECTORY$lambda$0(Path path) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            string = null;
        } else if (!Files.isWritable(path)) {
            Object[] objectArray = new Object[]{PathsKt.getName((Path)path)};
            string = UIBundle.message((String)"label.project.wizard.new.project.directory.not.writable.error", (Object[])objectArray);
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (!Files.isDirectory(path, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                Object[] objectArray = new Object[]{PathsKt.getName((Path)path)};
                string = UIBundle.message((String)"label.project.wizard.new.project.file.not.directory.error", (Object[])objectArray);
            } else {
                string = null;
            }
        }
        return string;
    }

    private static final String CHECK_READABLE_DIRECTORY$lambda$0(Path path) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            string = null;
        } else if (!Files.isReadable(path)) {
            Object[] objectArray = new Object[]{PathsKt.getName((Path)path)};
            string = UIBundle.message((String)"label.project.wizard.new.project.directory.not.readable.error", (Object[])objectArray);
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (!Files.isDirectory(path, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                Object[] objectArray = new Object[]{PathsKt.getName((Path)path)};
                string = UIBundle.message((String)"label.project.wizard.new.project.file.not.directory.error", (Object[])objectArray);
            } else {
                string = null;
            }
        }
        return string;
    }

    private static final String CHECK_GROUP_ID_FORMAT$lambda$0(String text2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (StringsKt.startsWith$default((CharSequence)text2, (char)'.', (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)text2, (char)'.', (boolean)false, (int)2, null)) {
            string = UIBundle.message((String)"kotlin.dsl.validation.groupId.leading.trailing.dot", (Object[])new Object[0]);
        } else if (StringsKt.contains$default((CharSequence)text2, (CharSequence)"..", (boolean)false, (int)2, null)) {
            string = UIBundle.message((String)"kotlin.dsl.validation.groupId.double.dot", (Object[])new Object[0]);
        } else {
            Object v1;
            block7: {
                String[] stringArray = new String[]{"."};
                Iterable iterable = StringsKt.split$default((CharSequence)text2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                for (Object object : iterable) {
                    String it = (String)object;
                    boolean bl = false;
                    if (!(!firstSymbolGroupIdPattern.matches((CharSequence)it))) continue;
                    v1 = object;
                    break block7;
                }
                v1 = null;
            }
            String string2 = v1;
            if (string2 != null) {
                Object object;
                String it = string2;
                boolean bl = false;
                object = new Object[]{it};
                string = UIBundle.message((String)"kotlin.dsl.validation.groupId.part.allowed.symbols", object);
            } else {
                string = null;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String CHECK_FREE_MODULE_NAME$lambda$0(Project project2, String name2) {
        Module module;
        block2: {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            if (project2 == null) return null;
            Module[] moduleArray = ValidationsKt.getModules(project2);
            if (moduleArray == null) return null;
            Module[] moduleArray2 = moduleArray;
            int n = 0;
            int n2 = moduleArray2.length;
            while (n < n2) {
                Module it = module = moduleArray2[n];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name2)) {
                    ++n;
                    continue;
                }
                break block2;
            }
            return null;
        }
        Module module2 = module;
        Module module3 = module2;
        if (module3 == null) return null;
        Module it = module3;
        boolean bl = false;
        Object[] objectArray = new Object[]{it.getName()};
        String string = UIBundle.message((String)"label.project.wizard.new.module.name.exists.error", (Object[])objectArray);
        return string;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String CHECK_FREE_MODULE_PATH$lambda$0(Project project2, Path path) {
        Module module;
        block7: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (project2 == null) return null;
            Module[] moduleArray = ValidationsKt.getModules(project2);
            if (moduleArray == null) return null;
            Module[] moduleArray2 = moduleArray;
            int n = 0;
            int n2 = moduleArray2.length;
            while (n < n2) {
                boolean bl;
                block6: {
                    void $this$mapTo$iv$iv;
                    Module m = module = moduleArray2[n];
                    boolean bl2 = false;
                    VirtualFile[] virtualFileArray = ProjectUtil.getRootManager((Module)m).getContentRoots();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
                    Object[] objectArray = virtualFileArray;
                    boolean $i$f$map = false;
                    Object[] objectArray2 = objectArray;
                    Collection destination$iv$iv = new ArrayList(objectArray.length);
                    boolean $i$f$mapTo = false;
                    for (void item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        collection.add(it.toNioPath());
                    }
                    Iterable iterable = (List)destination$iv$iv;
                    boolean $i$f$any = false;
                    if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : iterable) {
                            Path it = (Path)element$iv;
                            boolean bl4 = false;
                            if (!Intrinsics.areEqual((Object)it, (Object)path)) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (!bl) {
                    ++n;
                    continue;
                }
                break block7;
            }
            return null;
        }
        Module module2 = module;
        Module module3 = module2;
        if (module3 == null) return null;
        Module it = module3;
        boolean bl = false;
        Object[] objectArray = new Object[]{it.getName()};
        String string = UIBundle.message((String)"label.project.wizard.new.module.directory.already.taken.error", (Object[])objectArray);
        return string;
    }

    private static final String CHECK_FREE_PROJECT_PATH$lambda$0(Path path) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Project project2 = com.intellij.ide.impl.ProjectUtil.INSTANCE.findProject(path);
        if (project2 != null) {
            Object[] objectArray = new Object[]{project2.getName()};
            string = UIBundle.message((String)"label.project.wizard.new.project.directory.already.taken.error", (Object[])objectArray);
        } else {
            string = null;
        }
        return string;
    }

    static {
        String string = UIBundle.message((String)"kotlin.dsl.validation.missing.value", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        CHECK_NON_EMPTY = ValidationUtilKt.validationErrorIf((String)string, ValidationsKt::CHECK_NON_EMPTY$lambda$0);
        String string2 = UIBundle.message((String)"kotlin.dsl.validation.no.whitespaces", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        CHECK_NO_WHITESPACES = ValidationUtilKt.validationErrorIf((String)string2, ValidationsKt::CHECK_NO_WHITESPACES$lambda$0);
        reservedWordsPattern = new Regex("(^|[ .])(con|prn|aux|nul|com\\d|lpt\\d)($|[ .])", RegexOption.IGNORE_CASE);
        String string3 = UIBundle.message((String)"kotlin.dsl.validation.no.reserved.words", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        CHECK_NO_RESERVED_WORDS = ValidationUtilKt.validationErrorIf((String)string3, ValidationsKt::CHECK_NO_RESERVED_WORDS$lambda$0);
        namePattern = new Regex("[a-zA-Z\\d\\s_.-]*");
        firstSymbolNamePattern = new Regex("[a-zA-Z\\d_].*");
        String string4 = UIBundle.message((String)"kotlin.dsl.validation.name.allowed.symbols", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        DialogValidation.WithParameter withParameter = ValidationUtilKt.validationErrorIf((String)string4, ValidationsKt::CHECK_NAME_FORMAT$lambda$0);
        String string5 = UIBundle.message((String)"kotlin.dsl.validation.name.leading.symbols", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        CHECK_NAME_FORMAT = OperationUtilKt.and((DialogValidation.WithParameter)withParameter, (DialogValidation.WithParameter)ValidationUtilKt.validationErrorIf((String)string5, ValidationsKt::CHECK_NAME_FORMAT$lambda$1));
        CHECK_NON_EMPTY_DIRECTORY = OperationUtilKt.withOKEnabled((DialogValidation.WithParameter)OperationUtilKt.asWarning((DialogValidation.WithParameter)ValidationUtilKt.validationPathErrorFor(ValidationsKt::CHECK_NON_EMPTY_DIRECTORY$lambda$0)));
        CHECK_DIRECTORY = ValidationUtilKt.validationPathErrorFor(ValidationsKt::CHECK_DIRECTORY$lambda$0);
        CHECK_READABLE_DIRECTORY = ValidationUtilKt.validationPathErrorFor(ValidationsKt::CHECK_READABLE_DIRECTORY$lambda$0);
        firstSymbolGroupIdPattern = new Regex("[a-zA-Z_].*");
        CHECK_GROUP_ID_FORMAT = ValidationUtilKt.validationErrorFor(ValidationsKt::CHECK_GROUP_ID_FORMAT$lambda$0);
        CHECK_GROUP_ID = OperationUtilKt.and((DialogValidation.WithParameter)OperationUtilKt.and((DialogValidation.WithParameter)OperationUtilKt.and(CHECK_NO_WHITESPACES, CHECK_NAME_FORMAT), CHECK_GROUP_ID_FORMAT), CHECK_NO_RESERVED_WORDS);
        CHECK_ARTIFACT_ID = OperationUtilKt.and((DialogValidation.WithParameter)OperationUtilKt.and(CHECK_NO_WHITESPACES, CHECK_NAME_FORMAT), CHECK_NO_RESERVED_WORDS);
        CHECK_FREE_MODULE_NAME = ValidationUtilKt.validationErrorFor(ValidationsKt::CHECK_FREE_MODULE_NAME$lambda$0);
        CHECK_FREE_MODULE_PATH = ValidationUtilKt.validationPathErrorFor(ValidationsKt::CHECK_FREE_MODULE_PATH$lambda$0);
        CHECK_FREE_PROJECT_PATH = ValidationUtilKt.validationPathErrorFor(ValidationsKt::CHECK_FREE_PROJECT_PATH$lambda$0);
        CHECK_MODULE_NAME = OperationUtilKt.and((DialogValidation.WithTwoParameters)OperationUtilKt.and(CHECK_NAME_FORMAT, CHECK_FREE_MODULE_NAME), CHECK_NO_RESERVED_WORDS);
        CHECK_MODULE_PATH = OperationUtilKt.and((DialogValidation.WithParameter)OperationUtilKt.and(CHECK_DIRECTORY, CHECK_NON_EMPTY_DIRECTORY), CHECK_FREE_MODULE_PATH);
        CHECK_PROJECT_PATH = OperationUtilKt.and(CHECK_MODULE_PATH, CHECK_FREE_PROJECT_PATH);
    }
}

