/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.features;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextLikeFileType;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.features.FileHandlerFeatureDetector;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Locale;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001f\u0010\n\u001a\r\u0012\u0004\u0012\u00020\u00070\u000b\u00a2\u0006\u0002\b\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/features/AnsiHighlighterDetector;", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/features/FileHandlerFeatureDetector;", "<init>", "()V", "ansiRegex", "Lkotlin/text/Regex;", "id", "", "getId", "()Ljava/lang/String;", "displayName", "Ljava/util/function/Supplier;", "Lorg/jetbrains/annotations/Nls;", "getDisplayName", "()Ljava/util/function/Supplier;", "isSupported", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class AnsiHighlighterDetector
implements FileHandlerFeatureDetector {
    @NotNull
    private final Regex ansiRegex = new Regex("\\u001b\\[[0-9;]*[mGKHFJ]|\n\\u001b\\([0-9;]*[BJ]|\n\\u001b][0-9;]*.*\\u0007|\n\\u001b[PX^_].*\\u001b\\\\");
    @NotNull
    private final String id;
    @NotNull
    private final Supplier<String> displayName;

    public AnsiHighlighterDetector() {
        this.id = "ansi-highlighter";
        Supplier supplier = IdeBundle.messagePointer((String)"feature.file.handler.ansi.highlighter", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"messagePointer(...)");
        this.displayName = supplier;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public Supplier<String> getDisplayName() {
        return this.displayName;
    }

    @Override
    public boolean isSupported(@NotNull VirtualFile file2) {
        String extension;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        String string = file2.getExtension();
        if (string != null) {
            String string2 = string.toLowerCase(Locale.ROOT);
            v2 = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        } else {
            v2 = extension = null;
        }
        if (!Intrinsics.areEqual((Object)extension, (Object)"txt") && !Intrinsics.areEqual((Object)extension, (Object)"log")) {
            return false;
        }
        FileType fileType2 = file2.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"getFileType(...)");
        FileType fileType3 = fileType2;
        if (fileType3.isBinary()) {
            return false;
        }
        if (!(fileType3 instanceof PlainTextLikeFileType)) {
            return false;
        }
        CharSequence charSequence = LoadTextUtil.loadText((VirtualFile)file2, (int)1000);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"loadText(...)");
        CharSequence logString = charSequence;
        return this.ansiRegex.containsMatchIn(logString);
    }
}

