/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsUtils;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.WindowState;
import com.intellij.openapi.util.WindowStateAdapter;
import com.intellij.openapi.util.WindowStateBean;
import com.intellij.openapi.util.WindowStateService;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.ScreenUtil;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class WindowStateServiceImpl
extends WindowStateService
implements ModificationTracker,
PersistentStateComponent<Element> {
    @NonNls
    private static final String KEY = "key";
    @NonNls
    private static final String STATE = "state";
    @NonNls
    private static final String MAXIMIZED = "maximized";
    @NonNls
    private static final String FULL_SCREEN = "full-screen";
    @NonNls
    private static final String TIMESTAMP = "timestamp";
    @NonNls
    private static final String SCREEN = "screen";
    @NonNls
    private static final String PRESENTATION_MODE_MODE_KEY_SUFFIX = ".inPresentationMode";
    private static final Logger LOG = Logger.getInstance(WindowStateService.class);
    private final AtomicLong myModificationCount = new AtomicLong();
    private final Map<String, Runnable> myRunnableMap = new TreeMap<String, Runnable>();
    private final Map<String, CachedState> myStateMap = new TreeMap<String, CachedState>();

    protected WindowStateServiceImpl(@Nullable Project project2) {
        super(project2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getModificationCount() {
        Map<String, Runnable> map2 = this.myRunnableMap;
        synchronized (map2) {
            this.myRunnableMap.values().forEach(Runnable::run);
        }
        return this.myModificationCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Element getState() {
        Element element = new Element(STATE);
        Map<String, CachedState> map2 = this.myStateMap;
        synchronized (map2) {
            for (Map.Entry<String, CachedState> entry : this.myStateMap.entrySet()) {
                String key = entry.getKey();
                if (key == null) continue;
                CachedState state2 = entry.getValue();
                Element child = new Element(STATE);
                if (state2.myLocation != null) {
                    JDOMUtil.setLocation((Element)child, (Point)state2.myLocation);
                }
                if (state2.mySize != null) {
                    JDOMUtil.setSize((Element)child, (Dimension)state2.mySize);
                }
                if (state2.myMaximized) {
                    child.setAttribute(MAXIMIZED, Boolean.toString(true));
                }
                if (state2.myFullScreen) {
                    child.setAttribute(FULL_SCREEN, Boolean.toString(true));
                }
                if (state2.myScreen != null) {
                    child.addContent(JDOMUtil.setBounds((Element)new Element(SCREEN), (Rectangle)state2.myScreen));
                }
                child.setAttribute(KEY, key);
                child.setAttribute(TIMESTAMP, Long.toString(state2.myTimeStamp));
                element.addContent(child);
            }
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadState(@NotNull Element element) {
        if (element == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(0);
        }
        Map<String, CachedState> map2 = this.myStateMap;
        synchronized (map2) {
            this.myStateMap.clear();
            for (Element child : element.getChildren()) {
                String key;
                if (!STATE.equals(child.getName())) continue;
                long current = System.currentTimeMillis();
                long timestamp = StringUtilRt.parseLong((String)child.getAttributeValue(TIMESTAMP), (long)current);
                if (TimeUnit.DAYS.toMillis(100L) <= current - timestamp || StringUtilRt.isEmpty((CharSequence)(key = child.getAttributeValue(KEY)))) continue;
                Point location = JDOMUtil.getLocation((Element)child);
                Dimension size2 = JDOMUtil.getSize((Element)child);
                if (location == null && size2 == null) continue;
                CachedState state2 = new CachedState();
                state2.myLocation = location;
                state2.mySize = size2;
                state2.myMaximized = Boolean.parseBoolean(child.getAttributeValue(MAXIMIZED));
                state2.myFullScreen = Boolean.parseBoolean(child.getAttributeValue(FULL_SCREEN));
                state2.myScreen = WindowStateServiceImpl.apply(JDOMUtil::getBounds, child.getChild(SCREEN));
                state2.myTimeStamp = timestamp;
                this.myStateMap.put(key, state2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowState getStateFor(final @Nullable Project project2, final @NotNull String key, @NotNull Window window) {
        if (key == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(1);
        }
        if (window == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(2);
        }
        Map<String, Runnable> map2 = this.myRunnableMap;
        synchronized (map2) {
            final WindowStateBean state2 = WindowStateAdapter.getState(window);
            Runnable runnable2 = this.myRunnableMap.put(key, new Runnable(){
                private long myModificationCount;
                {
                    this.myModificationCount = state2.getModificationCount();
                }

                @Override
                public void run() {
                    long newModificationCount = state2.getModificationCount();
                    if (this.myModificationCount != newModificationCount) {
                        this.myModificationCount = newModificationCount;
                        Point location = state2.getLocation();
                        Dimension size2 = state2.getSize();
                        WindowStateServiceImpl.this.putFor(project2, key, location, location != null, size2, size2 != null, 6 == state2.getExtendedState(), true, state2.isFullScreen(), true);
                    }
                }
            });
            if (runnable2 != null) {
                runnable2.run();
            }
        }
        return this.getFor(project2, key, WindowState.class);
    }

    public Point getLocationFor(Object object, @NotNull String key) {
        if (key == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(3);
        }
        return this.getFor(object, key, Point.class);
    }

    public void putLocationFor(Object object, @NotNull String key, Point location) {
        if (key == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(4);
        }
        this.putFor(object, key, location, true, null, false, false, false, false, false);
    }

    public Dimension getSizeFor(Object object, @NotNull String key) {
        if (key == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(5);
        }
        return this.getFor(object, key, Dimension.class);
    }

    public void putSizeFor(Object object, @NotNull String key, Dimension size2) {
        if (key == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(6);
        }
        this.putFor(object, key, null, false, size2, true, false, false, false, false);
    }

    public Rectangle getBoundsFor(Object object, @NotNull String key) {
        if (key == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(7);
        }
        return this.getFor(object, key, Rectangle.class);
    }

    public void putBoundsFor(Object object, @NotNull String key, Rectangle bounds) {
        if (key == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(8);
        }
        Point location = WindowStateServiceImpl.apply(Rectangle::getLocation, bounds);
        Dimension size2 = WindowStateServiceImpl.apply(Rectangle::getSize, bounds);
        this.putFor(object, key, location, true, size2, true, false, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getFor(Object object, @NotNull String key, @NotNull Class<T> type) {
        if (key == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(9);
        }
        if (type == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(10);
        }
        if (GraphicsEnvironment.getLocalGraphicsEnvironment().isHeadlessInstance() || Registry.is((String)"ui.disable.dimension.service.keys", (boolean)false)) {
            return null;
        }
        if (UISettings.getInstance().getPresentationMode()) {
            key = (String)key + PRESENTATION_MODE_MODE_KEY_SUFFIX;
        }
        String keyWithScale = WindowStateServiceImpl.withAppendedIdeScale((String)key);
        boolean tryWithScale = WindowStateServiceImpl.shouldAppendIdeScaleToKey();
        GraphicsConfiguration configuration = WindowStateServiceImpl.getConfiguration(object);
        Map<String, CachedState> map2 = this.myStateMap;
        synchronized (map2) {
            T result2;
            if (tryWithScale && (result2 = this.synchronizedGetFor(configuration, keyWithScale, type)) != null) {
                return result2;
            }
            return this.synchronizedGetFor(configuration, (String)key, type);
        }
    }

    private <T> T synchronizedGetFor(GraphicsConfiguration configuration, @NotNull String key, @NotNull Class<T> type) {
        CachedState state2;
        if (key == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(11);
        }
        if (type == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(12);
        }
        if (WindowStateServiceImpl.isVisible(state2 = this.myStateMap.get(WindowStateServiceImpl.getAbsoluteKey(configuration, key)))) {
            return state2.get(type, null);
        }
        state2 = this.myStateMap.get(key);
        return state2 == null ? null : (T)state2.get(type, state2.myScreen == null ? null : WindowStateServiceImpl.getScreenRectangle(configuration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putFor(Object object, @NotNull String key, Point location, boolean locationSet, Dimension size2, boolean sizeSet, boolean maximized, boolean maximizedSet, boolean fullScreen, boolean fullScreenSet) {
        if (key == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(13);
        }
        if (GraphicsEnvironment.getLocalGraphicsEnvironment().isHeadlessInstance()) {
            return;
        }
        if (UISettings.getInstance().getPresentationMode()) {
            key = (String)key + PRESENTATION_MODE_MODE_KEY_SUFFIX;
        }
        key = WindowStateServiceImpl.withAppendedIdeScale((String)key);
        GraphicsConfiguration configuration = WindowStateServiceImpl.getConfiguration(object);
        Map<String, CachedState> map2 = this.myStateMap;
        synchronized (map2) {
            this.put(WindowStateServiceImpl.getAbsoluteKey(configuration, (String)key), location, locationSet, size2, sizeSet, maximized, maximizedSet, fullScreen, fullScreenSet);
            CachedState state2 = this.put((String)key, location, locationSet, size2, sizeSet, maximized, maximizedSet, fullScreen, fullScreenSet);
            if (state2 != null) {
                state2.updateScreenRectangle(configuration);
            }
        }
        this.myModificationCount.getAndIncrement();
    }

    private static String withAppendedIdeScale(String key) {
        int defaultPercentScale;
        if (!WindowStateServiceImpl.shouldAppendIdeScaleToKey()) {
            return key;
        }
        UISettingsUtils settingsUtils = UISettingsUtils.getInstance();
        int percentScale = UISettingsUtils.percentValue((float)settingsUtils.getCurrentIdeScale());
        if (percentScale == (defaultPercentScale = UISettingsUtils.percentValue((float)settingsUtils.getCurrentDefaultScale()))) {
            return key;
        }
        return key + ".ideScale=" + percentScale;
    }

    private static boolean shouldAppendIdeScaleToKey() {
        return Registry.is((String)"ide.window.state.consider.ide.scale");
    }

    @Nullable
    private CachedState put(@NotNull String key, @Nullable Point location, boolean locationSet, @Nullable Dimension size2, boolean sizeSet, boolean maximized, boolean maximizedSet, boolean fullScreen, boolean fullScreenSet) {
        CachedState state2;
        if (key == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(14);
        }
        if ((state2 = this.myStateMap.get(key)) == null) {
            state2 = new CachedState();
            if (!state2.set(location, locationSet, size2, sizeSet, maximized, maximizedSet, fullScreen, fullScreenSet)) {
                return null;
            }
            this.myStateMap.put(key, state2);
            return state2;
        }
        if (state2.set(location, locationSet, size2, sizeSet, maximized, maximizedSet, fullScreen, fullScreenSet)) {
            return state2;
        }
        this.myStateMap.remove(key);
        return null;
    }

    @NotNull
    private static String getAbsoluteKey(@Nullable GraphicsConfiguration configuration, @NotNull String key) {
        if (key == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(15);
        }
        StringBuilder sb = new StringBuilder(key);
        for (GraphicsDevice device : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            Rectangle bounds = ScreenUtil.getScreenRectangle((GraphicsConfiguration)device.getDefaultConfiguration());
            sb.append('/').append(bounds.x);
            sb.append('.').append(bounds.y);
            sb.append('.').append(bounds.width);
            sb.append('.').append(bounds.height);
        }
        if (configuration != null) {
            Rectangle bounds = ScreenUtil.getScreenRectangle((GraphicsConfiguration)configuration);
            sb.append('@').append(bounds.x);
            sb.append('.').append(bounds.y);
            sb.append('.').append(bounds.width);
            sb.append('.').append(bounds.height);
        }
        String string = sb.toString();
        if (string == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Nullable
    private static GraphicsConfiguration getConfiguration(@Nullable Object object) {
        GraphicsDevice device;
        if (object instanceof Project) {
            Project project2 = (Project)object;
            if (project2.isDefault()) {
                return null;
            }
            Application app = ApplicationManager.getApplication();
            if (app != null && app.isHeadlessEnvironment()) {
                return null;
            }
            object = WindowManager.getInstance().getFrame(project2);
            if (object == null) {
                LOG.warn("cannot find a project frame for " + String.valueOf(project2));
            }
        }
        if (object instanceof Window) {
            Window window = (Window)object;
            GraphicsConfiguration configuration = window.getGraphicsConfiguration();
            if (configuration != null) {
                return configuration;
            }
            object = ScreenUtil.getScreenDevice((Rectangle)window.getBounds());
            if (object == null) {
                LOG.warn("cannot find a device for " + String.valueOf(window));
            }
        }
        if (object instanceof GraphicsDevice && (object = (device = (GraphicsDevice)object).getDefaultConfiguration()) == null) {
            LOG.warn("cannot find a configuration for " + String.valueOf(device));
        }
        if (object instanceof GraphicsConfiguration) {
            return (GraphicsConfiguration)object;
        }
        if (object != null) {
            LOG.warn("unexpected object " + String.valueOf(object.getClass()));
        }
        return null;
    }

    @NotNull
    private static Rectangle getScreenRectangle(@Nullable GraphicsConfiguration configuration) {
        Rectangle rectangle = configuration != null ? ScreenUtil.getScreenRectangle((GraphicsConfiguration)configuration) : ScreenUtil.getMainScreenBounds();
        if (rectangle == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(17);
        }
        return rectangle;
    }

    private static boolean isVisible(@Nullable CachedState state2) {
        return state2 != null && WindowStateServiceImpl.isVisible(state2.myLocation, state2.mySize);
    }

    private static boolean isVisible(Point location, Dimension size2) {
        if (location == null) {
            return size2 != null;
        }
        if (ScreenUtil.isVisible((Point)location)) {
            return true;
        }
        if (size2 == null) {
            return false;
        }
        return ScreenUtil.isVisible((Rectangle)new Rectangle(location, size2));
    }

    @Nullable
    private static <T, R> R apply(@NotNull Function<? super T, ? extends R> function, @Nullable T value) {
        if (function == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(18);
        }
        return value == null ? null : (R)function.apply((T)value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = KEY;
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/WindowStateServiceImpl";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/WindowStateServiceImpl";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsoluteKey";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getScreenRectangle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getStateFor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLocationFor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "putLocationFor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSizeFor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "putSizeFor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBoundsFor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "putBoundsFor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFor";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "synchronizedGetFor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "putFor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAbsoluteKey";
                break;
            }
            case 16: 
            case 17: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16, 17 -> new IllegalStateException(string);
        };
    }

    private static final class CachedState {
        private Rectangle myScreen;
        private Point myLocation;
        private Dimension mySize;
        private boolean myMaximized;
        private boolean myFullScreen;
        private long myTimeStamp;

        private CachedState() {
        }

        <T> T get(@NotNull Class<T> type, @Nullable Rectangle screen) {
            if (type == null) {
                CachedState.$$$reportNull$$$0(0);
            }
            Point location = WindowStateServiceImpl.apply(Point::new, this.myLocation);
            Dimension size2 = WindowStateServiceImpl.apply(Dimension::new, this.mySize);
            if (this.myScreen != null && !this.myScreen.isEmpty() && screen != null && !screen.isEmpty()) {
                if (location != null) {
                    ScreenUtil.moveAndScale((Point)location, (Rectangle)this.myScreen, (Rectangle)screen);
                }
                if (size2 != null) {
                    ScreenUtil.moveAndScale((Dimension)size2, (Rectangle)this.myScreen, (Rectangle)screen);
                }
                if (!WindowStateServiceImpl.isVisible(location, size2)) {
                    return null;
                }
            }
            if (type == Point.class) {
                return (T)location;
            }
            if (type == Dimension.class) {
                return (T)size2;
            }
            if (type == Rectangle.class) {
                return (T)(location == null || size2 == null ? null : new Rectangle(location, size2));
            }
            if (type != WindowState.class) {
                throw new IllegalArgumentException();
            }
            WindowStateBean state2 = new WindowStateBean();
            state2.setLocation(location);
            state2.setSize(size2);
            state2.setExtendedState(this.myMaximized ? 6 : 0);
            state2.setFullScreen(this.myFullScreen);
            return (T)state2;
        }

        private boolean set(Point location, boolean locationSet, Dimension size2, boolean sizeSet, boolean maximized, boolean maximizedSet, boolean fullScreen, boolean fullScreenSet) {
            if (locationSet) {
                this.myLocation = WindowStateServiceImpl.apply(Point::new, location);
            }
            if (sizeSet) {
                this.mySize = WindowStateServiceImpl.apply(Dimension::new, size2);
            }
            if (maximizedSet) {
                this.myMaximized = maximized;
            }
            if (fullScreenSet) {
                this.myFullScreen = fullScreen;
            }
            if (this.myLocation == null && this.mySize == null) {
                return false;
            }
            this.myTimeStamp = System.currentTimeMillis();
            return true;
        }

        void updateScreenRectangle(@Nullable GraphicsConfiguration configuration) {
            this.myScreen = this.myLocation == null ? WindowStateServiceImpl.getScreenRectangle(configuration) : (this.mySize == null ? ScreenUtil.getScreenRectangle((Point)this.myLocation) : ScreenUtil.getScreenRectangle((int)(this.myLocation.x + this.mySize.width / 2), (int)(this.myLocation.y + this.mySize.height / 2)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/util/WindowStateServiceImpl$CachedState", "get"));
        }
    }
}

