/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001\u001aj\u0010\t\u001a\u00020\n\"\u0004\b\u0000\u0010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000f2\"\u0010\u0010\u001a\u001e\b\u0001\u0012\u0004\u0012\u0002H\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00112\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\n0\u0011H\u0087@\u00a2\u0006\u0002\u0010\u0016\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0017"}, d2={"systemIndependentPath", "", "Ljava/io/File;", "getSystemIndependentPath", "(Ljava/io/File;)Ljava/lang/String;", "endsWithName", "", "path", "name", "writeWithEnsureWritable", "", "FileDescriptor", "project", "Lcom/intellij/openapi/project/Project;", "files", "", "writeFile", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "", "errorCollector", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nfileUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 fileUtil.kt\ncom/intellij/openapi/util/io/FileUtilKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,110:1\n136#2,9:111\n216#2:120\n217#2:122\n145#2:123\n1#3:121\n2813#4,10:124\n*S KotlinDebug\n*F\n+ 1 fileUtil.kt\ncom/intellij/openapi/util/io/FileUtilKt\n*L\n68#1:111,9\n68#1:120\n68#1:122\n68#1:123\n68#1:121\n83#1:124,10\n*E\n"})
public final class FileUtilKt {
    @NotNull
    public static final String getSystemIndependentPath(@NotNull File $this$systemIndependentPath) {
        Intrinsics.checkNotNullParameter((Object)$this$systemIndependentPath, (String)"<this>");
        String string = $this$systemIndependentPath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return StringsKt.replace$default((String)string, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean endsWithName(@NotNull String path, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (!StringsKt.endsWith$default((String)path, (String)name2, (boolean)false, (int)2, null)) return false;
        if (path.length() == name2.length()) return true;
        Character c = StringsKt.getOrNull((CharSequence)path, (int)(path.length() - name2.length() - 1));
        char c2 = '/';
        if (c == null) return false;
        if (c.charValue() != c2) return false;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @ApiStatus.Internal
    @Nullable
    public static final <FileDescriptor> Object writeWithEnsureWritable(@Nullable Project project, @NotNull Collection<? extends FileDescriptor> files, @NotNull Function2<? super FileDescriptor, ? super Continuation<? super Unit>, ? extends Object> writeFile, @NotNull Function2<? super FileDescriptor, ? super Throwable, Unit> errorCollector, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof writeWithEnsureWritable.1)) ** GOTO lbl-1000
        var28_5 = $completion;
        if ((var28_5.label & -2147483648) != 0) {
            var28_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                Object L$10;
                Object L$11;
                Object L$12;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return FileUtilKt.writeWithEnsureWritable(null, null, null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var29_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                notWritableFiles = new LinkedHashMap<K, V>();
                var6_9 = files.iterator();
lbl14:
                // 6 sources

                while (var6_9.hasNext()) {
                    file = var6_9.next();
                    $continuation.L$0 = project;
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)files);
                    $continuation.L$2 = writeFile;
                    $continuation.L$3 = errorCollector;
                    $continuation.L$4 = notWritableFiles;
                    $continuation.L$5 = var6_9;
                    $continuation.L$6 = file;
                    $continuation.label = 1;
                    v0 = writeFile.invoke(file, $continuation);
                    if (v0 != var29_7) continue;
                    return var29_7;
                }
                break;
            }
            case 1: {
                file = $continuation.L$6;
                var6_9 = (Iterator<FileDescriptor>)$continuation.L$5;
                notWritableFiles = (Map)$continuation.L$4;
                errorCollector = (Function2)$continuation.L$3;
                writeFile = (Function2)$continuation.L$2;
                files = (Collection)$continuation.L$1;
                project = (Project)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                    ** GOTO lbl14
                }
                catch (CancellationException e) {
                    throw e;
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (AccessDeniedException e) {
                    if (project != null) ** GOTO lbl52
                    errorCollector.invoke(file, (Object)e);
                    ** GOTO lbl14
lbl52:
                    // 1 sources

                    notWritableFiles.put(file, e);
                    ** GOTO lbl14
                }
                catch (Throwable e) {
                    errorCollector.invoke(file, (Object)e);
                    ** GOTO lbl14
                }
            }
        }
        if (project == null || notWritableFiles.isEmpty()) {
            return Unit.INSTANCE;
        }
        v1 = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getInstance(...)");
        localFileSystem = v1;
        $this$mapNotNull$iv = notWritableFiles;
        $i$f$mapNotNull = false;
        var10_18 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var15_25 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (var15_25.hasNext()) {
            element$iv$iv = element$iv$iv$iv = var15_25.next();
            $i$a$-forEach-MapsKt___MapsKt$mapNotNullTo$1$iv$iv = false;
            var19_33 = element$iv$iv;
            $i$a$-mapNotNull-FileUtilKt$writeWithEnsureWritable$accessDeniedFiles$1 = false;
            file = var19_33.getKey();
            accessDeniedException = (AccessDeniedException)var19_33.getValue();
            if (accessDeniedException.getFile() == null) {
                v2 = null;
            } else {
                virtualFile = localFileSystem.findFileByPath(filePath);
                v3 = virtualFile;
                v2 = v3 != null ? TuplesKt.to(file, (Object)v3) : null;
            }
            if (v2 == null) continue;
            it$iv$iv = v2;
            $i$a$-let-MapsKt___MapsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        accessDeniedFiles = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)files);
        $continuation.L$2 = writeFile;
        $continuation.L$3 = errorCollector;
        $continuation.L$4 = notWritableFiles;
        $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)localFileSystem);
        $continuation.L$6 = accessDeniedFiles;
        $continuation.label = 2;
        v4 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ReadonlyStatusHandler.OperationStatus>, Object>(project, accessDeniedFiles, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ Map<FileDescriptor, VirtualFile> $accessDeniedFiles;
            {
                this.$project = $project;
                this.$accessDeniedFiles = $accessDeniedFiles;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        return ReadonlyStatusHandler.getInstance((Project)this.$project).ensureFilesWritable(this.$accessDeniedFiles.values());
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super ReadonlyStatusHandler.OperationStatus> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $continuation);
        if (v4 == var29_7) {
            return var29_7;
        }
        ** GOTO lbl115
        {
            case 2: {
                accessDeniedFiles = (Map)$continuation.L$6;
                localFileSystem = (LocalFileSystem)$continuation.L$5;
                notWritableFiles = (Map)$continuation.L$4;
                errorCollector = (Function2)$continuation.L$3;
                writeFile = (Function2)$continuation.L$2;
                files = (Collection)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl115:
                // 2 sources

                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"withContext(...)");
                status = (ReadonlyStatusHandler.OperationStatus)v4;
                v5 = status.getReadonlyFiles();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getReadonlyFiles(...)");
                readOnlyFiles = ArraysKt.toSet((Object[])v5);
                $this$partition$iv = MapsKt.asSequence((Map)accessDeniedFiles);
                $i$f$partition = false;
                first$iv = new ArrayList<E>();
                second$iv = new ArrayList<E>();
                for (E element$iv : $this$partition$iv) {
                    var17_31 = (Map.Entry)element$iv;
                    $i$a$-partition-FileUtilKt$writeWithEnsureWritable$2 = false;
                    file = (VirtualFile)var17_31.getValue();
                    v6 = readOnlyFiles.contains(file) != false ? first$iv.add(element$iv) : second$iv.add(element$iv);
                }
                var10_18 = new Pair(first$iv, second$iv);
                stillReadOnly = (List)var10_18.component1();
                writableFiles = (List)var10_18.component2();
                var13_22 = writableFiles.iterator();
lbl134:
                // 5 sources

                while (var13_22.hasNext()) {
                    file = ((Map.Entry)var13_22.next()).getKey();
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)files);
                    $continuation.L$2 = writeFile;
                    $continuation.L$3 = errorCollector;
                    $continuation.L$4 = notWritableFiles;
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)localFileSystem);
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)accessDeniedFiles);
                    $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)status);
                    $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)readOnlyFiles);
                    $continuation.L$9 = stillReadOnly;
                    $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)writableFiles);
                    $continuation.L$11 = var13_22;
                    $continuation.L$12 = file;
                    $continuation.label = 3;
                    v7 = writeFile.invoke(file, $continuation);
                    if (v7 != var29_7) continue;
                    return var29_7;
                }
                break;
            }
            case 3: {
                file = $continuation.L$12;
                var13_22 = (Iterator<E>)$continuation.L$11;
                writableFiles = (List)$continuation.L$10;
                stillReadOnly = (List)$continuation.L$9;
                readOnlyFiles = (Set)$continuation.L$8;
                status = (ReadonlyStatusHandler.OperationStatus)$continuation.L$7;
                accessDeniedFiles = (Map)$continuation.L$6;
                localFileSystem = (LocalFileSystem)$continuation.L$5;
                notWritableFiles = (Map)$continuation.L$4;
                errorCollector = (Function2)$continuation.L$3;
                writeFile = (Function2)$continuation.L$2;
                files = (Collection)$continuation.L$1;
                project = (Project)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v7 = $result;
                    ** GOTO lbl134
                }
                catch (CancellationException e) {
                    throw e;
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (AccessDeniedException e) {
                    notWritableFiles.put(file, e);
                    ** GOTO lbl134
                }
                catch (Throwable e) {
                    errorCollector.invoke(file, (Object)e);
                    ** GOTO lbl134
                }
            }
        }
        var13_22 = stillReadOnly.iterator();
        while (var13_22.hasNext()) {
            file = ((Map.Entry)var13_22.next()).getKey();
            accessDeniedException = (AccessDeniedException)notWritableFiles.get(file);
            if (accessDeniedException == null) continue;
            errorCollector.invoke(file, (Object)accessDeniedException);
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }
}

