/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFsConnectionListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/vfs/impl/jar/ArchiveCachesCleaner;", "Lcom/intellij/openapi/vfs/newvfs/persistent/PersistentFsConnectionListener;", "<init>", "()V", "beforeConnectionClosed", "", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nArchiveCachesCleaner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArchiveCachesCleaner.kt\ncom/intellij/openapi/vfs/impl/jar/ArchiveCachesCleaner\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,25:1\n13#2:26\n*S KotlinDebug\n*F\n+ 1 ArchiveCachesCleaner.kt\ncom/intellij/openapi/vfs/impl/jar/ArchiveCachesCleaner\n*L\n19#1:26\n*E\n"})
final class ArchiveCachesCleaner
implements PersistentFsConnectionListener {
    public void beforeConnectionClosed() {
        ManagingFS managingFS = ManagingFS.getInstanceOrNull();
        if (managingFS == null) {
            return;
        }
        VirtualFile[] virtualFileArray = managingFS.getRoots();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getRoots(...)");
        for (VirtualFile root : virtualFileArray) {
            VirtualFileSystem fs;
            Intrinsics.checkNotNullExpressionValue((Object)root.getFileSystem(), (String)"getFileSystem(...)");
            if (!(fs instanceof ArchiveFileSystem) || fs instanceof Disposable) continue;
            try {
                ((ArchiveFileSystem)fs).clearArchiveCache(root);
            }
            catch (Exception e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(ArchiveCachesCleaner.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error((Throwable)e);
            }
        }
    }
}

