/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.ThrottledLogger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.ChildInfoImpl;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.FileDeletedException;
import com.intellij.openapi.vfs.newvfs.impl.FileLoadingTracker;
import com.intellij.openapi.vfs.newvfs.impl.UserDataInterner;
import com.intellij.openapi.vfs.newvfs.impl.VfsData;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecordsImpl;
import com.intellij.openapi.vfs.newvfs.persistent.ListResult;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSRecordAccessor;
import com.intellij.psi.impl.PsiCachedValue;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.keyFMap.KeyFMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public class VirtualDirectoryImpl
extends VirtualFileSystemEntry {
    private static final Logger LOG = Logger.getInstance(VirtualDirectoryImpl.class);
    private static final ThrottledLogger THROTTLED_LOG = new ThrottledLogger(LOG, TimeUnit.SECONDS.toMillis(30L));
    private static final boolean CHECK_CONSISTENCY = ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManagerEx.isInStressTest();
    private static final int LINEAR_SEARCH_THRESHOLD = SystemProperties.getIntProperty((String)"VirtualDirectoryImpl.LINEAR_SEARCH_THRESHOLD", (int)64);
    private static final boolean TRUST_FIND_CHILD_BY_ID_CALLERS = SystemProperties.getBooleanProperty((String)"VirtualDirectoryImpl.TRUST_FIND_CHILD_BY_ID_CALLERS", (boolean)false);
    public final VfsData.DirectoryData directoryData;
    private final NewVirtualFileSystem fileSystem;

    @VisibleForTesting
    @ApiStatus.Internal
    public VirtualDirectoryImpl(int id2, @NotNull VfsData.Segment segment, @NotNull VfsData.DirectoryData directoryData, @Nullable VirtualDirectoryImpl parent, @NotNull NewVirtualFileSystem fileSystem) {
        if (segment == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(0);
        }
        if (directoryData == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(1);
        }
        if (fileSystem == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(2);
        }
        super(id2, segment, parent);
        this.directoryData = directoryData;
        this.fileSystem = fileSystem;
        if (parent != null) {
            this.registerLink((VirtualFileSystem)fileSystem);
        }
    }

    public boolean isDirectory() {
        return true;
    }

    @NotNull
    public NewVirtualFileSystem getFileSystem() {
        NewVirtualFileSystem newVirtualFileSystem = this.fileSystem;
        if (newVirtualFileSystem == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(3);
        }
        return newVirtualFileSystem;
    }

    @Nullable
    private VirtualFileSystemEntry findChild(@NotNull String name2, boolean doRefresh, boolean ensureCanonicalName) {
        if (name2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(4);
        }
        this.owningPersistentFS().incrementFindChildByNameCount();
        this.updateCaseSensitivityIfUnknown(name2);
        VirtualFileSystemEntry child = this.findChildImpl(name2, ensureCanonicalName, this.isCaseSensitive());
        if (child == NULL_VIRTUAL_FILE) {
            child = doRefresh ? this.createChildAndFireCreationEvent(name2) : null;
        } else if (child != null && doRefresh && this.fileSystem.isDirectory((VirtualFile)child) != child.isDirectory()) {
            RefreshQueue.getInstance().refresh(false, false, null, new VirtualFile[]{child});
            child = this.findChild(name2, false, ensureCanonicalName);
        }
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private VirtualFileSystemEntry findInCachedChildren(@NotNull String childName, boolean isCaseSensitive) {
        int childId;
        if (childName == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(5);
        }
        if (this.directoryData.isAdoptedName(childName)) {
            return NULL_VIRTUAL_FILE;
        }
        VfsData.ChildrenIds sortedChildren = this.ensureChildrenSorted(isCaseSensitive);
        int indexByName = this.findIndexByName(sortedChildren, childName, isCaseSensitive);
        if (indexByName < 0) {
            return null;
        }
        VfsData vfsData = this.getVfsData();
        VirtualFileSystemEntry entry = vfsData.cachedFileById(childId = sortedChildren.id(indexByName), this);
        if (entry == null) {
            VfsData.DirectoryData directoryData = this.directoryData;
            synchronized (directoryData) {
                return this.getCachedOrLoadChild(childId, vfsData);
            }
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VfsData.ChildrenIds ensureChildrenSorted(boolean isCaseSensitive) {
        VfsData.ChildrenIds children2 = this.directoryData.children;
        if (children2.isSorted()) {
            return children2;
        }
        VfsData.DirectoryData directoryData = this.directoryData;
        synchronized (directoryData) {
            children2 = this.directoryData.children;
            if (children2.isSorted()) {
                return children2;
            }
            return this.sortChildrenByName(children2, isCaseSensitive);
        }
    }

    @Nullable
    private VirtualFileSystemEntry findChildImpl(@NotNull String childName, boolean ensureCanonicalName, boolean isCaseSensitive) {
        if (childName == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(6);
        }
        if (childName.isEmpty()) {
            return null;
        }
        if (!this.isValid()) {
            return this.handleInvalidDirectory(null);
        }
        VirtualFileSystemEntry child = this.findInCachedChildren(childName, isCaseSensitive);
        if (child != null) {
            return child;
        }
        if (ensureCanonicalName) {
            String trimmedName = VirtualDirectoryImpl.deSlash(childName);
            if (trimmedName == null) {
                return null;
            }
            if (!trimmedName.equals(childName)) {
                child = this.findInCachedChildren(trimmedName, isCaseSensitive);
                if (child != null) {
                    return child;
                }
                childName = trimmedName;
            }
        }
        if (this.allChildrenLoaded()) {
            return NULL_VIRTUAL_FILE;
        }
        return this.findInPersistence(childName, ensureCanonicalName, isCaseSensitive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private VirtualFileSystemEntry findInPersistence(@NotNull String name2, boolean ensureCanonicalName, boolean isCaseSensitive) {
        VirtualFileSystemEntry newlyLoadedChild;
        if (name2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(7);
        }
        VfsData.DirectoryData directoryData = this.directoryData;
        synchronized (directoryData) {
            CharSequence persistedName;
            VirtualFileSystemEntry existingChild = this.findInCachedChildren(name2, isCaseSensitive);
            if (existingChild != null) {
                return existingChild;
            }
            if (this.allChildrenLoaded()) {
                return null;
            }
            VfsData vfsData = this.getVfsData();
            PersistentFSImpl pFS = vfsData.owningPersistentFS();
            ChildInfo childInfo = pFS.findChildInfo((VirtualFile)this, name2, this.fileSystem);
            if (childInfo == null) {
                this.directoryData.addAdoptedName(name2, isCaseSensitive);
                return null;
            }
            if (ensureCanonicalName && !Comparing.equal((CharSequence)name2, (CharSequence)(persistedName = childInfo.getName())) && (existingChild = this.findInCachedChildren(persistedName.toString(), isCaseSensitive)) != null) {
                return existingChild;
            }
            int childId = childInfo.getId();
            int childNameId = childInfo.getNameId();
            VirtualFileSystemEntry childById = vfsData.cachedFileById(childId, this);
            if (childById != null) {
                int indexOfChild = this.directoryData.children.indexOfId(childId);
                if (indexOfChild >= 0) {
                    if (ensureCanonicalName) {
                        this.logChildLookupFailure(pFS, childId, childNameId, name2);
                    }
                } else {
                    this.addChild(childById);
                }
                return childById;
            }
            if (!vfsData.isFileValid(childId)) {
                throw new IllegalStateException("file(=#" + childId + ") is deleted, but still in .children list");
            }
            newlyLoadedChild = this.getCachedOrLoadChild(childId, vfsData);
            this.addChild(newlyLoadedChild);
        }
        if (!newlyLoadedChild.isDirectory()) {
            VfsRootAccess.assertAccessInTests((VirtualFile)newlyLoadedChild, this.getFileSystem());
        }
        return newlyLoadedChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void setCaseSensitivityFlag(boolean newIsCaseSensitive) {
        FileAttributes.CaseSensitivity oldCaseSensitivity = this.getChildrenCaseSensitivity();
        if (oldCaseSensitivity.isUnknown() || oldCaseSensitivity.isSensitive() != newIsCaseSensitive) {
            VfsData vfsData = this.getVfsData();
            VfsData.Segment segment = vfsData.segmentForFileId(this.getId(), false);
            int newFlags = 0x8000000 | (newIsCaseSensitive ? Integer.MIN_VALUE : 0);
            segment.setFlags(this.getId(), -2013265920, newFlags);
            this.resortChildren();
            VfsData.DirectoryData directoryData = this.directoryData;
            synchronized (directoryData) {
                List<String> adoptedNames = this.directoryData.getAdoptedNames();
                this.directoryData.clearAdoptedNames();
                this.directoryData.addAdoptedNames(adoptedNames, newIsCaseSensitive);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @ApiStatus.Internal
    @NotNull
    public VirtualFileSystemEntry initializeChildDataIfNotYet(int fileId, int nameId, @PersistentFS.Attributes int attributes, boolean isEmptyDirectory) {
        VfsData.DirectoryData directoryData = this.directoryData;
        // MONITORENTER : directoryData
        VirtualFileSystemEntry entry = this.getVfsData().cachedFileById(fileId, this);
        if (entry != null) {
            VirtualFileSystemEntry virtualFileSystemEntry = entry;
            // MONITOREXIT : directoryData
            if (virtualFileSystemEntry != null) return virtualFileSystemEntry;
            VirtualDirectoryImpl.$$$reportNull$$$0(8);
            return virtualFileSystemEntry;
        }
        VirtualFileSystemEntry virtualFileSystemEntry = this.initializeChildData(fileId, nameId, attributes, isEmptyDirectory);
        // MONITOREXIT : directoryData
        if (virtualFileSystemEntry != null) return virtualFileSystemEntry;
        VirtualDirectoryImpl.$$$reportNull$$$0(9);
        return virtualFileSystemEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private VirtualFileSystemEntry initializeChildData(int childId, int nameId, @PersistentFS.Attributes int attributes, boolean isEmptyDirectory) {
        VirtualFileSystemEntry childEntry;
        if (PersistentFSRecordAccessor.hasDeletedFlag(attributes)) {
            throw new FileDeletedException(childId, "{nameId: " + nameId + ", attributes: " + attributes + "} is deleted -- can't load deleted file records");
        }
        FileLoadingTracker.fileLoaded(this, nameId);
        VfsData vfsData = this.getVfsData();
        VfsData.Segment segment = vfsData.segmentForFileId(childId, true);
        boolean isDirectory = PersistentFS.isDirectory(attributes);
        segment.setFlags(childId, -16777216, VirtualFileSystemEntry.VfsDataFlags.toFlags(attributes, isDirectory));
        if (isDirectory) {
            VfsData.DirectoryData childDirectoryData = new VfsData.DirectoryData();
            VirtualDirectoryImpl childDirectory = new VirtualDirectoryImpl(childId, segment, childDirectoryData, this, this.fileSystem);
            childDirectoryData.assignDirectory(childDirectory);
            if (isEmptyDirectory) {
                VfsData.DirectoryData directoryData = childDirectoryData;
                synchronized (directoryData) {
                    childDirectoryData.children = childDirectoryData.children.withAllChildrenLoaded(true);
                }
            }
            segment.initFileData(childId, childDirectoryData, this);
            childEntry = childDirectory;
        } else {
            segment.initFileData(childId, KeyFMap.EMPTY_MAP, this);
            childEntry = new VirtualFileImpl(childId, segment, this);
        }
        childEntry.updateLinkStatus(this);
        if (this.fileSystem.markNewFilesAsDirty()) {
            childEntry.markDirty();
        }
        VirtualFileImpl virtualFileImpl = childEntry;
        if (virtualFileImpl == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(10);
        }
        return virtualFileImpl;
    }

    @Nullable
    private VirtualFileSystemEntry createChildAndFireCreationEvent(@NotNull String childName) {
        FakeVirtualFile fake;
        FileAttributes attributes;
        if (childName == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(11);
        }
        if ((attributes = this.fileSystem.getAttributes((VirtualFile)(fake = new FakeVirtualFile((VirtualFile)this, childName)))) == null) {
            return null;
        }
        String canonicallyCasedName = this.fileSystem.getCanonicallyCasedName((VirtualFile)fake);
        boolean isDirectory = attributes.isDirectory();
        boolean isEmptyDirectory = isDirectory && !this.fileSystem.hasChildren((VirtualFile)fake);
        String symlinkTarget = attributes.isSymLink() ? this.fileSystem.resolveSymLink((VirtualFile)fake) : null;
        ChildInfo[] children2 = isEmptyDirectory ? ChildInfo.EMPTY_ARRAY : null;
        VFileCreateEvent event = new VFileCreateEvent(VFileEvent.REFRESH_REQUESTOR, (VirtualFile)this, canonicallyCasedName, isDirectory, attributes, symlinkTarget, children2);
        RefreshQueue.getInstance().processEvents(false, List.of(event));
        VirtualFileSystemEntry child = this.findChild(canonicallyCasedName);
        if (child == null) {
            LOG.warn(String.valueOf((Object)this) + "/[" + childName + "|" + canonicallyCasedName + "]: exists (attributes: " + String.valueOf(attributes) + "), but somehow still absent after refresh (adopted: " + String.valueOf(this.directoryData.getAdoptedNames()) + ")");
        }
        return child;
    }

    private void updateCaseSensitivityIfUnknown(@NotNull String childName) {
        PersistentFSImpl pFS;
        VFilePropertyChangeEvent caseSensitivityEvent;
        if (childName == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(12);
        }
        if ((caseSensitivityEvent = (pFS = this.owningPersistentFS()).determineCaseSensitivityAndPrepareUpdate((VirtualFile)this, childName)) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(".updateCaseSensitivityIfUnknown(): " + String.valueOf(caseSensitivityEvent));
            }
            pFS.executeChangeCaseSensitivity(this, ((FileAttributes.CaseSensitivity)caseSensitivityEvent.getNewValue()).toBooleanOrFail());
            RefreshQueue.getInstance().processEvents(true, List.of(caseSensitivityEvent));
        } else if (!this.isChildrenCaseSensitivityKnown()) {
            boolean defaultCaseSensitivity = this.fileSystem.isCaseSensitive();
            if (LOG.isDebugEnabled()) {
                LOG.debug(".updateCaseSensitivityIfUnknown(): set default " + defaultCaseSensitivity);
            }
            this.setCaseSensitivityFlag(defaultCaseSensitivity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resortChildren() {
        VfsData.DirectoryData directoryData = this.directoryData;
        synchronized (directoryData) {
            boolean isCaseSensitive = this.isCaseSensitive();
            VfsData.ChildrenIds sortedChildren = this.sortChildrenByName(this.directoryData.children, isCaseSensitive);
            this.assertConsistency(isCaseSensitive, sortedChildren, "afterCaseSensitivityChanged", isCaseSensitive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private VfsData.ChildrenIds sortChildrenByName(@NotNull VfsData.ChildrenIds children2, boolean isCaseSensitive) {
        VfsData.ChildrenIds sortedChildren;
        if (children2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(13);
        }
        VfsData vfsData = this.getVfsData();
        VfsData.DirectoryData directoryData = this.directoryData;
        // MONITORENTER : directoryData
        Comparator byName = (f1, f2) -> VirtualDirectoryImpl.compareNames(f1.getName(), f2.getName(), isCaseSensitive);
        this.directoryData.children = sortedChildren = children2.sorted(id2 -> this.getCachedOrLoadChild(id2, vfsData), byName);
        VfsData.ChildrenIds childrenIds = sortedChildren;
        // MONITOREXIT : directoryData
        if (childrenIds != null) return childrenIds;
        VirtualDirectoryImpl.$$$reportNull$$$0(14);
        return childrenIds;
    }

    @Nullable
    public NewVirtualFile refreshAndFindChild(@NotNull String name2) {
        if (name2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(15);
        }
        return this.findChild(name2, true, true);
    }

    @Nullable
    public NewVirtualFile findChildIfCached(@NotNull String name2) {
        VirtualFileSystemEntry found;
        if (name2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(16);
        }
        return (found = this.findInCachedChildren(name2, this.isCaseSensitive())) == NULL_VIRTUAL_FILE ? null : found;
    }

    @NotNull
    public @Unmodifiable Iterable<VirtualFile> iterInDbChildren() {
        PersistentFSImpl pFS = this.owningPersistentFS();
        if (!pFS.wereChildrenAccessed((VirtualFile)this)) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                VirtualDirectoryImpl.$$$reportNull$$$0(17);
            }
            return list2;
        }
        if (pFS.areChildrenLoaded((VirtualFile)this)) {
            List<VirtualFile> list3 = Arrays.asList(this.getChildren());
            if (list3 == null) {
                VirtualDirectoryImpl.$$$reportNull$$$0(18);
            }
            return list3;
        }
        this.loadAllPersistedChildren();
        Collection collection = this.getCachedChildren();
        if (collection == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(19);
        }
        return collection;
    }

    @NotNull
    public @Unmodifiable Iterable<VirtualFile> iterInDbChildrenWithoutLoadingVfsFromOtherProjects() {
        PersistentFSImpl pFS = this.owningPersistentFS();
        if (!pFS.wereChildrenAccessed((VirtualFile)this)) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                VirtualDirectoryImpl.$$$reportNull$$$0(20);
            }
            return list2;
        }
        if (!pFS.areChildrenLoaded((VirtualFile)this)) {
            this.loadAllPersistedChildren();
        }
        Collection collection = this.getCachedChildren();
        if (collection == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(21);
        }
        return collection;
    }

    private void loadAllPersistedChildren() {
        ListResult childrenInPersistence = this.owningPersistentFS().peer().list(this.getId());
        for (ChildInfo childInfo : childrenInPersistence.children) {
            this.findChildById(childInfo.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private VirtualFile @NotNull [] loadAllChildren(boolean sortChildrenOnLoading) {
        boolean reallyNeedsSorting;
        VfsData vfsData = this.getVfsData();
        PersistentFSImpl pFS = vfsData.owningPersistentFS();
        pFS.listAll((VirtualFile)this);
        VfsData.DirectoryData directoryData = this.directoryData;
        // MONITORENTER : directoryData
        List childrenInfo = pFS.listAll((VirtualFile)this);
        if (childrenInfo.isEmpty()) {
            this.directoryData.clearAdoptedNames();
            this.directoryData.children = VfsData.ChildrenIds.EMPTY.withAllChildrenLoaded(true);
            // MONITOREXIT : directoryData
            if (VirtualFile.EMPTY_ARRAY != null) return VirtualFile.EMPTY_ARRAY;
            VirtualDirectoryImpl.$$$reportNull$$$0(22);
            return VirtualFile.EMPTY_ARRAY;
        }
        boolean bl = reallyNeedsSorting = sortChildrenOnLoading && childrenInfo.size() > 1;
        if (reallyNeedsSorting) {
            String someChildName = childrenInfo.get(0).getName().toString();
            this.updateCaseSensitivityIfUnknown(someChildName);
        }
        boolean isCaseSensitive = this.isCaseSensitive();
        if (reallyNeedsSorting) {
            IntRef errorCount = new IntRef(0);
            List _childrenInfo = childrenInfo;
            childrenInfo = ContainerUtil.sorted(childrenInfo, (info1, info2) -> {
                CharSequence name2;
                CharSequence name1 = info1.getName();
                int cmp = VirtualDirectoryImpl.compareNames(name1, name2 = info2.getName(), isCaseSensitive);
                if (cmp == 0 && name1 != name2) {
                    if (errorCount.get() == 0) {
                        boolean wasChildrenLoaded = pFS.areChildrenLoaded((VirtualFile)this);
                        THROTTLED_LOG.error(String.valueOf((Object)this.owningPersistentFS()) + " returned duplicate file names('" + String.valueOf(name1) + "', '" + String.valueOf(name2) + "') caseSensitive: " + isCaseSensitive + " SystemInfo.isFileSystemCaseSensitive: " + SystemInfo.isFileSystemCaseSensitive + " SystemInfo.OS: " + SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION + " wasChildrenLoaded: " + wasChildrenLoaded + " in the dir: " + String.valueOf((Object)this) + "; " + _childrenInfo.size() + " children: " + StringUtil.first((String)_childrenInfo.toString(), (int)300, (boolean)true));
                    }
                    errorCount.inc();
                    if (!isCaseSensitive) {
                        cmp = VirtualDirectoryImpl.compareNames(name1, name2, true);
                    }
                }
                return cmp;
            });
        }
        IntOpenHashSet prevChildren = this.directoryData.children.toIntSet();
        VirtualFile[] newChildren = new VirtualFile[childrenInfo.size()];
        int[] newChildrenIds = new int[newChildren.length];
        for (int i2 = 0; i2 < newChildren.length; ++i2) {
            int childId;
            ChildInfo childInfo = (ChildInfo)childrenInfo.get(i2);
            newChildrenIds[i2] = childId = childInfo.getId();
            prevChildren.remove(childId);
            if (!vfsData.isFileValid(childId)) {
                throw new IllegalStateException("file[" + i2 + "](=#" + childId + ") is deleted, but still in .children list");
            }
            VirtualFileSystemEntry child = this.getCachedOrLoadChild(childId, vfsData);
            newChildren[i2] = child;
        }
        if (!prevChildren.isEmpty()) {
            this.logDisappearedChildren(vfsData, (IntSet)prevChildren, newChildren, childrenInfo);
        }
        this.directoryData.clearAdoptedNames();
        this.directoryData.children = new VfsData.ChildrenIds(newChildrenIds, sortChildrenOnLoading, true);
        this.assertConsistency(isCaseSensitive, childrenInfo);
        // MONITOREXIT : directoryData
        if (newChildren != null) return newChildren;
        VirtualDirectoryImpl.$$$reportNull$$$0(23);
        return newChildren;
    }

    public VirtualFile @NotNull [] getChildren() {
        VirtualFile[] virtualFileArray = this.getChildren(true);
        if (virtualFileArray == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(24);
        }
        return virtualFileArray;
    }

    @ApiStatus.Internal
    public VirtualFile @NotNull [] getChildren(boolean requireSorting) {
        if (!this.isValid()) {
            VirtualFile[] virtualFileArray = (VirtualFile[])this.handleInvalidDirectory(EMPTY_ARRAY);
            if (virtualFileArray == null) {
                VirtualDirectoryImpl.$$$reportNull$$$0(25);
            }
            return virtualFileArray;
        }
        if (this.allChildrenLoaded()) {
            if (requireSorting && !this.directoryData.children.isSorted()) {
                this.ensureChildrenSorted(this.isCaseSensitive());
            }
            return this.cachedChildren();
        }
        return this.loadAllChildren(requireSorting);
    }

    @Nullable
    public VirtualFileSystemEntry findChild(@NotNull String name2) {
        if (name2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(26);
        }
        return this.findChild(name2, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @Nullable
    public VirtualFileSystemEntry findChildById(int childId) {
        if (childId == this.getId()) {
            throw new IllegalArgumentException("Trying to find childId(=" + childId + ") in parent(=" + this.getId() + ")");
        }
        VfsData vfsData = this.getVfsData();
        PersistentFSImpl pFS = vfsData.owningPersistentFS();
        VirtualFileSystemEntry child = vfsData.cachedFileById(childId, this);
        if (child != null && !child.isValid()) {
            return null;
        }
        VfsData.DirectoryData directoryData = this.directoryData;
        synchronized (directoryData) {
            if (child == null) {
                if (!vfsData.isFileValid(childId)) {
                    return null;
                }
                child = this.getCachedOrLoadChild(childId, vfsData);
            }
            VfsData.ChildrenIds children2 = this.directoryData.children;
            boolean allChildrenLoaded = children2.areAllChildrenLoaded();
            Boolean wasInPersistentChildren = null;
            if (children2.isSorted() && VirtualDirectoryImpl.worthBinarySearch(children2)) {
                String childName = child.getName();
                this.updateCaseSensitivityIfUnknown(childName);
                boolean isCaseSensitive = this.isCaseSensitive();
                int indexOfName = this.findIndexByName(children2, childName, isCaseSensitive);
                if (indexOfName >= 0) {
                    return child;
                }
                if (!allChildrenLoaded && (TRUST_FIND_CHILD_BY_ID_CALLERS || (wasInPersistentChildren = Boolean.valueOf(VirtualDirectoryImpl.isInPersistentChildren(pFS, this.getId(), childId))).booleanValue())) {
                    int insertionIndex = -indexOfName - 1;
                    this.directoryData.children = children2.insertAt(insertionIndex, childId);
                    return child;
                }
            } else {
                int indexOfId = children2.indexOfId(childId);
                if (indexOfId >= 0) {
                    return child;
                }
                if (!allChildrenLoaded && (TRUST_FIND_CHILD_BY_ID_CALLERS || (wasInPersistentChildren = Boolean.valueOf(VirtualDirectoryImpl.isInPersistentChildren(pFS, this.getId(), childId))).booleanValue())) {
                    this.directoryData.children = children2.appendId(childId);
                    return child;
                }
            }
            if (Boolean.FALSE.equals(wasInPersistentChildren)) {
                for (int i2 = 0; i2 < 3; ++i2) {
                    try {
                        this.directoryData.wait(0L, 1);
                    }
                    catch (InterruptedException isCaseSensitive) {
                        // empty catch block
                    }
                    boolean isInPersistentChildren = VirtualDirectoryImpl.isInPersistentChildren(pFS, this.getId(), childId);
                    if (!isInPersistentChildren) continue;
                    return this.findChildById(childId);
                }
            }
            boolean isInPersistentChildren = VirtualDirectoryImpl.isInPersistentChildren(pFS, this.getId(), childId);
            int parentId = pFS.peer().getParent(childId);
            VirtualDirectoryImpl parent = child.getParent();
            LOG.error("[" + String.valueOf((Object)child) + ", id: " + child.getId() + ", parentId: " + parentId + ", parent.id: " + parent.getId() + "] expected to be in [" + String.valueOf((Object)this) + ", id: " + this.getId() + ", this == parent?: " + (this == parent) + "].children=" + String.valueOf(children2) + " -- but absent. childId in persistent children: " + isInPersistentChildren + ", was in persistent children: " + wasInPersistentChildren + " -> refresh race or VFS inconsistency?");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @Contract(mutates="this,param1")
    public void initializeAndAddChildren(@NotNull List<ChildInfo> added, boolean markAllChildrenLoaded, @NotNull BiConsumer<? super VirtualFile, ? super ChildInfo> callback) {
        int addedSize;
        if (added == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(27);
        }
        if (callback == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(28);
        }
        if ((addedSize = added.size()) <= 1) {
            VfsData.DirectoryData directoryData = this.directoryData;
            synchronized (directoryData) {
                for (int i2 = 0; i2 < addedSize; ++i2) {
                    ChildInfo info = added.get(i2);
                    assert (info.getId() > 0) : info;
                    @PersistentFS.Attributes int attributes = info.getFileAttributeFlags();
                    boolean isEmptyDirectory = info.getChildren() != null && info.getChildren().length == 0;
                    int indexOfId = this.directoryData.children.indexOfId(info.getId());
                    if (indexOfId >= 0) continue;
                    VirtualFileSystemEntry child = this.initializeChildData(info.getId(), info.getNameId(), attributes, isEmptyDirectory);
                    this.addChild(child);
                    callback.accept((VirtualFile)child, (ChildInfo)info);
                }
                if (markAllChildrenLoaded) {
                    this.directoryData.children = this.directoryData.children.withAllChildrenLoaded(true);
                }
                return;
            }
        }
        boolean isCaseSensitive = this.isCaseSensitive();
        Comparator byName = (p1, p2) -> VirtualDirectoryImpl.compareNames(p1.getName(), p2.getName(), isCaseSensitive);
        added.sort(byName);
        final FSRecordsImpl vfsPeer = this.owningPersistentFS().peer();
        VfsData.DirectoryData directoryData = this.directoryData;
        synchronized (directoryData) {
            final VfsData.ChildrenIds oldChildren = this.ensureChildrenSorted(isCaseSensitive);
            IntArrayList mergedIds = new IntArrayList(oldChildren.size() + addedSize);
            AbstractList<ChildInfo> existingChildren = new AbstractList<ChildInfo>(this){

                @Override
                public ChildInfo get(int index) {
                    int id2 = oldChildren.id(index);
                    assert (id2 > 0) : id2;
                    int nameId = vfsPeer.getNameIdByFileId(id2);
                    return new ChildInfoImpl(id2, nameId, null, null, null);
                }

                @Override
                public int size() {
                    return oldChildren.size();
                }
            };
            ContainerUtil.processSortedListsInOrder((List)existingChildren, added, (Comparator)byName, (boolean)true, (arg_0, arg_1) -> this.lambda$initializeAndAddChildren$4(callback, (IntList)mergedIds, arg_0, arg_1));
            this.directoryData.children = markAllChildrenLoaded ? oldChildren.withIds(mergedIds.toIntArray()).withAllChildrenLoaded(true) : oldChildren.withIds(mergedIds.toIntArray());
            this.assertConsistency(isCaseSensitive, added);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(@NotNull VirtualFileSystemEntry child) {
        int childId;
        if (child == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(29);
        }
        if ((childId = child.getId()) == this.getId()) {
            throw new IllegalArgumentException("Trying to add child(=" + String.valueOf((Object)child) + ") to itself (parent=" + String.valueOf((Object)this) + ")");
        }
        String childName = child.getName();
        VfsData.DirectoryData directoryData = this.directoryData;
        synchronized (directoryData) {
            this.directoryData.removeAdoptedName(childName);
            VfsData.ChildrenIds children2 = this.directoryData.children;
            if (children2.isSorted() && VirtualDirectoryImpl.worthBinarySearch(children2)) {
                this.updateCaseSensitivityIfUnknown(childName);
                boolean isCaseSensitive = this.isCaseSensitive();
                int childIndex = this.findIndexByName(children2, childName, isCaseSensitive);
                if (childIndex < 0) {
                    int insertionIndex = -childIndex - 1;
                    this.directoryData.children = children2.insertAt(insertionIndex, childId);
                    this.assertConsistency(isCaseSensitive, new Object[]{child, "insertionIndex", insertionIndex});
                }
            } else {
                int childIndex = children2.indexOfId(childId);
                if (childIndex < 0) {
                    this.directoryData.children = children2.appendId(childId);
                    boolean isCaseSensitive = this.isCaseSensitive();
                    this.assertConsistency(isCaseSensitive, new Object[]{child});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(@NotNull VirtualFileSystemEntry child) {
        if (child == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(30);
        }
        boolean isCaseSensitive = this.isCaseSensitive();
        String name2 = child.getName();
        int childId = child.getId();
        VfsData.DirectoryData directoryData = this.directoryData;
        synchronized (directoryData) {
            VfsData.ChildrenIds children2 = this.directoryData.children;
            int childIndex = children2.isSorted() && VirtualDirectoryImpl.worthBinarySearch(children2) ? this.findIndexByName(children2, name2, isCaseSensitive) : children2.indexOfId(childId);
            if (childIndex >= 0) {
                this.directoryData.children = children2.removeAt(childIndex);
            }
            if (!this.allChildrenLoaded()) {
                this.directoryData.addAdoptedName(name2, isCaseSensitive);
            }
            this.assertConsistency(isCaseSensitive, new Object[]{child});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildren(@NotNull IntSet idsToRemove, @NotNull List<? extends CharSequence> namesToRemove) {
        if (idsToRemove == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(31);
        }
        if (namesToRemove == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(32);
        }
        boolean isCaseSensitive = this.isCaseSensitive();
        VfsData.DirectoryData directoryData = this.directoryData;
        synchronized (directoryData) {
            this.directoryData.children = this.directoryData.children.removeIds(idsToRemove);
            if (!this.allChildrenLoaded()) {
                this.directoryData.addAdoptedNames(namesToRemove, isCaseSensitive);
            }
            this.assertConsistency(isCaseSensitive, namesToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void validateChildrenToCreate(@NotNull Collection<VFileCreateEvent> childrenToCreate) {
        if (childrenToCreate == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(33);
        }
        if (childrenToCreate.size() <= 1) {
            childrenToCreate.removeIf(event -> !event.isValid());
            return;
        }
        boolean isCaseSensitive = this.isCaseSensitive();
        VfsData vfsData = this.getVfsData();
        FSRecordsImpl peer = vfsData.owningPersistentFS().peer();
        Set existingNames = CollectionFactory.createCharSequenceSet((boolean)isCaseSensitive, (int)this.directoryData.children.size());
        VfsData.DirectoryData directoryData = this.directoryData;
        synchronized (directoryData) {
            VfsData.ChildrenIds children2 = this.directoryData.children;
            for (int i2 = 0; i2 < children2.size(); ++i2) {
                int id2 = children2.id(i2);
                existingNames.add(vfsData.getNameByFileId(id2));
            }
            int parentId = this.getId();
            existingNames.addAll(ContainerUtil.map(peer.list((int)parentId).children, ChildInfo::getName));
            this.validateAgainst(childrenToCreate, existingNames);
            if (!childrenToCreate.isEmpty() && !this.allChildrenLoaded()) {
                int beforeSize = existingNames.size();
                String[] names = this.fileSystem.list((VirtualFile)this);
                existingNames.addAll(Arrays.asList(names));
                if (beforeSize != existingNames.size()) {
                    this.validateAgainst(childrenToCreate, existingNames);
                }
            }
        }
    }

    private void validateAgainst(@NotNull Collection<VFileCreateEvent> childrenToCreate, @NotNull Set<? extends CharSequence> existingNames) {
        if (childrenToCreate == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(34);
        }
        if (existingNames == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(35);
        }
        childrenToCreate.removeIf(event -> {
            String childName = event.getChildName();
            return !this.directoryData.isAdoptedName(childName) && existingNames.contains(childName);
        });
    }

    public boolean allChildrenLoaded() {
        return this.directoryData.children.areAllChildrenLoaded();
    }

    public @Unmodifiable @NotNull List<String> getSuspiciousNames() {
        List<String> list2 = this.directoryData.getAdoptedNames();
        if (list2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(36);
        }
        return list2;
    }

    private int findIndexByName(@NotNull VfsData.ChildrenIds children2, @NotNull CharSequence name3, boolean isCaseSensitive) {
        if (children2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(37);
        }
        if (name3 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(38);
        }
        if (!children2.isSorted()) {
            throw new IllegalStateException("children is not sorted -- can't find index by name");
        }
        FSRecordsImpl peer = this.owningPersistentFS().peer();
        return children2.findIndexByName(name3, (name1, name2) -> VirtualDirectoryImpl.compareNames(name1, name2, isCaseSensitive), id2 -> peer.getName(id2));
    }

    @NotNull
    public @Unmodifiable List<VirtualFile> getCachedChildren() {
        List<VirtualFileSystemEntry> list2 = Arrays.asList(this.cachedChildren());
        if (list2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(39);
        }
        return list2;
    }

    public byte @NotNull [] contentsToByteArray() throws IOException {
        throw new IOException("Cannot get content of directory: " + String.valueOf((Object)this));
    }

    @NotNull
    public InputStream getInputStream() throws IOException {
        throw new IOException("getInputStream() must not be called against a directory: " + this.getUrl());
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new IOException("getOutputStream() must not be called against a directory: " + this.getUrl());
    }

    @Override
    public void markDirtyRecursively() {
        this.markDirty();
        this.markDirtyRecursivelyInternal();
    }

    private void markDirtyRecursivelyInternal() {
        for (VirtualFileSystemEntry child : this.cachedChildren()) {
            child.markDirtyInternal();
            if (!(child instanceof VirtualDirectoryImpl)) continue;
            VirtualDirectoryImpl childDir = (VirtualDirectoryImpl)child;
            if (child.isRecursiveOrCircularSymlink()) continue;
            childDir.markDirtyRecursivelyInternal();
        }
    }

    protected void setUserMap(@NotNull KeyFMap map2) {
        if (map2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(40);
        }
        this.directoryData.userMap = map2;
    }

    @ApiStatus.Internal
    @NotNull
    public KeyFMap getUserMap() {
        KeyFMap keyFMap = this.directoryData.userMap;
        if (keyFMap == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(41);
        }
        return keyFMap;
    }

    protected boolean changeUserMap(@NotNull KeyFMap oldMap, @NotNull KeyFMap newMap) {
        if (oldMap == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(42);
        }
        if (newMap == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(43);
        }
        VirtualDirectoryImpl.checkLeaks(newMap);
        return this.directoryData.changeUserMap(oldMap, UserDataInterner.internUserData(newMap));
    }

    public boolean isCaseSensitive() {
        return this.isChildrenCaseSensitivityKnown() ? this.getFlagInt(Integer.MIN_VALUE) : super.isCaseSensitive();
    }

    private boolean isChildrenCaseSensitivityKnown() {
        return this.getFlagInt(0x8000000);
    }

    @ApiStatus.Internal
    @NotNull
    public FileAttributes.CaseSensitivity getChildrenCaseSensitivity() {
        FileAttributes.CaseSensitivity caseSensitivity = this.isChildrenCaseSensitivityKnown() ? FileAttributes.CaseSensitivity.fromBoolean((boolean)this.isCaseSensitive()) : FileAttributes.CaseSensitivity.UNKNOWN;
        if (caseSensitivity == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(44);
        }
        return caseSensitivity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private VirtualFileSystemEntry @NotNull [] cachedChildren() {
        VfsData vfsData = this.getVfsData();
        VfsData.DirectoryData directoryData = this.directoryData;
        // MONITORENTER : directoryData
        VirtualFileSystemEntry[] virtualFileSystemEntryArray = this.directoryData.children.asFiles(childId -> this.getCachedOrLoadChild(childId, vfsData));
        // MONITOREXIT : directoryData
        if (virtualFileSystemEntryArray != null) return virtualFileSystemEntryArray;
        VirtualDirectoryImpl.$$$reportNull$$$0(45);
        return virtualFileSystemEntryArray;
    }

    private static boolean isInPersistentChildren(@NotNull PersistentFSImpl pFS, int parentId, int childId) {
        if (pFS == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(46);
        }
        return pFS.peer().forEachChildOf(parentId, _childId -> _childId == childId);
    }

    @NotNull
    private VirtualFileSystemEntry getCachedOrLoadChild(int childId, @NotNull VfsData vfsData) {
        VirtualFileSystemEntry cachedChild;
        if (vfsData == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(47);
        }
        if ((cachedChild = vfsData.cachedFileById(childId, this)) != null) {
            VirtualFileSystemEntry virtualFileSystemEntry = cachedChild;
            if (virtualFileSystemEntry == null) {
                VirtualDirectoryImpl.$$$reportNull$$$0(48);
            }
            return virtualFileSystemEntry;
        }
        PersistentFSImpl pFS = vfsData.owningPersistentFS();
        FSRecordsImpl vfsPeer = pFS.peer();
        @PersistentFS.Attributes int childAttributes = pFS.getFileAttributes(childId);
        if (PersistentFSRecordAccessor.hasDeletedFlag(childAttributes)) {
            throw new FileDeletedException(childId, "file is deleted, can't be loaded");
        }
        int childNameId = vfsPeer.getNameIdByFileId(childId);
        boolean isEmptyDirectory = PersistentFS.isDirectory(childAttributes) && !pFS.mayHaveChildren(childId);
        return this.initializeChildData(childId, childNameId, childAttributes, isEmptyDirectory);
    }

    private static String deSlash(@NotNull String name2) {
        if (name2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(49);
        }
        int startTrimmed = -1;
        int endTrimmed = -1;
        for (int i2 = 0; i2 < name2.length(); ++i2) {
            char c = name2.charAt(i2);
            if (startTrimmed == -1) {
                if (VirtualDirectoryImpl.isFileSeparator(c)) continue;
                startTrimmed = i2;
                continue;
            }
            if (endTrimmed == -1) {
                if (!VirtualDirectoryImpl.isFileSeparator(c)) continue;
                endTrimmed = i2;
                continue;
            }
            if (VirtualDirectoryImpl.isFileSeparator(c)) continue;
            return null;
        }
        if (startTrimmed == -1) {
            return null;
        }
        if (endTrimmed == -1) {
            return name2.substring(startTrimmed);
        }
        if (startTrimmed == endTrimmed) {
            return null;
        }
        return name2.substring(startTrimmed, endTrimmed);
    }

    private static boolean isFileSeparator(char c) {
        return c == '/' || c == File.separatorChar;
    }

    private static boolean worthBinarySearch(VfsData.ChildrenIds children2) {
        return children2.size() > LINEAR_SEARCH_THRESHOLD;
    }

    private void logChildLookupFailure(@NotNull PersistentFSImpl pfs, int childId, int childNameId, @NotNull String childName) {
        if (pfs == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(50);
        }
        if (childName == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(51);
        }
        FSRecordsImpl vfsPeer = pfs.peer();
        LOG.warn("Child[#" + childId + ", nameId: " + childNameId + "][name='" + vfsPeer.getNameByNameId(childNameId) + "'] present in a children list [" + String.valueOf(this.directoryData.children) + "],  but can't be found by name[" + childName + "] even though ensureCanonicalName=true");
    }

    private <T> T handleInvalidDirectory(T empty) {
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return empty;
        }
        throw new InvalidVirtualFileAccessException((VirtualFile)this);
    }

    private void error(String message, Object ... details) {
        StringBuilder builder = new StringBuilder().append(message).append("\n--- children ---");
        for (VirtualFileSystemEntry virtualFileSystemEntry : this.cachedChildren()) {
            builder.append('\n').append(VirtualDirectoryImpl.verboseToString(virtualFileSystemEntry));
        }
        builder.append("--- details ---");
        for (Object object : details) {
            builder.append('\n').append(object instanceof Object[] ? Arrays.toString((Object[])object) : object.toString());
        }
        throw new AssertionError((Object)builder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertConsistency(boolean isCaseSensitive, Object ... details) {
        if (details == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(52);
        }
        if (!CHECK_CONSISTENCY || ApplicationManagerEx.isInStressTest()) {
            return;
        }
        VfsData.ChildrenIds children2 = this.directoryData.children;
        if (children2.size() == 0) {
            return;
        }
        boolean sorted = children2.isSorted();
        VfsData vfsData = this.getVfsData();
        String prevName = vfsData.getNameByFileId(children2.id(0));
        for (int i2 = 1; i2 < children2.size(); ++i2) {
            int id2 = children2.id(i2);
            String name2 = vfsData.getNameByFileId(id2);
            if (sorted) {
                int prev = children2.id(i2 - 1);
                int cmp = VirtualDirectoryImpl.compareNames(name2, prevName, isCaseSensitive);
                prevName = name2;
                if (cmp <= 0) {
                    VirtualFileSystemEntry prevFile = vfsData.cachedFileById(prev, this);
                    VirtualFileSystemEntry child = vfsData.cachedFileById(id2, this);
                    String info = "prevFile.isCaseSensitive()=" + String.valueOf(prevFile == null ? "?" : Boolean.valueOf(prevFile.isCaseSensitive())) + ";child.isCaseSensitive()=" + String.valueOf(child == null ? "?" : Boolean.valueOf(child.isCaseSensitive())) + ";this.isCaseSensitive()=" + this.isCaseSensitive();
                    String message = info + " but in " + String.valueOf((Object)this) + " the " + VirtualDirectoryImpl.verboseToString(prevFile) + "\n is wrongly placed before " + VirtualDirectoryImpl.verboseToString(child) + "\n";
                    this.error(message, details);
                }
            }
            VfsData.DirectoryData directoryData = this.directoryData;
            synchronized (directoryData) {
                if (this.directoryData.isAdoptedName(name2)) {
                    List<String> adoptedNames = this.directoryData.getAdoptedNames();
                    this.directoryData.removeAdoptedName(name2);
                    String message = "In " + VirtualDirectoryImpl.verboseToString(this) + " file '" + String.valueOf(name2) + "' is both `child` and `adopted`";
                    this.error(message, "Adopted: " + String.valueOf(adoptedNames) + ";\n ", details);
                }
                continue;
            }
        }
    }

    private static String verboseToString(@Nullable VirtualFileSystemEntry file2) {
        return file2 == null ? "null" : String.valueOf((Object)file2) + " (name: '" + file2.getName() + "', " + String.valueOf(((Object)((Object)file2)).getClass()) + ", parent: " + String.valueOf((Object)file2.getParent()) + ", id: " + file2.getId() + ", FS: " + String.valueOf(file2.getFileSystem()) + ", fs.attrs: " + String.valueOf(file2.getFileSystem().getAttributes((VirtualFile)file2)) + ", file.isCaseSensitive: " + file2.isCaseSensitive() + ", canonicalName: '" + file2.getFileSystem().getCanonicallyCasedName((VirtualFile)file2) + "')";
    }

    private void logDisappearedChildren(@NotNull VfsData vfsData, @NotNull IntSet prevChildren, @NotNull @NotNull VirtualFile @NotNull [] newChildren, @NotNull List<? extends ChildInfo> childrenInfo) {
        if (vfsData == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(53);
        }
        if (prevChildren == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(54);
        }
        if (childrenInfo == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(55);
        }
        if (newChildren == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(56);
        }
        StringBuilder sb = new StringBuilder("Loaded child(ren) disappeared: \nparent: " + VirtualDirectoryImpl.verboseToString(this) + "\nmissed children: ");
        for (int disappearedChildId : prevChildren.toIntArray()) {
            VirtualFileSystemEntry missing = vfsData.cachedFileById(disappearedChildId, this);
            sb.append("\n\t[" + disappearedChildId + "] ").append(VirtualDirectoryImpl.verboseToString(missing));
        }
        sb.append("\nexisting children:");
        for (int existingChild : (Object)newChildren) {
            VirtualFileSystemEntry child = (VirtualFileSystemEntry)existingChild;
            sb.append("\n\t[" + child.getId() + "] ").append(VirtualDirectoryImpl.verboseToString(child));
        }
        sb.append("\nchildren infos:");
        Object object = childrenInfo.iterator();
        while (object.hasNext()) {
            ChildInfo childInfo = (ChildInfo)object.next();
            sb.append("\n\t[" + childInfo.getId() + "] ").append(childInfo);
        }
        LOG.error(sb.toString());
    }

    protected static void checkLeaks(@NotNull KeyFMap newMap) {
        if (newMap == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(57);
        }
        for (Key key : newMap.getKeys()) {
            if (newMap.get(key) instanceof PsiCachedValue) {
                throw new AssertionError((Object)"Don't store CachedValue in VFS user data, since it leads to memory leaks");
            }
        }
    }

    private static int compareNames(@NotNull CharSequence name1, @NotNull CharSequence name2, boolean isCaseSensitive) {
        int d;
        if (name1 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(58);
        }
        if (name2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(59);
        }
        if ((d = name1.length() - name2.length()) != 0) {
            return d;
        }
        for (int i2 = 0; i2 < name1.length(); ++i2) {
            d = StringUtil.compare((char)name1.charAt(i2), (char)name2.charAt(i2), (!isCaseSensitive ? 1 : 0) != 0);
            if (d == 0) continue;
            return d;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T, E extends Throwable> T runUnderAllLocksAcquired(@NotNull ThrowableComputable<T, E> lambda, @NotNull VirtualDirectoryImpl dir1, @NotNull VirtualDirectoryImpl dir2) throws E {
        if (lambda == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(60);
        }
        if (dir1 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(61);
        }
        if (dir2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(62);
        }
        VfsData.DirectoryData lock1 = dir1.directoryData;
        VfsData.DirectoryData lock2 = dir2.directoryData;
        if (System.identityHashCode(lock1) <= System.identityHashCode(lock2)) {
            VfsData.DirectoryData directoryData = lock1;
            synchronized (directoryData) {
                VfsData.DirectoryData directoryData2 = lock2;
                synchronized (directoryData2) {
                    return (T)lambda.compute();
                }
            }
        }
        VfsData.DirectoryData directoryData = lock2;
        synchronized (directoryData) {
            VfsData.DirectoryData directoryData3 = lock1;
            synchronized (directoryData3) {
                return (T)lambda.compute();
            }
        }
    }

    private /* synthetic */ void lambda$initializeAndAddChildren$4(BiConsumer callback, IntList mergedIds, ChildInfo nextInfo, ContainerUtil.MergeResult mergeResult) {
        if (mergeResult == ContainerUtil.MergeResult.COPIED_FROM_LIST2) {
            assert (nextInfo.getId() > 0) : nextInfo;
            @PersistentFS.Attributes int attributes = nextInfo.getFileAttributeFlags();
            boolean isEmptyDirectory = nextInfo.getChildren() != null && nextInfo.getChildren().length == 0;
            this.directoryData.removeAdoptedName(nextInfo.getName());
            VirtualFileSystemEntry child = this.initializeChildData(nextInfo.getId(), nextInfo.getNameId(), attributes, isEmptyDirectory);
            callback.accept(child, nextInfo);
        }
        mergedIds.add(nextInfo.getId());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8, 9, 10, 14, 17, 18, 19, 20, 21, 22, 23, 24, 25, 36, 39, 41, 44, 45, 48 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystem";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 36: 
            case 39: 
            case 41: 
            case 44: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl";
                break;
            }
            case 4: 
            case 7: 
            case 15: 
            case 16: 
            case 26: 
            case 38: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 13: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "added";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idsToRemove";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesToRemove";
                break;
            }
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenToCreate";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingNames";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldMap";
                break;
            }
            case 43: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMap";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pFS";
                break;
            }
            case 47: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfsData";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pfs";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevChildren";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenInfo";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChildren";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name1";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name2";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambda";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir1";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "initializeChildDataIfNotYet";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "initializeChildData";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "sortChildrenByName";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "iterInDbChildren";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "iterInDbChildrenWithoutLoadingVfsFromOtherProjects";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAllChildren";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuspiciousNames";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedChildren";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserMap";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenCaseSensitivity";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "cachedChildren";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedOrLoadChild";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 36: 
            case 39: 
            case 41: 
            case 44: 
            case 45: 
            case 48: {
                break;
            }
            case 4: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findChild";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findInCachedChildren";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findChildImpl";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findInPersistence";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createChildAndFireCreationEvent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateCaseSensitivityIfUnknown";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "sortChildrenByName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindChild";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findChildIfCached";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "initializeAndAddChildren";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "removeChildren";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "validateChildrenToCreate";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "validateAgainst";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findIndexByName";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "setUserMap";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "changeUserMap";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isInPersistentChildren";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getCachedOrLoadChild";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "deSlash";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "logChildLookupFailure";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "assertConsistency";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "logDisappearedChildren";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "checkLeaks";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "compareNames";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "runUnderAllLocksAcquired";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8, 9, 10, 14, 17, 18, 19, 20, 21, 22, 23, 24, 25, 36, 39, 41, 44, 45, 48 -> new IllegalStateException(string);
        };
    }
}

