/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import java.nio.file.Path;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class PersistentFSPaths {
    @NonNls
    private static final String ROOTS_START_PREFIX = "roots_";
    static final String VFS_FILES_EXTENSION = System.getProperty("idea.vfs.files.extension", ".dat");
    @NotNull
    private final Path storagesDir;

    @VisibleForTesting
    public PersistentFSPaths(@NotNull Path storagesDir) {
        if (storagesDir == null) {
            PersistentFSPaths.$$$reportNull$$$0(0);
        }
        this.storagesDir = storagesDir.toAbsolutePath();
    }

    @NotNull
    public Path getCorruptionMarkerFile() {
        Path path = this.storagesDir.resolve("corruption.marker");
        if (path == null) {
            PersistentFSPaths.$$$reportNull$$$0(1);
        }
        return path;
    }

    @NotNull
    public Path getRootsBaseFile() {
        Path path = this.storagesDir.resolve(ROOTS_START_PREFIX);
        if (path == null) {
            PersistentFSPaths.$$$reportNull$$$0(2);
        }
        return path;
    }

    @NotNull
    public Path getRootsStorage(@NotNull String storageName) {
        if (storageName == null) {
            PersistentFSPaths.$$$reportNull$$$0(3);
        }
        Path path = this.storagesDir.resolve(ROOTS_START_PREFIX + storageName + VFS_FILES_EXTENSION);
        if (path == null) {
            PersistentFSPaths.$$$reportNull$$$0(4);
        }
        return path;
    }

    @NotNull
    public Path storagePath(@NotNull String storageName) {
        if (storageName == null) {
            PersistentFSPaths.$$$reportNull$$$0(5);
        }
        Path path = this.storagesDir.resolve(storageName + VFS_FILES_EXTENSION);
        if (path == null) {
            PersistentFSPaths.$$$reportNull$$$0(6);
        }
        return path;
    }

    @NotNull
    public Path storagesSubDir(@NotNull String name2) {
        if (name2 == null) {
            PersistentFSPaths.$$$reportNull$$$0(7);
        }
        Path path = this.storagesDir.resolve(name2);
        if (path == null) {
            PersistentFSPaths.$$$reportNull$$$0(8);
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storagesDir";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSPaths";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSPaths";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCorruptionMarkerFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsBaseFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsStorage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "storagePath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "storagesSubDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRootsStorage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "storagePath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "storagesSubDir";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 6, 8 -> new IllegalStateException(string);
        };
    }
}

