/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.mac.MacMenuSettings;
import com.intellij.ui.mac.MergeAllWindowsAction;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\t\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0015\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0015J\u0012\u0010\u0010\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0015J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0017J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u0012\u0010\u0015\u001a\u00020\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0015J\b\u0010\u0016\u001a\u00020\u0012H\u0014J\u0012\u0010\t\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0002R\u0014\u0010\u0004\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/wm/impl/CloseProjectWindowHelper;", "", "<init>", "()V", "isMacSystemMenu", "", "()Z", "isShowWelcomeScreen", "isShowWelcomeScreenFromSettings", "couldReturnToWelcomeScreen", "projects", "", "Lcom/intellij/openapi/project/Project;", "([Lcom/intellij/openapi/project/Project;)Z", "isMacOsTabbedProjectView", "project", "isCloseTab", "windowClosing", "", "getNumberOfOpenedProjects", "", "closeProjectAndShowWelcomeFrameIfNoProjectOpened", "quitApp", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nCloseProjectWindowHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloseProjectWindowHelper.kt\ncom/intellij/openapi/wm/impl/CloseProjectWindowHelper\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 storeUtil.kt\ncom/intellij/configurationStore/StoreUtilKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,112:1\n12970#2,2:113\n11879#2,9:118\n13805#2:127\n13806#2:129\n11888#2:130\n228#3,2:115\n1#4:117\n1#4:128\n37#5,2:131\n55#6:133\n*S KotlinDebug\n*F\n+ 1 CloseProjectWindowHelper.kt\ncom/intellij/openapi/wm/impl/CloseProjectWindowHelper\n*L\n43#1:113,2\n75#1:118,9\n75#1:127\n75#1:129\n75#1:130\n91#1:115,2\n75#1:128\n75#1:131,2\n76#1:133\n*E\n"})
public class CloseProjectWindowHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Boolean> SHOW_WELCOME_FRAME_FOR_PROJECT;

    protected boolean isMacSystemMenu() {
        return SystemProperties.getBooleanProperty((String)"idea.test.isMacSystemMenu", (boolean)MacMenuSettings.isSystemMenu);
    }

    private final boolean isShowWelcomeScreen() {
        return this.isMacSystemMenu() && this.isShowWelcomeScreenFromSettings();
    }

    protected boolean isShowWelcomeScreenFromSettings() {
        return GeneralSettings.Companion.getInstance().isShowWelcomeScreen();
    }

    @ApiStatus.Internal
    protected boolean couldReturnToWelcomeScreen(@NotNull Project[] projects) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)projects, (String)"projects");
            Project[] $this$any$iv = projects;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int j = 0; j < n; ++j) {
                Project element$iv;
                Project project2 = element$iv = $this$any$iv[j];
                boolean bl2 = false;
                if (!this.couldReturnToWelcomeScreen(project2)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @ApiStatus.Internal
    protected boolean isMacOsTabbedProjectView(@Nullable Project project2) {
        if (!SystemInfo.isMac) {
            return false;
        }
        JFrame jFrame = WindowManager.getInstance().getFrame(project2);
        if (jFrame == null) {
            return false;
        }
        JFrame projectFrame = jFrame;
        return MergeAllWindowsAction.isTabbedWindow(projectFrame);
    }

    @ApiStatus.Internal
    protected boolean isCloseTab(@Nullable Project project2) {
        if (project2 == null) {
            return false;
        }
        JFrame jFrame = WindowManager.getInstance().getFrame(project2);
        if (jFrame == null) {
            return false;
        }
        JFrame frame = jFrame;
        return Intrinsics.areEqual((Object)frame.getRootPane().getClientProperty("CloseTab"), (Object)true);
    }

    @RequiresEdt
    public void windowClosing(@Nullable Project project2) {
        WriteIntentReadAction.run(() -> CloseProjectWindowHelper.windowClosing$lambda$0(this, project2));
    }

    protected int getNumberOfOpenedProjects() {
        return ProjectManager.getInstance().getOpenProjects().length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    protected void closeProjectAndShowWelcomeFrameIfNoProjectOpened(@Nullable Project project2) {
        boolean $i$f$runInAutoSaveDisabledMode = false;
        AutoCloseable autoCloseable = (AutoCloseable)SaveAndSyncHandler.Companion.getInstance().disableAutoSave();
        Throwable throwable = null;
        try {
            AccessToken it$iv = (AccessToken)autoCloseable;
            boolean bl = false;
            boolean bl2 = false;
            if (project2 != null && project2.isOpen()) {
                ProjectManager.getInstance().closeAndDispose(project2);
            }
            MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
            Topic topic = AppLifecycleListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            ((AppLifecycleListener)messageBus.syncPublisher(topic)).projectFrameClosed();
            SaveAndSyncHandler.Companion.getInstance().scheduleSave(new SaveAndSyncHandler.SaveTask(null, true, 1, null), true);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        WelcomeFrame.Companion.showIfNoProjectOpened$default(WelcomeFrame.Companion, null, 1, null);
    }

    protected void quitApp() {
        ApplicationManager.getApplication().exit();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean couldReturnToWelcomeScreen(Project project2) {
        Object object;
        block3: {
            block2: {
                object = project2;
                if (object == null) break block2;
                Project it = object;
                boolean bl = false;
                Boolean bl2 = (Boolean)SHOW_WELCOME_FRAME_FOR_PROJECT.get((UserDataHolder)project2);
                object = bl2;
                if (bl2 != null) break block3;
            }
            if (!this.isShowWelcomeScreen()) return false;
            if (PlatformUtils.isDataSpell()) return false;
            if (PlatformUtils.isDataGrip()) return false;
            return true;
        }
        boolean bl = (Boolean)object;
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final void windowClosing$lambda$0(CloseProjectWindowHelper this$0, Project $project) {
        block5: {
            block3: {
                int numberOfOpenedProjects;
                block4: {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    numberOfOpenedProjects = this$0.getNumberOfOpenedProjects();
                    boolean isMacOsTabbedProjectView = this$0.isMacOsTabbedProjectView($project);
                    if (!isMacOsTabbedProjectView && numberOfOpenedProjects > 1 || isMacOsTabbedProjectView && this$0.isCloseTab($project)) break block3;
                    if (!isMacOsTabbedProjectView) break block4;
                    IdeFrame[] ideFrameArray = WindowManager.getInstance().getAllProjectFrames();
                    Intrinsics.checkNotNullExpressionValue((Object)ideFrameArray, (String)"getAllProjectFrames(...)");
                    Object[] objectArray = ideFrameArray;
                    CloseProjectWindowHelper closeProjectWindowHelper = this$0;
                    boolean $i$f$mapNotNull = false;
                    void var6_7 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    int n = ((void)$this$forEach$iv$iv$iv).length;
                    for (int j = 0; j < n; ++j) {
                        Project it$iv$iv;
                        void element$iv$iv$iv;
                        void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
                        boolean bl = false;
                        IdeFrame it = (IdeFrame)element$iv$iv;
                        boolean bl2 = false;
                        if (it.getProject() == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    if (closeProjectWindowHelper.couldReturnToWelcomeScreen(thisCollection$iv.toArray(new Project[0]))) break block3;
                }
                boolean $i$f$serviceIfCreated = false;
                Application application = ApplicationManager.getApplication();
                LightEditService lightEditService = (LightEditService)(application != null ? application.getServiceIfCreated(LightEditService.class) : null);
                if ((lightEditService != null ? lightEditService.getProject() : null) == null && (numberOfOpenedProjects != 1 || !this$0.couldReturnToWelcomeScreen($project))) break block5;
            }
            this$0.closeProjectAndShowWelcomeFrameIfNoProjectOpened($project);
            return;
        }
        this$0.quitApp();
    }

    static {
        Key key = Key.create((String)"Show.Welcome.Frame.For.Project");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        SHOW_WELCOME_FRAME_FOR_PROJECT = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/wm/impl/CloseProjectWindowHelper$Companion;", "", "<init>", "()V", "SHOW_WELCOME_FRAME_FOR_PROJECT", "Lcom/intellij/openapi/util/Key;", "", "getSHOW_WELCOME_FRAME_FOR_PROJECT", "()Lcom/intellij/openapi/util/Key;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Boolean> getSHOW_WELCOME_FRAME_FOR_PROJECT() {
            return SHOW_WELCOME_FRAME_FOR_PROJECT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

