/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.FrameInfoHelper;
import com.intellij.openapi.wm.impl.FrameInfoHelperKt;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ProjectFrameBounds;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.WindowManagerImplKt;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JRootPane;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/wm/impl/FrameStateListener;", "Ljava/awt/event/ComponentAdapter;", "defaultFrameInfoHelper", "Lcom/intellij/openapi/wm/impl/FrameInfoHelper;", "<init>", "(Lcom/intellij/openapi/wm/impl/FrameInfoHelper;)V", "componentMoved", "", "e", "Ljava/awt/event/ComponentEvent;", "componentResized", "update", "intellij.platform.ide.impl"})
public final class FrameStateListener
extends ComponentAdapter {
    @NotNull
    private final FrameInfoHelper defaultFrameInfoHelper;

    public FrameStateListener(@NotNull FrameInfoHelper defaultFrameInfoHelper) {
        Intrinsics.checkNotNullParameter((Object)defaultFrameInfoHelper, (String)"defaultFrameInfoHelper");
        this.defaultFrameInfoHelper = defaultFrameInfoHelper;
    }

    @Override
    public void componentMoved(@NotNull ComponentEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.update(e);
    }

    @Override
    public void componentResized(@NotNull ComponentEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.update(e);
    }

    private final void update(ComponentEvent e) {
        Component component2 = e.getComponent();
        Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type com.intellij.openapi.wm.impl.IdeFrameImpl");
        IdeFrameImpl frame = (IdeFrameImpl)component2;
        JRootPane rootPane = frame.getRootPane();
        if (rootPane != null && (Intrinsics.areEqual((Object)rootPane.getClientProperty("dispose.temporary"), (Object)true) || frame.togglingFullScreenInProgress)) {
            return;
        }
        int extendedState = frame.getExtendedState();
        Rectangle bounds = frame.getBounds();
        FrameInfoHelperKt.checkForNonsenseBounds("FrameStateListener.update.bounds", bounds);
        frame.ensureSensibleSize$intellij_platform_ide_impl();
        Rectangle normalBoundsOnCurrentScreen = null;
        if (rootPane != null) {
            Rectangle newScreen;
            Rectangle oldScreen = frame.getScreenBounds();
            GraphicsConfiguration graphicsConfiguration = frame.getGraphicsConfiguration();
            Rectangle rectangle = newScreen = graphicsConfiguration != null ? graphicsConfiguration.getBounds() : null;
            if (extendedState == 0) {
                frame.setNormalBounds(bounds);
                frame.setScreenBounds(newScreen);
                if (WindowManagerImplKt.IDE_FRAME_EVENT_LOG.isDebugEnabled()) {
                    WindowManagerImplKt.IDE_FRAME_EVENT_LOG.debug("Updated bounds for IDE frame " + frame.getNormalBounds() + " and screen " + frame.getScreenBounds() + " after moving/resizing");
                }
            } else if (FrameInfoHelper.Companion.isMaximized(extendedState)) {
                normalBoundsOnCurrentScreen = WindowManagerImplKt.access$getNormalFrameBounds(frame, oldScreen, newScreen);
            }
        }
        IdeFrameImpl.FrameHelper frameHelper = frame.getFrameHelper();
        IdeFrame ideFrame = frameHelper != null ? frameHelper.getHelper() : null;
        ProjectFrameHelper projectFrameHelper = ideFrame instanceof ProjectFrameHelper ? (ProjectFrameHelper)ideFrame : null;
        if (projectFrameHelper == null) {
            return;
        }
        ProjectFrameHelper frameHelper2 = projectFrameHelper;
        Project project2 = frameHelper2.getProject();
        if (project2 == null) {
            this.defaultFrameInfoHelper.updateFrameInfo(frameHelper2, frame);
        } else if (!project2.isDisposed()) {
            ProjectFrameBounds.Companion.getInstance(project2).markDirty(FrameInfoHelper.Companion.isMaximized(extendedState) ? normalBoundsOnCurrentScreen : bounds);
        }
    }
}

