/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidgetHelper;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000bH\u0015J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0014J\u0012\u0010\u001e\u001a\u00020\r2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001dH\u0016J\b\u0010 \u001a\u0004\u0018\u00010!J\b\u0010\"\u001a\u0004\u0018\u00010\u001dJ\n\u0010#\u001a\u0004\u0018\u00010$H\u0014J\u0010\u0010%\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\tH\u0016J\b\u0010&\u001a\u00020\u001aH\u0016R\u0016\u0010\u0002\u001a\u00020\u00038\u0004X\u0085\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u0004\u0018\u00010\t8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u00038DX\u0084\u0004\u00a2\u0006\f\u0012\u0004\b\u0011\u0010\u0007\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\t8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/openapi/wm/impl/status/EditorBasedWidget;", "Lcom/intellij/openapi/wm/StatusBarWidget;", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getMyProject$annotations", "()V", "myStatusBar", "Lcom/intellij/openapi/wm/StatusBar;", "myConnection", "Lcom/intellij/util/messages/MessageBusConnection;", "value", "", "isDisposed", "()Z", "project", "getProject$annotations", "getProject", "()Lcom/intellij/openapi/project/Project;", "statusBar", "getStatusBar", "()Lcom/intellij/openapi/wm/StatusBar;", "helper", "Lcom/intellij/openapi/wm/impl/status/EditorBasedWidgetHelper;", "registerCustomListeners", "", "connection", "getEditor", "Lcom/intellij/openapi/editor/Editor;", "isOurEditor", "editor", "getFocusedComponent", "Ljava/awt/Component;", "getFocusedEditor", "getSelectedFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "install", "dispose", "intellij.platform.ide.impl"})
public abstract class EditorBasedWidget
implements StatusBarWidget {
    @JvmField
    @NotNull
    protected final Project myProject;
    @JvmField
    @Nullable
    protected StatusBar myStatusBar;
    @JvmField
    @NotNull
    protected final MessageBusConnection myConnection;
    private volatile boolean isDisposed;
    @NotNull
    private final EditorBasedWidgetHelper helper;

    protected EditorBasedWidget(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        this.helper = new EditorBasedWidgetHelper(this.getProject());
        this.myConnection = this.getProject().getMessageBus().connect((Disposable)this);
        this.registerCustomListeners(this.myConnection);
    }

    @Deprecated(message="Use project", replaceWith=@ReplaceWith(expression="project", imports={}))
    protected static /* synthetic */ void getMyProject$annotations() {
    }

    protected final boolean isDisposed() {
        return this.isDisposed;
    }

    @NotNull
    protected final Project getProject() {
        return this.myProject;
    }

    protected static /* synthetic */ void getProject$annotations() {
    }

    @Nullable
    protected final StatusBar getStatusBar() {
        return this.myStatusBar;
    }

    @Deprecated(message="Custom listeners should be registered after class initialization to prevent using not fully constructed class in the listeners.")
    protected void registerCustomListeners(@NotNull MessageBusConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
    }

    @Nullable
    protected Editor getEditor() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return FileEditorManager.getInstance((Project)this.getProject()).getSelectedTextEditor();
        }
        FileEditor fileEditor = StatusBarUtil.getCurrentFileEditor(this.myStatusBar);
        return fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : null;
    }

    public boolean isOurEditor(@Nullable Editor editor2) {
        return this.helper.isOurEditor(editor2, this.myStatusBar);
    }

    @Nullable
    public final Component getFocusedComponent() {
        return this.helper.getFocusedComponent();
    }

    @Nullable
    public final Editor getFocusedEditor() {
        return this.helper.getFocusedEditor(this.myStatusBar);
    }

    @Nullable
    protected VirtualFile getSelectedFile() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Editor editor2 = FileEditorManager.getInstance((Project)this.getProject()).getSelectedTextEditor();
            return editor2 != null ? editor2.getVirtualFile() : null;
        }
        FileEditor fileEditor = StatusBarUtil.getCurrentFileEditor(this.myStatusBar);
        TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
        return textEditor != null ? textEditor.getFile() : null;
    }

    public void install(@NotNull StatusBar statusBar) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)statusBar, (String)"statusBar");
        boolean bl2 = bl = statusBar.getProject() == null || Intrinsics.areEqual((Object)statusBar.getProject(), (Object)this.getProject());
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Cannot install widget from one project on status bar of another project";
            throw new AssertionError((Object)string);
        }
        this.myStatusBar = statusBar;
    }

    public void dispose() {
        this.isDisposed = true;
        this.myStatusBar = null;
    }
}

