/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen.learnIde.coursesInProgress;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.impl.welcomeScreen.learnIde.coursesInProgress.CourseCardComponentKt;
import com.intellij.openapi.wm.impl.welcomeScreen.learnIde.coursesInProgress.CourseDataStorage;
import com.intellij.openapi.wm.impl.welcomeScreen.learnIde.coursesInProgress.CourseDataStorageKt;
import com.intellij.openapi.wm.impl.welcomeScreen.learnIde.coursesInProgress.CourseDeletedListener;
import com.intellij.openapi.wm.impl.welcomeScreen.learnIde.coursesInProgress.CourseInfo;
import com.intellij.openapi.wm.impl.welcomeScreen.learnIde.coursesInProgress.CourseInfoComponent;
import com.intellij.openapi.wm.impl.welcomeScreen.learnIde.coursesInProgress.CourseNameComponent;
import com.intellij.openapi.wm.impl.welcomeScreen.learnIde.coursesInProgress.CoursesStorageProvider;
import com.intellij.openapi.wm.impl.welcomeScreen.learnIde.jbAcademy.JBAcademyWelcomeScreenBundle;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010\u0017\u001a\u00020\u0016J\b\u0010\u0018\u001a\u00020\u0001H\u0002J\b\u0010\u0019\u001a\u00020\tH\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020\u001fJ\u0006\u0010#\u001a\u00020\u001fJ\u0010\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u0010H\u0002J\u0010\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/openapi/wm/impl/welcomeScreen/learnIde/coursesInProgress/CourseCardComponent;", "Ljavax/swing/JPanel;", "data", "Lcom/intellij/openapi/wm/impl/welcomeScreen/learnIde/coursesInProgress/CourseInfo;", "<init>", "(Lcom/intellij/openapi/wm/impl/welcomeScreen/learnIde/coursesInProgress/CourseInfo;)V", "getData", "()Lcom/intellij/openapi/wm/impl/welcomeScreen/learnIde/coursesInProgress/CourseInfo;", "actionComponent", "Ljavax/swing/JComponent;", "getActionComponent", "()Ljavax/swing/JComponent;", "setActionComponent", "(Ljavax/swing/JComponent;)V", "baseComponent", "isHovered", "", "getScaledLogoComponent", "Lcom/intellij/ui/components/panels/Wrapper;", "logo", "Ljavax/swing/Icon;", "ancestor", "Ljava/awt/Component;", "getClickComponent", "createMainComponent", "createSideActionComponent", "showRemoveCourseDialog", "", "courseName", "", "updateColors", "", "background", "Ljava/awt/Color;", "onHover", "onHoverEnded", "setActionComponentVisible", "visible", "paintComponent", "g", "Ljava/awt/Graphics;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class CourseCardComponent
extends JPanel {
    @NotNull
    private final CourseInfo data;
    public JComponent actionComponent;
    private JComponent baseComponent;
    private boolean isHovered;

    public CourseCardComponent(@NotNull CourseInfo data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        super(new BorderLayout());
        this.data = data2;
        this.setBorder(JBUI.Borders.empty((int)6));
        this.setPreferredSize((Dimension)JBUI.size((int)80, (int)55));
        DialogPanel logoPanel = BuilderKt.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> CourseCardComponent._init_$lambda$0(this, arg_0)));
        logoPanel.setBorder((Border)JBUI.Borders.emptyRight((int)6));
        this.add((Component)logoPanel, "Before");
        this.add((Component)this.createMainComponent(), "Center");
        this.updateColors(CourseCardComponentKt.getMainBackgroundColor());
    }

    @NotNull
    public final CourseInfo getData() {
        return this.data;
    }

    @NotNull
    public final JComponent getActionComponent() {
        JComponent jComponent = this.actionComponent;
        if (jComponent != null) {
            return jComponent;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"actionComponent");
        return null;
    }

    public final void setActionComponent(@NotNull JComponent jComponent) {
        Intrinsics.checkNotNullParameter((Object)jComponent, (String)"<set-?>");
        this.actionComponent = jComponent;
    }

    private final Wrapper getScaledLogoComponent(Icon logo, Component ancestor) {
        float scaleFactor = (float)20 / (float)logo.getIconHeight();
        Icon scaledIcon = IconUtil.scale((Icon)logo, (Component)ancestor, (float)scaleFactor);
        return new Wrapper((JComponent)new JBLabel(IconUtil.toSize((Icon)scaledIcon, (int)JBUI.scale((int)20), (int)JBUI.scale((int)20))));
    }

    @NotNull
    public final Component getClickComponent() {
        JComponent jComponent = this.baseComponent;
        if (jComponent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"baseComponent");
            jComponent = null;
        }
        return jComponent;
    }

    private final JPanel createMainComponent() {
        this.baseComponent = (JComponent)new NonOpaquePanel();
        JComponent jComponent = this.baseComponent;
        if (jComponent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"baseComponent");
            jComponent = null;
        }
        jComponent.add((Component)new CourseNameComponent(this.data.getName()), "North");
        JComponent jComponent2 = this.baseComponent;
        if (jComponent2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"baseComponent");
            jComponent2 = null;
        }
        jComponent2.add((Component)new CourseInfoComponent(this.data.getTasksSolved(), this.data.getTasksTotal()), "South");
        NonOpaquePanel panel2 = new NonOpaquePanel();
        JComponent jComponent3 = this.baseComponent;
        if (jComponent3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"baseComponent");
            jComponent3 = null;
        }
        panel2.add((Component)jComponent3, (Object)"Center");
        this.setActionComponent(this.createSideActionComponent());
        this.getActionComponent().setVisible(false);
        panel2.add((Component)this.getActionComponent(), (Object)"After");
        return (JPanel)panel2;
    }

    private final JComponent createSideActionComponent() {
        Wrapper wrapper2;
        JBLabel removeLabel = new JBLabel(AllIcons.Diff.Remove);
        removeLabel.addMouseListener((MouseListener)new MouseAdapter(this){
            final /* synthetic */ CourseCardComponent this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void mouseClicked(MouseEvent e) {
                if (CourseCardComponent.access$showRemoveCourseDialog(this.this$0, this.this$0.getData().getName()) == 1) {
                    void $this$any$iv;
                    List<CourseDataStorage> coursesStorages = CoursesStorageProvider.Companion.getAllStorages();
                    Iterable iterable = coursesStorages;
                    CourseCardComponent courseCardComponent = this.this$0;
                    boolean $i$f$any = false;
                    if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) {
                        for (T element$iv : $this$any$iv) {
                            CourseDataStorage it = (CourseDataStorage)element$iv;
                            boolean bl = false;
                            if (!it.removeCourseByLocation(courseCardComponent.getData().getLocation())) continue;
                            break;
                        }
                    }
                    ((CourseDeletedListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(CourseDataStorageKt.getCOURSE_DELETED())).courseDeleted(this.this$0.getData());
                }
            }
        });
        Wrapper $this$createSideActionComponent_u24lambda_u240 = wrapper2 = new Wrapper((JComponent)removeLabel);
        boolean bl = false;
        $this$createSideActionComponent_u24lambda_u240.setEnabled(false);
        $this$createSideActionComponent_u24lambda_u240.setVisible(false);
        return (JComponent)wrapper2;
    }

    private final int showRemoveCourseDialog(String courseName) {
        Object[] objectArray = new Object[]{courseName};
        String string = JBAcademyWelcomeScreenBundle.INSTANCE.message("welcome.tab.learn.remove.course.description", objectArray);
        objectArray = new String[]{Messages.getCancelButton(), JBAcademyWelcomeScreenBundle.INSTANCE.message("welcome.tab.learn.remove.course.title", new Object[0])};
        return Messages.showDialog(null, (String)string, (String)JBAcademyWelcomeScreenBundle.INSTANCE.message("welcome.tab.learn.remove.course.title", new Object[0]), (String[])objectArray, (int)0, (Icon)Messages.getErrorIcon());
    }

    public final void updateColors(@NotNull Color background) {
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        UIUtil.setBackgroundRecursively((Component)this, (Color)background);
        this.repaint();
    }

    public final void onHover() {
        this.isHovered = true;
        this.updateColors(CourseCardComponentKt.access$getHoverColor$p());
        this.setActionComponentVisible(true);
    }

    public final void onHoverEnded() {
        this.isHovered = false;
        this.updateColors(CourseCardComponentKt.getMainBackgroundColor());
        this.setActionComponentVisible(false);
    }

    private final void setActionComponentVisible(boolean visible) {
        this.getActionComponent().setVisible(visible);
        this.getActionComponent().setEnabled(visible);
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (!this.isHovered) {
            super.paintComponent(g);
            return;
        }
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(CourseCardComponentKt.access$getHoverColor$p());
        int cornerRadius = 15;
        g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), cornerRadius, cornerRadius);
        g2.drawRoundRect(0, 0, this.getWidth(), this.getHeight(), cornerRadius, cornerRadius);
        g2.dispose();
    }

    private static final Unit _init_$lambda$0(CourseCardComponent this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default($this$panel, null, arg_0 -> CourseCardComponent.lambda$0$0(this$0, arg_0), 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0(CourseCardComponent this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Icon icon2 = this$0.data.getIcon();
        if (icon2 != null) {
            $this$row.cell((JComponent)this$0.getScaledLogoComponent(icon2, this$0)).align(AlignY.TOP.INSTANCE).gap(RightGap.SMALL);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ int access$showRemoveCourseDialog(CourseCardComponent $this, String courseName) {
        return $this.showRemoveCourseDialog(courseName);
    }
}

