/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.impl.customization;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.platform.ide.customization.FeedbackReporter;
import com.intellij.platform.ide.impl.feedback.PlatformFeedbackDialogs;
import com.intellij.ui.LicensingFacade;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u001a\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u001a\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/ide/impl/customization/JetBrainsFeedbackReporter;", "Lcom/intellij/platform/ide/customization/FeedbackReporter;", "productName", "", "useInIdeGeneralFeedback", "", "useInIdeEvaluationFeedback", "<init>", "(Ljava/lang/String;ZZ)V", "destinationDescription", "getDestinationDescription", "()Ljava/lang/String;", "feedbackFormUrl", "Lcom/intellij/util/Url;", "description", "licenseInfo", "metadata", "isEval", "showFeedbackForm", "project", "Lcom/intellij/openapi/project/Project;", "requestedForEvaluation", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nJetBrainsFeedbackReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JetBrainsFeedbackReporter.kt\ncom/intellij/platform/ide/impl/customization/JetBrainsFeedbackReporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
public final class JetBrainsFeedbackReporter
implements FeedbackReporter {
    @NotNull
    private final String productName;
    private final boolean useInIdeGeneralFeedback;
    private final boolean useInIdeEvaluationFeedback;

    public JetBrainsFeedbackReporter(@NotNull String productName, boolean useInIdeGeneralFeedback, boolean useInIdeEvaluationFeedback) {
        Intrinsics.checkNotNullParameter((Object)productName, (String)"productName");
        this.productName = productName;
        this.useInIdeGeneralFeedback = useInIdeGeneralFeedback;
        this.useInIdeEvaluationFeedback = useInIdeEvaluationFeedback;
    }

    @NotNull
    public String getDestinationDescription() {
        return "jetbrains.com";
    }

    @NotNull
    public Url feedbackFormUrl(@NotNull String description) {
        Object object;
        Pair[] pairArray;
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        BuildNumber buildNumber = appInfo.getBuild();
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"getBuild(...)");
        BuildNumber build2 = buildNumber;
        Pair[] pairArray2 = LicensingFacade.getInstance();
        if (pairArray2 != null && (pairArray2 = pairArray2.metadata) != null) {
            Pair[] it = pairArray = pairArray2;
            boolean bl = false;
            object = it.length() > 10 ? pairArray : null;
        } else {
            object = null;
        }
        Pair[] metadata = object;
        LicensingFacade licensingFacade = LicensingFacade.getInstance();
        boolean isEval = licensingFacade != null ? licensingFacade.isEvaluationLicense() : false;
        pairArray = new Pair[]{TuplesKt.to((Object)"product", (Object)this.productName), TuplesKt.to((Object)"build", (Object)(appInfo.isEAP() ? build2.asStringWithoutProductCode() : build2.asString())), TuplesKt.to((Object)"timezone", (Object)System.getProperty("user.timezone", "")), TuplesKt.to((Object)"eval", (Object)String.valueOf(isEval)), TuplesKt.to((Object)"license", (Object)this.licenseInfo((String)metadata, isEval))};
        Url url = Urls.newFromEncoded((String)"https://www.jetbrains.com/feedback/feedback.jsp").addParameters(MapsKt.mapOf((Pair[])pairArray));
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"addParameters(...)");
        return url;
    }

    private final String licenseInfo(String metadata, boolean isEval) {
        Character c;
        Character c2;
        if (isEval) {
            return "eval";
        }
        String string = metadata;
        Character c3 = c2 = (c = string != null ? Character.valueOf(string.charAt(10)) : null);
        char c4 = 'C';
        if (c3 != null && c3.charValue() == c4) {
            return "commercial";
        }
        Character c5 = c2;
        c4 = 'E';
        if (c5 != null && c5.charValue() == c4) {
            return "academic";
        }
        Character c6 = c2;
        c4 = 'F';
        if (c6 != null && c6.charValue() == c4) {
            return "free";
        }
        Character c7 = c2;
        c4 = 'L';
        if (c7 != null && c7.charValue() == c4) {
            return "classroom";
        }
        Character c8 = c2;
        c4 = 'O';
        if (c8 != null && c8.charValue() == c4) {
            return "opensource";
        }
        Character c9 = c2;
        c4 = 'P';
        if (c9 != null && c9.charValue() == c4) {
            return "personal";
        }
        return "unknown";
    }

    public boolean showFeedbackForm(@Nullable Project project2, boolean requestedForEvaluation) {
        if (requestedForEvaluation && this.useInIdeEvaluationFeedback) {
            PlatformFeedbackDialogs feedbackDialogs = PlatformFeedbackDialogs.Companion.getInstance();
            DialogWrapper dialogWrapper = feedbackDialogs.createEvaluationFeedbackDialog(project2);
            if (dialogWrapper == null) {
                return false;
            }
            DialogWrapper evaluationFeedbackDialog = dialogWrapper;
            evaluationFeedbackDialog.show();
            return true;
        }
        if (!requestedForEvaluation && this.useInIdeGeneralFeedback) {
            PlatformFeedbackDialogs feedbackDialogs = PlatformFeedbackDialogs.Companion.getInstance();
            DialogWrapper dialogWrapper = feedbackDialogs.createGeneralFeedbackDialog(project2);
            if (dialogWrapper == null) {
                return false;
            }
            DialogWrapper generalFeedbackDialog = dialogWrapper;
            generalFeedbackDialog.show();
            return true;
        }
        return false;
    }
}

