/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.impl.customization;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.updateSettings.impl.UpdateRequestParametersProvider;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.platform.ide.customization.ExternalProductResourceUrls;
import com.intellij.platform.ide.customization.FeedbackReporter;
import com.intellij.platform.ide.impl.customization.BaseJetBrainsExternalProductResourceUrlsKt;
import com.intellij.ui.LicensingFacade;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.URLUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0005\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R1\u0010\u0011\u001a\u001f\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u0005\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0010R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0007R\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0007R\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0007R\u0016\u0010 \u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0007R\u0016\u0010\"\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0007R1\u0010$\u001a\u001f\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(%\u0012\u0004\u0012\u00020\u0005\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0010\u00a8\u0006'"}, d2={"Lcom/intellij/platform/ide/impl/customization/LegacyExternalProductResourceUrls;", "Lcom/intellij/platform/ide/customization/ExternalProductResourceUrls;", "<init>", "()V", "updateMetadataUrl", "Lcom/intellij/util/Url;", "getUpdateMetadataUrl", "()Lcom/intellij/util/Url;", "computePatchUrl", "from", "Lcom/intellij/openapi/util/BuildNumber;", "to", "bugReportUrl", "Lkotlin/Function1;", "", "getBugReportUrl", "()Lkotlin/jvm/functions/Function1;", "technicalSupportUrl", "Lkotlin/ParameterName;", "name", "description", "getTechnicalSupportUrl", "feedbackReporter", "Lcom/intellij/platform/ide/customization/FeedbackReporter;", "getFeedbackReporter", "()Lcom/intellij/platform/ide/customization/FeedbackReporter;", "downloadPageUrl", "getDownloadPageUrl", "youTubeChannelUrl", "getYouTubeChannelUrl", "keyboardShortcutsPdfUrl", "getKeyboardShortcutsPdfUrl", "whatIsNewPageUrl", "getWhatIsNewPageUrl", "gettingStartedPageUrl", "getGettingStartedPageUrl", "helpPageUrl", "topicId", "getHelpPageUrl", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLegacyExternalProductResourceUrls.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegacyExternalProductResourceUrls.kt\ncom/intellij/platform/ide/impl/customization/LegacyExternalProductResourceUrls\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n23#2:122\n1#3:123\n*S KotlinDebug\n*F\n+ 1 LegacyExternalProductResourceUrls.kt\ncom/intellij/platform/ide/impl/customization/LegacyExternalProductResourceUrls\n*L\n23#1:122\n*E\n"})
public final class LegacyExternalProductResourceUrls
implements ExternalProductResourceUrls {
    public LegacyExternalProductResourceUrls() {
        LegacyExternalProductResourceUrls $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(LegacyExternalProductResourceUrls.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("The default implementation LegacyExternalProductResourceUrls is deprecated and will be removed in the future;\nProvide your own implementation of ExternalProductResourceUrls using data which is currently stored in \n<idea.platform.prefix>ApplicationInfo.xml file and register it as the service override.\nIDEs developed by JetBrains should use BaseJetBrainsExternalProductResourceUrls as a superclass for their implementation.\n");
    }

    @Nullable
    public Url getUpdateMetadataUrl() {
        String customUrl = System.getProperty("idea.updates.url");
        if (customUrl != null) {
            return Urls.newFromEncoded((String)customUrl);
        }
        Object object = ApplicationInfoEx.getInstanceEx().getUpdateUrls();
        if (object == null || (object = object.getCheckingUrl()) == null) {
            return null;
        }
        Object baseUrl = object;
        return UpdateRequestParametersProvider.passUpdateParameters(Urls.newFromEncoded((String)baseUrl));
    }

    @Nullable
    public Url computePatchUrl(@NotNull BuildNumber from, @NotNull BuildNumber to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Url customUrl = BaseJetBrainsExternalProductResourceUrlsKt.computeCustomPatchDownloadUrl(from, to);
        if (customUrl != null) {
            return customUrl;
        }
        Object object = ApplicationInfoEx.getInstanceEx().getUpdateUrls();
        if (object == null || (object = object.getPatchesUrl()) == null) {
            return null;
        }
        Object baseUrl = object;
        return Urls.newFromEncoded((String)baseUrl).resolve(BaseJetBrainsExternalProductResourceUrlsKt.computePatchFileName(from, to));
    }

    @Nullable
    public Function1<String, Url> getBugReportUrl() {
        String string = ApplicationInfoEx.getInstanceEx().getYoutrackUrl();
        if (string == null) {
            return null;
        }
        String youtrackUrl = string;
        return arg_0 -> LegacyExternalProductResourceUrls._get_bugReportUrl_$lambda$0(youtrackUrl, arg_0);
    }

    @Nullable
    public Function1<String, Url> getTechnicalSupportUrl() {
        String string = ApplicationInfoEx.getInstanceEx().getSupportUrl();
        if (string == null) {
            return null;
        }
        String urlTemplate = string;
        return arg_0 -> LegacyExternalProductResourceUrls._get_technicalSupportUrl_$lambda$0(urlTemplate, arg_0);
    }

    @Nullable
    public FeedbackReporter getFeedbackReporter() {
        String string = ApplicationInfoEx.getInstanceEx().getFeedbackUrl();
        if (string == null) {
            return null;
        }
        String urlTemplate = string;
        return new FeedbackReporter(urlTemplate){
            final /* synthetic */ String $urlTemplate;
            {
                this.$urlTemplate = $urlTemplate;
            }

            public String getDestinationDescription() {
                String string;
                Pattern uriPattern = Pattern.compile("[^:/?#]+://(?:www\\.)?([^/?#]*).*", 32);
                Matcher matcher = uriPattern.matcher(this.$urlTemplate);
                if (matcher.matches()) {
                    String string2 = matcher.group(1);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
                } else {
                    String string3 = ApplicationInfo.getInstance().getCompanyName();
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getCompanyName(...)");
                }
                return string;
            }

            public Url feedbackFormUrl(String description) {
                Intrinsics.checkNotNullParameter((Object)description, (String)"description");
                ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
                BuildNumber buildNumber = appInfo.getBuild();
                Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"getBuild(...)");
                BuildNumber build2 = buildNumber;
                String string = URLUtil.encodeURIComponent((String)(appInfo.isEAP() ? build2.asStringWithoutProductCode() : build2.asString()));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeURIComponent(...)");
                String string2 = StringsKt.replace$default((String)this.$urlTemplate, (String)"$BUILD", (String)string, (boolean)false, (int)4, null);
                String string3 = URLUtil.encodeURIComponent((String)System.getProperty("user.timezone", ""));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"encodeURIComponent(...)");
                String string4 = StringsKt.replace$default((String)string2, (String)"$TIMEZONE", (String)string3, (boolean)false, (int)4, null);
                String string5 = URLUtil.encodeURIComponent((String)appInfo.getFullVersion());
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"encodeURIComponent(...)");
                String string6 = StringsKt.replace$default((String)string4, (String)"$VERSION", (String)string5, (boolean)false, (int)4, null);
                LicensingFacade licensingFacade = LicensingFacade.getInstance();
                String string7 = URLUtil.encodeURIComponent((String)String.valueOf(licensingFacade != null ? licensingFacade.isEvaluationLicense() : false));
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"encodeURIComponent(...)");
                String string8 = StringsKt.replace$default((String)string6, (String)"$EVAL", (String)string7, (boolean)false, (int)4, null);
                String string9 = URLUtil.encodeURIComponent((String)description);
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"encodeURIComponent(...)");
                String url = StringsKt.replace$default((String)string8, (String)"$DESCR", (String)string9, (boolean)false, (int)4, null);
                return Urls.newFromEncoded((String)url);
            }
        };
    }

    @Nullable
    public Url getDownloadPageUrl() {
        Url url;
        String string = ApplicationInfoEx.getInstanceEx().getDownloadUrl();
        if (string != null) {
            String it = string;
            boolean bl = false;
            url = Urls.newFromEncoded((String)it);
        } else {
            url = null;
        }
        return url;
    }

    @Nullable
    public Url getYouTubeChannelUrl() {
        Url url;
        String string = ApplicationInfoEx.getInstanceEx().getJetBrainsTvUrl();
        if (string != null) {
            String it = string;
            boolean bl = false;
            url = Urls.newFromEncoded((String)it);
        } else {
            url = null;
        }
        return url;
    }

    @Nullable
    public Url getKeyboardShortcutsPdfUrl() {
        Url url;
        String url2;
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        String string = url2 = SystemInfo.isMac ? appInfo.getMacKeymapUrl() : appInfo.getWinKeymapUrl();
        if (string != null) {
            String it = string;
            boolean bl = false;
            url = Urls.newFromEncoded((String)url2);
        } else {
            url = null;
        }
        return url;
    }

    @Nullable
    public Url getWhatIsNewPageUrl() {
        Url url;
        String string = ApplicationInfoEx.getInstanceEx().getWhatsNewUrl();
        if (string != null) {
            String it = string;
            boolean bl = false;
            url = Urls.newFromEncoded((String)it);
        } else {
            url = null;
        }
        return url;
    }

    @Nullable
    public Url getGettingStartedPageUrl() {
        Url url;
        String string = ApplicationInfoEx.getInstanceEx().getDocumentationUrl();
        if (string != null) {
            String it = string;
            boolean bl = false;
            url = Urls.newFromEncoded((String)it);
        } else {
            url = null;
        }
        return url;
    }

    @Nullable
    public Function1<String, Url> getHelpPageUrl() {
        String string = ApplicationInfoEx.getInstanceEx().getWebHelpUrl();
        if (string == null) {
            return null;
        }
        String baseHelpUrl = string;
        return arg_0 -> LegacyExternalProductResourceUrls._get_helpPageUrl_$lambda$0(baseHelpUrl, arg_0);
    }

    private static final Url _get_bugReportUrl_$lambda$0(String $youtrackUrl, String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        String string = URLUtil.encodeURIComponent((String)description);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeURIComponent(...)");
        return Urls.newFromEncoded((String)StringsKt.replace$default((String)$youtrackUrl, (String)"$DESCR", (String)string, (boolean)false, (int)4, null));
    }

    private static final Url _get_technicalSupportUrl_$lambda$0(String $urlTemplate, String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        String string2 = ApplicationInfo.getInstance().getBuild().asStringWithoutProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asStringWithoutProductCode(...)");
        String string3 = StringsKt.replace$default((String)StringsKt.replace$default((String)$urlTemplate, (String)"$BUILD", (String)string2, (boolean)false, (int)4, null), (String)"$OS", (String)BaseJetBrainsExternalProductResourceUrlsKt.currentOsNameForIntelliJSupport(), (boolean)false, (int)4, null);
        String string4 = System.getProperty("user.timezone");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getProperty(...)");
        String url = StringsKt.replace$default((String)string3, (String)"$TIMEZONE", (String)string4, (boolean)false, (int)4, null);
        return Urls.newFromEncoded((String)url);
    }

    private static final Url _get_helpPageUrl_$lambda$0(String $baseHelpUrl, String topicId) {
        Intrinsics.checkNotNullParameter((Object)topicId, (String)"topicId");
        return Urls.newFromEncoded((String)$baseHelpUrl).resolve(ApplicationInfo.getInstance().getShortVersion() + "/").addParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)topicId, (Object)"")));
    }
}

