/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.impl.presentationAssistant;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.ide.impl.presentationAssistant.KeymapKind;
import com.intellij.platform.ide.impl.presentationAssistant.MacKeymapPluginNotificationKt;
import com.intellij.platform.ide.impl.presentationAssistant.PresentationAssistantKt;
import com.intellij.platform.ide.impl.presentationAssistant.PresentationAssistantState;
import com.intellij.platform.ide.impl.presentationAssistant.ShortcutPresenter;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.xmlb.XmlSerializerUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PresentationAssistantIJ", storages={@Storage(value="presentation-assistant-ij.xml", roamingType=RoamingType.DISABLED)}, category=SettingsCategory.UI, exportable=true)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0006\u0010\u0012\u001a\u00020\u0010J\u001c\u0010\u0013\u001a\u00020\u00102\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u000bJ\r\u0010\u0017\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u0002X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/platform/ide/impl/presentationAssistant/PresentationAssistant;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/platform/ide/impl/presentationAssistant/PresentationAssistantState;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "configuration", "getConfiguration$intellij_platform_ide_impl", "()Lcom/intellij/platform/ide/impl/presentationAssistant/PresentationAssistantState;", "warningAboutMacKeymapWasShown", "", "presenter", "Lcom/intellij/platform/ide/impl/presentationAssistant/ShortcutPresenter;", "getState", "loadState", "", "p", "initialize", "updatePresenter", "project", "Lcom/intellij/openapi/project/Project;", "showInitialAction", "checkIfMacKeymapIsAvailable", "checkIfMacKeymapIsAvailable$intellij_platform_ide_impl", "Companion", "intellij.platform.ide.impl"})
public final class PresentationAssistant
implements PersistentStateComponent<PresentationAssistantState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final PresentationAssistantState configuration;
    private boolean warningAboutMacKeymapWasShown;
    @Nullable
    private ShortcutPresenter presenter;

    public PresentationAssistant(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.configuration = new PresentationAssistantState();
    }

    @NotNull
    public final PresentationAssistantState getConfiguration$intellij_platform_ide_impl() {
        return this.configuration;
    }

    @NotNull
    public PresentationAssistantState getState() {
        return this.configuration;
    }

    public void loadState(@NotNull PresentationAssistantState p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        XmlSerializerUtil.copyBean((Object)p, (Object)this.configuration);
    }

    public final void initialize() {
        if (this.configuration.getShowActionDescriptions() && this.presenter == null) {
            this.presenter = new ShortcutPresenter(CoroutineScopeKt.childScope$default((CoroutineScope)this.coroutineScope, null, (boolean)false, (int)3, null));
        }
    }

    public final void updatePresenter(@Nullable Project project2, boolean showInitialAction) {
        block2: {
            block3: {
                boolean isEnabled;
                block1: {
                    ShortcutPresenter presenter;
                    isEnabled = this.configuration.getShowActionDescriptions();
                    if (!isEnabled || this.presenter != null) break block1;
                    this.presenter = presenter = new ShortcutPresenter(CoroutineScopeKt.childScope$default((CoroutineScope)this.coroutineScope, null, (boolean)false, (int)3, null));
                    if (!showInitialAction) break block2;
                    presenter.showActionInfo(new ShortcutPresenter.ActionData("TogglePresentationAssistantAction", project2, ActionsBundle.message((String)"action.TogglePresentationAssistantAction.text", (Object[])new Object[0])));
                    break block2;
                }
                if (this.presenter == null) break block2;
                if (isEnabled) break block3;
                ShortcutPresenter shortcutPresenter = this.presenter;
                if (shortcutPresenter != null) {
                    shortcutPresenter.disable();
                }
                this.presenter = null;
                break block2;
            }
            ShortcutPresenter shortcutPresenter = this.presenter;
            if (shortcutPresenter == null) break block2;
            shortcutPresenter.refreshPresentedPopupIfNeeded();
        }
    }

    public static /* synthetic */ void updatePresenter$default(PresentationAssistant presentationAssistant, Project project2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            project2 = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        presentationAssistant.updatePresenter(project2, bl);
    }

    public final void checkIfMacKeymapIsAvailable$intellij_platform_ide_impl() {
        KeymapKind alternativeKeymap = PresentationAssistantKt.alternativeKeymapKind(this.configuration);
        if (this.warningAboutMacKeymapWasShown || SystemInfoRt.isMac || alternativeKeymap == null || !alternativeKeymap.isMac() || KeymapManager.getInstance().getKeymap(alternativeKeymap.getValue()) != null) {
            return;
        }
        PluginId pluginId = PluginId.Companion.getId("com.intellij.plugins.macoskeymap");
        IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)pluginId);
        if (plugin != null && plugin.isEnabled()) {
            return;
        }
        this.warningAboutMacKeymapWasShown = true;
        MacKeymapPluginNotificationKt.showInstallMacKeymapPluginNotification(pluginId);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/platform/ide/impl/presentationAssistant/PresentationAssistant$Companion;", "", "<init>", "()V", "isThemeEnabled", "", "()Z", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isThemeEnabled() {
            return ExperimentalUI.Companion.isNewUI() && Registry.Companion.is("ide.presentation.assistant.theme.enabled", false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

