/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.impl.toolkit;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.platform.impl.toolkit.ClientGraphicsEnvironment;
import com.intellij.platform.impl.toolkit.HeadlessDummyGraphicsEnvironment;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import sun.awt.PlatformGraphicsInfo;
import sun.java2d.SunGraphicsEnvironment;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0013\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lcom/intellij/platform/impl/toolkit/IdeGraphicsEnvironment;", "Lsun/java2d/SunGraphicsEnvironment;", "<init>", "()V", "notifyDevicesChanged", "", "findGraphicsConfigurationFor", "Ljava/awt/GraphicsConfiguration;", "bounds", "Ljava/awt/Rectangle;", "getNumScreens", "", "makeScreenDevice", "Ljava/awt/GraphicsDevice;", "screennum", "isDisplayLocal", "", "getScreenDevices", "", "()[Ljava/awt/GraphicsDevice;", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class IdeGraphicsEnvironment
extends SunGraphicsEnvironment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final IdeGraphicsEnvironment instance = new IdeGraphicsEnvironment();

    public IdeGraphicsEnvironment() {
        System.setProperty("swing.bufferPerWindow", "true");
    }

    public final void notifyDevicesChanged() {
        this.displayChanger.notifyListeners();
    }

    @NotNull
    public final GraphicsConfiguration findGraphicsConfigurationFor(@NotNull Rectangle bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        return IdeGraphicsEnvironment.Companion.getClientInstance().findGraphicsConfigurationFor(bounds);
    }

    @Override
    protected int getNumScreens() {
        return IdeGraphicsEnvironment.Companion.getClientInstance().getNumScreens();
    }

    @Override
    @NotNull
    protected GraphicsDevice makeScreenDevice(int screennum) {
        return IdeGraphicsEnvironment.Companion.getClientInstance().makeScreenDevice(screennum);
    }

    @Override
    public boolean isDisplayLocal() {
        return false;
    }

    @Override
    @NotNull
    public GraphicsDevice[] getScreenDevices() {
        return IdeGraphicsEnvironment.Companion.getClientInstance().getScreenDevices();
    }

    @NotNull
    public static final IdeGraphicsEnvironment getInstance() {
        return Companion.getInstance();
    }

    public static final boolean isRealHeadless() {
        return Companion.isRealHeadless();
    }

    @JvmStatic
    private static final ClientGraphicsEnvironment getClientInstance() {
        return IdeGraphicsEnvironment.Companion.getClientInstance();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0003R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\n8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000b\u0010\u0003\u001a\u0004\b\t\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/intellij/platform/impl/toolkit/IdeGraphicsEnvironment$Companion;", "", "<init>", "()V", "instance", "Lcom/intellij/platform/impl/toolkit/IdeGraphicsEnvironment;", "getInstance$annotations", "getInstance", "()Lcom/intellij/platform/impl/toolkit/IdeGraphicsEnvironment;", "isRealHeadless", "", "isRealHeadless$annotations", "()Z", "getClientInstance", "Lcom/intellij/platform/impl/toolkit/ClientGraphicsEnvironment;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IdeGraphicsEnvironment getInstance() {
            return instance;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        public final boolean isRealHeadless() {
            return PlatformGraphicsInfo.getDefaultHeadlessProperty();
        }

        @JvmStatic
        public static /* synthetic */ void isRealHeadless$annotations() {
        }

        @JvmStatic
        private final ClientGraphicsEnvironment getClientInstance() {
            ClientGraphicsEnvironment clientGraphicsEnvironment;
            Application application = ApplicationManager.getApplication();
            if (application == null) {
                return HeadlessDummyGraphicsEnvironment.Companion.getInstance();
            }
            ClientAppSession clientAppSession = (ClientAppSession)CollectionsKt.firstOrNull((List)ClientSessionsManager.Companion.getAppSessions(ClientKind.CONTROLLER));
            if (clientAppSession == null && (clientAppSession = (ClientAppSession)CollectionsKt.firstOrNull((List)ClientSessionsManager.Companion.getAppSessions(ClientKind.LOCAL))) == null) {
                return HeadlessDummyGraphicsEnvironment.Companion.getInstance();
            }
            ClientAppSession session = clientAppSession;
            try {
                clientGraphicsEnvironment = ClientGraphicsEnvironment.Companion.getInstance(session);
            }
            catch (IllegalStateException ex) {
                clientGraphicsEnvironment = HeadlessDummyGraphicsEnvironment.Companion.getInstance();
            }
            ClientGraphicsEnvironment client2 = clientGraphicsEnvironment;
            if (!client2.isInitialized()) {
                return HeadlessDummyGraphicsEnvironment.Companion.getInstance();
            }
            return client2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

