/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.toolWindow;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.Splittable;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.SquareStripeButton;
import com.intellij.toolWindow.ResizeStripeManager;
import com.intellij.toolWindow.StripeButtonManager;
import com.intellij.toolWindow.ToolWindowNamesChangeKt;
import com.intellij.toolWindow.ToolWindowToolbar;
import com.intellij.ui.PopupHandler;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000E\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t*\u0001\u0007\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0010H\u0016J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\rH\u0002J\u0006\u0010\u001a\u001a\u00020\u0014J\b\u0010\u001b\u001a\u00020\u0014H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\nH\u0016J\b\u0010 \u001a\u00020\nH\u0016J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\nH\u0016J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/toolWindow/ResizeStripeManager;", "Lcom/intellij/openapi/ui/Splittable;", "myComponent", "Lcom/intellij/toolWindow/ToolWindowToolbar;", "<init>", "(Lcom/intellij/toolWindow/ToolWindowToolbar;)V", "mySplitter", "com/intellij/toolWindow/ResizeStripeManager$mySplitter$1", "Lcom/intellij/toolWindow/ResizeStripeManager$mySplitter$1;", "myIgnoreProportion", "", "myCalculateDelta", "myDelta", "", "myCustomWidth", "myCurrentScale", "", "createLayout", "Ljava/awt/BorderLayout;", "updateState", "", "toolbar", "setProportion", "proportion", "checkMinMax", "width", "updateNamedState", "updateView", "asComponent", "Ljava/awt/Component;", "getMinProportion", "first", "getOrientation", "setOrientation", "verticalSplit", "setDragging", "dragging", "Companion", "intellij.platform.ide.impl"})
public final class ResizeStripeManager
implements Splittable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ToolWindowToolbar myComponent;
    @NotNull
    private final mySplitter.1 mySplitter;
    private boolean myIgnoreProportion;
    private boolean myCalculateDelta;
    private int myDelta;
    private int myCustomWidth;
    private float myCurrentScale;

    public ResizeStripeManager(@NotNull ToolWindowToolbar myComponent) {
        Intrinsics.checkNotNullParameter((Object)myComponent, (String)"myComponent");
        this.myComponent = myComponent;
        this.mySplitter = new OnePixelDivider(this){

            protected boolean noDeepestComponent(MouseEvent e, Component deepestComponentAt) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getID() == 506 && this.myDragging) {
                    return false;
                }
                return super.noDeepestComponent(e, deepestComponentAt);
            }

            public void paint(Graphics g) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            }
        };
        this.myIgnoreProportion = true;
        this.myComponent.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component component2, int x, int y) {
                Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
                if (Companion.enabled()) {
                    AnAction anAction = ActionManager.getInstance().getAction("ToolWindowShowNamesAction");
                    Intrinsics.checkNotNull((Object)anAction);
                    AnAction action2 = anAction;
                    ActionGroup group2 = new ActionGroup(action2){
                        final /* synthetic */ AnAction $action;
                        {
                            this.$action = $action;
                        }

                        public AnAction[] getChildren(AnActionEvent e) {
                            AnAction[] anActionArray = new AnAction[]{this.$action};
                            return anActionArray;
                        }
                    };
                    Companion.showPopup(group2, component2, x, y);
                }
            }
        });
    }

    @NotNull
    public final BorderLayout createLayout() {
        return new BorderLayout(this){
            final /* synthetic */ ResizeStripeManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void addLayoutComponent(String name2, Component component2) {
                Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
                if (component2 != ResizeStripeManager.access$getMySplitter$p(this.this$0)) {
                    super.addLayoutComponent(name2, component2);
                }
            }

            public Dimension preferredLayoutSize(Container target) {
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                Dimension size2 = super.preferredLayoutSize(target);
                if (!(ResizeStripeManager.access$getMyCustomWidth$p(this.this$0) == 0 || ResizeStripeManager.access$getMyComponent$p(this.this$0).getTopStripe$intellij_platform_ide_impl().getButtons().isEmpty() && ResizeStripeManager.access$getMyComponent$p(this.this$0).getBottomStripe$intellij_platform_ide_impl().getButtons().isEmpty())) {
                    size2.width = ResizeStripeManager.access$getMyCustomWidth$p(this.this$0);
                }
                Intrinsics.checkNotNull((Object)size2);
                return size2;
            }

            public void layoutContainer(Container target) {
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                super.layoutContainer(target);
                if (ResizeStripeManager.access$getMySplitter$p(this.this$0).getParent() == target) {
                    int width = JBUI.scale((int)1);
                    ResizeStripeManager.access$getMySplitter$p(this.this$0).setBounds(Intrinsics.areEqual((Object)ResizeStripeManager.access$getMyComponent$p(this.this$0).getAnchor(), (Object)ToolWindowAnchor.LEFT) ? target.getWidth() - width : 0, 0, width, target.getHeight());
                }
            }
        };
    }

    public final void updateState(@Nullable ToolWindowToolbar toolbar2) {
        if (toolbar2 == null) {
            boolean enabled2 = Companion.isShowNames();
            if (enabled2) {
                this.myCustomWidth = Companion.getSideCustomWidth(this.myComponent.getAnchor());
                this.myCurrentScale = UISettings.Companion.getInstance().getCurrentIdeScale();
                this.myComponent.add((Component)((Object)this.mySplitter));
            } else {
                this.myCustomWidth = 0;
                this.myComponent.remove((Component)((Object)this.mySplitter));
            }
            this.mySplitter.setResizeEnabled(enabled2);
        } else {
            if (toolbar2 == this.myComponent || !Intrinsics.areEqual((Object)toolbar2.getAnchor(), (Object)this.myComponent.getAnchor())) {
                return;
            }
            this.myCustomWidth = Companion.getSideCustomWidth(this.myComponent.getAnchor());
            this.myCurrentScale = UISettings.Companion.getInstance().getCurrentIdeScale();
        }
        this.updateView();
    }

    public void setProportion(float proportion) {
        if (this.myIgnoreProportion) {
            return;
        }
        this.myIgnoreProportion = true;
        int fullWidth = this.myComponent.getParent().getWidth();
        int width = (int)((float)fullWidth * proportion);
        if (Intrinsics.areEqual((Object)this.myComponent.getAnchor(), (Object)ToolWindowAnchor.RIGHT)) {
            width = fullWidth - width;
        }
        if (this.myCalculateDelta) {
            this.myCalculateDelta = false;
            this.myDelta = this.myCustomWidth - width;
        }
        width += this.myDelta;
        this.myCustomWidth = width = this.checkMinMax(width);
        this.myCurrentScale = UISettings.Companion.getInstance().getCurrentIdeScale();
        Companion.setSideCustomWidth(this.myComponent, width);
        this.updateView();
    }

    private final int checkMinMax(int width) {
        int min = JBUI.scale((int)(UISettings.Companion.getInstance().getCompactMode() ? 33 : 40));
        if (width < min) {
            return min;
        }
        int max = JBUI.scale((int)100);
        if (width > max) {
            return max;
        }
        return width;
    }

    public final void updateNamedState() {
        float currentScale = UISettings.Companion.getInstance().getCurrentIdeScale();
        if (this.myCustomWidth == 0 && this.myCurrentScale == 0.0f) {
            this.myCustomWidth = Companion.getSideCustomWidth(this.myComponent.getAnchor());
            int width = this.checkMinMax(this.myCustomWidth);
            if (width != this.myCustomWidth) {
                this.myCustomWidth = width;
                Companion.setSideCustomWidth(this.myComponent, width);
            }
        } else if (!(this.myCurrentScale == currentScale)) {
            this.myCustomWidth = (int)((float)this.myCustomWidth * currentScale / this.myCurrentScale);
            Companion.setSideCustomWidth(this.myComponent, this.myCustomWidth);
        } else {
            return;
        }
        this.myCurrentScale = currentScale;
        this.updateView();
    }

    private final void updateView() {
        for (StripeButtonManager button2 : this.myComponent.getTopStripe$intellij_platform_ide_impl().getButtons()) {
            JComponent jComponent = button2.getComponent();
            Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.openapi.wm.impl.SquareStripeButton");
            ((SquareStripeButton)jComponent).setOrUpdateShowName(this.myCustomWidth > 0);
        }
        for (StripeButtonManager button2 : this.myComponent.getBottomStripe$intellij_platform_ide_impl().getButtons()) {
            JComponent jComponent = button2.getComponent();
            Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.openapi.wm.impl.SquareStripeButton");
            ((SquareStripeButton)jComponent).setOrUpdateShowName(this.myCustomWidth > 0);
        }
        this.myComponent.revalidate();
    }

    @NotNull
    public Component asComponent() {
        this.myIgnoreProportion = false;
        Container container = this.myComponent.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)container, (String)"getParent(...)");
        return container;
    }

    public float getMinProportion(boolean first) {
        return 0.0f;
    }

    public boolean getOrientation() {
        return false;
    }

    public void setOrientation(boolean verticalSplit) {
    }

    public void setDragging(boolean dragging) {
        this.myCalculateDelta = dragging;
        this.myDelta = 0;
    }

    public static final /* synthetic */ mySplitter.1 access$getMySplitter$p(ResizeStripeManager $this) {
        return $this.mySplitter;
    }

    public static final /* synthetic */ int access$getMyCustomWidth$p(ResizeStripeManager $this) {
        return $this.myCustomWidth;
    }

    public static final /* synthetic */ ToolWindowToolbar access$getMyComponent$p(ResizeStripeManager $this) {
        return $this.myComponent;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005J\u0006\u0010\n\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fJ&\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/toolWindow/ResizeStripeManager$Companion;", "", "<init>", "()V", "enabled", "", "isShowNames", "setShowNames", "", "value", "applyShowNames", "getSideCustomWidth", "", "side", "Lcom/intellij/openapi/wm/ToolWindowAnchor;", "setSideCustomWidth", "toolbar", "Lcom/intellij/toolWindow/ToolWindowToolbar;", "width", "showPopup", "group", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "component", "Ljava/awt/Component;", "x", "y", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean enabled() {
            return true;
        }

        public final boolean isShowNames() {
            return this.enabled() && UISettings.Companion.getInstance().getShowToolWindowsNames();
        }

        public final void setShowNames(boolean value) {
            UISettings.Companion.getInstance().setShowToolWindowsNames(value);
            this.applyShowNames();
        }

        public final void applyShowNames() {
            UISettings uiSettings = UISettings.Companion.getInstance();
            boolean newValue = uiSettings.getShowToolWindowsNames();
            int defaultWidth = newValue ? JBUI.scale((int)59) : 0;
            uiSettings.setToolWindowLeftSideCustomWidth(defaultWidth);
            uiSettings.setToolWindowRightSideCustomWidth(defaultWidth);
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            for (Project project2 : projectArray) {
                ToolWindowManagerEx.Companion.getInstanceEx(project2).setShowNames(newValue);
            }
            ToolWindowNamesChangeKt.showToolWindowNamesChanged(newValue);
        }

        public final int getSideCustomWidth(@NotNull ToolWindowAnchor side) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            if (Intrinsics.areEqual((Object)side, (Object)ToolWindowAnchor.LEFT)) {
                return UISettings.Companion.getInstance().getToolWindowLeftSideCustomWidth();
            }
            if (Intrinsics.areEqual((Object)side, (Object)ToolWindowAnchor.RIGHT)) {
                return UISettings.Companion.getInstance().getToolWindowRightSideCustomWidth();
            }
            return 0;
        }

        public final void setSideCustomWidth(@NotNull ToolWindowToolbar toolbar2, int width) {
            Intrinsics.checkNotNullParameter((Object)toolbar2, (String)"toolbar");
            Project[] projectArray = toolbar2.getAnchor();
            if (Intrinsics.areEqual((Object)projectArray, (Object)ToolWindowAnchor.LEFT)) {
                UISettings.Companion.getInstance().setToolWindowLeftSideCustomWidth(width);
            } else if (Intrinsics.areEqual((Object)projectArray, (Object)ToolWindowAnchor.RIGHT)) {
                UISettings.Companion.getInstance().setToolWindowRightSideCustomWidth(width);
            }
            Project[] projectArray2 = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray2, (String)"getOpenProjects(...)");
            for (Project project2 : projectArray2) {
                ToolWindowManagerEx.Companion.getInstanceEx(project2).setSideCustomWidth(toolbar2, width);
            }
        }

        public final void showPopup(@NotNull ActionGroup group2, @NotNull Component component2, int x, int y) {
            Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            ActionPopupMenu actionPopupMenu = ActionManager.getInstance().createActionPopupMenu("ToolwindowPopup", group2);
            Intrinsics.checkNotNullExpressionValue((Object)actionPopupMenu, (String)"createActionPopupMenu(...)");
            ActionPopupMenu popupMenu = actionPopupMenu;
            popupMenu.getComponent().show(component2, x, y);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

