/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.toolWindow;

import com.intellij.accessibility.AccessibilityUtils;
import com.intellij.openapi.application.impl.BorderPainterHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.AbstractDroppableStripe;
import com.intellij.openapi.wm.impl.LayoutData;
import com.intellij.openapi.wm.impl.SquareStripeButton;
import com.intellij.toolWindow.MoreSquareStripeButton;
import com.intellij.toolWindow.ResizeStripeManager;
import com.intellij.toolWindow.StripeButtonManager;
import com.intellij.ui.BorderPainter;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.DefaultBorderPainter;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u0000 V2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0003VWXB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010)\u001a\u00020\"H\u0014J\b\u0010*\u001a\u00020\"H\u0002J\u001b\u0010+\u001a\u00020\"2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\"0!H\u0000\u00a2\u0006\u0002\b-J\u000e\u0010.\u001a\u00020\"2\u0006\u0010/\u001a\u000200J\u0010\u00101\u001a\u00020\"2\b\u00102\u001a\u0004\u0018\u00010\u0000J\u0006\u00103\u001a\u00020\"J\b\u00104\u001a\u000205H\u0016J\n\u00106\u001a\u0004\u0018\u000107H\u0016J\u0010\u00108\u001a\u00020\"2\u0006\u00109\u001a\u00020:H\u0016J\u0015\u0010;\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0006H \u00a2\u0006\u0002\b<J\u0017\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010?\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b@J\u0017\u0010;\u001a\u0004\u0018\u00010\u00132\u0006\u0010A\u001a\u00020BH\u0010\u00a2\u0006\u0002\b<J\u0006\u0010C\u001a\u00020\u0004J\u0006\u0010\u001e\u001a\u00020\u0004J\u0006\u0010D\u001a\u00020\"J\u0006\u0010E\u001a\u00020\"J\u0006\u0010F\u001a\u00020\"J3\u0010G\u001a\u00020\"2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020M2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\"0!H\u0000\u00a2\u0006\u0002\bOJ\b\u0010T\u001a\u00020UH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0013X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\u0013X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0012\u0010\u0018\u001a\u00020\u0019X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u00020$X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0019\u0010P\u001a\u00070\r\u00a2\u0006\u0002\bQ8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\bR\u0010S\u00a8\u0006Y"}, d2={"Lcom/intellij/toolWindow/ToolWindowToolbar;", "Lcom/intellij/ui/components/JBPanel;", "Lcom/intellij/openapi/application/impl/BorderPainterHolder;", "isPrimary", "", "anchor", "Lcom/intellij/openapi/wm/ToolWindowAnchor;", "<init>", "(ZLcom/intellij/openapi/wm/ToolWindowAnchor;)V", "getAnchor", "()Lcom/intellij/openapi/wm/ToolWindowAnchor;", "defaults", "", "", "getDefaults", "()Ljava/util/List;", "setDefaults", "(Ljava/util/List;)V", "bottomStripe", "Lcom/intellij/openapi/wm/impl/AbstractDroppableStripe;", "getBottomStripe$intellij_platform_ide_impl", "()Lcom/intellij/openapi/wm/impl/AbstractDroppableStripe;", "topStripe", "getTopStripe$intellij_platform_ide_impl", "moreButton", "Lcom/intellij/toolWindow/MoreSquareStripeButton;", "getMoreButton$intellij_platform_ide_impl", "()Lcom/intellij/toolWindow/MoreSquareStripeButton;", "myResizeManager", "Lcom/intellij/toolWindow/ResizeStripeManager;", "hasVisibleButtons", "visibleButtonsListeners", "", "Lkotlin/Function0;", "", "borderPainter", "Lcom/intellij/ui/BorderPainter;", "getBorderPainter", "()Lcom/intellij/ui/BorderPainter;", "setBorderPainter", "(Lcom/intellij/ui/BorderPainter;)V", "init", "updateVisibleButtons", "addVisibleButtonsListener", "listener", "addVisibleButtonsListener$intellij_platform_ide_impl", "initMoreButton", "project", "Lcom/intellij/openapi/project/Project;", "updateResizeState", "toolbar", "updateNamedState", "createBorder", "Ljavax/swing/border/Border;", "getBorderColor", "Ljava/awt/Color;", "paint", "g", "Ljava/awt/Graphics;", "getStripeFor", "getStripeFor$intellij_platform_ide_impl", "getButtonFor", "Lcom/intellij/toolWindow/StripeButtonManager;", "toolWindowId", "getButtonFor$intellij_platform_ide_impl", "screenPoint", "Ljava/awt/Point;", "hasButtons", "reset", "startDrag", "stopDrag", "tryDroppingOnGap", "data", "Lcom/intellij/openapi/wm/impl/LayoutData;", "gap", "", "dropRectangle", "Ljava/awt/Rectangle;", "doLayout", "tryDroppingOnGap$intellij_platform_ide_impl", "accessibleGroupName", "Lcom/intellij/openapi/util/NlsSafe;", "getAccessibleGroupName", "()Ljava/lang/String;", "getAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "Companion", "StripeV2", "AccessibleToolWindowToolbar", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nToolWindowToolbar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolWindowToolbar.kt\ncom/intellij/toolWindow/ToolWindowToolbar\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,307:1\n1869#2,2:308\n1#3:310\n*S KotlinDebug\n*F\n+ 1 ToolWindowToolbar.kt\ncom/intellij/toolWindow/ToolWindowToolbar\n*L\n84#1:308,2\n*E\n"})
public abstract class ToolWindowToolbar
extends JBPanel<ToolWindowToolbar>
implements BorderPainterHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isPrimary;
    @NotNull
    private final ToolWindowAnchor anchor;
    public List<String> defaults;
    @NotNull
    private final ResizeStripeManager myResizeManager;
    private boolean hasVisibleButtons;
    @NotNull
    private final List<Function0<Unit>> visibleButtonsListeners;
    @NotNull
    private BorderPainter borderPainter;

    public ToolWindowToolbar(boolean isPrimary, @NotNull ToolWindowAnchor anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        this.isPrimary = isPrimary;
        this.anchor = anchor;
        this.myResizeManager = new ResizeStripeManager(this);
        this.visibleButtonsListeners = new ArrayList();
        this.borderPainter = new DefaultBorderPainter();
    }

    @NotNull
    public final ToolWindowAnchor getAnchor() {
        return this.anchor;
    }

    @NotNull
    public final List<String> getDefaults() {
        List<String> list2 = this.defaults;
        if (list2 != null) {
            return list2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"defaults");
        return null;
    }

    public final void setDefaults(@NotNull List<String> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.defaults = list2;
    }

    @NotNull
    public abstract AbstractDroppableStripe getBottomStripe$intellij_platform_ide_impl();

    @NotNull
    public abstract AbstractDroppableStripe getTopStripe$intellij_platform_ide_impl();

    @NotNull
    public abstract MoreSquareStripeButton getMoreButton$intellij_platform_ide_impl();

    @Override
    @NotNull
    public BorderPainter getBorderPainter() {
        return this.borderPainter;
    }

    @Override
    public void setBorderPainter(@NotNull BorderPainter borderPainter) {
        Intrinsics.checkNotNullParameter((Object)borderPainter, (String)"<set-?>");
        this.borderPainter = borderPainter;
    }

    protected void init() {
        JBPanel jBPanel;
        this.setLayout(this.myResizeManager.createLayout());
        this.setOpaque(true);
        this.setBackground(JBUI.CurrentTheme.ToolWindow.stripeBackground());
        JBPanel $this$init_u24lambda_u240 = jBPanel = new JBPanel((LayoutManager)new BorderLayout());
        boolean bl = false;
        $this$init_u24lambda_u240.setBorder(JBUI.Borders.customLineTop((Color)JBUI.CurrentTheme.MainToolbar.borderColor()));
        JBPanel topWrapper = jBPanel;
        this.setBorder(this.createBorder());
        this.getTopStripe$intellij_platform_ide_impl().setBackground(JBUI.CurrentTheme.ToolWindow.stripeBackground());
        this.getBottomStripe$intellij_platform_ide_impl().setBackground(JBUI.CurrentTheme.ToolWindow.stripeBackground());
        topWrapper.setBackground(JBUI.CurrentTheme.ToolWindow.stripeBackground());
        topWrapper.add((Component)((Object)this.getTopStripe$intellij_platform_ide_impl()), (Object)"North");
        this.add((Component)topWrapper, "North");
        this.add((Component)((Object)this.getBottomStripe$intellij_platform_ide_impl()), "South");
        this.getTopStripe$intellij_platform_ide_impl().addButtonAddedRemovedListener$intellij_platform_ide_impl((Function0<Unit>)((Function0)() -> ToolWindowToolbar.init$lambda$1(this)));
        this.getBottomStripe$intellij_platform_ide_impl().addButtonAddedRemovedListener$intellij_platform_ide_impl((Function0<Unit>)((Function0)() -> ToolWindowToolbar.init$lambda$2(this)));
        this.getMoreButton$intellij_platform_ide_impl().addComponentListener(new ComponentAdapter(this){
            final /* synthetic */ ToolWindowToolbar this$0;
            {
                this.this$0 = $receiver;
            }

            public void componentShown(ComponentEvent e) {
                ToolWindowToolbar.access$updateVisibleButtons(this.this$0);
            }

            public void componentHidden(ComponentEvent e) {
                ToolWindowToolbar.access$updateVisibleButtons(this.this$0);
            }
        });
        this.updateVisibleButtons();
    }

    private final void updateVisibleButtons() {
        boolean hasVisibleButtons;
        boolean bl = hasVisibleButtons = this.hasButtons() || this.getMoreButton$intellij_platform_ide_impl().isVisible();
        if (this.hasVisibleButtons != hasVisibleButtons) {
            this.hasVisibleButtons = hasVisibleButtons;
            Iterable $this$forEach$iv = this.visibleButtonsListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function0 it = (Function0)element$iv;
                boolean bl2 = false;
                it.invoke();
            }
        }
    }

    public final void addVisibleButtonsListener$intellij_platform_ide_impl(@NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.visibleButtonsListeners.add(listener2);
    }

    public final void initMoreButton(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (this.isPrimary) {
            Container container = this.getTopStripe$intellij_platform_ide_impl().getParent();
            if (container != null) {
                container.add((Component)this.getMoreButton$intellij_platform_ide_impl(), "Center");
            }
            this.getMoreButton$intellij_platform_ide_impl().updateState(project2);
        }
    }

    public final void updateResizeState(@Nullable ToolWindowToolbar toolbar2) {
        this.myResizeManager.updateState(toolbar2);
    }

    public final void updateNamedState() {
        if (this.isVisible() && ResizeStripeManager.Companion.isShowNames()) {
            this.myResizeManager.updateNamedState();
        }
    }

    @NotNull
    public Border createBorder() {
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty();
        Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"empty(...)");
        return (Border)jBEmptyBorder;
    }

    @Nullable
    public Color getBorderColor() {
        return JBUI.CurrentTheme.ToolWindow.borderColor();
    }

    public void paint(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paint(g);
        this.getBorderPainter().paintAfterChildren((JComponent)((Object)this), g);
    }

    @NotNull
    public abstract AbstractDroppableStripe getStripeFor$intellij_platform_ide_impl(@NotNull ToolWindowAnchor var1);

    @Nullable
    public final StripeButtonManager getButtonFor$intellij_platform_ide_impl(@NotNull String toolWindowId) {
        StripeButtonManager stripeButtonManager;
        Object v0;
        StripeButtonManager it;
        Iterable iterable;
        block3: {
            Intrinsics.checkNotNullParameter((Object)toolWindowId, (String)"toolWindowId");
            iterable = this.getTopStripe$intellij_platform_ide_impl().getButtons();
            for (Object t : iterable) {
                it = (StripeButtonManager)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)toolWindowId)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        if ((stripeButtonManager = (StripeButtonManager)v0) == null) {
            Object v2;
            block4: {
                iterable = this.getBottomStripe$intellij_platform_ide_impl().getButtons();
                for (Object t : iterable) {
                    it = (StripeButtonManager)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)toolWindowId)) continue;
                    v2 = t;
                    break block4;
                }
                v2 = null;
            }
            stripeButtonManager = v2;
        }
        return stripeButtonManager;
    }

    @Nullable
    public AbstractDroppableStripe getStripeFor$intellij_platform_ide_impl(@NotNull Point screenPoint) {
        Intrinsics.checkNotNullParameter((Object)screenPoint, (String)"screenPoint");
        if (!this.isShowing()) {
            return null;
        }
        if (this.getTopStripe$intellij_platform_ide_impl().containsPoint(screenPoint)) {
            return this.getTopStripe$intellij_platform_ide_impl();
        }
        if (this.getBottomStripe$intellij_platform_ide_impl().containsPoint(screenPoint)) {
            return this.getBottomStripe$intellij_platform_ide_impl();
        }
        return null;
    }

    public final boolean hasButtons() {
        return !((Collection)this.getTopStripe$intellij_platform_ide_impl().getButtons()).isEmpty() || !((Collection)this.getBottomStripe$intellij_platform_ide_impl().getButtons()).isEmpty();
    }

    public final boolean hasVisibleButtons() {
        return this.hasVisibleButtons;
    }

    public final void reset() {
        this.getTopStripe$intellij_platform_ide_impl().reset();
        this.getBottomStripe$intellij_platform_ide_impl().reset();
    }

    public final void startDrag() {
        this.revalidate();
        this.repaint();
    }

    public final void stopDrag() {
        this.startDrag();
    }

    public final void tryDroppingOnGap$intellij_platform_ide_impl(@NotNull LayoutData data2, int gap, @NotNull Rectangle dropRectangle, @NotNull Function0<Unit> doLayout) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)dropRectangle, (String)"dropRectangle");
        Intrinsics.checkNotNullParameter(doLayout, (String)"doLayout");
        int sideDistance = data2.eachY + gap - dropRectangle.y + dropRectangle.height;
        if (sideDistance > 0) {
            data2.dragInsertPosition = -1;
            data2.dragToSide = false;
            data2.dragTargetChosen = true;
            doLayout.invoke();
        }
    }

    @NotNull
    protected String getAccessibleGroupName() {
        String string = UIBundle.message((String)"toolbar.group.default.accessible.group.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleToolWindowToolbar();
        }
        this.accessibleContext.setAccessibleName(this.getAccessibleGroupName());
        AccessibleContext accessibleContext = this.accessibleContext;
        Intrinsics.checkNotNullExpressionValue((Object)accessibleContext, (String)"accessibleContext");
        return accessibleContext;
    }

    private static final Unit init$lambda$1(ToolWindowToolbar this$0) {
        this$0.updateVisibleButtons();
        return Unit.INSTANCE;
    }

    private static final Unit init$lambda$2(ToolWindowToolbar this$0) {
        this$0.updateVisibleButtons();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$updateVisibleButtons(ToolWindowToolbar $this) {
        $this.updateVisibleButtons();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/toolWindow/ToolWindowToolbar$AccessibleToolWindowToolbar;", "Ljavax/swing/JPanel$AccessibleJPanel;", "Ljavax/swing/JPanel;", "<init>", "(Lcom/intellij/toolWindow/ToolWindowToolbar;)V", "getAccessibleRole", "Ljavax/accessibility/AccessibleRole;", "intellij.platform.ide.impl"})
    private final class AccessibleToolWindowToolbar
    extends JPanel.AccessibleJPanel {
        public AccessibleToolWindowToolbar() {
            super((JPanel)((Object)ToolWindowToolbar.this));
        }

        @Override
        @NotNull
        public AccessibleRole getAccessibleRole() {
            return AccessibilityUtils.GROUPED_ELEMENTS;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001d\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/intellij/toolWindow/ToolWindowToolbar$Companion;", "", "<init>", "()V", "updateButtons", "", "panel", "Ljavax/swing/JComponent;", "remove", "Lcom/intellij/openapi/wm/impl/AbstractDroppableStripe;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "remove$intellij_platform_ide_impl", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nToolWindowToolbar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolWindowToolbar.kt\ncom/intellij/toolWindow/ToolWindowToolbar$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,307:1\n1869#2,2:308\n1400#3,2:310\n*S KotlinDebug\n*F\n+ 1 ToolWindowToolbar.kt\ncom/intellij/toolWindow/ToolWindowToolbar$Companion\n*L\n164#1:308,2\n170#1:310,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void updateButtons(@NotNull JComponent panel2) {
            Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
            List list2 = ComponentUtil.findComponentsOfType((JComponent)panel2, SquareStripeButton.class);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"findComponentsOfType(...)");
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SquareStripeButton it = (SquareStripeButton)element$iv;
                boolean bl = false;
                it.update();
            }
            panel2.revalidate();
            panel2.repaint();
        }

        public final void remove$intellij_platform_ide_impl(@NotNull AbstractDroppableStripe panel2, @NotNull ToolWindow toolWindow2) {
            Object object;
            block2: {
                Intrinsics.checkNotNullParameter((Object)((Object)panel2), (String)"panel");
                Intrinsics.checkNotNullParameter((Object)toolWindow2, (String)"toolWindow");
                Component[] componentArray = panel2.getComponents();
                Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
                Object[] $this$firstOrNull$iv = componentArray;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Component it = (Component)element$iv;
                    boolean bl = false;
                    if (!(it instanceof SquareStripeButton && Intrinsics.areEqual((Object)((SquareStripeButton)it).getToolWindow().getId(), (Object)toolWindow2.getId()))) continue;
                    object = element$iv;
                    break block2;
                }
                object = null;
            }
            Component component2 = (Component)object;
            if (component2 == null) {
                return;
            }
            Component component3 = component2;
            panel2.remove(component3);
            panel2.revalidate();
            panel2.repaint();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u0019\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\tH\u0002J\b\u0010!\u001a\u00020\u001fH\u0002J\b\u0010\"\u001a\u00020#H\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u0005H\u0016J \u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020\u001fH\u0014J\b\u0010-\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0011\u00a8\u0006."}, d2={"Lcom/intellij/toolWindow/ToolWindowToolbar$StripeV2;", "Lcom/intellij/openapi/wm/impl/AbstractDroppableStripe;", "toolBar", "Lcom/intellij/toolWindow/ToolWindowToolbar;", "paneId", "", "anchor", "Lcom/intellij/openapi/wm/ToolWindowAnchor;", "split", "", "layout", "Ljava/awt/LayoutManager;", "<init>", "(Lcom/intellij/toolWindow/ToolWindowToolbar;Ljava/lang/String;Lcom/intellij/openapi/wm/ToolWindowAnchor;ZLjava/awt/LayoutManager;)V", "getAnchor", "()Lcom/intellij/openapi/wm/ToolWindowAnchor;", "getSplit", "()Z", "bottomAnchorDropAreaComponent", "Ljavax/swing/JComponent;", "getBottomAnchorDropAreaComponent", "()Ljavax/swing/JComponent;", "setBottomAnchorDropAreaComponent", "(Ljavax/swing/JComponent;)V", "isNewStripes", "getDropToSide", "()Ljava/lang/Boolean;", "containsPoint", "screenPoint", "Ljava/awt/Point;", "getFirstVisibleToolWindowSize", "", "width", "getStatusBarHeight", "getToolWindowDropAreaScreenBounds", "Ljava/awt/Rectangle;", "getButtonFor", "Lcom/intellij/toolWindow/StripeButtonManager;", "toolWindowId", "tryDroppingOnGap", "", "data", "Lcom/intellij/openapi/wm/impl/LayoutData;", "gap", "insertOrder", "toString", "intellij.platform.ide.impl"})
    public static final class StripeV2
    extends AbstractDroppableStripe {
        @NotNull
        private final ToolWindowToolbar toolBar;
        @NotNull
        private final ToolWindowAnchor anchor;
        private final boolean split;
        @Nullable
        private JComponent bottomAnchorDropAreaComponent;

        public StripeV2(@NotNull ToolWindowToolbar toolBar, @NotNull String paneId, @NotNull ToolWindowAnchor anchor, boolean split, @NotNull LayoutManager layout2) {
            Intrinsics.checkNotNullParameter((Object)toolBar, (String)"toolBar");
            Intrinsics.checkNotNullParameter((Object)paneId, (String)"paneId");
            Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
            Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
            super(paneId, layout2);
            this.toolBar = toolBar;
            this.anchor = anchor;
            this.split = split;
        }

        public /* synthetic */ StripeV2(ToolWindowToolbar toolWindowToolbar, String string, ToolWindowAnchor toolWindowAnchor, boolean bl, LayoutManager layoutManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                bl = false;
            }
            if ((n & 0x10) != 0) {
                layoutManager = (LayoutManager)new VerticalFlowLayout(0, 0);
            }
            this(toolWindowToolbar, string, toolWindowAnchor, bl, layoutManager);
        }

        @Override
        @NotNull
        public ToolWindowAnchor getAnchor() {
            return this.anchor;
        }

        @Override
        public boolean getSplit() {
            return this.split;
        }

        @Nullable
        public final JComponent getBottomAnchorDropAreaComponent() {
            return this.bottomAnchorDropAreaComponent;
        }

        public final void setBottomAnchorDropAreaComponent(@Nullable JComponent jComponent) {
            this.bottomAnchorDropAreaComponent = jComponent;
        }

        @Override
        public boolean isNewStripes() {
            return true;
        }

        @Override
        @NotNull
        public Boolean getDropToSide() {
            if (this.getSplit()) {
                return true;
            }
            Boolean dropToSide = super.getDropToSide();
            if (dropToSide == null) {
                return false;
            }
            return dropToSide;
        }

        @Override
        public boolean containsPoint(@NotNull Point screenPoint) {
            Intrinsics.checkNotNullParameter((Object)screenPoint, (String)"screenPoint");
            if (Intrinsics.areEqual((Object)this.getAnchor(), (Object)ToolWindowAnchor.LEFT) || Intrinsics.areEqual((Object)this.getAnchor(), (Object)ToolWindowAnchor.RIGHT)) {
                if (!this.toolBar.isShowing()) {
                    Rectangle bounds = new Rectangle(this.getRootPane().getLocationOnScreen(), this.getRootPane().getSize());
                    bounds.height /= 2;
                    int toolWindowWidth = this.getFirstVisibleToolWindowSize(true);
                    if (Intrinsics.areEqual((Object)this.getAnchor(), (Object)ToolWindowAnchor.RIGHT)) {
                        bounds.x = bounds.x + bounds.width - toolWindowWidth;
                    }
                    bounds.width = toolWindowWidth;
                    return bounds.contains(screenPoint);
                }
                Rectangle bounds = new Rectangle(this.toolBar.getLocationOnScreen(), this.toolBar.getSize());
                bounds.height /= 2;
                int toolWindowWidth = this.getFirstVisibleToolWindowSize(true);
                bounds.width += toolWindowWidth;
                if (Intrinsics.areEqual((Object)this.getAnchor(), (Object)ToolWindowAnchor.RIGHT)) {
                    bounds.x -= toolWindowWidth;
                }
                return bounds.contains(screenPoint);
            }
            if (Intrinsics.areEqual((Object)this.getAnchor(), (Object)ToolWindowAnchor.BOTTOM)) {
                Rectangle rootBounds = new Rectangle(this.getRootPane().getLocationOnScreen(), this.getRootPane().getSize());
                int toolWindowHeight = Math.max(this.getFirstVisibleToolWindowSize(false), this.getHeight() + JBUI.scale((int)40));
                Rectangle bounds = new Rectangle(rootBounds.x, rootBounds.y + rootBounds.height - toolWindowHeight - this.getStatusBarHeight(), rootBounds.width / 2, toolWindowHeight);
                if (this.getSplit()) {
                    bounds.x += bounds.width;
                }
                return bounds.contains(screenPoint);
            }
            return super.containsPoint(screenPoint);
        }

        private final int getFirstVisibleToolWindowSize(boolean width) {
            for (StripeButtonManager button2 : this.getButtons()) {
                if (!button2.getToolWindow().isVisible()) continue;
                if (width) {
                    return (int)((float)this.getRootPane().getWidth() * button2.getWindowDescriptor().getWeight());
                }
                return (int)((float)this.getRootPane().getHeight() * button2.getWindowDescriptor().getWeight());
            }
            return JBUI.scale((int)350);
        }

        private final int getStatusBarHeight() {
            JComponent component2;
            StatusBar statusBar = WindowManager.getInstance().getStatusBar((Component)((Object)this), null);
            if (statusBar != null && (component2 = statusBar.getComponent()) != null && component2.isVisible()) {
                return component2.getHeight();
            }
            return 0;
        }

        @Override
        @NotNull
        public Rectangle getToolWindowDropAreaScreenBounds() {
            Dimension size2 = this.toolBar.getSize();
            if (Intrinsics.areEqual((Object)this.getAnchor(), (Object)ToolWindowAnchor.LEFT)) {
                Point locationOnScreen = this.toolBar.getLocationOnScreen();
                return new Rectangle(locationOnScreen.x + size2.width, locationOnScreen.y, this.getFirstVisibleToolWindowSize(true), size2.height);
            }
            if (Intrinsics.areEqual((Object)this.getAnchor(), (Object)ToolWindowAnchor.RIGHT)) {
                Point locationOnScreen = this.toolBar.getLocationOnScreen();
                int toolWindowSize = this.getFirstVisibleToolWindowSize(true);
                return new Rectangle(locationOnScreen.x - toolWindowSize, locationOnScreen.y, toolWindowSize, size2.height);
            }
            if (Intrinsics.areEqual((Object)this.getAnchor(), (Object)ToolWindowAnchor.BOTTOM)) {
                JComponent jComponent = this.bottomAnchorDropAreaComponent;
                if (jComponent == null) {
                    jComponent = this.getRootPane();
                }
                JComponent pane2 = jComponent;
                Rectangle rootBounds = new Rectangle(pane2.getLocationOnScreen(), pane2.getSize());
                int toolWindowHeight = this.getFirstVisibleToolWindowSize(false);
                return new Rectangle(rootBounds.x, rootBounds.y + rootBounds.height - toolWindowHeight, rootBounds.width, toolWindowHeight);
            }
            return super.getToolWindowDropAreaScreenBounds();
        }

        @Override
        @Nullable
        public StripeButtonManager getButtonFor(@NotNull String toolWindowId) {
            Intrinsics.checkNotNullParameter((Object)toolWindowId, (String)"toolWindowId");
            return this.toolBar.getButtonFor$intellij_platform_ide_impl(toolWindowId);
        }

        @Override
        protected void tryDroppingOnGap(@NotNull LayoutData data2, int gap, int insertOrder) {
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            this.toolBar.tryDroppingOnGap$intellij_platform_ide_impl(data2, gap, this.getDropRectangle(), (Function0<Unit>)((Function0)() -> StripeV2.tryDroppingOnGap$lambda$0(this, data2, gap)));
        }

        @NotNull
        public String toString() {
            return "StripeNewUi(anchor=" + this.getAnchor() + ")";
        }

        private static final Unit tryDroppingOnGap$lambda$0(StripeV2 this$0, LayoutData $data, int $gap) {
            this$0.layoutDragButton($data, $gap);
            return Unit.INSTANCE;
        }
    }
}

