/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.toolWindow.xNext.toolbar.data;

import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.actions.ToolWindowsGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.toolWindow.xNext.toolbar.data.XNextPinnedService;
import com.intellij.toolWindow.xNext.toolbar.data.XNextToolbarManager;
import com.intellij.toolWindow.xNext.toolbar.data.XNextToolbarState;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 )2\u00020\u0001:\u0001)B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001dH\u0002J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0012H\u0002J\b\u0010!\u001a\u00020\u0012H\u0002J \u0010\u001c\u001a\u00020\u001d2\u0016\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020\u00100#j\b\u0012\u0004\u0012\u00020\u0010`$H\u0016J\u0018\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020(H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006*"}, d2={"Lcom/intellij/toolWindow/xNext/toolbar/data/XNextToolbarManagerImpl;", "Lcom/intellij/toolWindow/xNext/toolbar/data/XNextToolbarManager;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "toolWindowManager", "Lcom/intellij/openapi/wm/impl/ToolWindowManagerImpl;", "pinnedList", "", "", "xNextToolbarState", "Lcom/intellij/toolWindow/xNext/toolbar/data/XNextToolbarState;", "getXNextToolbarState", "()Lcom/intellij/toolWindow/xNext/toolbar/data/XNextToolbarState;", "currentState", "flow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "pinnedService", "Lcom/intellij/toolWindow/xNext/toolbar/data/XNextPinnedService;", "getPinnedService", "()Lcom/intellij/toolWindow/xNext/toolbar/data/XNextPinnedService;", "updatePinned", "", "updateState", "setState", "state", "getCurrentState", "linkSet", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "setPinned", "id", "pinned", "", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nXNextToolbarManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XNextToolbarManagerImpl.kt\ncom/intellij/toolWindow/xNext/toolbar/data/XNextToolbarManagerImpl\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n30#2,2:144\n1563#3:146\n1634#3,3:147\n774#3:150\n865#3,2:151\n1563#3:153\n1634#3,3:154\n774#3:157\n865#3,2:158\n774#3:160\n865#3,2:161\n774#3:163\n865#3,2:164\n*S KotlinDebug\n*F\n+ 1 XNextToolbarManagerImpl.kt\ncom/intellij/toolWindow/xNext/toolbar/data/XNextToolbarManagerImpl\n*L\n43#1:144,2\n62#1:146\n62#1:147,3\n64#1:150\n64#1:151,2\n70#1:153\n70#1:154,3\n71#1:157\n71#1:158,2\n72#1:160\n72#1:161,2\n75#1:163\n75#1:164,2\n*E\n"})
public final class XNextToolbarManagerImpl
implements XNextToolbarManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final ToolWindowManagerImpl toolWindowManager;
    @NotNull
    private List<String> pinnedList;
    @NotNull
    private XNextToolbarState currentState;
    @NotNull
    private MutableStateFlow<XNextToolbarState> flow;
    private static final int MAX_RECENT_COUNT = 3;
    @NotNull
    private static final List<ToolWindowManagerListener.ToolWindowManagerEventType> actEvent;
    @NotNull
    private static final List<ToolWindowManagerListener.ToolWindowManagerEventType> regEvent;

    public XNextToolbarManagerImpl(@NotNull Project project2, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project2;
        this.scope = scope;
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(this.project);
        Intrinsics.checkNotNull((Object)toolWindowManager, (String)"null cannot be cast to non-null type com.intellij.openapi.wm.impl.ToolWindowManagerImpl");
        this.toolWindowManager = (ToolWindowManagerImpl)toolWindowManager;
        this.pinnedList = CollectionsKt.emptyList();
        this.currentState = XNextToolbarState.Companion.getEMPTY();
        this.flow = StateFlowKt.MutableStateFlow((Object)this.currentState);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Topic<ToolWindowManagerListener> topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ToolWindowManagerListener(){

            @Override
            public void stateChanged(ToolWindowManager toolWindowManager, ToolWindowManagerListener.ToolWindowManagerEventType changeType) {
                Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                Intrinsics.checkNotNullParameter((Object)((Object)changeType), (String)"changeType");
                if (!(toolWindowManager instanceof ToolWindowManagerImpl)) {
                    return;
                }
                if (regEvent.contains((Object)changeType)) {
                    this.updatePinned();
                } else if (actEvent.contains((Object)changeType)) {
                    this.updateState();
                }
            }
        });
        this.updatePinned();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final CoroutineScope getScope() {
        return this.scope;
    }

    @Override
    @NotNull
    public XNextToolbarState getXNextToolbarState() {
        return this.currentState;
    }

    private final XNextPinnedService getPinnedService() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        ComponentManager $this$service$iv = (ComponentManager)application;
        boolean $i$f$service = false;
        Class<XNextPinnedService> serviceClass$iv = XNextPinnedService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (XNextPinnedService)object;
    }

    /*
     * WARNING - void declaration
     */
    public final void updatePinned() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String it;
        Object object;
        void $this$mapTo$iv$iv;
        List<ActivateToolWindowAction> list2 = ToolWindowsGroup.getToolWindowActions(this.project, false);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getToolWindowActions(...)");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ActivateToolWindowAction activateToolWindowAction = (ActivateToolWindowAction)((Object)item$iv$iv);
            object = destination$iv$iv;
            boolean bl = false;
            object.add(((ActivateToolWindowAction)((Object)it)).getToolWindowId());
        }
        List toolWindowIds = (List)destination$iv$iv;
        $this$map$iv = this.getPinnedService().getListOfPinnedIds();
        object = this;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!toolWindowIds.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        ((XNextToolbarManagerImpl)object).pinnedList = (List)destination$iv$iv;
        this.updateState();
    }

    /*
     * WARNING - void declaration
     */
    private final void updateState() {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        void $this$filterTo$iv$iv3;
        void $this$mapTo$iv$iv;
        List<ActivateToolWindowAction> list2 = ToolWindowsGroup.getToolWindowActions(this.project, false);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getToolWindowActions(...)");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ActivateToolWindowAction activateToolWindowAction = (ActivateToolWindowAction)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getToolWindowId());
        }
        List toolWindowIds = (List)destination$iv$iv;
        Iterable $this$filter$iv = this.toolWindowManager.getRecentToolWindows();
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv3) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!toolWindowIds.contains(it)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List allRecentIds = (List)destination$iv$iv2;
        Iterable $this$filter$iv2 = this.pinnedList;
        boolean $i$f$filter2 = false;
        destination$iv$iv2 = $this$filter$iv2;
        Iterable destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!toolWindowIds.contains(it)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List pinned = (List)destination$iv$iv3;
        Iterable $this$filter$iv3 = allRecentIds;
        boolean $i$f$filter3 = false;
        destination$iv$iv3 = $this$filter$iv3;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!pinned.contains(it))) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        List<String> recent = CollectionsKt.take((Iterable)((List)destination$iv$iv4), (int)3);
        List<String> prevRecent = this.getCurrentState().getRecent();
        if (Intrinsics.areEqual((Object)CollectionsKt.toSet((Iterable)prevRecent), (Object)CollectionsKt.toSet((Iterable)recent))) {
            recent = prevRecent;
        }
        this.setState(new XNextToolbarState(recent, pinned));
    }

    private final void setState(XNextToolbarState state2) {
        this.currentState = state2;
        this.flow.tryEmit((Object)this.currentState);
    }

    private final XNextToolbarState getCurrentState() {
        return this.currentState;
    }

    @Override
    public void updatePinned(@NotNull LinkedHashSet<String> linkSet) {
        Intrinsics.checkNotNullParameter(linkSet, (String)"linkSet");
        this.getPinnedService().updatePinned(linkSet);
        this.updatePinned();
    }

    @Override
    public void setPinned(@NotNull String id2, boolean pinned) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        this.getPinnedService().setPinned(id2, pinned);
        this.updatePinned();
    }

    static {
        ToolWindowManagerListener.ToolWindowManagerEventType[] toolWindowManagerEventTypeArray = new ToolWindowManagerListener.ToolWindowManagerEventType[]{ToolWindowManagerListener.ToolWindowManagerEventType.ActivateToolWindow, ToolWindowManagerListener.ToolWindowManagerEventType.ShowToolWindow};
        actEvent = CollectionsKt.listOf((Object[])toolWindowManagerEventTypeArray);
        toolWindowManagerEventTypeArray = new ToolWindowManagerListener.ToolWindowManagerEventType[]{ToolWindowManagerListener.ToolWindowManagerEventType.UnregisterToolWindow, ToolWindowManagerListener.ToolWindowManagerEventType.ToolWindowAvailable, ToolWindowManagerListener.ToolWindowManagerEventType.ToolWindowUnavailable, ToolWindowManagerListener.ToolWindowManagerEventType.RegisterToolWindow};
        regEvent = CollectionsKt.listOf((Object[])toolWindowManagerEventTypeArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/toolWindow/xNext/toolbar/data/XNextToolbarManagerImpl$Companion;", "", "<init>", "()V", "MAX_RECENT_COUNT", "", "actEvent", "", "Lcom/intellij/openapi/wm/ex/ToolWindowManagerListener$ToolWindowManagerEventType;", "regEvent", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

