/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.gdpr.Consent;
import com.intellij.ide.gdpr.ConsentOptions;
import com.intellij.ide.gdpr.ConsentSettingsUi;
import com.intellij.ide.gdpr.localConsents.LocalConsentOptions;
import com.intellij.ide.gdpr.trace.TraceConsentManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.UISettings;
import com.intellij.idea.AppMode;
import com.intellij.internal.statistic.persistence.UsageStatisticsPersistenceComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.AppUIUtilKt;
import com.intellij.ui.Color16;
import com.intellij.ui.JBColor;
import com.intellij.ui.LicensingFacade;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.system.OS;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.AWTAccessor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u001e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012H\u0007J\u0006\u0010\u0013\u001a\u00020\u0014J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0010\u0010\u0019\u001a\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u001b0\u001aJ\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u0016H\u0007J\u0014\u0010\u001e\u001a\u00020\u00162\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0 J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001b0 H\u0007J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001b0 H\u0007J\u0016\u0010#\u001a\u00020\u000b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0 H\u0007J\u0016\u0010$\u001a\u00020\u000b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0 H\u0007J\u001a\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010'H\u0007J\u0012\u0010)\u001a\u00020\u00162\b\u0010*\u001a\u0004\u0018\u00010+H\u0007J\u0010\u0010,\u001a\u00020\u00012\u0006\u0010-\u001a\u00020\u0001H\u0002J\u0006\u0010.\u001a\u00020\u0001J:\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002042\u0006\u00106\u001a\u00020\t2\b\b\u0002\u00107\u001a\u00020\t2\b\b\u0002\u00108\u001a\u00020\tJ:\u00109\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002042\u0006\u0010:\u001a\u00020\t2\b\b\u0002\u00107\u001a\u00020\t2\b\b\u0002\u00108\u001a\u00020\tJ\u00b2\u0001\u0010;\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002042\u0006\u00106\u001a\u00020\t2\u0006\u0010:\u001a\u00020\t2\b\b\u0002\u00107\u001a\u00020\t2\b\b\u0002\u00108\u001a\u00020\t2l\u0010<\u001ah\u0012\u0013\u0012\u00110>\u00a2\u0006\f\b?\u0012\b\b@\u0012\u0004\b\b(A\u0012\u0013\u0012\u00110B\u00a2\u0006\f\b?\u0012\b\b@\u0012\u0004\b\b(C\u0012\u0013\u0012\u00110B\u00a2\u0006\f\b?\u0012\b\b@\u0012\u0004\b\b(D\u0012\u001f\u0012\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020B0E0E\u00a2\u0006\f\b?\u0012\b\b@\u0012\u0004\b\b(F\u0012\u0004\u0012\u00020\u000b0=H\u0002\u00a8\u0006G"}, d2={"Lcom/intellij/ui/AppUIUtil;", "", "<init>", "()V", "loadApplicationIcon", "Ljavax/swing/Icon;", "ctx", "Lcom/intellij/ui/scale/ScaleContext;", "size", "", "invokeLaterIfProjectAlive", "", "project", "Lcom/intellij/openapi/project/Project;", "runnable", "Ljava/lang/Runnable;", "invokeOnEdt", "expired", "Lcom/intellij/openapi/util/Condition;", "getFrameClass", "", "showConsentsAgreementIfNeeded", "", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "filter", "Ljava/util/function/Predicate;", "Lcom/intellij/ide/gdpr/Consent;", "updateForDarcula", "isDarcula", "confirmConsentOptions", "consents", "", "loadConsentsForEditing", "loadLocalConsentsAsConsentsForEditing", "saveConsents", "saveConsentsAsLocalConsents", "targetToDevice", "comp", "Ljava/awt/Component;", "target", "isInFullScreen", "window", "Ljava/awt/Window;", "adjustFractionalMetrics", "defaultValue", "getAdjustedFractionalMetricsValue", "createHorizontalGradientTexture", "Ljava/awt/TexturePaint;", "graphics", "Ljava/awt/Graphics;", "colorStart", "Ljava/awt/Color;", "colorEnd", "width", "xStart", "yStart", "createVerticalGradientTexture", "height", "createGradientTexture", "pixelsFunction", "Lkotlin/Function4;", "Ljava/awt/image/BufferedImage;", "Lkotlin/ParameterName;", "name", "image", "Lcom/intellij/ui/Color16;", "colorStart16", "delta16", "", "pixels", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nAppUIUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppUIUtil.kt\ncom/intellij/ui/AppUIUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,546:1\n1#2:547\n774#3:548\n865#3,2:549\n*S KotlinDebug\n*F\n+ 1 AppUIUtil.kt\ncom/intellij/ui/AppUIUtil\n*L\n397#1:548\n397#1:549,2\n*E\n"})
public final class AppUIUtil {
    @NotNull
    public static final AppUIUtil INSTANCE = new AppUIUtil();

    private AppUIUtil() {
    }

    @JvmStatic
    @Nullable
    public static final Icon loadApplicationIcon(@NotNull ScaleContext ctx, int size2) {
        JBImageIcon jBImageIcon;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        String string = ApplicationInfoImpl.getShadowInstance().getApplicationSvgIconUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getApplicationSvgIconUrl(...)");
        Image image2 = AppUIUtilKt.access$loadAppIconImage(string, ctx, size2);
        if (image2 != null) {
            Image it = image2;
            boolean bl = false;
            jBImageIcon = new JBImageIcon(it);
        } else {
            jBImageIcon = null;
        }
        return (Icon)jBImageIcon;
    }

    @JvmStatic
    public static final void invokeLaterIfProjectAlive(@NotNull Project project2, @NotNull Runnable runnable2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            if (project2.isOpen() && !project2.isDisposed()) {
                runnable2.run();
            }
        } else {
            application.invokeLater(runnable2, arg_0 -> AppUIUtil.invokeLaterIfProjectAlive$lambda$0(project2, arg_0));
        }
    }

    @JvmStatic
    public static final void invokeOnEdt(@NotNull Runnable runnable2) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        AppUIUtil.invokeOnEdt(runnable2, null);
    }

    @JvmStatic
    @Deprecated(message="Use {@link com.intellij.openapi.application.AppUIExecutor#expireWith(Disposable)}")
    public static final void invokeOnEdt(@NotNull Runnable runnable2, @Nullable Condition<?> expired) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            if (expired == null || !expired.value(null)) {
                runnable2.run();
            }
        } else if (expired == null) {
            application.invokeLater(runnable2);
        } else {
            application.invokeLater(runnable2, expired);
        }
    }

    @NotNull
    public final String getFrameClass() {
        Object wmClass;
        String string = ApplicationNamesInfo.getInstance().getFullProductNameWithEdition();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullProductNameWithEdition(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String name2 = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string2, (char)' ', (char)'-', (boolean)false, (int)4, null), (String)"intellij-idea", (String)"idea", (boolean)false, (int)4, null), (String)"android-studio", (String)"studio", (boolean)false, (int)4, null), (String)"-community-edition", (String)"-ce", (boolean)false, (int)4, null), (String)"-ultimate-edition", (String)"", (boolean)false, (int)4, null), (String)"-professional-edition", (String)"", (boolean)false, (int)4, null);
        Object object = wmClass = StringsKt.startsWith$default((String)name2, (String)"jetbrains-", (boolean)false, (int)2, null) ? name2 : "jetbrains-" + name2;
        if (PluginManagerCore.isRunningFromSources()) {
            wmClass = (String)wmClass + "-debug";
        }
        return wmClass;
    }

    public final boolean showConsentsAgreementIfNeeded(@NotNull Logger log, @NotNull Predicate<? super Consent> filter2) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        Pair<List<Consent>, Boolean> pair = ConsentOptions.getInstance().getConsents(filter2);
        Intrinsics.checkNotNullExpressionValue(pair, (String)"getConsents(...)");
        Pair<List<Consent>, Boolean> pair2 = pair;
        List first = (List)pair2.component1();
        Boolean second = (Boolean)pair2.component2();
        if (!second.booleanValue()) {
            return false;
        }
        if (EventQueue.isDispatchThread()) {
            Intrinsics.checkNotNull((Object)first);
            return this.confirmConsentOptions(first);
        }
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        try {
            EventQueue.invokeAndWait(() -> AppUIUtil.showConsentsAgreementIfNeeded$lambda$0(result2, first));
        }
        catch (InterruptedException e) {
            log.warn((Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.warn((Throwable)e);
        }
        return result2.element;
    }

    @JvmStatic
    public static final void updateForDarcula(boolean isDarcula) {
        JBColor.setDark((boolean)isDarcula);
        IconLoader.setUseDarkIcons((boolean)isDarcula);
    }

    public final boolean confirmConsentOptions(@NotNull List<Consent> consents) {
        Intrinsics.checkNotNullParameter(consents, (String)"consents");
        if (consents.isEmpty()) {
            return false;
        }
        ConsentSettingsUi ui = new ConsentSettingsUi(false);
        DialogWrapper dialog2 = new DialogWrapper(ui, consents){
            final /* synthetic */ ConsentSettingsUi $ui;
            final /* synthetic */ List<Consent> $consents;
            {
                this.$ui = $ui;
                this.$consents = $consents;
                super(true);
            }

            protected Border createContentPaneBorder() {
                return null;
            }

            protected JComponent createSouthPanel() {
                JComponent southPanel = super.createSouthPanel();
                if (southPanel != null) {
                    southPanel.setBorder(DialogWrapper.createDefaultBorder());
                }
                return southPanel;
            }

            protected JComponent createCenterPanel() {
                JComponent jComponent = this.$ui.getComponent();
                Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
                return jComponent;
            }

            protected Action[] createActions() {
                if (this.$consents.size() > 1) {
                    Action[] actionArray = super.createActions();
                    Intrinsics.checkNotNullExpressionValue((Object)actionArray, (String)"createActions(...)");
                    Action[] actions = actionArray;
                    this.setOKButtonText(IdeBundle.message((String)"button.save", (Object[])new Object[0]));
                    this.setCancelButtonText(IdeBundle.message((String)"button.skip", (Object[])new Object[0]));
                    return actions;
                }
                this.setOKButtonText(this.$consents.iterator().next().getName());
                Action[] actionArray = new Action[2];
                Intrinsics.checkNotNullExpressionValue((Object)this.getOKAction(), (String)"getOKAction(...)");
                String string = IdeBundle.message((String)"button.do.not.send", (Object[])new Object[0]);
                actionArray[1] = new DialogWrapper.DialogWrapperAction(this, string){
                    final /* synthetic */ confirmConsentOptions.dialog.1 this$0;
                    {
                        this.this$0 = $receiver;
                        super((DialogWrapper)$receiver, $super_call_param$1);
                    }

                    protected void doAction(ActionEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        this.this$0.close(2);
                    }
                };
                return actionArray;
            }

            protected void createDefaultActions() {
                super.createDefaultActions();
                this.init();
                this.setAutoAdjustable(false);
            }
        };
        ui.reset(consents);
        dialog2.setModal(true);
        dialog2.setTitle(IdeBundle.message((String)"dialog.title.data.sharing", (Object[])new Object[0]));
        dialog2.pack();
        if (consents.size() < 2) {
            dialog2.setSize(dialog2.getWindow().getWidth(), dialog2.getWindow().getHeight() + JBUIScale.scale((int)75));
        }
        dialog2.show();
        int exitCode2 = dialog2.getExitCode();
        if (exitCode2 == 1) {
            return false;
        }
        List result2 = null;
        if (consents.size() == 1) {
            result2 = CollectionsKt.listOf((Object)consents.iterator().next().derive(exitCode2 == 0));
        } else {
            result2 = new ArrayList();
            ui.apply(result2);
        }
        AppUIUtil.saveConsents(result2);
        return true;
    }

    @JvmStatic
    @NotNull
    public static final List<Consent> loadConsentsForEditing() {
        Consent statConsent;
        ConsentOptions options2 = ConsentOptions.getInstance();
        List result2 = (List)options2.getConsents().getFirst();
        if (options2.isEAP() && (statConsent = options2.getDefaultUsageStatsConsent()) != null) {
            List consents = result2;
            result2 = new ArrayList();
            ((ArrayList)result2).add(statConsent.derive(UsageStatisticsPersistenceComponent.getInstance().isAllowed()));
            ((ArrayList)result2).addAll(consents);
        }
        List list2 = result2;
        Intrinsics.checkNotNull((Object)list2);
        AppUIUtilKt.access$removeTraceConsents(list2);
        result2.removeIf(ConsentOptions.condAiDataCollectionConsent());
        list2 = result2;
        Intrinsics.checkNotNull((Object)list2);
        return list2;
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final List<Consent> loadLocalConsentsAsConsentsForEditing() {
        List localConsents = CollectionsKt.toMutableList((Collection)((Collection)LocalConsentOptions.INSTANCE.getLocalConsents().getFirst()));
        TraceConsentManager traceConsentManager = TraceConsentManager.Companion.getInstance();
        if (!(traceConsentManager != null ? traceConsentManager.canDisplayTraceConsent() : false)) {
            AppUIUtilKt.access$removeTraceLocalConsents(localConsents);
        } else {
            Character licenseTypeFlag;
            Character c;
            Object object = LicensingFacade.getInstance();
            Character c2 = c = (licenseTypeFlag = object != null && (object = ((LicensingFacade)object).metadata) != null ? StringsKt.getOrNull((CharSequence)((CharSequence)object), (int)10) : null);
            char c3 = 'F';
            if (c2 != null && c2.charValue() == c3) {
                localConsents.removeIf(LocalConsentOptions.condTraceDataCollectionComLocalConsent());
            } else if (c == null) {
                AppUIUtilKt.access$removeTraceLocalConsents(localConsents);
            } else {
                localConsents.removeIf(LocalConsentOptions.condTraceDataCollectionNonComLocalConsent());
            }
        }
        return localConsents;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void saveConsents(@NotNull List<Consent> consents) {
        Intrinsics.checkNotNullParameter(consents, (String)"consents");
        if (consents.isEmpty()) {
            return;
        }
        ConsentOptions options2 = ConsentOptions.getInstance();
        if (ApplicationManager.getApplication() != null && options2.isEAP()) {
            Predicate<Consent> predicate = ConsentOptions.condUsageStatsConsent();
            Intrinsics.checkNotNullExpressionValue(predicate, (String)"condUsageStatsConsent(...)");
            Predicate<Consent> isUsageStats = predicate;
            int saved = 0;
            for (Consent consent : consents) {
                if (!isUsageStats.test(consent)) continue;
                UsageStatisticsPersistenceComponent.getInstance().setAllowed(consent.isAccepted());
                ++saved;
            }
            if (consents.size() - saved > 0) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Iterable iterable = consents;
                ConsentOptions consentOptions = options2;
                boolean $i$f$filter = false;
                void var6_8 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Consent it = (Consent)element$iv$iv;
                    boolean bl = false;
                    if (!(!isUsageStats.test(it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                consentOptions.setConsents((List)destination$iv$iv);
            }
        } else {
            options2.setConsents((Collection<Consent>)consents);
        }
    }

    @JvmStatic
    @ApiStatus.Internal
    public static final void saveConsentsAsLocalConsents(@NotNull List<Consent> consents) {
        Intrinsics.checkNotNullParameter(consents, (String)"consents");
        LocalConsentOptions.INSTANCE.setLocalConsents(consents);
    }

    @JvmStatic
    public static final void targetToDevice(@NotNull Component comp, @Nullable Component target) {
        Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
        if (comp.isShowing()) {
            return;
        }
        Component component2 = target;
        GraphicsConfiguration gc = component2 != null ? component2.getGraphicsConfiguration() : null;
        AWTAccessor.getComponentAccessor().setGraphicsConfiguration(comp, gc);
    }

    @JvmStatic
    public static final boolean isInFullScreen(@Nullable Window window) {
        return window instanceof IdeFrame && ((IdeFrame)window).isInFullScreen();
    }

    private final Object adjustFractionalMetrics(Object defaultValue) {
        Object object;
        if (OS.CURRENT != OS.macOS || GraphicsEnvironment.isHeadless() || AppMode.isRemoteDevHost()) {
            return defaultValue;
        }
        GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (JBUIScale.sysScale((GraphicsConfiguration)gc) == 1.0f) {
            Object object2 = RenderingHints.VALUE_FRACTIONALMETRICS_OFF;
            object = object2;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"VALUE_FRACTIONALMETRICS_OFF");
        } else {
            object = defaultValue;
        }
        return object;
    }

    @NotNull
    public final Object getAdjustedFractionalMetricsValue() {
        return this.adjustFractionalMetrics(UISettings.Companion.getPreferredFractionalMetricsValue());
    }

    @NotNull
    public final TexturePaint createHorizontalGradientTexture(@NotNull Graphics graphics, @NotNull Color colorStart, @NotNull Color colorEnd, int width, int xStart, int yStart) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        Intrinsics.checkNotNullParameter((Object)colorStart, (String)"colorStart");
        Intrinsics.checkNotNullParameter((Object)colorEnd, (String)"colorEnd");
        return this.createGradientTexture(graphics, colorStart, colorEnd, width, 2, xStart, yStart, (Function4<? super BufferedImage, ? super Color16, ? super Color16, ? super Color16[][], Unit>)((Function4)AppUIUtil::createHorizontalGradientTexture$lambda$0));
    }

    public static /* synthetic */ TexturePaint createHorizontalGradientTexture$default(AppUIUtil appUIUtil, Graphics graphics, Color color, Color color2, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 0x10) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x20) != 0) {
            n3 = 0;
        }
        return appUIUtil.createHorizontalGradientTexture(graphics, color, color2, n, n2, n3);
    }

    @NotNull
    public final TexturePaint createVerticalGradientTexture(@NotNull Graphics graphics, @NotNull Color colorStart, @NotNull Color colorEnd, int height, int xStart, int yStart) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        Intrinsics.checkNotNullParameter((Object)colorStart, (String)"colorStart");
        Intrinsics.checkNotNullParameter((Object)colorEnd, (String)"colorEnd");
        return this.createGradientTexture(graphics, colorStart, colorEnd, 2, height, xStart, yStart, (Function4<? super BufferedImage, ? super Color16, ? super Color16, ? super Color16[][], Unit>)((Function4)AppUIUtil::createVerticalGradientTexture$lambda$0));
    }

    public static /* synthetic */ TexturePaint createVerticalGradientTexture$default(AppUIUtil appUIUtil, Graphics graphics, Color color, Color color2, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 0x10) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x20) != 0) {
            n3 = 0;
        }
        return appUIUtil.createVerticalGradientTexture(graphics, color, color2, n, n2, n3);
    }

    private final TexturePaint createGradientTexture(Graphics graphics, Color colorStart, Color colorEnd, int width, int height, int xStart, int yStart, Function4<? super BufferedImage, ? super Color16, ? super Color16, ? super Color16[][], Unit> pixelsFunction) {
        int n;
        int n2;
        BufferedImage bufferedImage = ImageUtil.createImage((Graphics)graphics, (int)width, (int)height, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
        BufferedImage image2 = bufferedImage;
        int n3 = image2.getHeight();
        Color16[][] color16ArrayArray = new Color16[n3][];
        for (int j = 0; j < n3; ++j) {
            int n4 = j;
            int n5 = 0;
            n2 = image2.getWidth();
            Color16[] color16Array = new Color16[n2];
            int n6 = n4;
            Color16[][] color16ArrayArray2 = color16ArrayArray;
            while (n5 < n2) {
                n = n5++;
                color16Array[n] = Color16.Companion.getTRANSPARENT();
            }
            color16ArrayArray2[n6] = color16Array;
        }
        Color16[][] pixels = color16ArrayArray;
        Color16 colorStart16 = Color16.Companion.toColor16(colorStart);
        Color16 colorEnd16 = Color16.Companion.toColor16(colorEnd);
        Color16 delta16 = colorEnd16.minus(colorStart16);
        pixelsFunction.invoke((Object)image2, (Object)colorStart16, (Object)delta16, (Object)pixels);
        double[] dArray = new double[]{0.4375, 0.1875, 0.3125, 0.0625};
        double[] coefficients = dArray;
        n2 = image2.getHeight();
        for (int y = 0; y < n2; ++y) {
            n = image2.getWidth();
            for (int x = 0; x < n; ++x) {
                Color16 oldColor = pixels[y][x];
                Color newColor = oldColor.toColor8();
                image2.setRGB(x, y, newColor.getRGB());
                Color16 error = oldColor.minus(Color16.Companion.toColor16(newColor));
                if (x + 1 < image2.getWidth()) {
                    pixels[y][x + 1] = pixels[y][x + 1].plus(error.times(coefficients[0]));
                }
                if (x - 1 >= 0 && y + 1 < image2.getHeight()) {
                    pixels[y + 1][x - 1] = pixels[y + 1][x - 1].plus(error.times(coefficients[1]));
                }
                if (y + 1 < image2.getHeight()) {
                    pixels[y + 1][x] = pixels[y + 1][x].plus(error.times(coefficients[2]));
                }
                if (x + 1 >= image2.getWidth() || y + 1 >= image2.getHeight()) continue;
                pixels[y + 1][x + 1] = pixels[y + 1][x + 1].plus(error.times(coefficients[3]));
            }
        }
        return new TexturePaint(image2, new Rectangle(xStart, yStart, width, height));
    }

    static /* synthetic */ TexturePaint createGradientTexture$default(AppUIUtil appUIUtil, Graphics graphics, Color color, Color color2, int n, int n2, int n3, int n4, Function4 function4, int n5, Object object) {
        if ((n5 & 0x20) != 0) {
            n3 = 0;
        }
        if ((n5 & 0x40) != 0) {
            n4 = 0;
        }
        return appUIUtil.createGradientTexture(graphics, color, color2, n, n2, n3, n4, (Function4<? super BufferedImage, ? super Color16, ? super Color16, ? super Color16[][], Unit>)function4);
    }

    private static final boolean invokeLaterIfProjectAlive$lambda$0(Project $project, Object it) {
        return !$project.isOpen() || $project.isDisposed();
    }

    private static final void showConsentsAgreementIfNeeded$lambda$0(Ref.BooleanRef $result, List $first) {
        Intrinsics.checkNotNull((Object)$first);
        $result.element = INSTANCE.confirmConsentOptions($first);
    }

    private static final Unit createHorizontalGradientTexture$lambda$0(BufferedImage image2, Color16 colorStart16, Color16 delta16, Color16[][] pixels) {
        Intrinsics.checkNotNullParameter((Object)image2, (String)"image");
        Intrinsics.checkNotNullParameter((Object)colorStart16, (String)"colorStart16");
        Intrinsics.checkNotNullParameter((Object)delta16, (String)"delta16");
        Intrinsics.checkNotNullParameter((Object)pixels, (String)"pixels");
        int n = image2.getWidth();
        for (int x = 0; x < n; ++x) {
            double rel = (double)x * 1.0 / (double)(image2.getWidth() - 1);
            Color16 curColor = colorStart16.plus(delta16.times(rel));
            int n2 = image2.getHeight();
            for (int y = 0; y < n2; ++y) {
                pixels[y][x] = curColor;
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit createVerticalGradientTexture$lambda$0(BufferedImage image2, Color16 colorStart16, Color16 delta16, Color16[][] pixels) {
        Intrinsics.checkNotNullParameter((Object)image2, (String)"image");
        Intrinsics.checkNotNullParameter((Object)colorStart16, (String)"colorStart16");
        Intrinsics.checkNotNullParameter((Object)delta16, (String)"delta16");
        Intrinsics.checkNotNullParameter((Object)pixels, (String)"pixels");
        int n = image2.getHeight();
        for (int y = 0; y < n; ++y) {
            double rel = (double)y * 1.0 / (double)(image2.getHeight() - 1);
            Color16 curColor = colorStart16.plus(delta16.times(rel));
            int n2 = image2.getWidth();
            for (int x = 0; x < n2; ++x) {
                pixels[y][x] = curColor;
            }
        }
        return Unit.INSTANCE;
    }
}

