/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DrawUtil;
import com.intellij.ui.GotItComponentBuilderKt;
import com.intellij.ui.GotItPromoComponent;
import com.intellij.ui.GotItPromoContent;
import com.intellij.ui.GotItPromoHtmlPage;
import com.intellij.ui.GotItPromoImage;
import com.intellij.ui.GotItTextBuilder;
import com.intellij.ui.GotItTextBuilderImpl;
import com.intellij.ui.InlineCodeExtension;
import com.intellij.ui.JBColor;
import com.intellij.ui.LimitedWidthEditorPane;
import com.intellij.ui.RemoteTransferUIManager;
import com.intellij.ui.RoundedIcon;
import com.intellij.ui.ShortcutExtension;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.paint.RectanglePainter2D;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import java.io.Serializable;
import java.net.URL;
import java.util.Comparator;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SortingFocusTraversalPolicy;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 `2\u00020\u0001:\u0001`B%\u0012\u001c\u0010\u0002\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u00060\u0003\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0016\b\u0016\u0012\u000b\u0010\n\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0004\b\b\u0010\u000bJ\u000e\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,J\u0018\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u00122\b\b\u0002\u0010/\u001a\u00020\u0014J \u00100\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u0002032\b\b\u0002\u0010/\u001a\u00020\u0014J\u0010\u00104\u001a\u00020\u00002\b\b\u0001\u0010\u0017\u001a\u00020\u0005J\u000e\u00105\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0012J\u000e\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u000eJ\u0013\u00106\u001a\u00020\u00002\u000b\u0010\n\u001a\u00070\u0005\u00a2\u0006\u0002\b8J\u000e\u00109\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bJ\u001e\u0010:\u001a\u00020\u00002\b\b\u0001\u0010;\u001a\u00020\u00052\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0018\u0010=\u001a\u00020\u00002\b\b\u0001\u0010;\u001a\u00020\u00052\u0006\u0010>\u001a\u00020?J(\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00100\u001d2\b\b\u0001\u0010\n\u001a\u00020\u00052\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\u0014H\u0002J\u0014\u0010D\u001a\u00020\u00002\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010E\u001a\u00020\u0014J\u0010\u0010F\u001a\u00020\u00002\b\b\u0001\u0010G\u001a\u00020\u0005J\u000e\u0010H\u001a\u00020\u00002\u0006\u0010I\u001a\u00020\u0014J\u0014\u0010J\u001a\u00020\u00002\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u000e\u0010#\u001a\u00020\u00002\u0006\u0010K\u001a\u00020\u0014J\u001e\u0010L\u001a\u00020\u00002\b\b\u0001\u0010G\u001a\u00020\u00052\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0014\u0010M\u001a\u00020\u00002\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u000e\u0010N\u001a\u00020\u00002\u0006\u0010O\u001a\u00020\u000eJ\u000e\u0010P\u001a\u00020\u00002\u0006\u0010Q\u001a\u00020\u0014J)\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020U2\u0019\b\u0002\u0010V\u001a\u0013\u0012\u0004\u0012\u00020W\u0012\u0004\u0012\u00020W0\u0003\u00a2\u0006\u0002\b\u0007J\b\u0010X\u001a\u00020BH\u0002JD\u0010Y\u001a\u00020,2\u0012\u0010Z\u001a\u000e\u0012\u0004\u0012\u00020[\u0012\u0004\u0012\u00020\u00100\u00032\u0012\u0010\\\u001a\u000e\u0012\u0004\u0012\u00020[\u0012\u0004\u0012\u00020\u00100\u00032\u0012\u0010]\u001a\u000e\u0012\u0004\u0012\u00020^\u0012\u0004\u0012\u00020\u00100\u0003H\u0002J\f\u0010_\u001a\u00020\u0010*\u00020[H\u0002R\u0010\u0010\n\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00120\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u00020\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010!\u001a\u00020\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010'\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006a"}, d2={"Lcom/intellij/ui/GotItComponentBuilder;", "", "textSupplier", "Lkotlin/Function1;", "Lcom/intellij/ui/GotItTextBuilder;", "", "Lorg/jetbrains/annotations/Nls;", "Lkotlin/ExtensionFunctionType;", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "text", "(Ljava/lang/String;)V", "linkActionsMap", "", "", "Lkotlin/Function0;", "", "iconsMap", "Ljavax/swing/Icon;", "withImageBorder", "", "promoContent", "Lcom/intellij/ui/GotItPromoContent;", "header", "icon", "stepText", "shortcut", "Lcom/intellij/openapi/actionSystem/Shortcut;", "link", "Lcom/intellij/ui/components/labels/LinkLabel;", "linkAction", "afterLinkClickedAction", "showButton", "buttonLabel", "buttonAction", "requestFocus", "useContrastButton", "secondaryButtonText", "secondaryButtonAction", "escapeAction", "maxWidth", "useContrastColors", "withCustomComponentPromo", "component", "Ljavax/swing/JComponent;", "withImage", "image", "withBorder", "withBrowserPage", "htmlText", "size", "Ljava/awt/Dimension;", "withHeader", "withIcon", "withStepNumber", "step", "Lcom/intellij/openapi/util/NlsSafe;", "withShortcut", "withLink", "linkLabel", "action", "withBrowserLink", "url", "Ljava/net/URL;", "createLinkLabel", "foreground", "Ljava/awt/Color;", "isExternal", "onLinkClick", "show", "withButtonLabel", "label", "withContrastButton", "contrastButton", "onButtonClick", "request", "withSecondaryButton", "onEscapePressed", "withMaxWidth", "width", "withContrastColors", "contrastColors", "build", "Lcom/intellij/openapi/ui/popup/Balloon;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "additionalSettings", "Lcom/intellij/openapi/ui/popup/BalloonBuilder;", "getBorderColor", "createContent", "buttonConsumer", "Ljavax/swing/JButton;", "secondaryButtonConsumer", "descriptionConsumer", "Ljavax/swing/JEditorPane;", "pressOnEnter", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nGotItComponentBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GotItComponentBuilder.kt\ncom/intellij/ui/GotItComponentBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,1135:1\n1#2:1136\n23#3:1137\n*S KotlinDebug\n*F\n+ 1 GotItComponentBuilder.kt\ncom/intellij/ui/GotItComponentBuilder\n*L\n377#1:1137\n*E\n"})
public final class GotItComponentBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nls
    @NotNull
    private final String text;
    @NotNull
    private final Map<Integer, Function0<Unit>> linkActionsMap;
    @NotNull
    private final Map<Integer, Icon> iconsMap;
    private boolean withImageBorder;
    @Nullable
    private GotItPromoContent promoContent;
    @Nls
    @NotNull
    private String header;
    @Nullable
    private Icon icon;
    @NlsSafe
    @Nullable
    private String stepText;
    @Nullable
    private Shortcut shortcut;
    @Nullable
    private LinkLabel<Unit> link;
    @NotNull
    private Function0<Unit> linkAction;
    @NotNull
    private Function0<Unit> afterLinkClickedAction;
    private boolean showButton;
    @Nls
    @NotNull
    private String buttonLabel;
    @NotNull
    private Function0<Unit> buttonAction;
    private boolean requestFocus;
    private boolean useContrastButton;
    @Nls
    @Nullable
    private String secondaryButtonText;
    @NotNull
    private Function0<Unit> secondaryButtonAction;
    @Nullable
    private Function0<Unit> escapeAction;
    private int maxWidth;
    private boolean useContrastColors;
    @NotNull
    public static final String CLOSE_ACTION_NAME = "CloseGotItTooltip";
    public static final int MAX_LINES_COUNT = 5;

    public GotItComponentBuilder(@NotNull Function1<? super GotItTextBuilder, String> textSupplier) {
        Intrinsics.checkNotNullParameter(textSupplier, (String)"textSupplier");
        this.header = "";
        this.linkAction = GotItComponentBuilder::linkAction$lambda$0;
        this.afterLinkClickedAction = GotItComponentBuilder::afterLinkClickedAction$lambda$0;
        this.showButton = true;
        String string = IdeBundle.message((String)"got.it.button.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.buttonLabel = string;
        this.buttonAction = GotItComponentBuilder::buttonAction$lambda$0;
        this.secondaryButtonAction = GotItComponentBuilder::secondaryButtonAction$lambda$0;
        this.maxWidth = GotItComponentBuilder.Companion.getMAX_WIDTH();
        GotItTextBuilderImpl builder = new GotItTextBuilderImpl();
        String rawText = (String)textSupplier.invoke((Object)builder);
        String withPatchedShortcuts = ShortcutExtension.Companion.patchShortcutTags(rawText, true);
        this.text = InlineCodeExtension.Companion.patchCodeTags(withPatchedShortcuts);
        this.linkActionsMap = builder.getLinkActions();
        this.iconsMap = builder.getIcons();
    }

    public GotItComponentBuilder(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this((Function1<? super GotItTextBuilder, String>)((Function1)arg_0 -> GotItComponentBuilder._init_$lambda$0(text2, arg_0)));
    }

    @NotNull
    public final GotItComponentBuilder withCustomComponentPromo(@NotNull JComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        if (this.promoContent != null) {
            throw new IllegalStateException("Choose one of promo content".toString());
        }
        this.promoContent = new GotItPromoComponent(component2);
        return this;
    }

    @NotNull
    public final GotItComponentBuilder withImage(@NotNull Icon image2, boolean withBorder) {
        Intrinsics.checkNotNullParameter((Object)image2, (String)"image");
        if (this.promoContent != null) {
            throw new IllegalStateException("Choose one of promo content".toString());
        }
        double arcRatio = (double)JBUI.CurrentTheme.GotItTooltip.CORNER_RADIUS.get() / (double)Math.min(image2.getIconWidth(), image2.getIconHeight());
        this.promoContent = new GotItPromoImage((Icon)new RoundedIcon(image2, arcRatio, false));
        this.withImageBorder = withBorder;
        return this;
    }

    public static /* synthetic */ GotItComponentBuilder withImage$default(GotItComponentBuilder gotItComponentBuilder, Icon icon2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return gotItComponentBuilder.withImage(icon2, bl);
    }

    @NotNull
    public final GotItComponentBuilder withBrowserPage(@NotNull String htmlText, @NotNull Dimension size2, boolean withBorder) {
        Intrinsics.checkNotNullParameter((Object)htmlText, (String)"htmlText");
        Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
        if (this.promoContent != null) {
            throw new IllegalStateException("Choose one of promo content".toString());
        }
        this.promoContent = new GotItPromoHtmlPage(htmlText, size2);
        this.withImageBorder = withBorder;
        return this;
    }

    public static /* synthetic */ GotItComponentBuilder withBrowserPage$default(GotItComponentBuilder gotItComponentBuilder, String string, Dimension dimension, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return gotItComponentBuilder.withBrowserPage(string, dimension, bl);
    }

    @NotNull
    public final GotItComponentBuilder withHeader(@Nls @NotNull String header) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        this.header = header;
        return this;
    }

    @NotNull
    public final GotItComponentBuilder withIcon(@NotNull Icon icon2) {
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        if (this.stepText != null) {
            throw new IllegalStateException("Icon and step number can not be showed both at once. Choose one of them.");
        }
        this.icon = icon2;
        return this;
    }

    @NotNull
    public final GotItComponentBuilder withStepNumber(int step2) {
        if (this.icon != null) {
            throw new IllegalStateException("Icon and step number can not be showed both at once. Choose one of them.");
        }
        if (!(1 <= step2 ? step2 < 100 : false)) {
            throw new IllegalArgumentException("The step should be in the range [1, 99]. Provided step number: " + step2);
        }
        this.stepText = StringsKt.padStart((String)String.valueOf(step2), (int)2, (char)'0');
        return this;
    }

    @NotNull
    public final GotItComponentBuilder withStepNumber(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (this.icon != null) {
            throw new IllegalStateException("Icon and step number can not be showed both at once. Choose one of them.");
        }
        this.stepText = text2;
        return this;
    }

    @NotNull
    public final GotItComponentBuilder withShortcut(@NotNull Shortcut shortcut) {
        Intrinsics.checkNotNullParameter((Object)shortcut, (String)"shortcut");
        this.shortcut = shortcut;
        return this;
    }

    @NotNull
    public final GotItComponentBuilder withLink(@Nls @NotNull String linkLabel, @NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)linkLabel, (String)"linkLabel");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        Color color = JBUI.CurrentTheme.GotItTooltip.linkForeground((boolean)this.useContrastColors);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"linkForeground(...)");
        this.link = this.createLinkLabel(linkLabel, color, false);
        this.linkAction = action2;
        return this;
    }

    @NotNull
    public final GotItComponentBuilder withBrowserLink(@Nls @NotNull String linkLabel, @NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)linkLabel, (String)"linkLabel");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Color color = JBUI.CurrentTheme.GotItTooltip.linkForeground((boolean)this.useContrastColors);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"linkForeground(...)");
        this.link = this.createLinkLabel(linkLabel, color, true);
        this.linkAction = () -> GotItComponentBuilder.withBrowserLink$lambda$0(url);
        return this;
    }

    private final LinkLabel<Unit> createLinkLabel(@Nls String text2, Color foreground, boolean isExternal) {
        Icon icon2;
        if (isExternal) {
            Icon icon3 = AllIcons.Ide.External_link_arrow;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"External_link_arrow");
            icon2 = GotItComponentBuilderKt.colorizeIfPossible$default(icon3, foreground, null, 2, null);
        } else {
            icon2 = null;
        }
        Icon icon4 = icon2;
        Icon it = icon4 = new LinkLabel<Unit>(text2, foreground, this, icon4){
            final /* synthetic */ Color $foreground;
            final /* synthetic */ GotItComponentBuilder this$0;
            {
                this.$foreground = $foreground;
                this.this$0 = $receiver;
                super($text, $super_call_param$1);
            }

            protected Color getNormal() {
                return this.$foreground;
            }

            protected Color getHover() {
                return this.$foreground;
            }

            protected Color getVisited() {
                return this.$foreground;
            }

            protected Color getActive() {
                return this.$foreground;
            }

            protected Color getUnderlineColor() {
                Color color = JBUI.CurrentTheme.GotItTooltip.linkUnderline((boolean)GotItComponentBuilder.access$getUseContrastColors$p(this.this$0), (boolean)this.myUnderline, (Color)this.$foreground);
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"linkUnderline(...)");
                return color;
            }

            protected int getUnderlineShift() {
                return 4;
            }
        };
        boolean bl = false;
        if (isExternal) {
            it.setHorizontalTextPosition(2);
        }
        return (LinkLabel)icon4;
    }

    @NotNull
    public final GotItComponentBuilder onLinkClick(@NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        Function0<Unit> curAction = this.afterLinkClickedAction;
        this.afterLinkClickedAction = () -> GotItComponentBuilder.onLinkClick$lambda$0(curAction, action2);
        return this;
    }

    @NotNull
    public final GotItComponentBuilder showButton(boolean show2) {
        this.showButton = show2;
        return this;
    }

    @NotNull
    public final GotItComponentBuilder withButtonLabel(@Nls @NotNull String label2) {
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        this.buttonLabel = label2;
        return this;
    }

    @NotNull
    public final GotItComponentBuilder withContrastButton(boolean contrastButton) {
        this.useContrastButton = contrastButton;
        return this;
    }

    @NotNull
    public final GotItComponentBuilder onButtonClick(@NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        Function0<Unit> curAction = this.buttonAction;
        this.buttonAction = () -> GotItComponentBuilder.onButtonClick$lambda$0(curAction, action2);
        return this;
    }

    @NotNull
    public final GotItComponentBuilder requestFocus(boolean request) {
        this.requestFocus = request;
        return this;
    }

    @NotNull
    public final GotItComponentBuilder withSecondaryButton(@Nls @NotNull String label2, @NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        this.secondaryButtonText = label2;
        this.secondaryButtonAction = action2;
        return this;
    }

    @NotNull
    public final GotItComponentBuilder onEscapePressed(@NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        this.escapeAction = action2;
        return this;
    }

    @NotNull
    public final GotItComponentBuilder withMaxWidth(int width) {
        this.maxWidth = width;
        return this;
    }

    @NotNull
    public final GotItComponentBuilder withContrastColors(boolean contrastColors) {
        this.useContrastColors = contrastColors;
        return this;
    }

    @NotNull
    public final Balloon build(@NotNull Disposable parentDisposable, @NotNull Function1<? super BalloonBuilder, ? extends BalloonBuilder> additionalSettings) {
        JEditorPane jEditorPane;
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(additionalSettings, (String)"additionalSettings");
        Ref.ObjectRef button2 = new Ref.ObjectRef();
        Ref.ObjectRef secondaryButton = new Ref.ObjectRef();
        Ref.ObjectRef description = new Ref.ObjectRef();
        BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createBalloonBuilder(this.createContent((Function1<? super JButton, Unit>)((Function1)arg_0 -> GotItComponentBuilder.build$lambda$1(button2, arg_0)), (Function1<? super JButton, Unit>)((Function1)arg_0 -> GotItComponentBuilder.build$lambda$2(secondaryButton, arg_0)), (Function1<? super JEditorPane, Unit>)((Function1)arg_0 -> GotItComponentBuilder.build$lambda$3(description, arg_0)))).setDisposable(parentDisposable).setHideOnAction(false).setHideOnClickOutside(false).setHideOnFrameResize(false).setHideOnKeyOutside(false).setHideOnClickOutside(false).setBlockClicksThroughBalloon(true).setRequestFocus(this.requestFocus).setBorderColor(this.getBorderColor()).setCornerToPointerDistance(Companion.getArrowShift()).setFillColor(JBUI.CurrentTheme.GotItTooltip.background((boolean)this.useContrastColors)).setPointerSize((Dimension)JBUI.size((int)16, (int)8)).setCornerRadius(JBUI.CurrentTheme.GotItTooltip.CORNER_RADIUS.get());
        Intrinsics.checkNotNullExpressionValue((Object)balloonBuilder, (String)"setCornerRadius(...)");
        Object object = ((BalloonBuilder)additionalSettings.invoke((Object)balloonBuilder)).createBalloon();
        LinkLabel<Unit> it = object;
        boolean bl = false;
        it.setAnimationEnabled(false);
        LinkLabel<Unit> linkLabel = object;
        Intrinsics.checkNotNullExpressionValue((Object)linkLabel, (String)"also(...)");
        LinkLabel<Unit> balloon2 = linkLabel;
        if (description.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"description");
            jEditorPane = null;
        } else {
            jEditorPane = (JEditorPane)description.element;
        }
        jEditorPane.addHyperlinkListener(arg_0 -> GotItComponentBuilder.build$lambda$5(this, arg_0));
        LinkLabel<Unit> linkLabel2 = this.link;
        if (linkLabel2 != null) {
            object = linkLabel2;
            LinkLabel<Unit> $this$build_u24lambda_u246 = object;
            boolean bl2 = false;
            $this$build_u24lambda_u246.setListener((arg_0, arg_1) -> GotItComponentBuilder.build$lambda$6$0(this, arg_0, arg_1), null);
        }
        JButton jButton = (JButton)button2.element;
        if (jButton != null) {
            Object $this$build_u24lambda_u247 = object = jButton;
            boolean bl3 = false;
            ((AbstractButton)$this$build_u24lambda_u247).addActionListener(arg_0 -> GotItComponentBuilder.build$lambda$7$0(this, balloon2, arg_0));
        }
        JButton jButton2 = (JButton)secondaryButton.element;
        if (jButton2 != null) {
            Object $this$build_u24lambda_u248 = object = jButton2;
            boolean bl4 = false;
            ((AbstractButton)$this$build_u24lambda_u248).addActionListener(arg_0 -> GotItComponentBuilder.build$lambda$8$0(this, balloon2, arg_0));
        }
        if (this.escapeAction != null && balloon2 instanceof BalloonImpl) {
            ((BalloonImpl)balloon2).setHideListener(() -> GotItComponentBuilder.build$lambda$9(this, balloon2));
            ((BalloonImpl)balloon2).setHideOnClickOutside(false);
        }
        return balloon2;
    }

    public static /* synthetic */ Balloon build$default(GotItComponentBuilder gotItComponentBuilder, Disposable disposable, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = GotItComponentBuilder::build$lambda$0;
        }
        return gotItComponentBuilder.build(disposable, (Function1<? super BalloonBuilder, ? extends BalloonBuilder>)function1);
    }

    private final Color getBorderColor() {
        Color color = JBUI.CurrentTheme.GotItTooltip.borderColor((boolean)this.useContrastColors);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"borderColor(...)");
        Color borderColor = color;
        if (this.useContrastColors) {
            return borderColor;
        }
        JBColor jBColor = JBColor.namedColor((String)"GotItTooltip.borderSimplifiedColor", (Color)borderColor);
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        JBColor simpleBorderColor = jBColor;
        JBColor jBColor2 = JBColor.lazy(() -> GotItComponentBuilder.getBorderColor$lambda$0(simpleBorderColor, borderColor));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"lazy(...)");
        return (Color)jBColor2;
    }

    /*
     * WARNING - void declaration
     */
    private final JComponent createContent(Function1<? super JButton, Unit> buttonConsumer, Function1<? super JButton, Unit> secondaryButtonConsumer, Function1<? super JEditorPane, Unit> descriptionConsumer) {
        int n;
        Object object;
        LinkLabel<Unit> adjusted;
        Serializable adjustedSize;
        LinkLabel<Unit> it;
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBag gc = new GridBag();
        int left = this.icon != null || this.stepText != null ? JBUI.CurrentTheme.GotItTooltip.ICON_INSET.get() : 0;
        int column = this.icon != null || this.stepText != null ? 1 : 0;
        GotItPromoContent promo = this.promoContent;
        if (promo != null) {
            JComponent jComponent;
            int borderSize = 1;
            GotItPromoContent gotItPromoContent = promo;
            if (gotItPromoContent instanceof GotItPromoHtmlPage) {
                JBCefBrowser jBCefBrowser = JBCefBrowser.createBuilder().setMouseWheelEventEnable(false).build();
                Intrinsics.checkNotNullExpressionValue((Object)jBCefBrowser, (String)"build(...)");
                JBCefBrowser browser = jBCefBrowser;
                browser.loadHTML(((GotItPromoHtmlPage)promo).getHtmlText());
                JComponent jComponent2 = browser.getComponent();
                Wrapper wrapper2 = new Wrapper(jComponent2){

                    public void paint(Graphics g) {
                        super.paint(g);
                        super.paintBorder(g);
                    }
                };
                jComponent2 = wrapper2;
                it = jComponent2;
                boolean bl2 = false;
                UIUtil.setNotOpaqueRecursively((Component)((Component)it));
                Dimension baseSize = ((GotItPromoHtmlPage)promo).getHtmlPageSize();
                adjustedSize = new Dimension(baseSize.width + 2 * borderSize, baseSize.height + 2 * borderSize);
                it.setMinimumSize(adjustedSize);
                it.setPreferredSize(adjustedSize);
                jComponent = jComponent2;
            } else if (gotItPromoContent instanceof GotItPromoImage) {
                jComponent = new JLabel(Companion.adjustIcon$intellij_platform_ide_impl(((GotItPromoImage)promo).getImage(), this.useContrastColors));
            } else if (gotItPromoContent instanceof GotItPromoComponent) {
                jComponent = ((GotItPromoComponent)promo).getComponent();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            JComponent component2 = jComponent;
            component2.setBorder(new Border(borderSize, this){
                final /* synthetic */ int $borderSize;
                final /* synthetic */ GotItComponentBuilder this$0;
                {
                    this.$borderSize = $borderSize;
                    this.this$0 = $receiver;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Graphics graphics = g.create();
                    Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                    Graphics2D g2d = (Graphics2D)graphics;
                    try {
                        double arc = JBUI.CurrentTheme.GotItTooltip.CORNER_RADIUS.get();
                        Rectangle rect = new Rectangle(0, 0, width, height);
                        RoundRectangle2D.Double roundedRect = new RoundRectangle2D.Double((double)this.$borderSize / 2.0, (double)this.$borderSize / 2.0, (double)width - (double)this.$borderSize, (double)height - (double)this.$borderSize, arc, arc);
                        Path2D path = new Path2D.Float(0);
                        path.append(roundedRect, false);
                        path.append(rect, false);
                        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        g2d.setColor(JBUI.CurrentTheme.GotItTooltip.background((boolean)GotItComponentBuilder.access$getUseContrastColors$p(this.this$0)));
                        g2d.fill(path);
                        if (GotItComponentBuilder.access$getWithImageBorder$p(this.this$0)) {
                            g2d.setColor(JBUI.CurrentTheme.GotItTooltip.imageBorderColor((boolean)GotItComponentBuilder.access$getUseContrastColors$p(this.this$0)));
                            RectanglePainter2D.DRAW.paint(g2d, 0.0, 0.0, (double)width, (double)height, Double.valueOf(arc), LinePainter2D.StrokeType.CENTERED, (double)this.$borderSize, RenderingHints.VALUE_ANTIALIAS_ON);
                        }
                    }
                    finally {
                        g2d.dispose();
                    }
                }

                public Insets getBorderInsets(Component c) {
                    int it = this.$borderSize;
                    boolean bl = false;
                    return new Insets(it, it, it, it);
                }

                public boolean isBorderOpaque() {
                    return true;
                }
            });
            panel2.add((Component)component2, gc.nextLine().next().anchor(21).coverLine().insets(JBUI.CurrentTheme.GotItTooltip.IMAGE_TOP_INSET.get(), 0, JBUI.CurrentTheme.GotItTooltip.IMAGE_BOTTOM_INSET.get(), 0));
        }
        Ref.ObjectRef iconOrStepLabel = new Ref.ObjectRef();
        Icon icon2 = this.icon;
        if (icon2 != null) {
            Icon it2 = icon2;
            boolean bl = false;
            adjusted = Companion.adjustIcon$intellij_platform_ide_impl(it2, this.useContrastColors);
            Object object2 = iconOrStepLabel.element = new JLabel((Icon)adjusted);
            Intrinsics.checkNotNull((Object)object2);
            panel2.add((Component)object2, gc.nextLine().next().anchor(256));
        }
        String string = this.stepText;
        if (string != null) {
            void $this$createContent_u24lambda_u242_u240;
            String step2 = string;
            boolean bl = false;
            it = adjusted = new JLabel(step2);
            Ref.ObjectRef bl2 = iconOrStepLabel;
            boolean bl3 = false;
            $this$createContent_u24lambda_u242_u240.setForeground(JBUI.CurrentTheme.GotItTooltip.stepForeground((boolean)this.useContrastColors));
            $this$createContent_u24lambda_u242_u240.setFont(EditorColorsManager.getInstance().getGlobalScheme().getFont(EditorFontType.PLAIN).deriveFont((float)JBFont.label().getSize()));
            bl2.element = adjusted;
            Object object3 = iconOrStepLabel.element;
            Intrinsics.checkNotNull((Object)object3);
            panel2.add((Component)object3, gc.nextLine().next().anchor(256));
        }
        if (((CharSequence)this.header).length() > 0) {
            if (this.icon == null && this.stepText == null) {
                gc.nextLine();
            }
            String string2 = HtmlChunk.raw((String)this.header).bold().wrapWith(HtmlChunk.font((String)ColorUtil.toHtmlColor((Color)JBUI.CurrentTheme.GotItTooltip.headerForeground((boolean)this.useContrastColors)))).wrapWith(HtmlChunk.html()).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String finalText = string2;
            panel2.add((Component)new JBLabel(finalText), gc.setColumn(column).anchor(21).insets(1, left, 0, 0));
        }
        HtmlBuilder builder = new HtmlBuilder();
        builder.append(HtmlChunk.raw((String)this.text));
        Shortcut shortcut = this.shortcut;
        if (shortcut != null) {
            Shortcut it3 = shortcut;
            boolean bl = false;
            builder.append(HtmlChunk.nbsp()).append(HtmlChunk.nbsp()).append((HtmlChunk)HtmlChunk.text((String)KeymapUtil.getShortcutText((Shortcut)it3)).wrapWith(HtmlChunk.font((String)ColorUtil.toHtmlColor((Color)JBUI.CurrentTheme.GotItTooltip.shortcutForeground((boolean)this.useContrastColors)))));
        }
        if (this.icon == null && this.stepText == null || ((CharSequence)this.header).length() > 0) {
            gc.nextLine();
        }
        if ((object = this.promoContent) != null && (object = object.getWidth()) != null) {
            int n2;
            int width = ((Number)object).intValue();
            boolean bl = false;
            int n3 = width;
            JLabel jLabel = (JLabel)iconOrStepLabel.element;
            if (jLabel != null) {
                void it4;
                adjustedSize = jLabel;
                int n4 = n3;
                boolean bl4 = false;
                int n5 = it4.getPreferredSize().width + left;
                n3 = n4;
                n2 = n5;
            } else {
                n2 = 0;
            }
            n = n3 - n2;
        } else {
            n = this.maxWidth;
        }
        int textWidth = n;
        LimitedWidthEditorPane description = new LimitedWidthEditorPane(builder, textWidth, this.useContrastColors, this.promoContent == null && this.maxWidth == GotItComponentBuilder.Companion.getMAX_WIDTH(), this.iconsMap);
        descriptionConsumer.invoke((Object)description);
        panel2.add((Component)description, gc.setColumn(column).anchor(21).insets(((CharSequence)this.header).length() > 0 ? JBUI.CurrentTheme.GotItTooltip.TEXT_INSET.get() : 0, left, 0, 0));
        LinkLabel<Unit> linkLabel = this.link;
        if (linkLabel != null) {
            it = linkLabel;
            boolean bl = false;
            panel2.add((Component)it, gc.nextLine().setColumn(column).anchor(21).insets(JBUI.CurrentTheme.GotItTooltip.TEXT_INSET.get(), left, 0, 0));
        }
        if (this.showButton) {
            JComponent buttonComponent;
            ActionLink secondaryButton;
            JButton bl;
            JButton $this$createContent_u24lambda_u246 = bl = new JButton(this.buttonLabel);
            boolean bl5 = false;
            $this$createContent_u24lambda_u246.setFocusable(this.requestFocus);
            if (this.requestFocus) {
                this.pressOnEnter($this$createContent_u24lambda_u246);
            }
            $this$createContent_u24lambda_u246.setOpaque(false);
            $this$createContent_u24lambda_u246.setForeground(JBUI.CurrentTheme.GotItTooltip.buttonForeground());
            $this$createContent_u24lambda_u246.putClientProperty("gotItButton", true);
            if (this.useContrastColors) {
                $this$createContent_u24lambda_u246.putClientProperty("gotItButton.contrast", true);
            } else if (this.useContrastButton) {
                $this$createContent_u24lambda_u246.putClientProperty("gotItButton.contrast.only.button", true);
            }
            if (this.useContrastColors || this.useContrastButton) {
                $this$createContent_u24lambda_u246.setForeground(JBUI.CurrentTheme.GotItTooltip.buttonForegroundContrast());
            }
            JButton button2 = bl;
            buttonConsumer.invoke((Object)button2);
            String string3 = this.secondaryButtonText;
            if (string3 != null) {
                String buttonText = string3;
                boolean bl6 = false;
                ActionLink link = new ActionLink(buttonText, null, 2, null);
                link.setForeground(JBUI.CurrentTheme.GotItTooltip.secondaryActionForeground((boolean)this.useContrastColors));
                link.setFocusable(this.requestFocus);
                if (this.requestFocus) {
                    this.pressOnEnter((JButton)link);
                }
                secondaryButtonConsumer.invoke((Object)link);
                v15 = link;
            } else {
                v15 = secondaryButton = null;
            }
            if (secondaryButton != null) {
                JPanel jPanel;
                JPanel $this$createContent_u24lambda_u248 = jPanel = new JPanel();
                boolean bl7 = false;
                $this$createContent_u24lambda_u248.setOpaque(false);
                $this$createContent_u24lambda_u248.setLayout(new BoxLayout($this$createContent_u24lambda_u248, 0));
                $this$createContent_u24lambda_u248.add(button2);
                $this$createContent_u24lambda_u248.add(Box.createHorizontalStrut(JBUIScale.scale((int)16)));
                $this$createContent_u24lambda_u248.add((Component)secondaryButton);
                v16 = jPanel;
            } else {
                v16 = buttonComponent = (JComponent)button2;
            }
            if (this.requestFocus) {
                panel2.setFocusCycleRoot(true);
                panel2.setFocusTraversalPolicyProvider(true);
                Comparator comparator = GotItComponentBuilder::createContent$lambda$9;
                panel2.setFocusTraversalPolicy(new SortingFocusTraversalPolicy(button2, secondaryButton, comparator){
                    final /* synthetic */ JButton $button;
                    final /* synthetic */ ActionLink $secondaryButton;
                    {
                        this.$button = $button;
                        this.$secondaryButton = $secondaryButton;
                        super($super_call_param$1);
                    }

                    public Component getDefaultComponent(Container aContainer) {
                        return this.$button;
                    }

                    public Component getComponentAfter(Container aContainer, Component aComponent) {
                        return Intrinsics.areEqual((Object)aComponent, (Object)this.$button) && this.$secondaryButton != null ? (JButton)this.$secondaryButton : this.$button;
                    }

                    public Component getComponentBefore(Container aContainer, Component aComponent) {
                        return this.getComponentAfter(aContainer, aComponent);
                    }
                });
            }
            panel2.add((Component)buttonComponent, gc.nextLine().setColumn(column).insets(JBUI.CurrentTheme.GotItTooltip.BUTTON_TOP_INSET.get(), left, JBUI.CurrentTheme.GotItTooltip.BUTTON_BOTTOM_INSET.get(), 0).anchor(21));
        }
        panel2.setBackground(JBUI.CurrentTheme.GotItTooltip.background((boolean)this.useContrastColors));
        panel2.setBorder(new EmptyBorder(JBUI.CurrentTheme.GotItTooltip.insets()));
        RemoteTransferUIManager.forceDirectTransfer(panel2);
        return panel2;
    }

    private final void pressOnEnter(JButton $this$pressOnEnter) {
        KeyStroke pressedKeystroke;
        InputMap inputMap = $this$pressOnEnter.getInputMap(0);
        if (inputMap.get(pressedKeystroke = KeyStroke.getKeyStroke(10, 0)) == null) {
            inputMap.put(pressedKeystroke, "pressed");
            inputMap.put(KeyStroke.getKeyStroke(10, 0, true), "released");
        }
    }

    private static final String _init_$lambda$0(String $text, GotItTextBuilder gotItTextBuilder) {
        Intrinsics.checkNotNullParameter((Object)gotItTextBuilder, (String)"<this>");
        return $text;
    }

    private static final Unit linkAction$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit afterLinkClickedAction$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit buttonAction$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit secondaryButtonAction$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit withBrowserLink$lambda$0(URL $url) {
        BrowserUtil.browse((URL)$url);
        return Unit.INSTANCE;
    }

    private static final Unit onLinkClick$lambda$0(Function0 $curAction, Function0 $action) {
        $curAction.invoke();
        $action.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit onButtonClick$lambda$0(Function0 $curAction, Function0 $action) {
        $curAction.invoke();
        $action.invoke();
        return Unit.INSTANCE;
    }

    private static final BalloonBuilder build$lambda$0(BalloonBuilder balloonBuilder) {
        Intrinsics.checkNotNullParameter((Object)balloonBuilder, (String)"<this>");
        return balloonBuilder;
    }

    private static final Unit build$lambda$1(Ref.ObjectRef $button, JButton it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $button.element = it;
        return Unit.INSTANCE;
    }

    private static final Unit build$lambda$2(Ref.ObjectRef $secondaryButton, JButton it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $secondaryButton.element = it;
        return Unit.INSTANCE;
    }

    private static final Unit build$lambda$3(Ref.ObjectRef $description, JEditorPane it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $description.element = it;
        return Unit.INSTANCE;
    }

    private static final void build$lambda$5(GotItComponentBuilder this$0, HyperlinkEvent event) {
        if (Intrinsics.areEqual((Object)event.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            Function0<Unit> action2;
            Object object = event.getDescription();
            if (object != null && (object = StringsKt.toIntOrNull((String)object)) != null) {
                Object object2 = object;
                Map<Integer, Function0<Unit>> map2 = this$0.linkActionsMap;
                int p0 = ((Number)object2).intValue();
                boolean bl = false;
                v1 = map2.get(p0);
            } else {
                v1 = action2 = null;
            }
            if (action2 != null) {
                action2.invoke();
                this$0.afterLinkClickedAction.invoke();
            } else {
                GotItComponentBuilder $this$thisLogger$iv = this$0;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(GotItComponentBuilder.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Unknown link: " + event.getDescription());
            }
        }
    }

    private static final void build$lambda$6$0(GotItComponentBuilder this$0, LinkLabel linkLabel, Unit unit) {
        this$0.linkAction.invoke();
        this$0.afterLinkClickedAction.invoke();
    }

    private static final void build$lambda$7$0(GotItComponentBuilder this$0, Balloon $balloon, ActionEvent it) {
        this$0.buttonAction.invoke();
        $balloon.hide(true);
    }

    private static final void build$lambda$8$0(GotItComponentBuilder this$0, Balloon $balloon, ActionEvent it) {
        this$0.secondaryButtonAction.invoke();
        $balloon.hide(true);
    }

    private static final void build$lambda$9(GotItComponentBuilder this$0, Balloon $balloon) {
        Function0<Unit> function0 = this$0.escapeAction;
        if (function0 != null) {
            function0.invoke();
        }
        ((BalloonImpl)$balloon).hide(true);
    }

    private static final Color getBorderColor$lambda$0(JBColor $simpleBorderColor, Color $borderColor) {
        return DrawUtil.isSimplifiedUI() ? (Color)$simpleBorderColor : $borderColor;
    }

    private static final int createContent$lambda$9(Component component2, Component component3) {
        return 0;
    }

    @JvmStatic
    public static final int getArrowShift() {
        return Companion.getArrowShift();
    }

    public static final /* synthetic */ boolean access$getUseContrastColors$p(GotItComponentBuilder $this) {
        return $this.useContrastColors;
    }

    public static final /* synthetic */ boolean access$getWithImageBorder$p(GotItComponentBuilder $this) {
        return $this.withImageBorder;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u0007H\u0007J\u001d\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ui/GotItComponentBuilder$Companion;", "", "<init>", "()V", "CLOSE_ACTION_NAME", "", "MAX_LINES_COUNT", "", "MAX_WIDTH", "getMAX_WIDTH", "()I", "EXTENDED_MAX_WIDTH", "getEXTENDED_MAX_WIDTH$intellij_platform_ide_impl", "getArrowShift", "adjustIcon", "Ljavax/swing/Icon;", "icon", "useContrastColors", "", "adjustIcon$intellij_platform_ide_impl", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final int getMAX_WIDTH() {
            return JBUIScale.scale((int)280);
        }

        public final int getEXTENDED_MAX_WIDTH$intellij_platform_ide_impl() {
            return JBUIScale.scale((int)328);
        }

        @JvmStatic
        public final int getArrowShift() {
            return JBUIScale.scale((int)15) + JBUI.CurrentTheme.GotItTooltip.CORNER_RADIUS.get();
        }

        @NotNull
        public final Icon adjustIcon$intellij_platform_ide_impl(@NotNull Icon icon2, boolean useContrastColors) {
            Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
            Color fillColor = JBUI.CurrentTheme.GotItTooltip.iconFillColor((boolean)useContrastColors);
            Color borderColor = JBUI.CurrentTheme.GotItTooltip.iconBorderColor((boolean)useContrastColors);
            return fillColor != null && borderColor != null ? GotItComponentBuilderKt.access$colorizeIfPossible(icon2, fillColor, borderColor) : (ColorUtil.isDark((Color)JBUI.CurrentTheme.GotItTooltip.background((boolean)useContrastColors)) ? IconLoader.getDarkIcon((Icon)icon2, (boolean)true) : icon2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

