/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiCompatibleDataProvider;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.JBTabsPaneImpl;
import com.intellij.ui.PrevNextActionsDescriptor;
import com.intellij.ui.TabbedPane;
import com.intellij.ui.TabbedPaneImpl;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.table.ComponentsListFocusTraversalPolicy;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabbedPaneWrapper {
    private static final Logger LOG = Logger.getInstance(TabbedPaneWrapper.class);
    protected TabbedPane tabbedPane;
    private JComponent tabbedPaneHolder;
    private TabFactory factory;

    protected TabbedPaneWrapper(boolean construct) {
        if (construct) {
            this.init(1, TabbedPaneImpl.DEFAULT_PREV_NEXT_SHORTCUTS, new JTabbedPaneFactory(this));
        }
    }

    public TabbedPaneWrapper(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            TabbedPaneWrapper.$$$reportNull$$$0(0);
        }
        this(1, TabbedPaneImpl.DEFAULT_PREV_NEXT_SHORTCUTS, parentDisposable);
    }

    public TabbedPaneWrapper(int tabPlacement, @NotNull PrevNextActionsDescriptor installKeyboardNavigation, @NotNull Disposable parentDisposable) {
        if (installKeyboardNavigation == null) {
            TabbedPaneWrapper.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            TabbedPaneWrapper.$$$reportNull$$$0(2);
        }
        TabFactory factory = 3 == tabPlacement || 1 == tabPlacement ? new JBTabsFactory(this, null, parentDisposable) : new JTabbedPaneFactory(this);
        this.init(tabPlacement, installKeyboardNavigation, factory);
    }

    final void init(int tabPlacement, @NotNull PrevNextActionsDescriptor installKeyboardNavigation, @NotNull TabFactory tabbedPaneFactory) {
        if (installKeyboardNavigation == null) {
            TabbedPaneWrapper.$$$reportNull$$$0(3);
        }
        if (tabbedPaneFactory == null) {
            TabbedPaneWrapper.$$$reportNull$$$0(4);
        }
        this.factory = tabbedPaneFactory;
        this.tabbedPane = this.createTabbedPane(tabPlacement);
        this.tabbedPane.putClientProperty(TabbedPaneWrapper.class, this.tabbedPane);
        this.tabbedPane.setKeyboardNavigation(installKeyboardNavigation);
        this.tabbedPaneHolder = this.createTabbedPaneHolder();
        this.tabbedPaneHolder.add((Component)this.tabbedPane.getComponent(), "Center");
        this.tabbedPaneHolder.setFocusTraversalPolicyProvider(true);
        this.tabbedPaneHolder.setFocusTraversalPolicy(new _MyFocusTraversalPolicy());
        this.assertIsDispatchThread();
    }

    private void assertIsDispatchThread() {
        ApplicationEx application = ApplicationManagerEx.getApplicationEx();
        if (application != null) {
            application.assertIsDispatchThread(this.tabbedPane.getComponent());
        }
    }

    public final void addChangeListener(@NotNull ChangeListener listener2) {
        if (listener2 == null) {
            TabbedPaneWrapper.$$$reportNull$$$0(5);
        }
        this.assertIsDispatchThread();
        this.tabbedPane.addChangeListener(listener2);
    }

    public final void removeChangeListener(ChangeListener listener2) {
        this.assertIsDispatchThread();
        this.tabbedPane.removeChangeListener(listener2);
    }

    protected TabbedPaneHolder createTabbedPaneHolder() {
        return this.factory.createTabbedPaneHolder();
    }

    public final JComponent getComponent() {
        this.assertIsDispatchThread();
        return this.tabbedPaneHolder;
    }

    public final synchronized void addTab(@NlsContexts.TabTitle String title2, Icon icon2, @NotNull JComponent component2, @NlsContexts.Tooltip String tip) {
        if (component2 == null) {
            TabbedPaneWrapper.$$$reportNull$$$0(6);
        }
        this.insertTab(title2, icon2, component2, tip, this.tabbedPane.getTabCount());
    }

    public final synchronized void addTab(@NlsContexts.TabTitle String title2, @Nullable JComponent component2) {
        if (component2 == null) {
            LOG.error("Unable to insert a tab without component: " + title2);
        } else {
            this.insertTab(title2, null, component2, null, this.tabbedPane.getTabCount());
        }
    }

    public synchronized void insertTab(@NlsContexts.TabTitle String title2, @Nullable Icon icon2, @NotNull JComponent component2, @NlsContexts.Tooltip String tip, int index) {
        if (component2 == null) {
            TabbedPaneWrapper.$$$reportNull$$$0(7);
        }
        this.tabbedPane.insertTab(title2, icon2, this.createTabWrapper(component2), tip, index);
    }

    private TabWrapper createTabWrapper(@NotNull JComponent component2) {
        if (component2 == null) {
            TabbedPaneWrapper.$$$reportNull$$$0(8);
        }
        return this.factory.createTabWrapper(component2);
    }

    protected TabbedPane createTabbedPane(int tabPlacement) {
        return this.factory.createTabbedPane(tabPlacement);
    }

    public final void setTabPlacement(int tabPlacement) {
        this.assertIsDispatchThread();
        this.tabbedPane.setTabPlacement(tabPlacement);
    }

    public final void addMouseListener(MouseListener listener2) {
        this.assertIsDispatchThread();
        this.tabbedPane.addMouseListener(listener2);
    }

    public final synchronized int getSelectedIndex() {
        return this.tabbedPane.getSelectedIndex();
    }

    public final void setSelectedIndex(int index) {
        this.setSelectedIndex(index, true);
    }

    public final synchronized JComponent getSelectedComponent() {
        TabWrapper tabWrapper = this.tabbedPane.getTabCount() > 0 ? (TabWrapper)this.tabbedPane.getSelectedComponent() : null;
        return tabWrapper != null ? tabWrapper.getComponent() : null;
    }

    public final void setSelectedComponent(JComponent component2) {
        this.assertIsDispatchThread();
        int index = this.indexOfComponent(component2);
        if (index == -1) {
            throw new IllegalArgumentException("component not found in tabbed pane wrapper");
        }
        this.setSelectedIndex(index);
    }

    public final void setSelectedIndex(int index, boolean requestFocus) {
        this.assertIsDispatchThread();
        boolean hadFocus = IJSwingUtilities.hasFocus2(this.tabbedPaneHolder);
        this.tabbedPane.setSelectedIndex(index);
        if (hadFocus && requestFocus) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.tabbedPaneHolder, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void removeTabAt(int index) {
        this.assertIsDispatchThread();
        boolean hadFocus = IJSwingUtilities.hasFocus2(this.tabbedPaneHolder);
        TabWrapper wrapper2 = this.getWrapperAt(index);
        try {
            this.tabbedPane.removeTabAt(index);
            if (this.tabbedPane.getTabCount() == 0) {
                this.tabbedPane.revalidate();
            }
            if (hadFocus) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.tabbedPaneHolder, true));
            }
        }
        finally {
            wrapper2.dispose();
        }
    }

    public final synchronized int getTabCount() {
        return this.tabbedPane.getTabCount();
    }

    public final Color getForegroundAt(int index) {
        this.assertIsDispatchThread();
        return this.tabbedPane.getForegroundAt(index);
    }

    public final void setForegroundAt(int index, Color color) {
        this.assertIsDispatchThread();
        this.tabbedPane.setForegroundAt(index, color);
    }

    public final Component getTabComponentAt(int index) {
        return this.tabbedPane.getTabComponentAt(index);
    }

    public final synchronized JComponent getComponentAt(int i2) {
        return this.getWrapperAt(i2).getComponent();
    }

    private TabWrapper getWrapperAt(int i2) {
        return (TabWrapper)this.tabbedPane.getComponentAt(i2);
    }

    public final void setTitleAt(int index, @NlsContexts.TabTitle @NotNull String title2) {
        if (title2 == null) {
            TabbedPaneWrapper.$$$reportNull$$$0(9);
        }
        this.assertIsDispatchThread();
        this.tabbedPane.setTitleAt(index, title2);
    }

    public final void setToolTipTextAt(int index, @NlsContexts.Tooltip String toolTipText) {
        this.assertIsDispatchThread();
        this.tabbedPane.setToolTipTextAt(index, toolTipText);
    }

    public final synchronized void setComponentAt(int index, @NotNull JComponent component2) {
        if (component2 == null) {
            TabbedPaneWrapper.$$$reportNull$$$0(10);
        }
        this.assertIsDispatchThread();
        this.tabbedPane.setComponentAt(index, this.createTabWrapper(component2));
    }

    public final void setIconAt(int index, Icon icon2) {
        this.assertIsDispatchThread();
        this.tabbedPane.setIconAt(index, icon2);
    }

    public final void setEnabledAt(int index, boolean enabled2) {
        this.assertIsDispatchThread();
        this.tabbedPane.setEnabledAt(index, enabled2);
    }

    public final synchronized int indexOfComponent(JComponent component2) {
        for (int i2 = 0; i2 < this.tabbedPane.getTabCount(); ++i2) {
            JComponent c = this.getWrapperAt(i2).getComponent();
            if (c != component2) continue;
            return i2;
        }
        return -1;
    }

    public final synchronized int getTabLayoutPolicy() {
        return this.tabbedPane.getTabLayoutPolicy();
    }

    public final synchronized void setTabLayoutPolicy(int policy) {
        this.tabbedPane.setTabLayoutPolicy(policy);
        int index = this.tabbedPane.getSelectedIndex();
        if (index != -1) {
            this.tabbedPane.scrollTabToVisible(index);
        }
    }

    @Nls
    public final String getTitleAt(int i2) {
        return this.tabbedPane.getTitleAt(i2);
    }

    @Nullable
    public String getSelectedTitle() {
        return this.getSelectedIndex() < 0 ? null : this.getTitleAt(this.getSelectedIndex());
    }

    public void setSelectedTitle(@Nullable String title2) {
        if (title2 == null) {
            return;
        }
        for (int i2 = 0; i2 < this.tabbedPane.getTabCount(); ++i2) {
            String each = this.tabbedPane.getTitleAt(i2);
            if (!title2.equals(each)) continue;
            this.tabbedPane.setSelectedIndex(i2);
            break;
        }
    }

    public void removeAll() {
        this.tabbedPane.removeAll();
    }

    @NotNull
    public TabbedPane getTabbedPane() {
        TabbedPane tabbedPane = this.tabbedPane;
        if (tabbedPane == null) {
            TabbedPaneWrapper.$$$reportNull$$$0(11);
        }
        return tabbedPane;
    }

    public static TabbedPaneWrapper get(JTabbedPane tabs) {
        return (TabbedPaneWrapper)tabs.getClientProperty(TabbedPaneWrapper.class);
    }

    @NotNull
    public static TabbedPaneWrapper createJbTabs(@Nullable Project project2, int tabPlacement, PrevNextActionsDescriptor installKeyboardNavigation, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            TabbedPaneWrapper.$$$reportNull$$$0(12);
        }
        TabbedPaneWrapper result2 = new TabbedPaneWrapper(false);
        result2.init(tabPlacement, installKeyboardNavigation, new JBTabsFactory(result2, project2, parentDisposable));
        TabbedPaneWrapper tabbedPaneWrapper = result2;
        if (tabbedPaneWrapper == null) {
            TabbedPaneWrapper.$$$reportNull$$$0(13);
        }
        return tabbedPaneWrapper;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installKeyboardNavigation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabbedPaneFactory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/TabbedPaneWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/TabbedPaneWrapper";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabbedPane";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createJbTabs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addTab";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "insertTab";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTabWrapper";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setTitleAt";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setComponentAt";
                break;
            }
            case 11: 
            case 13: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createJbTabs";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 13 -> new IllegalStateException(string);
        };
    }

    private static final class JTabbedPaneFactory
    implements TabFactory {
        private final TabbedPaneWrapper myWrapper;

        private JTabbedPaneFactory(TabbedPaneWrapper wrapper2) {
            this.myWrapper = wrapper2;
        }

        @Override
        @NotNull
        public TabbedPane createTabbedPane(int tabPlacement) {
            return new TabbedPaneImpl(tabPlacement);
        }

        @Override
        @NotNull
        public TabbedPaneHolder createTabbedPaneHolder() {
            return new TabbedPaneHolder(this.myWrapper);
        }

        @Override
        @NotNull
        public TabWrapper createTabWrapper(@NotNull JComponent component2) {
            if (component2 == null) {
                JTabbedPaneFactory.$$$reportNull$$$0(0);
            }
            return new TabWrapper(component2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/TabbedPaneWrapper$JTabbedPaneFactory", "createTabWrapper"));
        }
    }

    private static interface TabFactory {
        @NotNull
        public TabbedPane createTabbedPane(int var1);

        @NotNull
        public TabbedPaneHolder createTabbedPaneHolder();

        @NotNull
        public TabWrapper createTabWrapper(@NotNull JComponent var1);
    }

    private static final class JBTabsFactory
    implements TabFactory {
        private final Project myProject;
        private final Disposable myParent;
        private final TabbedPaneWrapper myWrapper;

        private JBTabsFactory(TabbedPaneWrapper wrapper2, Project project2, @NotNull Disposable parent) {
            if (parent == null) {
                JBTabsFactory.$$$reportNull$$$0(0);
            }
            this.myWrapper = wrapper2;
            this.myProject = project2;
            this.myParent = parent;
        }

        @Override
        @NotNull
        public TabbedPane createTabbedPane(int tabPlacement) {
            return new JBTabsPaneImpl(this.myProject, tabPlacement, this.myParent);
        }

        @Override
        @NotNull
        public TabbedPaneHolder createTabbedPaneHolder() {
            return new TabbedPaneHolder(this.myWrapper){

                @Override
                public boolean requestDefaultFocus() {
                    this.getTabs().requestFocus();
                    return true;
                }
            };
        }

        @Override
        @NotNull
        public TabWrapper createTabWrapper(@NotNull JComponent component2) {
            if (component2 == null) {
                JBTabsFactory.$$$reportNull$$$0(1);
            }
            TabWrapper tabWrapper = new TabWrapper(component2);
            tabWrapper.myCustomFocus = false;
            TabWrapper tabWrapper2 = tabWrapper;
            if (tabWrapper2 == null) {
                JBTabsFactory.$$$reportNull$$$0(2);
            }
            return tabWrapper2;
        }

        public JBTabs getTabs() {
            return ((JBTabsPaneImpl)this.myWrapper.tabbedPane).getTabs();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/TabbedPaneWrapper$JBTabsFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/TabbedPaneWrapper$JBTabsFactory";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTabWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createTabWrapper";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static class TabbedPaneHolder
    extends JPanel {
        private final TabbedPaneWrapper myWrapper;

        protected TabbedPaneHolder(TabbedPaneWrapper wrapper2) {
            super(new BorderLayout());
            this.myWrapper = wrapper2;
        }

        @Override
        public boolean requestDefaultFocus() {
            JComponent preferredFocusedComponent = IdeFocusTraversalPolicy.getPreferredFocusedComponent(this.myWrapper.tabbedPane.getComponent());
            if (preferredFocusedComponent != null) {
                if (!preferredFocusedComponent.requestFocusInWindow()) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)preferredFocusedComponent, true));
                }
                return true;
            }
            return super.requestDefaultFocus();
        }

        @Override
        public final void requestFocus() {
            this.requestDefaultFocus();
        }

        @Override
        public final boolean requestFocusInWindow() {
            return this.requestDefaultFocus();
        }

        @Override
        public void updateUI() {
            super.updateUI();
            if (this.myWrapper != null) {
                this.myWrapper.tabbedPane.updateUI();
            }
        }

        public TabbedPaneWrapper getTabbedPaneWrapper() {
            return this.myWrapper;
        }
    }

    private final class _MyFocusTraversalPolicy
    extends ComponentsListFocusTraversalPolicy {
        private _MyFocusTraversalPolicy() {
        }

        @Override
        @NotNull
        protected List<Component> getOrderedComponents() {
            ArrayList<Component> result2 = new ArrayList<Component>();
            if (TabbedPaneWrapper.this.tabbedPane.getSelectedComponent() != null) {
                result2.add(TabbedPaneWrapper.this.tabbedPane.getSelectedComponent());
            }
            ArrayList<Component> arrayList = result2;
            if (arrayList == null) {
                _MyFocusTraversalPolicy.$$$reportNull$$$0(0);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/TabbedPaneWrapper$_MyFocusTraversalPolicy", "getOrderedComponents"));
        }
    }

    public static final class TabWrapper
    extends JPanel
    implements UiCompatibleDataProvider {
        boolean myCustomFocus;
        private JComponent myComponent;

        TabWrapper(@NotNull JComponent component2) {
            if (component2 == null) {
                TabWrapper.$$$reportNull$$$0(0);
            }
            super(new BorderLayout());
            this.myCustomFocus = true;
            this.myComponent = component2;
            this.add((Component)component2, "Center");
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                TabWrapper.$$$reportNull$$$0(1);
            }
            DataSink.uiDataSnapshot((DataSink)sink, (Object)this.myComponent);
        }

        public JComponent getComponent() {
            return this.myComponent;
        }

        public void dispose() {
            if (this.myComponent != null) {
                this.remove(this.myComponent);
                this.myComponent = null;
            }
        }

        @Override
        public boolean requestDefaultFocus() {
            if (!this.myCustomFocus) {
                return super.requestDefaultFocus();
            }
            if (this.myComponent == null) {
                return false;
            }
            JComponent preferredFocusedComponent = IdeFocusTraversalPolicy.getPreferredFocusedComponent(this.myComponent);
            if (preferredFocusedComponent != null) {
                if (!preferredFocusedComponent.requestFocusInWindow()) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)preferredFocusedComponent, true));
                }
                return true;
            }
            return this.myComponent.requestDefaultFocus();
        }

        @Override
        public void requestFocus() {
            if (!this.myCustomFocus) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> super.requestFocus());
            } else {
                this.requestDefaultFocus();
            }
        }

        @Override
        public boolean requestFocusInWindow() {
            if (!this.myCustomFocus) {
                return super.requestFocusInWindow();
            }
            return this.requestDefaultFocus();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/TabbedPaneWrapper$TabWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "uiDataSnapshot";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class AsJTabbedPane
    extends TabbedPaneWrapper {
        public AsJTabbedPane(int tabPlacement) {
            super(false);
            this.init(tabPlacement, TabbedPaneImpl.DEFAULT_PREV_NEXT_SHORTCUTS, new JTabbedPaneFactory(this));
        }
    }

    @Deprecated
    public static final class AsJBTabs
    extends TabbedPaneWrapper {
        public AsJBTabs(@Nullable Project project2, int tabPlacement, PrevNextActionsDescriptor installKeyboardNavigation, @NotNull Disposable parent) {
            if (parent == null) {
                AsJBTabs.$$$reportNull$$$0(0);
            }
            super(false);
            this.init(tabPlacement, installKeyboardNavigation, new JBTabsFactory(this, project2, parent));
        }

        @NotNull
        public JBTabs getTabs() {
            JBTabs jBTabs = ((JBTabsPaneImpl)this.tabbedPane).getTabs();
            if (jBTabs == null) {
                AsJBTabs.$$$reportNull$$$0(1);
            }
            return jBTabs;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/TabbedPaneWrapper$AsJBTabs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/TabbedPaneWrapper$AsJBTabs";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTabs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

