/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dsl.builder.components;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0001\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0001\u00a8\u0006\f"}, d2={"getSegmentedButtonBorderPaint", "Ljava/awt/Paint;", "segmentedButton", "Ljava/awt/Component;", "subButton", "", "paintBorder", "", "g", "Ljava/awt/Graphics2D;", "r", "Ljava/awt/Rectangle;", "intellij.platform.ide.impl"})
public final class SegmentedButtonToolbarKt {
    @ApiStatus.Internal
    @NotNull
    public static final Paint getSegmentedButtonBorderPaint(@NotNull Component segmentedButton, boolean subButton) {
        Intrinsics.checkNotNullParameter((Object)segmentedButton, (String)"segmentedButton");
        if (!segmentedButton.isEnabled()) {
            Color color = JBUI.CurrentTheme.Button.disabledOutlineColor();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"disabledOutlineColor(...)");
            return color;
        }
        if (segmentedButton.hasFocus()) {
            Color color = JBUI.CurrentTheme.Button.focusBorderColor((boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"focusBorderColor(...)");
            return color;
        }
        if (subButton) {
            return new GradientPaint(0.0f, 0.0f, JBUI.CurrentTheme.SegmentedButton.SELECTED_START_BORDER_COLOR, 0.0f, segmentedButton.getHeight(), JBUI.CurrentTheme.SegmentedButton.SELECTED_END_BORDER_COLOR);
        }
        return new GradientPaint(0.0f, 0.0f, JBUI.CurrentTheme.Button.buttonOutlineColorStart((boolean)false), 0.0f, segmentedButton.getHeight(), JBUI.CurrentTheme.Button.buttonOutlineColorEnd((boolean)false));
    }

    @ApiStatus.Internal
    public static final void paintBorder(@NotNull Graphics2D g, @NotNull Rectangle r) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Path2D.Float border = new Path2D.Float(0);
        float lw = DarculaUIUtil.LW.getFloat();
        float arc = DarculaUIUtil.BUTTON_ARC.getFloat();
        border.append(new RoundRectangle2D.Float(r.x, r.y, r.width, r.height, arc, arc), false);
        arc = Math.max(arc - lw, 0.0f);
        border.append(new RoundRectangle2D.Float((float)r.x + lw, (float)r.y + lw, (float)r.width - lw * (float)2, (float)r.height - lw * (float)2, arc, arc), false);
        g.fill(border);
    }
}

