/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dsl.listCellRenderer.impl;

import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.GroupHeaderSeparator;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.dsl.UiDslException;
import com.intellij.ui.dsl.gridLayout.Constraints;
import com.intellij.ui.dsl.gridLayout.GridLayout;
import com.intellij.ui.dsl.gridLayout.HorizontalAlign;
import com.intellij.ui.dsl.gridLayout.UnscaledGaps;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.intellij.ui.dsl.gridLayout.builders.RowsGridBuilder;
import com.intellij.ui.dsl.listCellRenderer.KotlinUIDslRendererComponent;
import com.intellij.ui.dsl.listCellRenderer.LcrInitParams;
import com.intellij.ui.dsl.listCellRenderer.impl.LcrCellBaseImpl;
import com.intellij.ui.dsl.listCellRenderer.impl.LcrIconImpl;
import com.intellij.ui.dsl.listCellRenderer.impl.LcrSimpleColoredTextImpl;
import com.intellij.ui.dsl.listCellRenderer.impl.LcrSwitchImpl;
import com.intellij.ui.dsl.listCellRenderer.impl.RowKey;
import com.intellij.ui.popup.list.SelectablePanel;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J$\u0010\u001c\u001a\u00020\u001d2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!J\"\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00172\n\u0010%\u001a\u0006\u0012\u0002\b\u00030&2\u0006\u0010'\u001a\u00020\u0017J\u0006\u0010(\u001a\u00020\u001dJA\u0010)\u001a\u00020\u001d2\b\u0010*\u001a\u0004\u0018\u00010+2\b\u0010,\u001a\u0004\u0018\u00010+2\u0006\u0010-\u001a\u00020\u00172\b\u0010.\u001a\u0004\u0018\u00010\u00172\u0006\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\u001f\u00a2\u0006\u0002\u00101J\u0006\u00102\u001a\u00020\u001dJ\u0010\u00103\u001a\u00020\u001d2\b\u0010*\u001a\u0004\u0018\u00010+R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u00064"}, d2={"Lcom/intellij/ui/dsl/listCellRenderer/impl/RendererPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/ui/dsl/listCellRenderer/KotlinUIDslRendererComponent;", "key", "Lcom/intellij/ui/dsl/listCellRenderer/impl/RowKey;", "<init>", "(Lcom/intellij/ui/dsl/listCellRenderer/impl/RowKey;)V", "cellsLayout", "Lcom/intellij/ui/dsl/gridLayout/GridLayout;", "cellsPanel", "selectablePanel", "Lcom/intellij/ui/popup/list/SelectablePanel;", "separator", "Lcom/intellij/ui/GroupHeaderSeparator;", "listSeparator", "Lcom/intellij/openapi/ui/popup/ListSeparator;", "getListSeparator", "()Lcom/intellij/openapi/ui/popup/ListSeparator;", "setListSeparator", "(Lcom/intellij/openapi/ui/popup/ListSeparator;)V", "getCopyText", "", "getBaseline", "", "width", "height", "getAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "applySeparator", "", "isHideLine", "", "list", "Ljavax/swing/JList;", "applyCellConstraints", "Ljavax/swing/JComponent;", "i", "cell", "Lcom/intellij/ui/dsl/listCellRenderer/impl/LcrCellBaseImpl;", "leftGap", "initCollapsedComboBoxItem", "initItem", "background", "Ljava/awt/Color;", "selectionColor", "rowHeight", "rowWidth", "roundSelectionTop", "roundSelectionBottom", "(Ljava/awt/Color;Ljava/awt/Color;ILjava/lang/Integer;ZZ)V", "initOldUICollapsedComboBoxItem", "initOldUIItem", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nLcrRowImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LcrRowImpl.kt\ncom/intellij/ui/dsl/listCellRenderer/impl/RendererPanel\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,506:1\n3919#2:507\n4434#2,2:508\n*S KotlinDebug\n*F\n+ 1 LcrRowImpl.kt\ncom/intellij/ui/dsl/listCellRenderer/impl/RendererPanel\n*L\n331#1:507\n331#1:508,2\n*E\n"})
final class RendererPanel
extends JPanel
implements KotlinUIDslRendererComponent {
    @NotNull
    private final GridLayout cellsLayout;
    @NotNull
    private final JPanel cellsPanel;
    @NotNull
    private final SelectablePanel selectablePanel;
    @NotNull
    private final GroupHeaderSeparator separator;
    @Nullable
    private ListSeparator listSeparator;

    public RendererPanel(@NotNull RowKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        super(new BorderLayout());
        this.cellsLayout = new GridLayout();
        this.cellsPanel = new JPanel((LayoutManager)this.cellsLayout);
        this.selectablePanel = new SelectablePanel(null, 1, null);
        this.separator = new GroupHeaderSeparator(ExperimentalUI.Companion.isNewUI() ? JBUI.CurrentTheme.Popup.separatorLabelInsets() : (Insets)JBUI.insets((int)UIUtil.getListCellVPadding(), (int)UIUtil.getListCellHPadding()));
        this.add((Component)this.separator, "North");
        this.add((Component)this.selectablePanel, "Center");
        this.cellsPanel.setOpaque(false);
        this.selectablePanel.setLayout((LayoutManager)new BorderLayout());
        this.selectablePanel.add((Component)this.cellsPanel, (Object)"Center");
        RowsGridBuilder builder = new RowsGridBuilder((JComponent)this.cellsPanel, null, 2, null);
        builder.resizableRow();
        for (LcrCellBaseImpl.Type type : key.getTypes()) {
            RowsGridBuilder.cell$default((RowsGridBuilder)builder, (JComponent)type.createInstance(), (int)0, null, null, (boolean)false, (boolean)false, null, null, null, null, (int)1022, null);
        }
    }

    @Nullable
    public ListSeparator getListSeparator() {
        return this.listSeparator;
    }

    public void setListSeparator(@Nullable ListSeparator listSeparator) {
        this.listSeparator = listSeparator;
    }

    @Nullable
    public String getCopyText() {
        Component[] componentArray = this.cellsPanel.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        for (Component component2 : componentArray) {
            String string;
            Object object = component2;
            if (object instanceof SimpleColoredComponent) {
                string = ((Object)((SimpleColoredComponent)component2).getCharSequence(true)).toString();
            } else if (object instanceof JLabel) {
                string = ((JLabel)component2).getText();
            } else {
                throw new UiDslException("Unsupported component type: " + component2.getClass().getName(), null, 2, null);
            }
            String result2 = string;
            object = result2;
            if (object == null || object.length() == 0) continue;
            return result2;
        }
        return null;
    }

    @Override
    public int getBaseline(int width, int height) {
        CharSequence $this$filterTo$iv$iv;
        Iterator $this$filter$iv;
        List patchedLabels = new ArrayList();
        Component[] componentArray = this.cellsPanel.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        Object[] objectArray = componentArray;
        boolean $i$f$filter = false;
        Pair pair2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv = $this$filterTo$iv$iv[j];
            Component it = (Component)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type javax.swing.JComponent");
            Constraints constraints = this.cellsLayout.getConstraints((JComponent)it);
            Intrinsics.checkNotNull((Object)constraints);
            if (!constraints.getBaselineAlign()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List baselineComponents = (List)destination$iv$iv;
        for (Component component2 : baselineComponents) {
            if (!(component2 instanceof JLabel) || !(($this$filterTo$iv$iv = (CharSequence)((JLabel)component2).getText()) == null || $this$filterTo$iv$iv.length() == 0)) continue;
            ((Collection)patchedLabels).add(TuplesKt.to((Object)component2, (Object)((JLabel)component2).getText()));
            ((JLabel)component2).setText(" ");
        }
        this.selectablePanel.setSize(width, height);
        this.selectablePanel.doLayout();
        this.cellsPanel.doLayout();
        int result2 = -1;
        for (Component component3 : baselineComponents) {
            int componentBaseline = component3.getBaseline(component3.getWidth(), component3.getHeight());
            if (componentBaseline < 0) continue;
            result2 = Math.max(result2, this.cellsPanel.getY() + component3.getY() + componentBaseline);
        }
        for (Pair pair2 : patchedLabels) {
            JLabel label2 = (JLabel)pair2.component1();
            String text2 = (String)pair2.component2();
            label2.setText(text2);
        }
        return result2;
    }

    @Override
    @NotNull
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JPanel.AccessibleJPanel(this){
                final /* synthetic */ RendererPanel this$0;
                {
                    this.this$0 = $receiver;
                    super($receiver);
                }

                public AccessibleRole getAccessibleRole() {
                    AccessibleRole accessibleRole = AccessibleRole.LABEL;
                    Intrinsics.checkNotNullExpressionValue((Object)accessibleRole, (String)"LABEL");
                    return accessibleRole;
                }

                /*
                 * WARNING - void declaration
                 */
                public String getAccessibleName() {
                    void $this$filterTo$iv$iv;
                    Iterable $this$mapTo$iv$iv;
                    Component[] componentArray = RendererPanel.access$getCellsPanel$p(this.this$0).getComponents();
                    Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
                    Object[] $this$map$iv = componentArray;
                    boolean $i$f$map = false;
                    Object[] objectArray = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                    boolean $i$f$mapTo = false;
                    for (void item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Component component2 = (Component)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        String string = it.getAccessibleContext().getAccessibleName();
                        collection.add(string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null);
                    }
                    Iterable $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$filter = false;
                    $this$mapTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        String it = (String)element$iv$iv;
                        boolean bl = false;
                        CharSequence charSequence = it;
                        if (!(!(charSequence == null || charSequence.length() == 0))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List names = (List)destination$iv$iv;
                    return CollectionsKt.joinToString$default((Iterable)names, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                }
            };
        }
        AccessibleContext accessibleContext = this.accessibleContext;
        Intrinsics.checkNotNullExpressionValue((Object)accessibleContext, (String)"accessibleContext");
        return accessibleContext;
    }

    public final void applySeparator(@Nullable ListSeparator listSeparator, boolean isHideLine, @NotNull JList<?> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        this.separator.setVisible(listSeparator != null);
        if (listSeparator != null) {
            this.separator.setCaption(listSeparator.getText());
            this.separator.setHideLine(isHideLine);
            this.setBackground(list2.getBackground());
        }
    }

    @NotNull
    public final JComponent applyCellConstraints(int i2, @NotNull LcrCellBaseImpl<?> cell, int leftGap) {
        boolean resizableColumn;
        int n;
        Intrinsics.checkNotNullParameter(cell, (String)"cell");
        Component component2 = this.cellsPanel.getComponent(i2);
        Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type javax.swing.JComponent");
        JComponent result2 = (JComponent)component2;
        Constraints constraints = this.cellsLayout.getConstraints(result2);
        Intrinsics.checkNotNull((Object)constraints);
        Constraints constraints2 = constraints;
        LcrCellBaseImpl<?> lcrCellBaseImpl = cell;
        if (lcrCellBaseImpl instanceof LcrIconImpl) {
            n = 0;
        } else if (lcrCellBaseImpl instanceof LcrSwitchImpl || lcrCellBaseImpl instanceof LcrSimpleColoredTextImpl) {
            n = 1;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        int topOffset = n;
        UnscaledGaps gaps = UnscaledGapsKt.UnscaledGaps$default((int)topOffset, (int)leftGap, (int)0, (int)0, (int)12, null);
        LcrInitParams.Align align = cell.getInitParams().getAlign();
        HorizontalAlign horizontalAlign = switch (align == null ? -1 : WhenMappings.$EnumSwitchMapping$0[align.ordinal()]) {
            case -1, 1 -> HorizontalAlign.LEFT;
            case 2 -> HorizontalAlign.CENTER;
            case 3 -> HorizontalAlign.RIGHT;
            default -> throw new NoWhenBranchMatchedException();
        };
        boolean baselineAlign = cell.getBaselineAlign();
        if (!Intrinsics.areEqual((Object)constraints2.getGaps(), (Object)gaps) || constraints2.getHorizontalAlign() != horizontalAlign || constraints2.getBaselineAlign() != baselineAlign) {
            Constraints newConstrains = Constraints.copy$default((Constraints)constraints2, null, (int)0, (int)0, (int)0, (int)0, (HorizontalAlign)horizontalAlign, null, (boolean)baselineAlign, (UnscaledGaps)gaps, null, null, null, (int)3679, null);
            this.cellsLayout.setComponentConstrains(result2, newConstrains);
        }
        boolean bl = resizableColumn = cell.getInitParams().getAlign() != null;
        if (resizableColumn) {
            ((Collection)this.cellsLayout.getRootGrid().getResizableColumns()).add(i2);
        } else {
            ((Collection)this.cellsLayout.getRootGrid().getResizableColumns()).remove(i2);
        }
        return result2;
    }

    public final void initCollapsedComboBoxItem() {
        SelectablePanel $this$initCollapsedComboBoxItem_u24lambda_u240 = this.selectablePanel;
        boolean bl = false;
        $this$initCollapsedComboBoxItem_u24lambda_u240.setOpaque(false);
        $this$initCollapsedComboBoxItem_u24lambda_u240.setSelectionArc(0);
        JBInsets jBInsets = JBInsets.emptyInsets();
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"emptyInsets(...)");
        $this$initCollapsedComboBoxItem_u24lambda_u240.setSelectionInsets((Insets)jBInsets);
        $this$initCollapsedComboBoxItem_u24lambda_u240.setBorder(null);
        $this$initCollapsedComboBoxItem_u24lambda_u240.setPreferredHeight(null);
        $this$initCollapsedComboBoxItem_u24lambda_u240.setBackground(null);
        $this$initCollapsedComboBoxItem_u24lambda_u240.setSelectionColor(null);
    }

    public final void initItem(@Nullable Color background, @Nullable Color selectionColor, int rowHeight, @Nullable Integer rowWidth, boolean roundSelectionTop, boolean roundSelectionBottom) {
        int leftRightInset = JBUI.CurrentTheme.Popup.Selection.LEFT_RIGHT_INSET.get();
        Insets insets = JBUI.CurrentTheme.Popup.Selection.innerInsets();
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"innerInsets(...)");
        Insets innerInsets = insets;
        SelectablePanel $this$initItem_u24lambda_u240 = this.selectablePanel;
        boolean bl = false;
        $this$initItem_u24lambda_u240.setOpaque(true);
        $this$initItem_u24lambda_u240.setSelectionArc(JBUI.CurrentTheme.Popup.Selection.ARC.get());
        JBInsets jBInsets = JBInsets.create((int)0, (int)leftRightInset);
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"create(...)");
        $this$initItem_u24lambda_u240.setSelectionInsets((Insets)jBInsets);
        $this$initItem_u24lambda_u240.setBorder((Border)JBUI.Borders.empty((int)0, (int)(innerInsets.left + leftRightInset), (int)0, (int)(innerInsets.right + leftRightInset)));
        $this$initItem_u24lambda_u240.setPreferredHeight(Integer.valueOf(rowHeight));
        $this$initItem_u24lambda_u240.setPreferredWidth(rowWidth);
        $this$initItem_u24lambda_u240.setSelectionArcCorners(roundSelectionTop && roundSelectionBottom ? SelectablePanel.SelectionArcCorners.ALL : (roundSelectionTop ? SelectablePanel.SelectionArcCorners.TOP : (roundSelectionBottom ? SelectablePanel.SelectionArcCorners.BOTTOM : SelectablePanel.SelectionArcCorners.NONE)));
        $this$initItem_u24lambda_u240.setBackground(background);
        $this$initItem_u24lambda_u240.setSelectionColor(selectionColor);
    }

    public final void initOldUICollapsedComboBoxItem() {
        SelectablePanel $this$initOldUICollapsedComboBoxItem_u24lambda_u240 = this.selectablePanel;
        boolean bl = false;
        $this$initOldUICollapsedComboBoxItem_u24lambda_u240.setBorder(null);
        $this$initOldUICollapsedComboBoxItem_u24lambda_u240.setBackground(null);
        $this$initOldUICollapsedComboBoxItem_u24lambda_u240.setSelectionColor(null);
    }

    public final void initOldUIItem(@Nullable Color background) {
        SelectablePanel $this$initOldUIItem_u24lambda_u240 = this.selectablePanel;
        boolean bl = false;
        $this$initOldUIItem_u24lambda_u240.setBorder((Border)JBUI.Borders.empty((int)UIUtil.getListCellVPadding(), (int)UIUtil.getListCellHPadding()));
        $this$initOldUIItem_u24lambda_u240.setBackground(background);
        $this$initOldUIItem_u24lambda_u240.setSelectionColor(null);
    }

    public static final /* synthetic */ JPanel access$getCellsPanel$p(RendererPanel $this) {
        return $this.cellsPanel;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LcrInitParams.Align.values().length];
            try {
                nArray[LcrInitParams.Align.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LcrInitParams.Align.CENTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LcrInitParams.Align.RIGHT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

