/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.messages;

import com.intellij.credentialStore.CredentialPromptDialog;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.ExitActionType;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.MessageMultilineInputDialog;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TestDialogManager;
import com.intellij.openapi.ui.messages.MessageDialog;
import com.intellij.openapi.ui.messages.MessagesService;
import com.intellij.openapi.ui.messages.TwoStepConfirmationDialog;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.messages.AlertMessagesManager;
import com.intellij.ui.messages.ChooseDialog;
import com.intellij.ui.messages.InputDialogWithCheckbox;
import com.intellij.ui.messages.MoreInfoMessageDialog;
import com.intellij.ui.messages.PasswordInputDialog;
import com.intellij.util.Function;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.SwingUndoUtil;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessagesServiceImpl
implements MessagesService {
    public int showMessageDialog(@Nullable Project project2, @Nullable Component parentComponent, String message, @Nls(capitalization=Nls.Capitalization.Title) String title2, String @NotNull [] options2, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon2, @Nullable DoNotAskOption doNotAskOption, boolean alwaysUseIdeaUI, @Nullable String helpId, @Nullable String invocationPlace, ExitActionType @NotNull [] exitActionTypes) {
        if (options2 == null) {
            MessagesServiceImpl.$$$reportNull$$$0(0);
        }
        if (exitActionTypes == null) {
            MessagesServiceImpl.$$$reportNull$$$0(1);
        }
        if (MessagesServiceImpl.isApplicationInUnitTestOrHeadless()) {
            return TestDialogManager.getTestImplementation().show(message, doNotAskOption);
        }
        AlertMessagesManager alertMessagesManager = AlertMessagesManager.getInstanceIfPossible();
        if (alertMessagesManager != null) {
            return alertMessagesManager.showMessageDialog(project2, parentComponent, message, title2, options2, defaultOptionIndex, focusedOptionIndex, icon2, doNotAskOption, helpId, invocationPlace, exitActionTypes);
        }
        MessageDialog dialog2 = new MessageDialog(project2, parentComponent, message, title2, options2, defaultOptionIndex, focusedOptionIndex, icon2, doNotAskOption, false, helpId, invocationPlace, exitActionTypes);
        dialog2.show();
        return dialog2.getExitCode();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public int showMoreInfoMessageDialog(Project project2, String string, String string2, @NlsContexts.DetailedDescription String string3, String[] stringArray, int n, int n2, Icon icon2) {
        void icon3;
        void focusedOptionIndex;
        void defaultOptionIndex;
        void options2;
        void title2;
        void project3;
        AlertMessagesManager alertMessagesManager;
        void moreInfo;
        void message;
        ThreadingAssertions.assertEventDispatchThread();
        if (MessagesServiceImpl.isApplicationInUnitTestOrHeadless()) {
            return TestDialogManager.getTestImplementation().show((String)message);
        }
        if (moreInfo == null && (alertMessagesManager = AlertMessagesManager.getInstanceIfPossible()) != null) {
            return alertMessagesManager.showMessageDialog((Project)project3, null, (String)message, (String)title2, (String[])options2, (int)defaultOptionIndex, (int)focusedOptionIndex, (Icon)icon3, null, null, null, new ExitActionType[0]);
        }
        MoreInfoMessageDialog dialog2 = new MoreInfoMessageDialog((Project)project3, (String)message, (String)title2, (String)moreInfo, (String[])options2, (int)defaultOptionIndex, (int)focusedOptionIndex, (Icon)icon3);
        dialog2.show();
        return dialog2.getExitCode();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public int showTwoStepConfirmationDialog(String string, String string2, String[] stringArray, String string3, boolean bl, int n, int n2, Icon icon2, BiFunction<? super Integer, ? super JCheckBox, Integer> biFunction) {
        void exitFunc;
        void icon3;
        void focusedOptionIndex;
        void defaultOptionIndex;
        void checked;
        void checkboxText;
        void options2;
        void title2;
        void message;
        ThreadingAssertions.assertEventDispatchThread();
        if (MessagesServiceImpl.isApplicationInUnitTestOrHeadless()) {
            return TestDialogManager.getTestImplementation().show((String)message);
        }
        TwoStepConfirmationDialog dialog2 = new TwoStepConfirmationDialog((String)message, (String)title2, (String[])options2, (String)checkboxText, (boolean)checked, (int)defaultOptionIndex, (int)focusedOptionIndex, (Icon)icon3, (BiFunction)exitFunc);
        dialog2.show();
        return dialog2.getExitCode();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public String showPasswordDialog(Project project2, String string, String string2, Icon icon2, InputValidator inputValidator) {
        void icon3;
        void title2;
        void project3;
        void validator2;
        void message;
        ThreadingAssertions.assertEventDispatchThread();
        if (MessagesServiceImpl.isApplicationInUnitTestOrHeadless()) {
            return TestDialogManager.getTestInputImplementation().show((String)message, (InputValidator)validator2);
        }
        PasswordInputDialog dialog2 = project3 != null ? new PasswordInputDialog((Project)project3, (String)message, (String)title2, (Icon)icon3, (InputValidator)validator2) : new PasswordInputDialog((String)message, (String)title2, (Icon)icon3, (InputValidator)validator2);
        dialog2.show();
        return dialog2.getInputString();
    }

    @RequiresEdt
    public char[] showPasswordDialog(@NotNull Component parentComponent, String message, String title2, Icon icon2, @Nullable InputValidator validator2) {
        if (parentComponent == null) {
            MessagesServiceImpl.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (MessagesServiceImpl.isApplicationInUnitTestOrHeadless()) {
            return TestDialogManager.getTestInputImplementation().show(message, validator2).toCharArray();
        }
        PasswordInputDialog dialog2 = new PasswordInputDialog(parentComponent, message, title2, icon2, validator2);
        dialog2.show();
        return dialog2.getExitCode() == 0 ? CredentialPromptDialog.getTrimmedChars(dialog2.getTextField()) : null;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public String showInputDialog(@Nullable Project project2, Component component2, String string, String string2, @Nullable Icon icon2, @Nullable String string3, @Nullable InputValidator inputValidator, @Nullable TextRange textRange, @NlsContexts.DetailedDescription @Nullable String string4) {
        void selection;
        void comment2;
        void initialValue;
        void icon3;
        void title2;
        void project3;
        void validator2;
        void message;
        ThreadingAssertions.assertEventDispatchThread();
        if (MessagesServiceImpl.isApplicationInUnitTestOrHeadless()) {
            return TestDialogManager.getTestInputImplementation().show((String)message, (InputValidator)validator2);
        }
        Messages.InputDialog dialog2 = new Messages.InputDialog((Project)project3, (String)message, (String)title2, (Icon)icon3, (String)initialValue, (InputValidator)validator2, new String[]{Messages.getOkButton(), Messages.getCancelButton()}, 0, (String)comment2);
        JTextComponent field = dialog2.getTextField();
        if (selection != null) {
            field.select(selection.getStartOffset(), selection.getEndOffset());
            field.putClientProperty(DialogWrapperPeer.HAVE_INITIAL_SELECTION, true);
        }
        dialog2.show();
        return dialog2.getInputString();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public String showMultilineInputDialog(Project project2, String string, String string2, String string3, Icon icon2, @Nullable InputValidator inputValidator) {
        void initialValue;
        void icon3;
        void title2;
        void project3;
        void validator2;
        void message;
        ThreadingAssertions.assertEventDispatchThread();
        if (MessagesServiceImpl.isApplicationInUnitTestOrHeadless()) {
            return TestDialogManager.getTestInputImplementation().show((String)message, (InputValidator)validator2);
        }
        MessageMultilineInputDialog dialog2 = new MessageMultilineInputDialog((Project)project3, (String)message, (String)title2, (Icon)icon3, (String)initialValue, (InputValidator)validator2, new String[]{Messages.getOkButton(), Messages.getCancelButton()}, 0);
        dialog2.show();
        return dialog2.getInputString();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public @NotNull Pair<@Nullable String, Boolean> showInputDialogWithCheckBox(String string, String string2, String string3, boolean bl, boolean bl2, Icon icon2, String string4, InputValidator inputValidator) {
        void validator2;
        void initialValue;
        void icon3;
        void checkboxEnabled;
        void checkboxText;
        void title2;
        void checked;
        void message;
        ThreadingAssertions.assertEventDispatchThread();
        if (MessagesServiceImpl.isApplicationInUnitTestOrHeadless()) {
            return new Pair((Object)TestDialogManager.getTestInputImplementation().show((String)message), (Object)((boolean)checked));
        }
        InputDialogWithCheckbox dialog2 = new InputDialogWithCheckbox((String)message, (String)title2, (String)checkboxText, (boolean)checked, (boolean)checkboxEnabled, (Icon)icon3, (String)initialValue, (InputValidator)validator2);
        dialog2.show();
        Pair pair = Pair.create((Object)dialog2.getInputString(), (Object)dialog2.isChecked());
        if (pair == null) {
            MessagesServiceImpl.$$$reportNull$$$0(3);
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public String showEditableChooseDialog(String string, String string2, Icon icon2, String[] stringArray, @NlsSafe String string3, InputValidator inputValidator) {
        void initialValue;
        void values;
        void icon3;
        void title2;
        void validator2;
        void message;
        ThreadingAssertions.assertEventDispatchThread();
        if (MessagesServiceImpl.isApplicationInUnitTestOrHeadless()) {
            return TestDialogManager.getTestInputImplementation().show((String)message, (InputValidator)validator2);
        }
        ChooseDialog dialog2 = new ChooseDialog((String)message, (String)title2, (Icon)icon3, (String[])values, (String)initialValue);
        dialog2.setValidator((InputValidator)validator2);
        dialog2.getComboBox().setEditable(true);
        dialog2.getComboBox().getEditor().setItem(initialValue);
        dialog2.getComboBox().setSelectedItem(initialValue);
        dialog2.show();
        return dialog2.getInputString();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public int showChooseDialog(@Nullable Project project2, @Nullable Component component2, String string, String string2, String[] stringArray, String string3, @Nullable Icon icon2) {
        void initialValue;
        void values;
        void icon3;
        void title2;
        void parentComponent;
        void project3;
        void message;
        ThreadingAssertions.assertEventDispatchThread();
        if (MessagesServiceImpl.isApplicationInUnitTestOrHeadless()) {
            return TestDialogManager.getTestImplementation().show((String)message);
        }
        ChooseDialog dialog2 = new ChooseDialog((Project)project3, (Component)parentComponent, (String)message, (String)title2, (Icon)icon3, (String[])values, (String)initialValue);
        dialog2.show();
        return dialog2.getSelectedIndex();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void showTextAreaDialog(JTextField jTextField, String string, String string2, Function<? super String, ? extends List<String>> function, Function<? super List<String>, String> function2) {
        void lineJoiner;
        void dimensionServiceKey;
        void textField2;
        void parser;
        void title2;
        ThreadingAssertions.assertEventDispatchThread();
        if (MessagesServiceImpl.isApplicationInUnitTestOrHeadless()) {
            TestDialogManager.getTestImplementation().show((String)title2);
            return;
        }
        JTextArea textArea = new JTextArea(10, 50);
        SwingUndoUtil.addUndoRedoActions((JTextComponent)textArea);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        List lines = (List)parser.fun((Object)textField2.getText());
        textArea.setText(StringUtil.join((Collection)lines, (String)"\n"));
        InsertPathAction.copyFromTo((JTextComponent)textField2, (JTextComponent)textArea);
        DialogBuilder builder = new DialogBuilder((Component)textField2);
        builder.setDimensionServiceKey((String)dimensionServiceKey);
        builder.setCenterPanel((JComponent)ScrollPaneFactory.createScrollPane((Component)textArea));
        builder.setPreferredFocusComponent((JComponent)textArea);
        String rawText = title2;
        if (StringUtil.endsWithChar((CharSequence)rawText, (char)':')) {
            rawText = rawText.substring(0, rawText.length() - 1);
        }
        builder.setTitle(rawText);
        builder.addOkAction();
        builder.addCancelAction();
        builder.setOkOperation(() -> MessagesServiceImpl.lambda$showTextAreaDialog$0((JTextField)textField2, (Function)lineJoiner, textArea, builder));
        builder.show();
    }

    public void showErrorDialog(@Nullable Project project2, @NlsContexts.DialogMessage @Nullable String message, @NlsContexts.DialogTitle @NotNull String title2) {
        if (title2 == null) {
            MessagesServiceImpl.$$$reportNull$$$0(4);
        }
        Messages.showErrorDialog((Project)project2, (String)message, (String)title2);
    }

    private static boolean isApplicationInUnitTestOrHeadless() {
        Application app = ApplicationManager.getApplication();
        return app != null && (app.isUnitTestMode() || app.isHeadlessEnvironment());
    }

    private static /* synthetic */ void lambda$showTextAreaDialog$0(JTextField textField2, Function lineJoiner, JTextArea textArea, DialogBuilder builder) {
        textField2.setText((String)lineJoiner.fun(Arrays.asList(StringUtil.splitByLines((String)textArea.getText()))));
        builder.getDialogWrapper().close(0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exitActionTypes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/messages/MessagesServiceImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/messages/MessagesServiceImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "showInputDialogWithCheckBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showMessageDialog";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showPasswordDialog";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showErrorDialog";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

