/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.plaf.beg;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.laf.intellij.IdeaPopupMenuUI;
import com.intellij.openapi.actionSystem.impl.ActionMenuItem;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.keymap.MacKeymapUtil;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.plaf.beg.IdeaMenuUI;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.BasicMenuItemUI;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class BegMenuItemUI
extends BasicMenuItemUI {
    private static final String KEEP_MENU_OPEN_PROP = "BegMenuItemUI.keep-menu-open";
    private static final Rectangle ourEmptyRect = new Rectangle(0, 0, 0, 0);
    private static final Rectangle ourTextRect = new Rectangle();
    private static final Rectangle ourArrowIconRect = new Rectangle();
    private static final Rectangle ourAcceleratorRect = new Rectangle();
    private static final Rectangle ourCheckIconRect = new Rectangle();
    private static final Rectangle ourIconRect = new Rectangle();
    private static final Rectangle ourSecondaryIconRect = new Rectangle();
    private static final Rectangle ourViewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    private int myMaxGutterIconWidth = 18;
    private int myMaxGutterIconWidth2 = 18;
    @NonNls
    public static final String PLAY_SOUND_METHOD = "playSound";

    public static ComponentUI createUI(JComponent component2) {
        return new BegMenuItemUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        String propertyPrefix = this.getPropertyPrefix();
        Integer integer = UIUtil.getPropertyMaxGutterIconWidth((String)propertyPrefix);
        if (integer != null) {
            this.myMaxGutterIconWidth2 = this.myMaxGutterIconWidth = integer.intValue();
        }
        this.selectionBackground = JBColor.namedColor((String)"Menu.selectionBackground", (Color)UIUtil.getListSelectionBackground((boolean)true));
    }

    static boolean isSelected(JMenuItem item) {
        if (item == null) {
            return false;
        }
        ButtonModel model2 = item.getModel();
        if (model2 == null) {
            return false;
        }
        return model2.isArmed() || item instanceof JMenu && model2.isSelected();
    }

    private void checkArrowIcon() {
        if (this.arrowIcon != null && IdeaPopupMenuUI.isPartOfPopupMenu(this.menuItem)) {
            this.arrowIcon = null;
        }
    }

    private void checkEmptyIcon(JComponent comp) {
        this.myMaxGutterIconWidth = this.getCheckIcon() == null && IdeaPopupMenuUI.hideEmptyIcon(comp) ? 0 : this.myMaxGutterIconWidth2;
    }

    @Override
    public void paint(Graphics g, JComponent comp) {
        this.checkArrowIcon();
        UISettings.setupAntialiasing((Graphics)g);
        JMenuItem menuItem = (JMenuItem)comp;
        ButtonModel buttonModel = menuItem.getModel();
        Icon icon2 = this.getIcon();
        Icon secondaryIcon = this.getSecondaryIcon();
        Icon checkIcon = this.getCheckIcon();
        this.checkEmptyIcon(comp);
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        BegMenuItemUI.initBounds();
        ourViewRect.setBounds(0, 0, menuWidth, menuHeight);
        JBInsets.removeFrom((Rectangle)ourViewRect, (Insets)comp.getInsets());
        Font oldFont = g.getFont();
        Font font = comp.getFont();
        g.setFont(font);
        FontMetrics fontMetrics = g.getFontMetrics(font);
        FontMetrics keyStrokeMetrics = g.getFontMetrics(this.acceleratorFont);
        String keyStrokeText = BegMenuItemUI.getKeyStrokeText(menuItem);
        String text2 = this.layoutMenuItem(fontMetrics, menuItem.getText(), keyStrokeMetrics, keyStrokeText, icon2, secondaryIcon, checkIcon, this.arrowIcon, menuItem.getVerticalAlignment(), menuItem.getHorizontalAlignment(), menuItem.getVerticalTextPosition(), menuItem.getHorizontalTextPosition(), ourViewRect, ourIconRect, ourSecondaryIconRect, ourTextRect, ourAcceleratorRect, ourCheckIconRect, ourArrowIconRect, menuItem.getText() != null ? this.defaultTextIconGap : 0, this.defaultTextIconGap);
        Color oldColor = g.getColor();
        if (comp.isOpaque()) {
            g.setColor(menuItem.getBackground());
            g.fillRect(0, 0, menuWidth, menuHeight);
            if (BegMenuItemUI.isSelected(menuItem)) {
                g.setColor(this.selectionBackground);
                if (ExperimentalUI.isNewUI() || IdeaPopupMenuUI.isRoundBorder()) {
                    IdeaMenuUI.paintRoundSelection(g, comp, menuWidth, menuHeight);
                } else {
                    g.fillRect(0, 0, menuWidth, menuHeight);
                }
            }
            g.setColor(oldColor);
        }
        if (checkIcon != null) {
            if (BegMenuItemUI.isSelected(menuItem)) {
                g.setColor(this.selectionForeground);
            } else {
                g.setColor(menuItem.getForeground());
            }
            if (this.useCheckAndArrow()) {
                IconUtil.paintSelectionAwareIcon((Icon)checkIcon, (JComponent)menuItem, (Graphics)g, (int)BegMenuItemUI.ourCheckIconRect.x, (int)BegMenuItemUI.ourCheckIconRect.y, (boolean)BegMenuItemUI.isSelected(menuItem));
            }
            g.setColor(oldColor);
        }
        if (icon2 != null) {
            if (!buttonModel.isEnabled()) {
                icon2 = menuItem.getDisabledIcon();
            } else if (buttonModel.isPressed() && buttonModel.isArmed() && (icon2 = menuItem.getPressedIcon()) == null) {
                icon2 = menuItem.getIcon();
            }
            if (icon2 != null) {
                IconUtil.paintSelectionAwareIcon((Icon)icon2, (JComponent)menuItem, (Graphics)g, (int)BegMenuItemUI.ourIconRect.x, (int)BegMenuItemUI.ourIconRect.y, (boolean)BegMenuItemUI.isSelected(menuItem));
            }
        }
        if (text2 != null && !text2.isEmpty()) {
            int mnemonicIndex = menuItem.getDisplayedMnemonicIndex();
            if (buttonModel.isEnabled()) {
                if (BegMenuItemUI.isSelected(menuItem)) {
                    g.setColor(this.selectionForeground);
                } else {
                    g.setColor(menuItem.getForeground());
                }
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text2, mnemonicIndex, BegMenuItemUI.ourTextRect.x, BegMenuItemUI.ourTextRect.y + fontMetrics.getAscent());
            } else {
                Object disabledForeground = UIUtil.getMenuItemDisabledForegroundObject();
                if (disabledForeground instanceof Color) {
                    Color disabledColor = (Color)disabledForeground;
                    g.setColor(disabledColor);
                    BasicGraphicsUtils.drawStringUnderlineCharAt(g, text2, mnemonicIndex, BegMenuItemUI.ourTextRect.x, BegMenuItemUI.ourTextRect.y + fontMetrics.getAscent());
                } else {
                    g.setColor(menuItem.getBackground().brighter());
                    BasicGraphicsUtils.drawStringUnderlineCharAt(g, text2, mnemonicIndex, BegMenuItemUI.ourTextRect.x, BegMenuItemUI.ourTextRect.y + fontMetrics.getAscent());
                    g.setColor(menuItem.getBackground().darker());
                    BasicGraphicsUtils.drawStringUnderlineCharAt(g, text2, mnemonicIndex, BegMenuItemUI.ourTextRect.x - 1, BegMenuItemUI.ourTextRect.y + fontMetrics.getAscent() - 1);
                }
            }
        }
        if (secondaryIcon != null) {
            IconUtil.paintSelectionAwareIcon((Icon)secondaryIcon, (JComponent)menuItem, (Graphics)g, (int)BegMenuItemUI.ourSecondaryIconRect.x, (int)BegMenuItemUI.ourSecondaryIconRect.y, (boolean)BegMenuItemUI.isSelected(menuItem));
        }
        if (keyStrokeText != null && !keyStrokeText.isEmpty()) {
            g.setFont(this.acceleratorFont);
            if (buttonModel.isEnabled()) {
                if (UIUtil.isUnderAquaBasedLookAndFeel() && BegMenuItemUI.isSelected(menuItem)) {
                    g.setColor(this.selectionForeground);
                } else if (BegMenuItemUI.isSelected(menuItem)) {
                    g.setColor(this.acceleratorSelectionForeground);
                } else {
                    g.setColor(this.acceleratorForeground);
                }
                BasicGraphicsUtils.drawString(g, keyStrokeText, 0, BegMenuItemUI.ourAcceleratorRect.x, BegMenuItemUI.ourAcceleratorRect.y + keyStrokeMetrics.getAscent());
            } else if (this.disabledForeground != null) {
                g.setColor(this.disabledForeground);
                BasicGraphicsUtils.drawString(g, keyStrokeText, 0, BegMenuItemUI.ourAcceleratorRect.x, BegMenuItemUI.ourAcceleratorRect.y + keyStrokeMetrics.getAscent());
            } else {
                g.setColor(menuItem.getBackground().brighter());
                BasicGraphicsUtils.drawString(g, keyStrokeText, 0, BegMenuItemUI.ourAcceleratorRect.x, BegMenuItemUI.ourAcceleratorRect.y + keyStrokeMetrics.getAscent());
                g.setColor(menuItem.getBackground().darker());
                BasicGraphicsUtils.drawString(g, keyStrokeText, 0, BegMenuItemUI.ourAcceleratorRect.x - 1, BegMenuItemUI.ourAcceleratorRect.y + keyStrokeMetrics.getAscent() - 1);
            }
        }
        if (this.arrowIcon != null) {
            if (BegMenuItemUI.isSelected(menuItem)) {
                g.setColor(this.selectionForeground);
            }
            if (this.useCheckAndArrow()) {
                IconUtil.paintSelectionAwareIcon((Icon)this.arrowIcon, (JComponent)comp, (Graphics)g, (int)BegMenuItemUI.ourArrowIconRect.x, (int)BegMenuItemUI.ourArrowIconRect.y, (boolean)BegMenuItemUI.isSelected(menuItem));
            }
        }
        g.setColor(oldColor);
        g.setFont(oldFont);
    }

    @NlsSafe
    private static String getKeyStrokeText(@NotNull JMenuItem item) {
        if (item == null) {
            BegMenuItemUI.$$$reportNull$$$0(0);
        }
        return item instanceof ActionMenuItem ? ((ActionMenuItem)((Object)item)).getFirstShortcutText() : BegMenuItemUI.getKeyStrokeText(item.getAccelerator());
    }

    @NlsSafe
    private static String getKeyStrokeText(KeyStroke keystroke) {
        Object s1 = "";
        if (keystroke != null) {
            int j1 = keystroke.getModifiers();
            if (j1 > 0) {
                s1 = ClientSystemInfo.isMac() ? MacKeymapUtil.getKeyModifiersTextForMacOSLeopard((int)j1) : KeyEvent.getKeyModifiersText(j1) + "+";
            }
            s1 = (String)s1 + KeyEvent.getKeyText(keystroke.getKeyCode());
        }
        return s1;
    }

    private boolean useCheckAndArrow() {
        return !(this.menuItem instanceof JMenu) || !((JMenu)this.menuItem).isTopLevelMenu();
    }

    @Override
    public MenuElement[] getPath() {
        MenuElement[] amenuelement1;
        MenuSelectionManager menuselectionmanager = MenuSelectionManager.defaultManager();
        MenuElement[] amenuelement = menuselectionmanager.getSelectedPath();
        int i1 = amenuelement.length;
        if (i1 == 0) {
            return new MenuElement[0];
        }
        Container container = this.menuItem.getParent();
        if (amenuelement[i1 - 1].getComponent() == container) {
            amenuelement1 = new MenuElement[i1 + 1];
            System.arraycopy(amenuelement, 0, amenuelement1, 0, i1);
            amenuelement1[i1] = this.menuItem;
        } else {
            int j1;
            for (j1 = amenuelement.length - 1; j1 >= 0 && amenuelement[j1].getComponent() != container; --j1) {
            }
            amenuelement1 = new MenuElement[j1 + 2];
            System.arraycopy(amenuelement, 0, amenuelement1, 0, j1 + 1);
            amenuelement1[j1 + 1] = this.menuItem;
        }
        return amenuelement1;
    }

    @Override
    public Dimension getMinimumSize(JComponent jcomponent) {
        return null;
    }

    private String layoutMenuItem(FontMetrics fontMetrics, @NlsContexts.Command String text2, FontMetrics keyStrokeMetrics, @NlsContexts.Label String keyStrokeText, Icon icon2, Icon secondaryIcon, Icon checkIcon, Icon arrowIcon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewRect, Rectangle iconRect, Rectangle secondaryIconRect, Rectangle textRect, Rectangle acceleratorRect, Rectangle checkIconRect, Rectangle arrowIconRect, int textIconGap, int menuItemGap) {
        SwingUtilities.layoutCompoundLabel(this.menuItem, fontMetrics, text2, icon2, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewRect, iconRect, textRect, textIconGap);
        if (keyStrokeText == null || keyStrokeText.isEmpty()) {
            acceleratorRect.height = 0;
            acceleratorRect.width = 0;
        } else {
            acceleratorRect.width = SwingUtilities.computeStringWidth(keyStrokeMetrics, keyStrokeText);
            acceleratorRect.height = keyStrokeMetrics.getHeight();
        }
        if (this.useCheckAndArrow()) {
            if (checkIcon != null) {
                checkIconRect.width = checkIcon.getIconWidth();
                checkIconRect.height = checkIcon.getIconHeight();
            } else {
                checkIconRect.height = 0;
                checkIconRect.width = 0;
            }
            if (arrowIcon != null) {
                arrowIconRect.width = arrowIcon.getIconWidth();
                arrowIconRect.height = arrowIcon.getIconHeight();
            } else {
                arrowIconRect.height = 0;
                arrowIconRect.width = 0;
            }
            textRect.x += this.myMaxGutterIconWidth;
            iconRect.x += this.myMaxGutterIconWidth;
        }
        textRect.x += menuItemGap;
        iconRect.x += menuItemGap;
        Rectangle labelRect = iconRect.union(textRect);
        if (secondaryIcon != null) {
            secondaryIconRect.width = secondaryIcon.getIconWidth();
            secondaryIconRect.height = secondaryIcon.getIconHeight();
            secondaryIconRect.x = labelRect.x + labelRect.width + menuItemGap;
            secondaryIconRect.y = labelRect.y + labelRect.height / 2 - secondaryIcon.getIconHeight() / 2;
        }
        acceleratorRect.x = viewRect.x + viewRect.width - arrowIconRect.width - (arrowIconRect.width > 0 ? menuItemGap : 0) - acceleratorRect.width;
        acceleratorRect.y = viewRect.y + viewRect.height / 2 - acceleratorRect.height / 2;
        if (this.useCheckAndArrow()) {
            arrowIconRect.x = viewRect.x + viewRect.width - arrowIconRect.width;
            arrowIconRect.y = labelRect.y + labelRect.height / 2 - arrowIconRect.height / 2;
            if (checkIcon != null) {
                checkIconRect.y = labelRect.y + labelRect.height / 2 - checkIconRect.height / 2;
                checkIconRect.x += viewRect.x + this.myMaxGutterIconWidth / 2 - checkIcon.getIconWidth() / 2;
            } else {
                checkIconRect.y = 0;
                checkIconRect.x = 0;
            }
        }
        return text2;
    }

    private Icon getIcon() {
        Icon icon2 = this.menuItem.getIcon();
        if (icon2 != null && this.getCheckIcon() != null) {
            icon2 = null;
        }
        return icon2;
    }

    @Override
    public Dimension getPreferredSize(JComponent comp) {
        this.checkArrowIcon();
        JMenuItem menuItem = (JMenuItem)comp;
        Icon icon2 = this.getIcon();
        Icon secondaryIcon = this.getSecondaryIcon();
        Icon checkIcon = this.getCheckIcon();
        this.checkEmptyIcon(comp);
        String text2 = menuItem.getText();
        String keyStrokeText = BegMenuItemUI.getKeyStrokeText(menuItem);
        FontMetrics fontMetrics = comp.getFontMetrics(menuItem.getFont());
        FontMetrics keyStrokeMetrics = comp.getFontMetrics(this.acceleratorFont);
        BegMenuItemUI.initBounds();
        this.layoutMenuItem(fontMetrics, text2, keyStrokeMetrics, keyStrokeText, icon2, secondaryIcon, checkIcon, this.arrowIcon, menuItem.getVerticalAlignment(), menuItem.getHorizontalAlignment(), menuItem.getVerticalTextPosition(), menuItem.getHorizontalTextPosition(), ourViewRect, ourIconRect, ourSecondaryIconRect, ourTextRect, ourAcceleratorRect, ourCheckIconRect, ourArrowIconRect, text2 != null ? this.defaultTextIconGap : 0, this.defaultTextIconGap);
        Rectangle rect = new Rectangle();
        rect.setBounds(ourTextRect);
        SwingUtilities.computeUnion(BegMenuItemUI.ourIconRect.x, BegMenuItemUI.ourIconRect.y, BegMenuItemUI.ourIconRect.width, BegMenuItemUI.ourIconRect.height, rect);
        if (keyStrokeText != null && !keyStrokeText.isEmpty()) {
            rect.width += BegMenuItemUI.ourAcceleratorRect.width;
            rect.width += 7 * this.defaultTextIconGap;
        }
        if (secondaryIcon != null) {
            rect.width += BegMenuItemUI.ourSecondaryIconRect.width + 2 * this.defaultTextIconGap;
        }
        if (this.useCheckAndArrow()) {
            rect.width += this.myMaxGutterIconWidth;
            rect.width += this.defaultTextIconGap;
            rect.width += this.defaultTextIconGap;
            rect.width += BegMenuItemUI.ourArrowIconRect.width;
        }
        rect.width += 2 * this.defaultTextIconGap;
        Insets insets = menuItem.getInsets();
        if (insets != null) {
            rect.width += insets.left + insets.right;
            rect.height += insets.top + insets.bottom;
        }
        if (rect.width % 2 == 0) {
            ++rect.width;
        }
        if (rect.height % 2 == 0) {
            ++rect.height;
        }
        return IdeaMenuUI.patchPreferredSize(comp, rect.getSize());
    }

    private static void initBounds() {
        ourIconRect.setBounds(ourEmptyRect);
        ourSecondaryIconRect.setBounds(ourEmptyRect);
        ourTextRect.setBounds(ourEmptyRect);
        ourAcceleratorRect.setBounds(ourEmptyRect);
        ourCheckIconRect.setBounds(ourEmptyRect);
        ourArrowIconRect.setBounds(ourEmptyRect);
        ourViewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
    }

    private Icon getCheckIcon() {
        Icon icon2;
        Icon icon3 = !this.menuItem.isEnabled() ? this.menuItem.getDisabledIcon() : (icon2 = BegMenuItemUI.isSelected(this.menuItem) ? this.menuItem.getSelectedIcon() : this.menuItem.getIcon());
        if (icon2 != null && icon2.getIconWidth() > this.myMaxGutterIconWidth) {
            icon2 = null;
        }
        return icon2;
    }

    private Icon getSecondaryIcon() {
        Icon icon2;
        JMenuItem jMenuItem = this.menuItem;
        if (jMenuItem instanceof ActionMenuItem) {
            ActionMenuItem actionMenuItem = (ActionMenuItem)((Object)jMenuItem);
            icon2 = actionMenuItem.getSecondaryIcon();
        } else {
            icon2 = null;
        }
        return icon2;
    }

    @Override
    public Dimension getMaximumSize(JComponent comp) {
        return null;
    }

    @Override
    public void update(Graphics g, JComponent comp) {
        this.paint(g, comp);
    }

    private boolean isInternalFrameSystemMenu() {
        String actionCommand = this.menuItem.getActionCommand();
        return "Close".equals(actionCommand) || "Minimize".equals(actionCommand) || "Restore".equals(actionCommand) || "Maximize".equals(actionCommand);
    }

    private void doClick(MenuSelectionManager msm, MouseEvent e) {
        Container parent;
        ActionMenuItem item;
        boolean keepMenuOpen;
        Action audioAction;
        ActionMap map2;
        if (!this.isInternalFrameSystemMenu() && (map2 = this.menuItem.getActionMap()) != null && (audioAction = map2.get(this.getPropertyPrefix() + ".commandSound")) != null) {
            BasicLookAndFeel lf = (BasicLookAndFeel)UIManager.getLookAndFeel();
            try {
                Method playSoundMethod = BasicLookAndFeel.class.getDeclaredMethod(PLAY_SOUND_METHOD, Action.class);
                playSoundMethod.setAccessible(true);
                playSoundMethod.invoke((Object)lf, audioAction);
            }
            catch (Exception playSoundMethod) {
                // empty catch block
            }
        }
        if (msm == null) {
            msm = MenuSelectionManager.defaultManager();
        }
        if (!(keepMenuOpen = Utils.isKeepPopupOpen((item = (ActionMenuItem)((Object)this.menuItem)).getKeepPopupOnPerform(), e))) {
            msm.clearSelectedPath();
        }
        ActionEvent event = new ActionEvent(this.menuItem, 1001, null, e.getWhen(), e.getModifiers());
        item.fireActionPerformed(event);
        if (keepMenuOpen && (parent = item.getParent()) instanceof JComponent) {
            ((JComponent)parent).putClientProperty(KEEP_MENU_OPEN_PROP, System.currentTimeMillis());
        }
    }

    public static void registerMultiChoiceSupport(@NotNull JPopupMenu component2, @NotNull Consumer<? super JPopupMenu> onUpdate) {
        if (component2 == null) {
            BegMenuItemUI.$$$reportNull$$$0(1);
        }
        if (onUpdate == null) {
            BegMenuItemUI.$$$reportNull$$$0(2);
        }
        component2.addPropertyChangeListener(KEEP_MENU_OPEN_PROP, evt -> onUpdate.accept((JPopupMenu)evt.getSource()));
    }

    @Override
    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new MyMouseInputHandler();
    }

    @Override
    protected MenuDragMouseListener createMenuDragMouseListener(JComponent c) {
        return new MyMenuDragMouseHandler();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onUpdate";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/plaf/beg/BegMenuItemUI";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getKeyStrokeText";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "registerMultiChoiceSupport";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MyMouseInputHandler
    extends BasicMenuItemUI.MouseInputHandler {
        private MyMouseInputHandler() {
            super(BegMenuItemUI.this);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            MenuSelectionManager manager2 = MenuSelectionManager.defaultManager();
            Point p = e.getPoint();
            if (p.x >= 0 && p.x < BegMenuItemUI.this.menuItem.getWidth() && p.y >= 0 && p.y < BegMenuItemUI.this.menuItem.getHeight()) {
                if (e.getButton() == 1) {
                    BegMenuItemUI.this.doClick(manager2, e);
                }
            } else {
                manager2.processMouseEvent(e);
            }
        }
    }

    private final class MyMenuDragMouseHandler
    implements MenuDragMouseListener {
        private MyMenuDragMouseHandler() {
        }

        @Override
        public void menuDragMouseEntered(MenuDragMouseEvent e) {
        }

        @Override
        public void menuDragMouseDragged(MenuDragMouseEvent e) {
            MenuSelectionManager manager2 = e.getMenuSelectionManager();
            MenuElement[] path = e.getPath();
            manager2.setSelectedPath(path);
        }

        @Override
        public void menuDragMouseExited(MenuDragMouseEvent e) {
        }

        @Override
        public void menuDragMouseReleased(MenuDragMouseEvent e) {
            if (!AdvancedSettings.getBoolean((String)"ide.trigger.menu.actions.on.rmb.release")) {
                return;
            }
            MenuSelectionManager manager2 = e.getMenuSelectionManager();
            Point p = e.getPoint();
            if (p.x >= 0 && p.x < BegMenuItemUI.this.menuItem.getWidth() && p.y >= 0 && p.y < BegMenuItemUI.this.menuItem.getHeight()) {
                BegMenuItemUI.this.doClick(manager2, e);
            } else {
                manager2.clearSelectedPath();
            }
        }
    }
}

