/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.google.common.base.Predicate;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.concurrency.ThreadContext;
import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.DataManager;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.UiActivity;
import com.intellij.ide.UiActivityMonitor;
import com.intellij.ide.actions.WindowAction;
import com.intellij.ide.ui.PopupLocationTracker;
import com.intellij.ide.ui.PopupLocator;
import com.intellij.ide.ui.ScreenAreaConsumer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.UiCompatibleDataProvider;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.impl.AutoPopupSupportingListener;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.ActiveIcon;
import com.intellij.openapi.ui.popup.AlignedPopup;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindow;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.MaskProvider;
import com.intellij.openapi.ui.popup.MouseChecker;
import com.intellij.openapi.ui.popup.PopupCornerType;
import com.intellij.openapi.ui.popup.PopupRelativePosition;
import com.intellij.openapi.ui.popup.PopupShowOptions;
import com.intellij.openapi.ui.popup.PopupShowOptionsBuilder;
import com.intellij.openapi.ui.popup.PopupShowOptionsImpl;
import com.intellij.openapi.ui.popup.StackingPopupDispatcher;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.WindowStateService;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.FloatingDecorator;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.openapi.wm.impl.ModalityHelper;
import com.intellij.platform.diagnostic.telemetry.PlatformScopesKt;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceKt;
import com.intellij.ui.ActiveComponent;
import com.intellij.ui.CaptionPanel;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.LightColors;
import com.intellij.ui.ListenerUtil;
import com.intellij.ui.PopupBorder;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TitlePanel;
import com.intellij.ui.UiInterceptors;
import com.intellij.ui.WindowMoveListener;
import com.intellij.ui.WindowResizeListener;
import com.intellij.ui.WindowResizeListenerEx;
import com.intellij.ui.WindowRoundedCornersManager;
import com.intellij.ui.awt.AnchoredPoint;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.mac.touchbar.TouchbarSupport;
import com.intellij.ui.popup.PopupAlignableComponent;
import com.intellij.ui.popup.PopupComponent;
import com.intellij.ui.popup.PopupComponentFactory;
import com.intellij.ui.popup.util.PopupImplUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchInputMethodRequests;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.Alarm;
import com.intellij.util.BooleanFunction;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SlowOperations;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakList;
import com.intellij.util.ui.ChildFocusWatcher;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.ScrollUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.context.Context;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.im.InputMethodRequests;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class AbstractPopup
implements JBPopup,
ScreenAreaConsumer,
AlignedPopup {
    @NonNls
    public static final String SHOW_HINTS = "ShowHints";
    @NonNls
    public static final String FIRST_TIME_SIZE = "FirstTimeSize";
    private static final Logger LOG = Logger.getInstance(AbstractPopup.class);
    private PopupComponent myPopup;
    private MyContentPanel myContent;
    private JComponent myPreferredFocusedComponent;
    private boolean myRequestFocus;
    private boolean myFocusable;
    private boolean myForcedHeavyweight;
    private boolean myLocateWithinScreen;
    private boolean myResizable;
    private WindowResizeListener myResizeListener;
    private WindowMoveListener myMoveListener;
    private JPanel myHeaderPanel;
    private CaptionPanel myCaption;
    private JComponent myComponent;
    private SpeedSearch mySpeedSearchFoundInRootComponent;
    private String myDimensionServiceKey;
    private Computable<Boolean> myCallBack;
    private Object[] modalEntitiesWhenShown;
    private Project myProject;
    private boolean myCancelOnClickOutside;
    private final List<JBPopupListener> myListeners = new CopyOnWriteArrayList<JBPopupListener>();
    private boolean myUseDimServiceForXYLocation;
    private MouseChecker myCancelOnMouseOutCallback;
    private Canceller myMouseOutCanceller;
    private boolean myCancelOnWindow;
    private boolean myCancelOnWindowDeactivation = true;
    private Dimension myForcedSize;
    private Point myForcedLocation;
    private boolean myCancelKeyEnabled;
    private boolean myLocateByContent;
    private Dimension myMinSize;
    private boolean myStretchToOwnerWidth;
    private boolean myStretchToOwnerHeight;
    private List<Object> myUserData;
    private boolean myShadowed;
    private float myAlpha;
    private float myLastAlpha;
    private MaskProvider myMaskProvider;
    private Window myWindow;
    private boolean myInStack;
    private MyWindowListener myWindowListener;
    private boolean myModalContext;
    private Component[] myFocusOwners;
    private PopupBorder myPopupBorder;
    private Color myPopupBorderColor;
    private Dimension myRestoreWindowSize;
    protected Component myOwner;
    private Component myRequestorComponent;
    private boolean myHeaderAlwaysFocusable;
    private boolean myMovable;
    private JComponent myHeaderComponent;
    InputEvent myDisposeEvent;
    private Runnable myFinalRunnable;
    private Runnable myOkHandler;
    @Nullable
    private BooleanFunction<? super KeyEvent> myKeyEventHandler;
    protected boolean myOk;
    private final List<Runnable> myResizeListeners = new ArrayList<Runnable>();
    private static final WeakList<JBPopup> all = new WeakList();
    private boolean mySpeedSearchAlwaysShown;
    protected final SpeedSearch mySpeedSearch = new SpeedSearch(){
        boolean searchFieldShown;

        public void update() {
            AbstractPopup.this.updateSpeedSearchColors(false);
            AbstractPopup.this.onSpeedSearchPatternChanged();
            AbstractPopup.this.mySpeedSearchPatternField.setText(this.getFilter());
            if (!AbstractPopup.this.mySpeedSearchAlwaysShown) {
                if (this.isHoldingFilter() && !this.searchFieldShown) {
                    AbstractPopup.this.setHeaderComponent((JComponent)AbstractPopup.this.mySpeedSearchPatternField);
                    this.searchFieldShown = true;
                } else if (!this.isHoldingFilter() && this.searchFieldShown) {
                    AbstractPopup.this.setHeaderComponent(null);
                    this.searchFieldShown = false;
                }
            }
        }

        public void noHits() {
            AbstractPopup.this.updateSpeedSearchColors(true);
        }

        public InputMethodRequests getInputMethodRequests() {
            return new SpeedSearchInputMethodRequests(){

                protected InputMethodRequests getDelegate() {
                    if (searchFieldShown || AbstractPopup.this.mySpeedSearchAlwaysShown) {
                        return AbstractPopup.this.mySpeedSearchPatternField.getTextEditor().getInputMethodRequests();
                    }
                    return null;
                }

                protected void ensurePopupIsShown() {
                    if (!searchFieldShown && !AbstractPopup.this.mySpeedSearchAlwaysShown) {
                        AbstractPopup.this.setHeaderComponent((JComponent)AbstractPopup.this.mySpeedSearchPatternField);
                        searchFieldShown = true;
                    }
                }
            };
        }

        public void selectTextRange(int begin, int length) {
            if (this.searchFieldShown || AbstractPopup.this.mySpeedSearchAlwaysShown) {
                AbstractPopup.this.mySpeedSearchPatternField.getTextEditor().select(begin, begin + length);
            }
        }
    };
    private @NlsContexts.StatusText String mySpeedSearchEmptyText;
    protected SearchTextField mySpeedSearchPatternField;
    private PopupComponentFactory.PopupType myPopupType;
    private boolean myNativePopup;
    private boolean myMayBeParent;
    private JComponent myAdComponent;
    private boolean myDisposed;
    private boolean myNormalWindowLevel;
    private UiActivity myActivityKey;
    private Disposable myProjectDisposable;
    private volatile State myState = State.NEW;
    private long myOpeningTime;

    protected void updateSpeedSearchColors(boolean error) {
        JBTextField textEditor = this.mySpeedSearchPatternField.getTextEditor();
        if (ExperimentalUI.isNewUI()) {
            textEditor.setForeground(error ? NamedColorUtil.getErrorForeground() : UIUtil.getLabelForeground());
        } else {
            textEditor.setBackground(error ? LightColors.RED : UIUtil.getTextFieldBackground());
        }
    }

    void setNormalWindowLevel(boolean normalWindowLevel) {
        this.myNormalWindowLevel = normalWindowLevel;
    }

    private void debugState(@NonNls @NotNull String message, State ... states) {
        if (message == null) {
            AbstractPopup.$$$reportNull$$$0(0);
        }
        if (states == null) {
            AbstractPopup.$$$reportNull$$$0(1);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.hashCode() + " - " + message);
            if (!ApplicationManager.getApplication().isDispatchThread()) {
                LOG.debug("unexpected thread");
            }
            for (State state2 : states) {
                if (state2 != this.myState) continue;
                return;
            }
            LOG.debug((Throwable)new IllegalStateException("myState=" + String.valueOf((Object)this.myState)));
        }
    }

    protected AbstractPopup() {
    }

    @NotNull
    protected AbstractPopup init(Project project2, @NotNull JComponent component2, @Nullable JComponent preferredFocusedComponent, boolean requestFocus, boolean focusable, boolean movable, String dimensionServiceKey, boolean resizable, @NlsContexts.PopupTitle @Nullable String caption, @Nullable Computable<Boolean> callback, boolean cancelOnClickOutside, @NotNull Set<? extends JBPopupListener> listeners, boolean useDimServiceForXYLocation, ActiveComponent commandButton, @Nullable IconButton cancelButton, @Nullable MouseChecker cancelOnMouseOutCallback, boolean cancelOnWindow, @Nullable ActiveIcon titleIcon, boolean cancelKeyEnabled, boolean locateByContent, boolean placeWithinScreenBounds, @Nullable Dimension minSize, float alpha, @Nullable MaskProvider maskProvider, boolean inStack, boolean modalContext, Component @NotNull [] focusOwners, @NlsContexts.PopupAdvertisement @Nullable String adText, int adTextAlignment, boolean headerAlwaysFocusable, @NotNull List<? extends Pair<ActionListener, KeyStroke>> keyboardActions, Component settingsButtons, @Nullable Processor<? super JBPopup> pinCallback, boolean mayBeParent, boolean showShadow, boolean showBorder, Color borderColor, boolean cancelOnWindowDeactivation, @Nullable BooleanFunction<? super KeyEvent> keyEventHandler) {
        if (component2 == null) {
            AbstractPopup.$$$reportNull$$$0(2);
        }
        if (listeners == null) {
            AbstractPopup.$$$reportNull$$$0(3);
        }
        if (keyboardActions == null) {
            AbstractPopup.$$$reportNull$$$0(4);
        }
        if (focusOwners == null) {
            AbstractPopup.$$$reportNull$$$0(5);
        }
        if (requestFocus && !focusable) {
            requestFocus = false;
            LOG.error("Incorrect argument combination: requestFocus=true focusable=false");
        }
        all.add((Object)this);
        this.myActivityKey = new UiActivity.Focus(new String[]{"Popup:" + String.valueOf(this)});
        this.myProject = project2;
        this.myComponent = component2;
        this.mySpeedSearchFoundInRootComponent = (SpeedSearch)AbstractPopup.findInComponentHierarchy(component2, it -> it instanceof ListWithFilter ? ((ListWithFilter)it).getSpeedSearch() : null);
        this.myPopupBorder = showBorder ? (borderColor != null ? PopupBorder.Factory.createColored((Color)borderColor) : PopupBorder.Factory.create((boolean)true, (boolean)showShadow)) : PopupBorder.Factory.createEmpty();
        this.myPopupBorder.setPopupUsed();
        this.myShadowed = showShadow;
        if (showBorder) {
            this.myPopupBorderColor = borderColor == null ? JBUI.CurrentTheme.Popup.borderColor((boolean)true) : borderColor;
        }
        this.myContent = this.createContentPanel(resizable, this.myPopupBorder, false);
        this.myMayBeParent = mayBeParent;
        this.myCancelOnWindowDeactivation = cancelOnWindowDeactivation;
        this.myContent.add((Component)component2, "Center");
        if (adText != null) {
            this.setAdText(adText, adTextAlignment);
        }
        this.myCancelKeyEnabled = cancelKeyEnabled;
        this.myLocateByContent = locateByContent;
        this.myLocateWithinScreen = placeWithinScreenBounds && !StartupUiUtil.isWaylandToolkit();
        this.myAlpha = alpha;
        this.myMaskProvider = maskProvider;
        this.myInStack = inStack;
        this.myModalContext = modalContext;
        this.myFocusOwners = focusOwners;
        this.myHeaderAlwaysFocusable = headerAlwaysFocusable;
        this.myMovable = movable;
        this.myHeaderPanel = new JPanel(new BorderLayout()){

            @Override
            public Color getBackground() {
                return JBUI.CurrentTheme.Popup.headerBackground((boolean)true);
            }
        };
        if (caption != null) {
            if (!caption.isEmpty()) {
                TitlePanel titlePanel = titleIcon == null ? new TitlePanel() : new TitlePanel(titleIcon.getRegular(), titleIcon.getInactive());
                titlePanel.setText(caption);
                titlePanel.setPopupTitle(ExperimentalUI.isNewUI());
                this.myCaption = titlePanel;
            } else {
                this.myCaption = new CaptionPanel();
            }
            if (pinCallback != null) {
                Icon icon2 = ToolWindowManager.getInstance((Project)(this.myProject != null ? this.myProject : ProjectUtil.guessCurrentProject((JComponent)((JComponent)this.myOwner)))).getShowInFindToolWindowIcon();
                this.myCaption.setButtonComponent((ActiveComponent)new InplaceButton(new IconButton(IdeBundle.message((String)"show.in.find.window.button.name", (Object[])new Object[0]), icon2), e -> pinCallback.process((Object)this)), JBUI.Borders.empty((int)4));
            } else if (cancelButton != null) {
                this.myCaption.setButtonComponent((ActiveComponent)new InplaceButton(cancelButton, e -> this.cancel()), JBUI.Borders.empty((int)4));
            } else if (commandButton != null) {
                this.myCaption.setButtonComponent(commandButton, null);
            }
        } else {
            this.myCaption = new CaptionPanel();
            this.myCaption.setBorder(null);
            this.myCaption.setPreferredSize((Dimension)JBUI.emptySize());
        }
        this.setWindowActive(this.myHeaderAlwaysFocusable);
        this.myHeaderPanel.add((Component)this.myCaption, "North");
        this.myContent.add((Component)this.myHeaderPanel, "North");
        this.myForcedHeavyweight = true;
        this.myResizable = resizable;
        this.myPreferredFocusedComponent = preferredFocusedComponent;
        this.myRequestFocus = requestFocus;
        this.myFocusable = focusable;
        this.myDimensionServiceKey = dimensionServiceKey;
        this.myCallBack = callback;
        this.myCancelOnClickOutside = cancelOnClickOutside;
        this.myCancelOnMouseOutCallback = cancelOnMouseOutCallback;
        this.myListeners.addAll(listeners);
        this.myUseDimServiceForXYLocation = useDimServiceForXYLocation;
        this.myCancelOnWindow = cancelOnWindow;
        this.myMinSize = minSize;
        if (LoadingState.COMPONENTS_LOADED.isOccurred() && Registry.is((String)"ide.popup.horizontal.scroll.bar.opaque")) {
            this.forHorizontalScrollBar((Consumer<? super JScrollBar>)((Consumer)bar2 -> bar2.setOpaque(true)));
        }
        for (Pair pair : keyboardActions) {
            this.myContent.registerKeyboardAction((ActionListener)pair.getFirst(), (KeyStroke)pair.getSecond(), 2);
        }
        if (settingsButtons != null) {
            this.myCaption.addSettingsComponent(settingsButtons);
        }
        this.myKeyEventHandler = keyEventHandler;
        this.debugState("popup initialized", State.NEW);
        this.myState = State.INIT;
        Component clickSource = PopupImplUtil.getClickSourceFromLastInputEvent();
        if (!(clickSource instanceof JList) && !(clickSource instanceof JTree)) {
            PopupUtil.setPopupToggleComponent((JBPopup)this, (Component)clickSource);
        }
        ActionUtil.initActionContextForComponent((JComponent)this.myContent);
        AbstractPopup abstractPopup = this;
        if (abstractPopup == null) {
            AbstractPopup.$$$reportNull$$$0(6);
        }
        return abstractPopup;
    }

    private void setWindowActive(boolean active) {
        boolean value;
        boolean bl = value = this.myHeaderAlwaysFocusable || active;
        if (this.myCaption != null) {
            this.myCaption.setActive(value);
        }
        this.myPopupBorder.setActive(value);
        this.myContent.repaint();
    }

    @NotNull
    protected MyContentPanel createContentPanel(boolean resizable, @NotNull PopupBorder border, boolean isToDrawMacCorner) {
        if (border == null) {
            AbstractPopup.$$$reportNull$$$0(7);
        }
        return new MyContentPanel(border);
    }

    public void setShowHints(boolean show2) {
        JRootPane rootPane;
        Window ancestor = AbstractPopup.getContentWindow(this.myComponent);
        if (ancestor instanceof RootPaneContainer && (rootPane = ((RootPaneContainer)((Object)ancestor)).getRootPane()) != null) {
            rootPane.putClientProperty(SHOW_HINTS, show2);
        }
    }

    public String getDimensionServiceKey() {
        return this.myDimensionServiceKey;
    }

    public void setDimensionServiceKey(@Nullable String dimensionServiceKey) {
        this.myDimensionServiceKey = dimensionServiceKey;
    }

    public void setAdText(@NlsContexts.PopupAdvertisement @NotNull String s) {
        if (s == null) {
            AbstractPopup.$$$reportNull$$$0(8);
        }
        this.setAdText(s, 2);
    }

    @NotNull
    public PopupBorder getPopupBorder() {
        PopupBorder popupBorder = this.myPopupBorder;
        if (popupBorder == null) {
            AbstractPopup.$$$reportNull$$$0(9);
        }
        return popupBorder;
    }

    public void setAdText(@NlsContexts.PopupAdvertisement @NotNull String s, int alignment) {
        Window popupWindow;
        JLabel label2;
        if (s == null) {
            AbstractPopup.$$$reportNull$$$0(10);
        }
        if (this.myAdComponent == null || !(this.myAdComponent instanceof JLabel)) {
            label2 = HintUtil.createAdComponent(s, JBUI.CurrentTheme.Advertiser.border(), alignment);
            this.setFooterComponent(label2);
        } else {
            label2 = (JLabel)this.myAdComponent;
        }
        JBDimension prefSize = label2.isVisible() ? this.myAdComponent.getPreferredSize() : JBUI.emptySize();
        boolean keepSize = BasicHTML.isHTMLString(s);
        label2.setVisible(StringUtil.isNotEmpty((String)s));
        label2.setText(keepSize ? s : this.wrapToSize(s));
        label2.setHorizontalAlignment(alignment);
        JBDimension newPrefSize = label2.isVisible() ? this.myAdComponent.getPreferredSize() : JBUI.emptySize();
        int delta = newPrefSize.height - prefSize.height;
        if (this.myPopup != null && !this.isBusy() && delta != 0 && !keepSize && (popupWindow = AbstractPopup.getContentWindow(this.myContent)) != null) {
            Dimension size2 = popupWindow.getSize();
            size2.height += delta;
            this.myContent.setPreferredSize(size2);
            popupWindow.pack();
            this.updateMaskAndAlpha(popupWindow);
        }
    }

    protected void setFooterComponent(JComponent c) {
        if (this.myAdComponent != null) {
            this.myContent.remove(this.myAdComponent);
        }
        this.myContent.add((Component)c, "South");
        this.pack(false, true);
        this.myAdComponent = c;
    }

    @NotNull
    @Nls
    private String wrapToSize(@NotNull @Nls String hint) {
        if (hint == null) {
            AbstractPopup.$$$reportNull$$$0(11);
        }
        if (StringUtil.isEmpty((String)hint)) {
            String string = hint;
            if (string == null) {
                AbstractPopup.$$$reportNull$$$0(12);
            }
            return string;
        }
        Dimension size2 = this.myContent.getSize();
        if (size2.width == 0 && size2.height == 0) {
            size2 = this.myContent.computePreferredSize();
        }
        JBInsets.removeFrom((Dimension)size2, (Insets)this.myContent.getInsets());
        JBInsets.removeFrom((Dimension)size2, (Insets)this.myAdComponent.getInsets());
        int width = Math.max(JBUI.CurrentTheme.Popup.minimumHintWidth(), size2.width);
        String string = HtmlChunk.text((String)hint).wrapWith(HtmlChunk.div().attr("width", width)).wrapWith(HtmlChunk.html()).toString();
        if (string == null) {
            AbstractPopup.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public static Point getCenterOf(@NotNull Component aContainer, @NotNull JComponent content2) {
        if (aContainer == null) {
            AbstractPopup.$$$reportNull$$$0(14);
        }
        if (content2 == null) {
            AbstractPopup.$$$reportNull$$$0(15);
        }
        return AbstractPopup.getCenterOf(aContainer, content2.getPreferredSize());
    }

    @NotNull
    private static Point getCenterOf(@NotNull Component aContainer, @NotNull Dimension contentSize) {
        JComponent component2;
        if (aContainer == null) {
            AbstractPopup.$$$reportNull$$$0(16);
        }
        if (contentSize == null) {
            AbstractPopup.$$$reportNull$$$0(17);
        }
        Rectangle visibleBounds = (component2 = AbstractPopup.getTargetComponent(aContainer)) != null ? component2.getVisibleRect() : new Rectangle(aContainer.getSize());
        Point containerScreenPoint = visibleBounds.getLocation();
        SwingUtilities.convertPointToScreen(containerScreenPoint, aContainer);
        visibleBounds.setLocation(containerScreenPoint);
        Point point = UIUtil.getCenterPoint((Rectangle)visibleBounds, (Dimension)contentSize);
        if (point == null) {
            AbstractPopup.$$$reportNull$$$0(18);
        }
        return point;
    }

    public void showCenteredInCurrentWindow(@NotNull Project project2) {
        if (project2 == null) {
            AbstractPopup.$$$reportNull$$$0(19);
        }
        if (UiInterceptors.tryIntercept((Object)this)) {
            return;
        }
        Window window = AbstractPopup.getCurrentWindow(project2);
        if (window != null && window.isShowing()) {
            this.showInCenterOf(window);
        }
    }

    @Nullable
    public static Window getCurrentWindow(@NotNull Project project2) {
        if (project2 == null) {
            AbstractPopup.$$$reportNull$$$0(20);
        }
        Window window = null;
        WindowManagerEx manager2 = AbstractPopup.getWndManager();
        if (manager2 != null) {
            window = AbstractPopup.getTargetWindow(manager2.getFocusedComponent(project2));
        }
        if (window == null) {
            window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        }
        if (!(window != null && window.isShowing() || manager2 == null)) {
            window = manager2.getFrame(project2);
        }
        return window;
    }

    private static Window getTargetWindow(Component component2) {
        Window res = null;
        while (component2 != null) {
            if (component2 instanceof FloatingDecorator) {
                FloatingDecorator fd = (FloatingDecorator)component2;
                return fd;
            }
            Container parent = component2.getParent();
            if (component2 instanceof Window) {
                Window w = (Window)component2;
                if (ModalityHelper.isModalBlocked(w)) break;
                res = w;
            }
            component2 = parent;
        }
        return res;
    }

    public void showInCenterOf(@NotNull Component aComponent) {
        if (aComponent == null) {
            AbstractPopup.$$$reportNull$$$0(21);
        }
        HelpTooltip.setMasterPopup((Component)aComponent, (JBPopup)this);
        Point popupPoint = AbstractPopup.getCenterOf(aComponent, this.getPreferredContentSize());
        this.show(aComponent, popupPoint.x, popupPoint.y, false);
    }

    public void showUnderneathOf(@NotNull Component aComponent) {
        if (aComponent == null) {
            AbstractPopup.$$$reportNull$$$0(22);
        }
        this.showUnderneathOf(aComponent, true);
    }

    public void showUnderneathOf(@NotNull Component aComponent, boolean useAlignment) {
        if (aComponent == null) {
            AbstractPopup.$$$reportNull$$$0(23);
        }
        boolean isAlignmentUsed = ExperimentalUI.isNewUI() && Registry.is((String)"ide.popup.align.by.content") && useAlignment && AbstractPopup.isComponentSupportsAlignment(aComponent);
        RelativePoint point = isAlignmentUsed ? AbstractPopup.pointUnderneathOfAlignedHorizontally(aComponent) : AbstractPopup.defaultPointUnderneathOf(aComponent);
        this.show(point);
    }

    private static boolean isComponentSupportsAlignment(Component c) {
        return c instanceof JComponent && !(c instanceof ActionButton) && !(c instanceof ComboBoxWithWidePopup);
    }

    @NotNull
    private static RelativePoint defaultPointUnderneathOf(@NotNull Component aComponent) {
        if (aComponent == null) {
            AbstractPopup.$$$reportNull$$$0(24);
        }
        Point offset = new Point(JBUIScale.scale((int)2), 0);
        return new AnchoredPoint(AnchoredPoint.Anchor.BOTTOM_LEFT, aComponent, offset);
    }

    @NotNull
    private static RelativePoint pointUnderneathOfAlignedHorizontally(@NotNull Component comp) {
        if (comp == null) {
            AbstractPopup.$$$reportNull$$$0(25);
        }
        if (!(comp instanceof JComponent)) {
            return AbstractPopup.defaultPointUnderneathOf(comp);
        }
        JComponent jComponent = (JComponent)comp;
        Point offset = new Point(AbstractPopup.calcHorizontalAlignment(jComponent), 0);
        return new AnchoredPoint(AnchoredPoint.Anchor.BOTTOM_LEFT, comp, offset);
    }

    private static int calcHorizontalAlignment(JComponent jComponent) {
        int componentLeftInset;
        if (jComponent instanceof PopupAlignableComponent) {
            PopupAlignableComponent pac = (PopupAlignableComponent)((Object)jComponent);
            componentLeftInset = pac.getLeftGap();
        } else {
            AbstractButton button2;
            Insets margin;
            componentLeftInset = jComponent.getInsets().left;
            if (jComponent instanceof AbstractButton && (margin = (button2 = (AbstractButton)jComponent).getMargin()) != null) {
                componentLeftInset += margin.left;
            }
        }
        int popupLeftInset = JBUI.CurrentTheme.Popup.Selection.LEFT_RIGHT_INSET.get() + JBUI.CurrentTheme.Popup.Selection.innerInsets().left;
        int res = componentLeftInset - popupLeftInset;
        return res;
    }

    private static void fitXToComponentScreen(@NotNull Point screenPoint, @NotNull Component comp) {
        if (screenPoint == null) {
            AbstractPopup.$$$reportNull$$$0(26);
        }
        if (comp == null) {
            AbstractPopup.$$$reportNull$$$0(27);
        }
        Rectangle componentScreen = ScreenUtil.getScreenRectangle((Component)comp);
        if (screenPoint.x < componentScreen.x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Moving the popup X coordinate from " + screenPoint.x + " to " + componentScreen.x + " to fit into the component screen " + String.valueOf(componentScreen));
            }
            screenPoint.x = componentScreen.x;
        }
        if (screenPoint.x > componentScreen.x + componentScreen.width) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Moving the popup X coordinate from " + screenPoint.x + " to " + (componentScreen.x + componentScreen.width) + " to fit into the component screen " + String.valueOf(componentScreen));
            }
            screenPoint.x = componentScreen.x + componentScreen.width;
        }
    }

    public void show(@NotNull RelativePoint aPoint) {
        if (aPoint == null) {
            AbstractPopup.$$$reportNull$$$0(28);
        }
        if (UiInterceptors.tryIntercept((Object)this, (RelativePoint)aPoint)) {
            return;
        }
        HelpTooltip.setMasterPopup((Component)aPoint.getOriginalComponent(), (JBPopup)this);
        Point screenPoint = aPoint.getScreenPoint();
        AbstractPopup.fitXToComponentScreen(screenPoint, aPoint.getComponent());
        this.stretchContentToOwnerIfNecessary(aPoint.getOriginalComponent());
        this.show(aPoint.getComponent(), screenPoint.x, screenPoint.y, false);
    }

    public void showInScreenCoordinates(@NotNull Component owner, @NotNull Point point) {
        if (owner == null) {
            AbstractPopup.$$$reportNull$$$0(29);
        }
        if (point == null) {
            AbstractPopup.$$$reportNull$$$0(30);
        }
        this.show(owner, point.x, point.y, false);
    }

    @NotNull
    public Point getBestPositionFor(@NotNull DataContext dataContext2) {
        Editor editor2;
        if (dataContext2 == null) {
            AbstractPopup.$$$reportNull$$$0(31);
        }
        if ((editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2)) != null && editor2.getComponent().isShowing()) {
            Point point = this.getBestPositionFor(editor2).getScreenPoint();
            if (point == null) {
                AbstractPopup.$$$reportNull$$$0(32);
            }
            return point;
        }
        Point point = this.relativePointByQuickSearch(dataContext2).getScreenPoint();
        if (point == null) {
            AbstractPopup.$$$reportNull$$$0(33);
        }
        return point;
    }

    public void showInBestPositionFor(@NotNull DataContext dataContext2) {
        Editor editor2;
        if (dataContext2 == null) {
            AbstractPopup.$$$reportNull$$$0(34);
        }
        if ((editor2 = (Editor)CommonDataKeys.EDITOR_EVEN_IF_INACTIVE.getData(dataContext2)) != null && editor2.getComponent().isShowing()) {
            this.showInBestPositionFor(editor2);
        } else {
            this.show(this.relativePointByQuickSearch(dataContext2));
        }
    }

    public void showInFocusCenter() {
        Component parent = AbstractPopup.getFocusedParent(this.myProject);
        if (parent != null) {
            this.showInCenterOf(parent);
        } else {
            LOG.error(new Throwable("Can't show the popup because no focused component could be found"));
        }
    }

    @ApiStatus.Internal
    @Nullable
    public static Component getFocusedParent(@Nullable Project project2) {
        JFrame frame;
        Component focused;
        WindowManagerEx windowManager = AbstractPopup.getWndManager();
        Component component2 = focused = windowManager == null ? null : windowManager.getFocusedComponent(project2);
        if (focused != null) {
            LOG.debug("Using the focused component to show the popup " + String.valueOf(focused));
            return focused;
        }
        WindowManager manager2 = WindowManager.getInstance();
        JFrame jFrame = frame = project2 != null ? manager2.getFrame(project2) : manager2.findVisibleFrame();
        if (frame != null) {
            JRootPane pane2 = frame.getRootPane();
            LOG.debug("Using the focused frame's root pane to show the popup: frame=" + String.valueOf(frame) + " rootPane=" + String.valueOf(pane2));
            return pane2;
        }
        for (Window window : Window.getWindows()) {
            if (!window.isShowing() || !(window instanceof RootPaneContainer)) continue;
            RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)window);
            JRootPane pane3 = rootPaneContainer.getRootPane();
            LOG.debug("Using a random visible window to show the popup: window=" + String.valueOf(window) + " rootPane=" + String.valueOf(pane3));
            return pane3;
        }
        return null;
    }

    @NotNull
    private RelativePoint relativePointByQuickSearch(@NotNull DataContext dataContext2) {
        Component contextComponent;
        Rectangle dominantArea;
        if (dataContext2 == null) {
            AbstractPopup.$$$reportNull$$$0(35);
        }
        if ((dominantArea = (Rectangle)PlatformDataKeys.DOMINANT_HINT_AREA_RECTANGLE.getData(dataContext2)) != null) {
            Component focusedComponent;
            WindowManagerEx windowManager = AbstractPopup.getWndManager();
            Component component2 = focusedComponent = windowManager == null ? null : windowManager.getFocusedComponent(this.myProject);
            if (focusedComponent != null) {
                JLayeredPane layeredPane2;
                Window window = SwingUtilities.windowForComponent(focusedComponent);
                if (window instanceof JFrame) {
                    layeredPane2 = ((JFrame)window).getLayeredPane();
                } else if (window instanceof JDialog) {
                    layeredPane2 = ((JDialog)window).getLayeredPane();
                } else if (window instanceof JWindow) {
                    layeredPane2 = ((JWindow)window).getLayeredPane();
                } else {
                    throw new IllegalStateException("cannot find parent window: project=" + String.valueOf(this.myProject) + "; window=" + String.valueOf(window));
                }
                return this.relativePointWithDominantRectangle(layeredPane2, dominantArea);
            }
        }
        RelativePoint location = (contextComponent = (Component)dataContext2.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT)) == this.myComponent ? new RelativePoint((Component)this.myComponent, new Point()) : JBPopupFactory.getInstance().guessBestPopupLocation(dataContext2);
        if (this.myLocateWithinScreen) {
            Point screenPoint = location.getScreenPoint();
            Rectangle rectangle = new Rectangle(screenPoint, this.getSizeForPositioning());
            Rectangle screen = ScreenUtil.getScreenRectangle((Point)screenPoint);
            ScreenUtil.moveToFit((Rectangle)rectangle, (Rectangle)screen, null);
            location = new RelativePoint(rectangle.getLocation()).getPointOn(location.getComponent());
        }
        RelativePoint relativePoint = location;
        if (relativePoint == null) {
            AbstractPopup.$$$reportNull$$$0(36);
        }
        return relativePoint;
    }

    public Dimension getSizeForPositioning() {
        Dimension size2 = this.getSize();
        if (size2 == null) {
            size2 = this.getStoredSize();
        }
        if (size2 == null) {
            Dimension contentPreferredSize = this.myContent.getPreferredSize();
            Dimension titlePreferredSize = this.getTitle().getPreferredSize();
            size2 = new JBDimension(Math.max(contentPreferredSize.width, titlePreferredSize.width), contentPreferredSize.height + titlePreferredSize.height, true);
        }
        return size2;
    }

    public void showInBestPositionFor(@NotNull Editor editor2) {
        if (editor2 == null) {
            AbstractPopup.$$$reportNull$$$0(37);
        }
        if (UiInterceptors.tryIntercept((Object)this)) {
            return;
        }
        assert (UIUtil.isShowing((Component)editor2.getContentComponent())) : "Editor must be showing on the screen";
        AccessibleContextUtil.setParent((Component)this.myComponent, (Component)editor2.getContentComponent());
        this.show(this.getBestPositionFor(editor2));
    }

    @ApiStatus.Internal
    @NotNull
    public final RelativePoint getBestPositionFor(@NotNull Editor editor2) {
        if (editor2 == null) {
            AbstractPopup.$$$reportNull$$$0(38);
        }
        if (editor2 instanceof EditorEx) {
            Point result2;
            DataContext context = ((EditorEx)editor2).getDataContext();
            PopupLocator popupLocator = (PopupLocator)PlatformDataKeys.CONTEXT_MENU_LOCATOR.getData(context);
            if (popupLocator != null && (result2 = popupLocator.getPositionFor((JBPopup)this)) != null) {
                return new RelativePoint(result2);
            }
            Rectangle dominantArea = (Rectangle)PlatformDataKeys.DOMINANT_HINT_AREA_RECTANGLE.getData(context);
            if (dominantArea != null && !this.myRequestFocus) {
                JLayeredPane layeredPane2 = editor2.getContentComponent().getRootPane().getLayeredPane();
                return this.relativePointWithDominantRectangle(layeredPane2, dominantArea);
            }
        }
        return this.guessBestPopupLocation(editor2);
    }

    @NotNull
    private RelativePoint guessBestPopupLocation(@NotNull Editor editor2) {
        if (editor2 == null) {
            AbstractPopup.$$$reportNull$$$0(39);
        }
        RelativePoint preferredLocation = JBPopupFactory.getInstance().guessBestPopupLocation(editor2);
        Dimension targetSize = this.getSizeForPositioning();
        Point preferredPoint = preferredLocation.getScreenPoint();
        Point result2 = AbstractPopup.getLocationAboveEditorLineIfPopupIsClippedAtTheBottom(preferredPoint, targetSize, editor2);
        if (this.myLocateWithinScreen) {
            Rectangle rectangle = new Rectangle(result2, targetSize);
            Rectangle screen = ScreenUtil.getScreenRectangle((Point)preferredPoint);
            ScreenUtil.moveToFit((Rectangle)rectangle, (Rectangle)screen, null);
            result2 = rectangle.getLocation();
        }
        return AbstractPopup.toRelativePoint(result2, preferredLocation.getComponent());
    }

    @NotNull
    private static RelativePoint toRelativePoint(@NotNull Point screenPoint, @Nullable Component component2) {
        if (screenPoint == null) {
            AbstractPopup.$$$reportNull$$$0(40);
        }
        if (component2 == null) {
            RelativePoint relativePoint = RelativePoint.fromScreen((Point)screenPoint);
            if (relativePoint == null) {
                AbstractPopup.$$$reportNull$$$0(41);
            }
            return relativePoint;
        }
        SwingUtilities.convertPointFromScreen(screenPoint, component2);
        return new RelativePoint(component2, screenPoint);
    }

    @NotNull
    private static Point getLocationAboveEditorLineIfPopupIsClippedAtTheBottom(@NotNull Point originalLocation, @NotNull Dimension popupSize, @NotNull Editor editor2) {
        if (originalLocation == null) {
            AbstractPopup.$$$reportNull$$$0(42);
        }
        if (popupSize == null) {
            AbstractPopup.$$$reportNull$$$0(43);
        }
        if (editor2 == null) {
            AbstractPopup.$$$reportNull$$$0(44);
        }
        Rectangle preferredBounds = new Rectangle(originalLocation, popupSize);
        Rectangle adjustedBounds = new Rectangle(preferredBounds);
        ScreenUtil.moveRectangleToFitTheScreen((Rectangle)adjustedBounds);
        if (preferredBounds.y - adjustedBounds.y <= 0) {
            Point point = originalLocation;
            if (point == null) {
                AbstractPopup.$$$reportNull$$$0(45);
            }
            return point;
        }
        int adjustedY = preferredBounds.y - editor2.getLineHeight() - popupSize.height;
        if (adjustedY < 0) {
            Point point = originalLocation;
            if (point == null) {
                AbstractPopup.$$$reportNull$$$0(46);
            }
            return point;
        }
        return new Point(preferredBounds.x, adjustedY);
    }

    @NotNull
    private RelativePoint relativePointWithDominantRectangle(@NotNull JLayeredPane layeredPane2, @NotNull Rectangle bounds) {
        if (layeredPane2 == null) {
            AbstractPopup.$$$reportNull$$$0(47);
        }
        if (bounds == null) {
            AbstractPopup.$$$reportNull$$$0(48);
        }
        Dimension size2 = this.getSizeForPositioning();
        List<Supplier> optionsToTry = Arrays.asList(() -> new Point(bounds.x + bounds.width, bounds.y), () -> new Point(bounds.x - size2.width, bounds.y));
        for (Supplier option2 : optionsToTry) {
            Point location = (Point)option2.get();
            SwingUtilities.convertPointToScreen(location, layeredPane2);
            Point adjustedLocation = AbstractPopup.fitToScreenAdjustingVertically(location, size2);
            if (adjustedLocation == null) continue;
            RelativePoint relativePoint = new RelativePoint(adjustedLocation).getPointOn((Component)layeredPane2);
            if (relativePoint == null) {
                AbstractPopup.$$$reportNull$$$0(49);
            }
            return relativePoint;
        }
        this.setDimensionServiceKey(null);
        Point rightTopCorner = new Point(bounds.x + bounds.width, bounds.y);
        Point rightTopCornerScreen = (Point)rightTopCorner.clone();
        SwingUtilities.convertPointToScreen(rightTopCornerScreen, layeredPane2);
        Rectangle screen = ScreenUtil.getScreenRectangle((int)rightTopCornerScreen.x, (int)rightTopCornerScreen.y);
        int spaceOnTheLeft = bounds.x;
        int spaceOnTheRight = screen.x + screen.width - rightTopCornerScreen.x;
        if (spaceOnTheLeft > spaceOnTheRight) {
            this.myComponent.setPreferredSize(new Dimension(spaceOnTheLeft, Math.max(size2.height, JBUIScale.scale((int)200))));
            return new RelativePoint((Component)layeredPane2, new Point(0, bounds.y));
        }
        this.myComponent.setPreferredSize(new Dimension(spaceOnTheRight, Math.max(size2.height, JBUIScale.scale((int)200))));
        return new RelativePoint((Component)layeredPane2, rightTopCorner);
    }

    @Nullable
    private static Point fitToScreenAdjustingVertically(@NotNull Point position, @NotNull Dimension size2) {
        if (position == null) {
            AbstractPopup.$$$reportNull$$$0(50);
        }
        if (size2 == null) {
            AbstractPopup.$$$reportNull$$$0(51);
        }
        Rectangle screenRectangle = ScreenUtil.getScreenRectangle((Point)position);
        Rectangle rectangle = new Rectangle(position, size2);
        if (rectangle.height > screenRectangle.height || rectangle.x < screenRectangle.x || rectangle.x + rectangle.width > screenRectangle.x + screenRectangle.width) {
            return null;
        }
        ScreenUtil.moveToFit((Rectangle)rectangle, (Rectangle)screenRectangle, null);
        return rectangle.getLocation();
    }

    @NotNull
    public Dimension getPreferredContentSize() {
        if (this.myForcedSize != null) {
            Dimension dimension = this.myForcedSize;
            if (dimension == null) {
                AbstractPopup.$$$reportNull$$$0(52);
            }
            return dimension;
        }
        Dimension size2 = this.getStoredSize();
        if (size2 != null) {
            Dimension dimension = size2;
            if (dimension == null) {
                AbstractPopup.$$$reportNull$$$0(53);
            }
            return dimension;
        }
        Dimension dimension = this.myComponent.getPreferredSize();
        if (dimension == null) {
            AbstractPopup.$$$reportNull$$$0(54);
        }
        return dimension;
    }

    public final void closeOk(@Nullable InputEvent e) {
        this.setOk(true);
        this.myFinalRunnable = FunctionUtil.composeRunnables((Runnable)this.myOkHandler, (Runnable)this.myFinalRunnable);
        this.cancel(e);
    }

    public final void cancel() {
        InputEvent inputEvent = null;
        AWTEvent event = IdeEventQueue.getInstance().getTrueCurrentEvent();
        if (event instanceof InputEvent) {
            Window window;
            InputEvent ie = (InputEvent)event;
            if (this.myPopup != null && (window = this.myPopup.getWindow()) != null && UIUtil.isDescendingFrom((Component)ie.getComponent(), (Component)window)) {
                inputEvent = ie;
            }
        }
        this.cancel(inputEvent);
    }

    public void setRequestFocus(boolean requestFocus) {
        this.myRequestFocus = requestFocus;
    }

    public boolean shouldRequestFocus() {
        return this.myRequestFocus;
    }

    public void cancel(InputEvent e) {
        if (this.myState == State.CANCEL || this.myState == State.DISPOSE) {
            return;
        }
        this.debugState("cancel popup", State.SHOWN);
        this.myState = State.CANCEL;
        if (this.isDisposed()) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Throwable)new Exception("cancel popup stack trace"));
        }
        if (this.myPopup != null) {
            Point location;
            JRootPane root;
            if (!this.canClose()) {
                this.debugState("cannot cancel popup", State.CANCEL);
                this.myState = State.SHOWN;
                return;
            }
            this.storeDimensionSize();
            if (this.myUseDimServiceForXYLocation && (root = this.myComponent.getRootPane()) != null && (location = AbstractPopup.getLocationOnScreen(root.getParent())) != null) {
                this.storeLocation(this.fixLocateByContent(location, true));
            }
            if (e instanceof MouseEvent) {
                IdeEventQueue.getInstance().blockNextEvents((MouseEvent)e);
            }
            this.myPopup.hide(false);
            this.modalEntitiesWhenShown = null;
            if (ApplicationManager.getApplication() != null) {
                StackingPopupDispatcher.getInstance().onPopupHidden((JBPopup)this);
            }
            this.disposePopup();
        }
        this.myListeners.forEach(listener2 -> listener2.onClosed(new LightweightWindowEvent((LightweightWindow)this, this.myOk)));
        Disposer.dispose((Disposable)this, (boolean)false);
        if (this.myProjectDisposable != null) {
            Disposer.dispose((Disposable)this.myProjectDisposable);
        }
    }

    private void disposePopup() {
        all.remove((Object)this);
        if (this.myPopup != null) {
            this.resetWindow();
            this.myPopup.hide(true);
        }
        this.myPopup = null;
    }

    public boolean canClose() {
        Computable<Boolean> callBack = this.myCallBack;
        return !this.anyModalWindowsKeepPopupOpen() && (callBack == null || (Boolean)callBack.compute() != false) && !this.preventImmediateClosingAfterOpening() || this.myDisposed;
    }

    boolean anyModalWindowsKeepPopupOpen() {
        return this.anyModalWindowsMatching((Predicate<Window>)((Predicate)window -> ClientProperty.isTrue((Component)window, (Object)DialogWrapper.KEEP_POPUPS_OPEN)));
    }

    boolean anyModalWindowsAbovePopup() {
        return this.anyModalWindowsMatching((Predicate<Window>)((Predicate)window -> true));
    }

    private boolean anyModalWindowsMatching(Predicate<Window> predicate) {
        int i2;
        Object[] modalEntitiesNow = LaterInvocator.getCurrentModalEntities();
        if (this.modalEntitiesWhenShown != null) {
            for (i2 = 0; i2 < modalEntitiesNow.length && i2 < this.modalEntitiesWhenShown.length && modalEntitiesNow[i2] == this.modalEntitiesWhenShown[i2]; ++i2) {
            }
        }
        while (i2 < modalEntitiesNow.length) {
            Window modalWindow;
            Object object = modalEntitiesNow[i2];
            if (object instanceof Window && predicate.apply((Object)(modalWindow = (Window)object))) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private boolean preventImmediateClosingAfterOpening() {
        return UIUtil.isXServerOnWindows() && this.myNormalWindowLevel && IdeEventQueue.getInstance().getTrueCurrentEvent().getID() == 206 && System.currentTimeMillis() < this.myOpeningTime + 1000L;
    }

    public boolean isVisible() {
        if (this.myPopup == null) {
            return false;
        }
        Window window = this.myPopup.getWindow();
        if (window != null && window.isShowing()) {
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("window hidden, popup's state: " + String.valueOf((Object)this.myState));
        }
        return false;
    }

    public void show(@NotNull Component owner) {
        if (owner == null) {
            AbstractPopup.$$$reportNull$$$0(55);
        }
        this.stretchContentToOwnerIfNecessary(owner);
        this.show(owner, -1, -1, true);
    }

    public void show(@NotNull Component owner, int aScreenX, int aScreenY, boolean considerForcedXY) {
        if (owner == null) {
            AbstractPopup.$$$reportNull$$$0(56);
        }
        PopupShowOptionsBuilder builder = new PopupShowOptionsBuilder();
        this.showImpl(builder.withOwner(owner).withScreenXY(aScreenX, aScreenY).withForcedXY(considerForcedXY));
    }

    public void show(@NotNull PopupShowOptions showOptions) {
        if (showOptions == null) {
            AbstractPopup.$$$reportNull$$$0(57);
        }
        this.showImpl((PopupShowOptionsBuilder)showOptions);
    }

    @ApiStatus.Internal
    protected void showImpl(@NotNull PopupShowOptionsBuilder showOptions) {
        WindowResizeListenerEx resizeListener2;
        Insets insets;
        if (showOptions == null) {
            AbstractPopup.$$$reportNull$$$0(58);
        }
        if (UiInterceptors.tryIntercept((Object)this)) {
            return;
        }
        PopupShowOptionsImpl options2 = showOptions.build();
        Component owner = options2.getOwner();
        int aScreenX = options2.getScreenX();
        int aScreenY = options2.getScreenY();
        boolean considerForcedXY = options2.getConsiderForcedXY();
        if (ApplicationManager.getApplication() != null && ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        if (this.isDisposed()) {
            throw new IllegalStateException("Popup was already disposed. Recreate a new instance to show again");
        }
        ThreadingAssertions.assertEventDispatchThread();
        assert (this.myState == State.INIT) : "Popup was already shown. Recreate a new instance to show again.";
        this.debugState("show popup", State.INIT);
        this.myState = State.SHOWING;
        this.installProjectDisposer();
        this.addActivity();
        boolean shouldShow = this.beforeShow();
        if (!shouldShow) {
            this.removeActivity();
            this.debugState("rejected to show popup", State.SHOWING);
            this.myState = State.INIT;
            return;
        }
        this.prepareToShow();
        AbstractPopup.installWindowHook(this);
        Object[] roundedCornerParams = null;
        if (WindowRoundedCornersManager.isAvailable()) {
            Object[] cornerType = this.getUserData(PopupCornerType.class);
            if (cornerType == null) {
                cornerType = PopupCornerType.RoundedWindow;
            }
            if (cornerType != PopupCornerType.None) {
                if (SystemInfoRt.isMac && this.myPopupBorderColor != null && UIUtil.isUnderDarcula() || SystemInfoRt.isWindows) {
                    roundedCornerParams = new Object[]{cornerType, this.myPopupBorderColor == null ? JBUI.CurrentTheme.Popup.borderColor((boolean)true) : this.myPopupBorderColor};
                    this.myPopupBorder = PopupBorder.Factory.createEmpty();
                    this.myContent.setBorder((Border)this.myPopupBorder);
                } else {
                    roundedCornerParams = cornerType;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("START calculating bounds for a popup with options = " + String.valueOf(options2));
        }
        Dimension sizeToSet = this.getStoredSize();
        if (LOG.isDebugEnabled()) {
            LOG.debug("The stored size for key " + this.myDimensionServiceKey + " is " + String.valueOf(sizeToSet));
        }
        if (this.myForcedSize != null) {
            sizeToSet = this.myForcedSize;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Forced the size to " + String.valueOf(sizeToSet));
            }
        }
        Rectangle screen = ScreenUtil.getScreenRectangle((int)aScreenX, (int)aScreenY);
        if (LOG.isDebugEnabled()) {
            LOG.debug("The screen rectangle for (" + aScreenX + "," + aScreenY + ") is " + String.valueOf(screen));
        }
        if (this.myLocateWithinScreen) {
            Dimension size2;
            Dimension preferredSize = this.myContent.getPreferredSize();
            if (LOG.isDebugEnabled()) {
                LOG.debug("The preferred size is " + String.valueOf(preferredSize));
            }
            Object o = this.myContent.getClientProperty(FIRST_TIME_SIZE);
            if (sizeToSet == null && o instanceof Dimension) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The size from the FIRST_TIME_SIZE property is " + String.valueOf(o));
                }
                int w = ((Dimension)o).width;
                int h = ((Dimension)o).height;
                if (w > 0) {
                    preferredSize.width = w;
                }
                if (h > 0) {
                    preferredSize.height = h;
                }
                sizeToSet = preferredSize;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The size is set to " + String.valueOf(sizeToSet));
                }
            }
            Dimension dimension = size2 = sizeToSet != null ? sizeToSet : preferredSize;
            if (size2.width > screen.width) {
                size2.width = screen.width;
                sizeToSet = size2;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Resized to fit the screen width: " + String.valueOf(sizeToSet));
                }
            }
            if (size2.height > screen.height) {
                size2.height = screen.height;
                sizeToSet = size2;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Resized to fit the screen height: " + String.valueOf(sizeToSet));
                }
            }
        }
        if (sizeToSet != null) {
            Insets insets2 = this.myContent.getInsets();
            JBInsets.addTo((Dimension)sizeToSet, (Insets)insets2);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added insets (" + String.valueOf(insets2) + "), the size is now: " + String.valueOf(sizeToSet));
            }
            Dimension minimumSize = this.myContent.getMinimumSize();
            sizeToSet.width = Math.max(sizeToSet.width, minimumSize.width);
            sizeToSet.height = Math.max(sizeToSet.height, minimumSize.height);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Coerced to the minimum size (" + String.valueOf(minimumSize) + "): " + String.valueOf(sizeToSet));
            }
            this.myContent.setSize(sizeToSet);
            this.myContent.setPreferredSize(sizeToSet);
        }
        Point xy = new Point(aScreenX, aScreenY);
        boolean adjustXY = true;
        if (this.myUseDimServiceForXYLocation) {
            Point storedLocation = this.getStoredLocation();
            if (LOG.isDebugEnabled()) {
                LOG.debug("The stored location for key " + this.myDimensionServiceKey + " is " + String.valueOf(storedLocation));
            }
            if (storedLocation != null) {
                xy = storedLocation;
                adjustXY = false;
            }
        }
        if (adjustXY && (insets = this.myContent.getInsets()) != null) {
            xy.x -= insets.left;
            xy.y -= insets.top;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Location after adjusting by insets (" + String.valueOf(insets) + ") is " + String.valueOf(xy));
            }
        }
        if (considerForcedXY && this.myForcedLocation != null) {
            xy = this.myForcedLocation;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Location forced to " + String.valueOf(this.myForcedLocation));
            }
        }
        this.fixLocateByContent(xy, false);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Location after fixing by content is " + String.valueOf(xy));
        }
        Rectangle targetBounds = new Rectangle(xy, this.myContent.getPreferredSize());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Target bounds " + String.valueOf(targetBounds));
        }
        AppliedAdjustments adjustments = null;
        if (options2.getPopupAnchor() != AnchoredPoint.Anchor.TOP_LEFT) {
            adjustments = this.adjustForAnchor(targetBounds, options2, screen);
        }
        if (targetBounds.width > screen.width || targetBounds.height > screen.height) {
            StringBuilder sb = new StringBuilder("popup preferred size is bigger than screen: ");
            sb.append(targetBounds.width).append("x").append(targetBounds.height);
            IJSwingUtilities.appendComponentClassNames(sb, this.myContent);
            LOG.warn(sb.toString());
        }
        Rectangle original = new Rectangle(targetBounds);
        if (this.myLocateWithinScreen) {
            ScreenUtil.moveToFit((Rectangle)targetBounds, (Rectangle)screen, null);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Target bounds after moving to fit the screen: " + String.valueOf(targetBounds));
            }
        } else {
            AbstractPopup.fitToVisibleArea(targetBounds);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Target bounds after moving to fit the visible area: " + String.valueOf(targetBounds));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("END calculating popup bounds, the result is " + String.valueOf(targetBounds));
        }
        if (this.myMouseOutCanceller != null) {
            this.myMouseOutCanceller.myEverEntered = targetBounds.equals(original);
        }
        Point pointOnOwner = new Point(aScreenX, aScreenY);
        SwingUtilities.convertPointFromScreen(pointOnOwner, owner);
        if (ActionToolbarImpl.isInPopupToolbar(SwingUtilities.getDeepestComponentAt(owner, pointOnOwner.x, pointOnOwner.y))) {
            AutoPopupSupportingListener.installOn(this);
        }
        this.myOwner = AbstractPopup.getFrameOrDialog(owner);
        if (this.myOwner == null) {
            this.myOwner = owner;
        }
        this.myRequestorComponent = owner;
        this.myPopupType = this.getMostSuitablePopupType();
        this.myNativePopup = this.myPopupType != PopupComponentFactory.PopupType.DIALOG;
        Component popupOwner = this.myOwner;
        if (popupOwner instanceof RootPaneContainer) {
            RootPaneContainer root = (RootPaneContainer)((Object)popupOwner);
            if (!(popupOwner instanceof IdeFrame) || Registry.is((String)"popup.fix.ide.frame.owner")) {
                popupOwner = root.getRootPane();
                LOG.debug("popup owner fixed for JDK cache");
            }
        }
        if (StartupUiUtil.isWaylandToolkit()) {
            popupOwner = SwingUtilities.getRoot(popupOwner);
            targetBounds.setLocation(AbstractPopup.getLocationRelativeToParent(targetBounds, (Window)popupOwner));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("expected preferred size: " + String.valueOf(this.myContent.getPreferredSize()));
        }
        PopupComponentFactory factory = PopupComponentFactory.getCurrentInstance();
        this.myPopup = factory.createPopupComponent(this.myPopupType, popupOwner, this.myContent, targetBounds.x, targetBounds.y, this);
        if (LOG.isDebugEnabled()) {
            LOG.debug("START adjusting popup bounds after creation");
            LOG.debug("  actual preferred size: " + String.valueOf(this.myContent.getPreferredSize()));
        }
        if (targetBounds.width != this.myContent.getWidth() || targetBounds.height != this.myContent.getHeight()) {
            LOG.debug("the expected size (" + String.valueOf(targetBounds.getSize()) + ") is not equal to the actual size (" + String.valueOf(this.myContent.getSize()) + ")");
            Window popup2 = this.myPopup.getWindow();
            if (popup2 != null) {
                popup2.setSize(targetBounds.width, targetBounds.height);
                if (this.myContent.getParent().getComponentCount() != 1) {
                    LOG.debug("unexpected count of components in heavy-weight popup");
                }
            } else {
                LOG.debug("cannot fix size for non-heavy-weight popup because its window is null");
            }
        }
        if (adjustments != null && adjustments.adjustedHeight()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Settings the size to " + String.valueOf(targetBounds.getSize()) + " because the height of the popup was adjusted");
            }
            this.setSize(targetBounds.getSize());
        }
        if (this.myResizable) {
            JRootPane root = this.myContent.getRootPane();
            IdeGlassPaneImpl glass = new IdeGlassPaneImpl(root);
            root.setGlassPane(glass);
            resizeListener2 = new WindowResizeListenerEx(glass, this.myComponent, this.myMovable);
            resizeListener2.install(this);
            resizeListener2.addResizeListeners(() -> this.myResizeListeners.forEach(Runnable::run));
            this.myResizeListener = resizeListener2;
        }
        this.setIsMovable(this.myMovable);
        this.notifyListeners();
        this.myPopup.setRequestFocus(this.myRequestFocus);
        Window window = AbstractPopup.getContentWindow(this.myContent);
        if (window instanceof IdeFrame) {
            LOG.warn("Lightweight popup is shown using AbstractPopup class. But this class is not supposed to work with lightweight popups.");
        }
        window.setFocusableWindowState(this.myRequestFocus);
        window.setFocusable(this.myRequestFocus);
        window.setAlwaysOnTop(false);
        if (this.myFocusable) {
            FocusTraversalPolicy focusTraversalPolicy = new FocusTraversalPolicy(){

                @Override
                public Component getComponentAfter(Container aContainer, Component aComponent) {
                    return this.getComponent();
                }

                private Component getComponent() {
                    return AbstractPopup.this.myPreferredFocusedComponent == null ? AbstractPopup.this.myComponent : AbstractPopup.this.myPreferredFocusedComponent;
                }

                @Override
                public Component getComponentBefore(Container aContainer, Component aComponent) {
                    return this.getComponent();
                }

                @Override
                public Component getFirstComponent(Container aContainer) {
                    return this.getComponent();
                }

                @Override
                public Component getLastComponent(Container aContainer) {
                    return this.getComponent();
                }

                @Override
                public Component getDefaultComponent(Container aContainer) {
                    return this.getComponent();
                }
            };
            window.setFocusTraversalPolicy(focusTraversalPolicy);
            Disposer.register((Disposable)this, () -> window.setFocusTraversalPolicy(null));
        }
        window.setAutoRequestFocus(this.myRequestFocus);
        resizeListener2 = this.myCaption;
        if (resizeListener2 instanceof TitlePanel) {
            TitlePanel titlePanel = (TitlePanel)resizeListener2;
            window.getAccessibleContext().setAccessibleName(StringUtil.unescapeXmlEntities((String)titlePanel.getLabel().getText()).replace("&nbsp;", " "));
        }
        if (roundedCornerParams != null) {
            WindowRoundedCornersManager.setRoundedCorners(window, roundedCornerParams);
        }
        if (this.myNormalWindowLevel && !window.isDisplayable()) {
            window.setType(Window.Type.NORMAL);
        }
        this.myWindow = window;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting minimum size to " + String.valueOf(this.myMinSize));
        }
        this.setMinimumSize(this.myMinSize);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Minimum size set to " + String.valueOf(window.getMinimumSize()));
        }
        TouchbarSupport.showPopupItems(this, this.myContent);
        this.modalEntitiesWhenShown = LaterInvocator.getCurrentModalEntities();
        this.myPopup.show();
        Rectangle bounds = window.getBounds();
        if (LOG.isDebugEnabled()) {
            LOG.debug("END adjusting popup bounds after creation, the result is: " + String.valueOf(bounds) + ", starting final post-show adjustments");
        }
        PopupLocationTracker.register(this);
        if (this.myLocateWithinScreen) {
            if (bounds.x < screen.x || bounds.y < screen.y || bounds.x + bounds.width > screen.x + screen.width || bounds.y + bounds.height > screen.y + screen.height) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Bounds won't fit into the screen, adjusting");
                }
                ScreenUtil.fitToScreen((Rectangle)bounds);
                window.setBounds(bounds);
            }
        } else if (bounds.width > screen.width || bounds.height > screen.height) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Bounds are larger than the screen, adjusting");
            }
            ScreenUtil.fitToScreen((Rectangle)bounds);
            window.setBounds(bounds);
        }
        if (LOG.isDebugEnabled()) {
            GraphicsDevice device = ScreenUtil.getScreenDevice((Rectangle)bounds);
            StringBuilder sb = new StringBuilder("Popup is shown with bounds " + String.valueOf(bounds));
            if (device != null) {
                sb.append(" on screen with ID \"").append(device.getIDstring()).append("\"").append(" and bounds ").append(device.getDefaultConfiguration().getBounds());
            }
            LOG.debug(sb.toString());
        }
        WindowAction.setEnabledFor(this.myPopup.getWindow(), this.myResizable);
        this.myWindowListener = new MyWindowListener();
        window.addWindowListener(this.myWindowListener);
        if (this.myWindow != null && !this.myMayBeParent && !(this.myWindow instanceof Frame)) {
            WindowManager.getInstance().doNotSuggestAsParent(this.myWindow);
        }
        Runnable afterShow = Context.current().wrap(() -> {
            if (this.isDisposed()) {
                LOG.debug("popup is disposed after showing");
                this.removeActivity();
                return;
            }
            if ((this.myPreferredFocusedComponent instanceof AbstractButton || this.myPreferredFocusedComponent instanceof JTextField) && this.myFocusable) {
                IJSwingUtilities.moveMousePointerOn(this.myPreferredFocusedComponent);
            }
            this.removeActivity();
            TraceKt.use((SpanBuilder)TelemetryManager.getInstance().getTracer(PlatformScopesKt.UI).spanBuilder("afterShow#" + this.getClass().getSimpleName()), __ -> {
                this.afterShow();
                return null;
            });
        });
        if (this.myRequestFocus) {
            if (this.myPreferredFocusedComponent != null) {
                ThreadContext.resetThreadContext(() -> {
                    this.myPreferredFocusedComponent.requestFocus();
                    return null;
                });
            } else {
                this._requestFocus();
            }
            window.setAutoRequestFocus(this.myRequestFocus);
            SwingUtilities.invokeLater(afterShow);
        } else {
            SwingUtilities.invokeLater(() -> {
                if (this.isDisposed()) {
                    this.removeActivity();
                    return;
                }
                afterShow.run();
            });
        }
        this.debugState("popup shown", State.SHOWING);
        this.myState = State.SHOWN;
        this.myOpeningTime = System.currentTimeMillis();
        this.afterShowSync();
    }

    private static Point getLocationRelativeToParent(Rectangle bounds, Window popupParent) {
        Rectangle newBounds = new Rectangle(bounds);
        Point parentLocation = popupParent.getLocationOnScreen();
        newBounds.x -= parentLocation.x;
        newBounds.y -= parentLocation.y;
        Rectangle okBounds = new Rectangle(0, 0, popupParent.getWidth() + newBounds.width, popupParent.getHeight() + newBounds.height);
        ScreenUtil.moveToFit((Rectangle)newBounds, (Rectangle)okBounds, (Insets)new Insets(0, 0, 1, 1));
        return newBounds.getLocation();
    }

    private AppliedAdjustments adjustForAnchor(@NotNull Rectangle bounds, @NotNull PopupShowOptionsImpl options2, @NotNull Rectangle screen) {
        if (bounds == null) {
            AbstractPopup.$$$reportNull$$$0(59);
        }
        if (options2 == null) {
            AbstractPopup.$$$reportNull$$$0(60);
        }
        if (screen == null) {
            AbstractPopup.$$$reportNull$$$0(61);
        }
        boolean adjustedHeight = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adjusting the bounds " + String.valueOf(bounds) + " for the screen " + String.valueOf(screen) + " with the options = " + String.valueOf(options2));
        }
        Point anchorPoint = options2.getPopupAnchor().getPointOnRectangle(bounds);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Anchor point " + String.valueOf(anchorPoint));
        }
        int originalY = bounds.y;
        int offsetX = bounds.x - anchorPoint.x;
        int offsetY = bounds.y - anchorPoint.y;
        bounds.x += offsetX;
        bounds.y += offsetY;
        if (LOG.isDebugEnabled()) {
            LOG.debug("The bounds after moving the anchor point " + String.valueOf(bounds));
        }
        if (options2.getPopupComponentUnscaledGap() != 0 && options2.getRelativePosition() != null) {
            int gap = JBUI.scale((int)options2.getPopupComponentUnscaledGap());
            switch (options2.getRelativePosition()) {
                case LEFT: {
                    bounds.x -= gap;
                    break;
                }
                case RIGHT: {
                    bounds.x += gap;
                    break;
                }
                case TOP: {
                    bounds.y -= gap;
                    break;
                }
                case BOTTOM: {
                    bounds.y += gap;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("The bounds after adjusting for the gap " + String.valueOf(bounds));
            }
        }
        if (this.myLocateWithinScreen && !screen.contains(bounds)) {
            int reducedHeight;
            int shift;
            LOG.debug("The bounds won't fit into the screen");
            if (bounds.x < screen.x) {
                shift = screen.x - bounds.x;
                bounds.x += shift;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The bounds after shifting horizontally to the left side " + String.valueOf(bounds));
                }
            }
            if (bounds.y < screen.y) {
                shift = screen.y - bounds.y;
                bounds.y += shift;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The bounds after shifting vertically to the top side " + String.valueOf(bounds));
                }
                if (options2.getRelativePosition() == PopupRelativePosition.TOP && options2.getMinimumHeight() != null) {
                    reducedHeight = bounds.height - shift;
                    if (reducedHeight >= options2.getMinimumHeight()) {
                        bounds.height = reducedHeight;
                        adjustedHeight = true;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("The bounds after adjusting height to fit above the owner " + String.valueOf(bounds));
                        }
                    } else {
                        bounds.y = originalY;
                    }
                }
            }
            if (bounds.x + bounds.width > screen.x + screen.width) {
                shift = bounds.x + bounds.width - (screen.x + screen.width);
                bounds.x -= shift;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The bounds after shifting horizontally to the right side " + String.valueOf(bounds));
                }
            }
            if (bounds.y + bounds.height > screen.y + screen.height) {
                shift = bounds.y + bounds.height - (screen.y + screen.height);
                if (options2.getRelativePosition() == PopupRelativePosition.BOTTOM && options2.getMinimumHeight() != null) {
                    reducedHeight = bounds.height - shift;
                    bounds.height = Math.max(options2.getMinimumHeight(), reducedHeight);
                    adjustedHeight = true;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("The bounds after adjusting height to fit below the owner " + String.valueOf(bounds));
                    }
                }
            }
            if (bounds.y + bounds.height > screen.y + screen.height) {
                shift = bounds.y + bounds.height - (screen.y + screen.height);
                bounds.height -= shift;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The bounds after shifting vertically to the bottom side " + String.valueOf(bounds));
                }
            }
        }
        return new AppliedAdjustments(adjustedHeight);
    }

    public void notifyListeners() {
        this.myListeners.forEach(listener2 -> listener2.beforeShown(new LightweightWindowEvent((LightweightWindow)this)));
    }

    private static void fitToVisibleArea(Rectangle targetBounds) {
        if (StartupUiUtil.isWaylandToolkit()) {
            return;
        }
        Point topLeft = new Point(targetBounds.x, targetBounds.y);
        Point bottomRight = new Point((int)targetBounds.getMaxX(), (int)targetBounds.getMaxY());
        Rectangle topLeftScreen = ScreenUtil.getScreenRectangle((Point)topLeft);
        Rectangle bottomRightScreen = ScreenUtil.getScreenRectangle((Point)bottomRight);
        if (topLeft.x < topLeftScreen.x || topLeft.y < topLeftScreen.y || (double)bottomRight.x > bottomRightScreen.getMaxX() || (double)bottomRight.y > bottomRightScreen.getMaxY()) {
            GraphicsDevice device = ScreenUtil.getScreenDevice((Rectangle)targetBounds);
            Rectangle mostAppropriateScreenRectangle = device != null ? ScreenUtil.getScreenRectangle((GraphicsConfiguration)device.getDefaultConfiguration()) : ScreenUtil.getMainScreenBounds();
            ScreenUtil.moveToFit((Rectangle)targetBounds, (Rectangle)mostAppropriateScreenRectangle, null);
        }
    }

    public void focusPreferredComponent() {
        this._requestFocus();
    }

    private void installProjectDisposer() {
        DataContext context;
        Project project2;
        Component c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (c != null && (project2 = (Project)CommonDataKeys.PROJECT.getData(context = DataManager.getInstance().getDataContext(c))) != null) {
            this.myProjectDisposable = () -> {
                if (!this.isDisposed()) {
                    Disposer.dispose((Disposable)this);
                }
            };
            Disposer.register((Disposable)project2, (Disposable)this.myProjectDisposable);
        }
    }

    private static void installWindowHook(@NotNull AbstractPopup popup2) {
        if (popup2 == null) {
            AbstractPopup.$$$reportNull$$$0(62);
        }
        if (popup2.myCancelOnWindow) {
            popup2.myCancelOnWindow = false;
            new Alarm((Disposable)popup2).addRequest(() -> {
                popup2.myCancelOnWindow = true;
            }, 100);
        }
    }

    private void addActivity() {
        UiActivityMonitor.getInstance().addActivity(this.myActivityKey);
    }

    private void removeActivity() {
        UiActivityMonitor.getInstance().removeActivity(this.myActivityKey);
    }

    private void prepareToShow() {
        MouseAdapter mouseAdapter2 = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Rectangle bounds = AbstractPopup.getBoundsOnScreen(AbstractPopup.this.myContent);
                if (bounds != null) {
                    bounds.x -= 2;
                    bounds.y -= 2;
                    bounds.width += 4;
                    bounds.height += 4;
                }
                if (bounds == null || !bounds.contains(e.getLocationOnScreen())) {
                    AbstractPopup.this.cancel();
                }
            }
        };
        this.myContent.addMouseListener(mouseAdapter2);
        Disposer.register((Disposable)this, () -> this.myContent.removeMouseListener(mouseAdapter2));
        this.myContent.addKeyListener((KeyListener)this.mySpeedSearch);
        if (this.myCancelOnMouseOutCallback != null || this.myCancelOnWindow) {
            this.installMouseOutCanceller();
        }
        ChildFocusWatcher focusWatcher = new ChildFocusWatcher(this.myContent){

            @Override
            protected void onFocusGained(FocusEvent event) {
                AbstractPopup.this.setWindowActive(true);
            }

            @Override
            protected void onFocusLost(FocusEvent event) {
                AbstractPopup.this.setWindowActive(false);
            }
        };
        Disposer.register((Disposable)this, (Disposable)focusWatcher);
        this.mySpeedSearchPatternField = new SearchTextField(false){

            protected void onFieldCleared() {
                AbstractPopup.this.mySpeedSearch.reset();
            }
        };
        this.mySpeedSearchPatternField.getTextEditor().setFocusable(this.mySpeedSearchAlwaysShown);
        if (this.mySpeedSearchEmptyText != null) {
            this.mySpeedSearchPatternField.getTextEditor().getEmptyText().setText(this.mySpeedSearchEmptyText);
        }
        AbstractPopup.customizeSearchFieldLook(this.mySpeedSearchPatternField, this.mySpeedSearchAlwaysShown);
        if (this.mySpeedSearchAlwaysShown) {
            this.setHeaderComponent((JComponent)this.mySpeedSearchPatternField);
        }
    }

    public static void customizeSearchFieldLook(@NotNull SearchTextField searchTextField, boolean isAlwaysShown) {
        if (searchTextField == null) {
            AbstractPopup.$$$reportNull$$$0(63);
        }
        JBTextField textField2 = searchTextField.getTextEditor();
        if (ExperimentalUI.isNewUI()) {
            searchTextField.setBackground(JBUI.CurrentTheme.Popup.BACKGROUND);
            textField2.setOpaque(false);
            textField2.putClientProperty((Object)"TextFieldWithoutMargins", (Object)true);
            textField2.putClientProperty((Object)"JComponent.compactHeight", (Object)true);
            textField2.putClientProperty((Object)"TextField.NoMinHeightBounds", (Object)true);
            EmptyBorder outsideBorder = new EmptyBorder(JBUI.CurrentTheme.Popup.searchFieldBorderInsets());
            Border lineBorder = JBUI.Borders.customLine((Color)JBUI.CurrentTheme.Popup.separatorColor(), (int)0, (int)0, (int)1, (int)0);
            searchTextField.setBorder(JBUI.Borders.compound((Border[])new Border[]{outsideBorder, lineBorder, new EmptyBorder(JBUI.CurrentTheme.Popup.searchFieldInputInsets())}));
            textField2.setBorder((Border)JBUI.Borders.empty());
        } else if (isAlwaysShown) {
            searchTextField.setBorder(JBUI.Borders.customLine((Color)JBUI.CurrentTheme.BigPopup.searchFieldBorderColor(), (int)1, (int)0, (int)1, (int)0));
            textField2.setBorder((Border)JBUI.Borders.empty());
        }
        if (SystemInfo.isMac) {
            RelativeFont.TINY.install((Component)searchTextField);
        }
    }

    private void updateMaskAndAlpha(Window window) {
        if (window == null) {
            return;
        }
        if (!window.isDisplayable() || !window.isShowing()) {
            return;
        }
        WindowManagerEx wndManager = AbstractPopup.getWndManager();
        if (wndManager == null) {
            return;
        }
        if (!wndManager.isAlphaModeEnabled(window)) {
            return;
        }
        if (this.myAlpha != this.myLastAlpha) {
            wndManager.setAlphaModeRatio(window, this.myAlpha);
            this.myLastAlpha = this.myAlpha;
        }
        if (this.myMaskProvider != null) {
            Dimension size2 = window.getSize();
            Shape mask = this.myMaskProvider.getMask(size2);
            wndManager.setWindowMask(window, mask);
        }
        WindowManagerEx.WindowShadowMode mode = this.myShadowed ? WindowManagerEx.WindowShadowMode.NORMAL : WindowManagerEx.WindowShadowMode.DISABLED;
        WindowManagerEx.getInstanceEx().setWindowShadow(window, mode);
    }

    private static WindowManagerEx getWndManager() {
        return ApplicationManager.getApplication() != null ? WindowManagerEx.getInstanceEx() : null;
    }

    public boolean isDisposed() {
        return this.myContent == null;
    }

    protected boolean beforeShow() {
        if (ApplicationManager.getApplication() == null || !LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
            return true;
        }
        StackingPopupDispatcher.getInstance().onPopupShown((JBPopup)this, this.myInStack);
        return true;
    }

    protected void afterShow() {
    }

    protected void afterShowSync() {
    }

    protected final boolean requestFocus() {
        if (!this.myFocusable) {
            return false;
        }
        this.getFocusManager().doWhenFocusSettlesDown(() -> this._requestFocus());
        return true;
    }

    private void _requestFocus() {
        if (!this.myFocusable) {
            return;
        }
        JComponent toFocus = (JComponent)ObjectUtils.chooseNotNull((Object)this.myPreferredFocusedComponent, (Object)(this.mySpeedSearchAlwaysShown ? this.mySpeedSearchPatternField : null));
        if (toFocus != null) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> {
                if (!this.myDisposed) {
                    IdeFocusManager.getGlobalInstance().requestFocus((Component)toFocus, true);
                }
            });
        }
    }

    private IdeFocusManager getFocusManager() {
        if (this.myProject != null) {
            return IdeFocusManager.getInstance((Project)this.myProject);
        }
        if (this.myOwner != null) {
            return IdeFocusManager.findInstanceByComponent((Component)this.myOwner);
        }
        return IdeFocusManager.findInstance();
    }

    private static JComponent getTargetComponent(Component aComponent) {
        if (aComponent instanceof JComponent) {
            return (JComponent)aComponent;
        }
        if (aComponent instanceof RootPaneContainer) {
            return ((RootPaneContainer)((Object)aComponent)).getRootPane();
        }
        LOG.error("Cannot find target for:" + String.valueOf(aComponent));
        return null;
    }

    private PopupComponentFactory.PopupType getMostSuitablePopupType() {
        boolean noFocus;
        boolean cannotBeDialog;
        boolean forceDialog;
        boolean bl = forceDialog = this.myMayBeParent || SystemInfo.isMac && !(this.myOwner instanceof IdeFrame) && this.myOwner.isShowing();
        if (LoadingState.COMPONENTS_LOADED.isOccurred() && Registry.is((String)"allow.dialog.based.popups") && !(cannotBeDialog = (noFocus = !this.myFocusable || !this.myRequestFocus)) && (this.isPersistent() || forceDialog)) {
            return PopupComponentFactory.PopupType.DIALOG;
        }
        if (this.myForcedHeavyweight || this.myResizable) {
            return PopupComponentFactory.PopupType.HEAVYWEIGHT;
        }
        return PopupComponentFactory.PopupType.DEFAULT;
    }

    @NotNull
    public JComponent getContent() {
        MyContentPanel myContentPanel = this.myContent;
        if (myContentPanel == null) {
            AbstractPopup.$$$reportNull$$$0(64);
        }
        return myContentPanel;
    }

    public void setLocation(@NotNull RelativePoint p) {
        if (p == null) {
            AbstractPopup.$$$reportNull$$$0(65);
        }
        if (this.isBusy()) {
            return;
        }
        this.setLocation(p, this.myPopup);
    }

    private void setLocation(@NotNull RelativePoint p, @Nullable PopupComponent popup2) {
        if (p == null) {
            AbstractPopup.$$$reportNull$$$0(66);
        }
        if (popup2 == null) {
            return;
        }
        Window wnd = popup2.getWindow();
        assert (wnd != null);
        if (StartupUiUtil.isWaylandToolkit() && wnd.getType() == Window.Type.POPUP && this.myOwner != null) {
            Rectangle newBounds = wnd.getBounds();
            newBounds.setLocation(p.getScreenPoint());
            Component parent = SwingUtilities.getRoot(this.myOwner);
            wnd.setLocation(AbstractPopup.getLocationRelativeToParent(newBounds, (Window)parent));
        } else {
            wnd.setLocation(p.getScreenPoint());
        }
    }

    public void pack(boolean width, boolean height) {
        Dimension size2 = this.calculateSizeForPack(width, height);
        if (size2 == null) {
            return;
        }
        Window window = AbstractPopup.getContentWindow(this.myContent);
        if (window != null) {
            window.setSize(size2);
        }
    }

    @Nullable
    protected Dimension calculateSizeForPack(boolean width, boolean height) {
        int delta;
        Rectangle screen;
        if (!this.isVisible() || !width && !height || this.isBusy()) {
            return null;
        }
        Dimension size2 = this.getSize();
        Dimension prefSize = this.myContent.computePreferredSize();
        Point location = !this.myLocateWithinScreen ? null : this.getLocationOnScreen();
        Rectangle rectangle = screen = location == null ? null : ScreenUtil.getScreenRectangle((Point)location);
        if (width) {
            size2.width = prefSize.width;
            if (screen != null && size2.width > (delta = screen.width + screen.x - location.x)) {
                size2.width = delta;
            }
        }
        if (height) {
            if (size2.width < prefSize.width && (!SystemInfo.isMac || Registry.is((String)"mac.scroll.horizontal.gap"))) {
                this.forHorizontalScrollBar((Consumer<? super JScrollBar>)((Consumer)bar2 -> prefSize.height += bar2.getPreferredSize().height));
            }
            size2.height = prefSize.height;
            if (screen != null && size2.height > (delta = screen.height + screen.y - location.y)) {
                size2.height = delta;
            }
        }
        return size2;
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public Project getProject() {
        return this.myProject;
    }

    public void dispose() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        if (this.myState == State.SHOWN) {
            LOG.debug("shown popup must be cancelled");
            this.cancel();
        }
        if (this.myState == State.DISPOSE) {
            return;
        }
        this.debugState("dispose popup", State.INIT, State.CANCEL);
        this.myState = State.DISPOSE;
        if (LOG.isDebugEnabled()) {
            LOG.debug("start disposing " + String.valueOf(this.myContent));
        }
        Disposer.dispose((Disposable)this, (boolean)false);
        if (this.myPopup != null) {
            this.cancel(this.myDisposeEvent);
        }
        if (this.myContent != null) {
            Container parent = this.myContent.getParent();
            if (parent != null) {
                parent.remove(this.myContent);
            }
            this.myContent.removeAll();
            this.myContent.removeKeyListener((KeyListener)this.mySpeedSearch);
        }
        this.myContent = null;
        this.myPreferredFocusedComponent = null;
        this.myComponent = null;
        this.mySpeedSearchFoundInRootComponent = null;
        this.myCallBack = null;
        this.myListeners.clear();
        this.removeMouseOutCanceller();
        if (this.myFinalRunnable != null) {
            Runnable finalRunnable = this.myFinalRunnable;
            this.getFocusManager().doWhenFocusSettlesDown(() -> {
                try (AccessToken ignore = SlowOperations.startSection((String)"action.perform");){
                    finalRunnable.run();
                }
            });
            this.myFinalRunnable = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("stop disposing content");
        }
    }

    private void resetWindow() {
        if (this.myWindow != null && AbstractPopup.getWndManager() != null) {
            Window window;
            AbstractPopup.getWndManager().resetWindow(this.myWindow);
            if (this.myWindowListener != null) {
                this.myWindow.removeWindowListener(this.myWindowListener);
            }
            if ((window = this.myWindow) instanceof RootPaneContainer) {
                RootPaneContainer container = (RootPaneContainer)((Object)window);
                JRootPane root = container.getRootPane();
                root.putClientProperty("JBPopup", null);
                if (root.getGlassPane() instanceof IdeGlassPaneImpl) {
                    JPanel glass = new JPanel();
                    glass.setName(root.getName() + ".glassPane");
                    glass.setVisible(false);
                    glass.setOpaque(false);
                    root.setGlassPane(glass);
                }
            }
            this.myWindow = null;
            this.myWindowListener = null;
        }
    }

    @Nullable
    private Project getProjectDependingOnKey(String key) {
        return !key.startsWith("APPLICATION_WIDE_STORE_") ? this.myProject : null;
    }

    @NotNull
    public final Dimension getContentSize() {
        Dimension size2 = this.myContent.getSize();
        JBInsets.removeFrom((Dimension)size2, (Insets)this.myContent.getInsets());
        Dimension dimension = size2;
        if (dimension == null) {
            AbstractPopup.$$$reportNull$$$0(67);
        }
        return dimension;
    }

    public void storeDimensionSize() {
        if (this.myDimensionServiceKey != null) {
            AbstractPopup.getWindowStateService(this.getProjectDependingOnKey(this.myDimensionServiceKey)).putSize(this.myDimensionServiceKey, this.getContentSize());
        }
    }

    private void storeLocation(Point xy) {
        if (this.myDimensionServiceKey != null) {
            AbstractPopup.getWindowStateService(this.getProjectDependingOnKey(this.myDimensionServiceKey)).putLocation(this.myDimensionServiceKey, xy);
        }
    }

    @ApiStatus.Internal
    public boolean isCancelOnClickOutside() {
        return this.myCancelOnClickOutside;
    }

    @ApiStatus.Internal
    public void setCancelOnClickOutside(boolean cancelOnClickOutside) {
        this.myCancelOnClickOutside = cancelOnClickOutside;
    }

    @ApiStatus.Internal
    public void setIsMovable(boolean movable) {
        this.myMovable = movable;
        if (!this.myMovable && this.myMoveListener != null) {
            MyContentPanel saved = this.myContent;
            ListenerUtil.removeMouseListener(saved, this.myMoveListener);
            ListenerUtil.removeMouseMotionListener(saved, this.myMoveListener);
            this.myMoveListener = null;
        }
        if (this.myCaption != null && this.myMovable) {
            WindowMoveListener moveListener2 = new WindowMoveListener((Component)this.myCaption){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isConsumed()) {
                        return;
                    }
                    if (UIUtil.isCloseClick((MouseEvent)e) && AbstractPopup.this.myCaption.isWithinPanel(e)) {
                        AbstractPopup.this.cancel();
                    } else {
                        super.mousePressed(e);
                    }
                }
            };
            moveListener2.installTo((Component)this.myCaption);
            MyContentPanel saved = this.myContent;
            Disposer.register((Disposable)this, () -> {
                ListenerUtil.removeMouseListener(saved, moveListener2);
                ListenerUtil.removeMouseMotionListener(saved, moveListener2);
            });
            this.myMoveListener = moveListener2;
        }
    }

    @ApiStatus.Internal
    public void setCancelOnWindowDeactivation(boolean cancelOnWindowDeactivation) {
        this.myCancelOnWindowDeactivation = cancelOnWindowDeactivation;
    }

    boolean isCancelOnWindowDeactivation() {
        return this.myCancelOnWindowDeactivation;
    }

    @ApiStatus.Internal
    public void setCancelOnMouseOutCallback(@Nullable MouseChecker checker) {
        this.myCancelOnMouseOutCallback = checker;
        if (checker != null && this.myMouseOutCanceller == null) {
            this.installMouseOutCanceller();
        } else if (checker == null && this.myMouseOutCanceller != null && !this.myCancelOnWindow) {
            this.removeMouseOutCanceller();
        }
    }

    @ApiStatus.Internal
    public void setCancelOnOtherWindowOpen(boolean cancel2) {
        this.myCancelOnWindow = cancel2;
        if (cancel2 && this.myMouseOutCanceller == null) {
            this.installMouseOutCanceller();
        } else if (!cancel2 && this.myMouseOutCanceller != null && this.myCancelOnMouseOutCallback == null) {
            this.removeMouseOutCanceller();
        }
    }

    private void installMouseOutCanceller() {
        this.myMouseOutCanceller = new Canceller();
        Toolkit.getDefaultToolkit().addAWTEventListener(this.myMouseOutCanceller, 112L);
    }

    private void removeMouseOutCanceller() {
        Toolkit toolkit;
        if (this.myMouseOutCanceller != null && (toolkit = Toolkit.getDefaultToolkit()) != null) {
            toolkit.removeAWTEventListener(this.myMouseOutCanceller);
        }
        this.myMouseOutCanceller = null;
    }

    public void setLocation(@NotNull Point screenPoint) {
        if (screenPoint == null) {
            AbstractPopup.$$$reportNull$$$0(68);
        }
        if (!this.isBusy()) {
            this.setBounds(new Point(screenPoint), null);
        }
    }

    private static Window getContentWindow(@NotNull Component content2) {
        Window window;
        if (content2 == null) {
            AbstractPopup.$$$reportNull$$$0(69);
        }
        if ((window = SwingUtilities.getWindowAncestor(content2)) == null && LOG.isDebugEnabled()) {
            LOG.debug("no window ancestor for " + String.valueOf(content2));
        }
        return window;
    }

    @NotNull
    public Point getLocationOnScreen() {
        Window window = AbstractPopup.getContentWindow(this.myContent);
        Point screenPoint = window == null ? new Point() : window.getLocation();
        this.fixLocateByContent(screenPoint, false);
        Insets insets = this.myContent.getInsets();
        if (insets != null) {
            screenPoint.x += insets.left;
            screenPoint.y += insets.top;
        }
        Point point = screenPoint;
        if (point == null) {
            AbstractPopup.$$$reportNull$$$0(70);
        }
        return point;
    }

    public void setSize(@NotNull Dimension size2) {
        if (size2 == null) {
            AbstractPopup.$$$reportNull$$$0(71);
        }
        this.setSize(null, size2);
    }

    public void setSize(@Nullable Point location, @NotNull Dimension size2) {
        if (size2 == null) {
            AbstractPopup.$$$reportNull$$$0(72);
        }
        if (!this.isBusy()) {
            this.setBounds(location, new Dimension(size2));
            if (this.myPopup != null) {
                Optional.ofNullable(AbstractPopup.getContentWindow(this.myContent)).ifPresent(Container::validate);
            }
        }
    }

    public int getAdComponentHeight() {
        return this.myAdComponent != null ? this.myAdComponent.getPreferredSize().height + JBUIScale.scale((int)1) : 0;
    }

    protected boolean isAdVisible() {
        return this.myAdComponent != null && this.myAdComponent.isVisible();
    }

    public Dimension getSize() {
        Window popupWindow;
        if (this.myPopup != null && (popupWindow = AbstractPopup.getContentWindow(this.myContent)) != null) {
            Dimension size2 = popupWindow.getSize();
            size2.height -= this.getAdComponentHeight();
            return size2;
        }
        return this.myForcedSize;
    }

    public void moveToFitScreen() {
        if (this.myPopup == null || this.isBusy()) {
            return;
        }
        Window popupWindow = AbstractPopup.getContentWindow(this.myContent);
        if (popupWindow == null) {
            return;
        }
        Rectangle bounds = popupWindow.getBounds();
        ScreenUtil.moveRectangleToFitTheScreen((Rectangle)bounds);
        if (LOG.isDebugEnabled()) {
            LOG.debug("MoveToFitScreen x = " + bounds.x + " y = " + bounds.y + " width = " + bounds.width + " height = " + bounds.height);
        }
        popupWindow.setBounds(bounds);
        this.updateMaskAndAlpha(popupWindow);
    }

    public void setBounds(@NotNull Rectangle bounds) {
        if (bounds == null) {
            AbstractPopup.$$$reportNull$$$0(73);
        }
        if (!this.isBusy()) {
            this.setBounds(bounds.getLocation(), bounds.getSize());
        }
    }

    private void stretchContentToOwnerIfNecessary(@NotNull Component owner) {
        if (owner == null) {
            AbstractPopup.$$$reportNull$$$0(74);
        }
        if (this.myForcedSize != null) {
            return;
        }
        if (!this.myStretchToOwnerWidth && !this.myStretchToOwnerHeight) {
            return;
        }
        Dimension filledSize = this.myContent.getPreferredSize();
        if (this.myStretchToOwnerWidth) {
            filledSize.width = owner.getWidth();
        }
        if (this.myStretchToOwnerHeight) {
            filledSize.height = owner.getHeight();
        }
        this.myContent.setPreferredSize(filledSize);
    }

    private void setBounds(@Nullable Point location, @Nullable Dimension size2) {
        if (size2 != null) {
            size2.height += this.getAdComponentHeight();
        }
        if (this.myPopup == null) {
            if (location != null) {
                this.myForcedLocation = location;
            }
            if (size2 != null) {
                this.myForcedSize = size2;
            }
        } else {
            MyContentPanel content2 = this.myContent;
            if (content2 == null) {
                return;
            }
            Window window = AbstractPopup.getContentWindow(content2);
            if (window == null) {
                return;
            }
            Insets insets = content2.getInsets();
            boolean useScreenLocation = true;
            if (location == null) {
                useScreenLocation = false;
                location = window.getLocation();
            } else {
                this.fixLocateByContent(location, false);
                if (insets != null) {
                    location.x -= insets.left;
                    location.y -= insets.top;
                }
            }
            if (size2 == null) {
                size2 = window.getSize();
            } else {
                JBInsets.addTo((Dimension)size2, (Insets)insets);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Update content preferred size: width = " + size2.width + " height = " + size2.height);
                }
                content2.setPreferredSize(size2);
                size2 = window.getPreferredSize();
            }
            if (StartupUiUtil.isWaylandToolkit() && useScreenLocation && this.myPopup.getWindow().getType() == Window.Type.POPUP && this.myOwner != null) {
                Component parent = SwingUtilities.getRoot(this.myOwner);
                Rectangle targetBounds = new Rectangle(location, size2);
                location.setLocation(AbstractPopup.getLocationRelativeToParent(targetBounds, (Window)parent));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("SetBounds x = " + location.x + " y = " + location.y + " width = " + size2.width + " height = " + size2.height);
            }
            window.setBounds(location.x, location.y, size2.width, size2.height);
            window.setCursor(Cursor.getDefaultCursor());
            this.updateMaskAndAlpha(window);
        }
    }

    public void setCaption(@NlsContexts.PopupTitle @NotNull String title2) {
        CaptionPanel captionPanel;
        if (title2 == null) {
            AbstractPopup.$$$reportNull$$$0(75);
        }
        if ((captionPanel = this.myCaption) instanceof TitlePanel) {
            TitlePanel titlePanel = (TitlePanel)captionPanel;
            titlePanel.setText(title2);
        }
    }

    public void setCaptionIcon(@Nullable Icon icon2) {
        CaptionPanel captionPanel = this.myCaption;
        if (captionPanel instanceof TitlePanel) {
            TitlePanel titlePanel = (TitlePanel)captionPanel;
            titlePanel.setRegularIcon(icon2);
            titlePanel.setInactiveIcon(icon2);
        }
    }

    public void setCaptionIconPosition(boolean left) {
        CaptionPanel captionPanel = this.myCaption;
        if (captionPanel instanceof TitlePanel) {
            TitlePanel titlePanel = (TitlePanel)captionPanel;
            titlePanel.setHorizontalTextPosition(left ? 4 : 2);
        }
    }

    public void setSpeedSearchAlwaysShown() {
        assert (this.myState.ordinal() <= State.INIT.ordinal());
        this.mySpeedSearchAlwaysShown = true;
    }

    public void setSpeedSearchEmptyText(@NlsContexts.StatusText @Nullable String text2) {
        this.mySpeedSearchEmptyText = text2;
    }

    public boolean isPersistent() {
        return !this.myCancelOnClickOutside && !this.myCancelOnWindow;
    }

    public boolean isNativePopup() {
        return this.myNativePopup;
    }

    public void setUiVisible(boolean visible) {
        if (this.myPopup != null) {
            if (visible) {
                this.myPopup.show();
                Window window = this.getPopupWindow();
                if (window != null && this.myRestoreWindowSize != null) {
                    window.setSize(this.myRestoreWindowSize);
                    this.myRestoreWindowSize = null;
                }
            } else {
                Window window = this.getPopupWindow();
                if (window != null) {
                    this.myRestoreWindowSize = window.getSize();
                    window.setVisible(false);
                }
            }
        }
    }

    public Window getPopupWindow() {
        return this.myPopup != null ? this.myPopup.getWindow() : null;
    }

    public void setUserData(@NotNull List<Object> userData) {
        if (userData == null) {
            AbstractPopup.$$$reportNull$$$0(76);
        }
        this.myUserData = userData;
    }

    public <T> T getUserData(@NotNull Class<T> userDataClass) {
        if (userDataClass == null) {
            AbstractPopup.$$$reportNull$$$0(77);
        }
        if (this.myUserData != null) {
            for (Object o : this.myUserData) {
                if (!userDataClass.isInstance(o)) continue;
                Object t = o;
                return (T)t;
            }
        }
        return null;
    }

    public boolean isModalContext() {
        return this.myModalContext;
    }

    public boolean isFocused() {
        if (this.myComponent != null && AbstractPopup.isFocused(new Component[]{SwingUtilities.getWindowAncestor(this.myComponent)})) {
            return true;
        }
        return AbstractPopup.isFocused(this.myFocusOwners);
    }

    private static boolean isFocused(Component @NotNull [] components) {
        Component owner;
        if (components == null) {
            AbstractPopup.$$$reportNull$$$0(78);
        }
        if ((owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) == null) {
            return false;
        }
        Window wnd = ComponentUtil.getWindow((Component)owner);
        for (Component each : components) {
            Window eachWindow;
            if (each == null || !SwingUtilities.isDescendingFrom(owner, each) || (eachWindow = ComponentUtil.getWindow((Component)each)) != wnd) continue;
            return true;
        }
        return false;
    }

    public boolean isCancelKeyEnabled() {
        return this.myCancelKeyEnabled;
    }

    @ApiStatus.Internal
    public void setCancelKeyEnabled(boolean enabled2) {
        this.myCancelKeyEnabled = enabled2;
    }

    @NotNull
    public CaptionPanel getTitle() {
        CaptionPanel captionPanel = this.myCaption;
        if (captionPanel == null) {
            AbstractPopup.$$$reportNull$$$0(79);
        }
        return captionPanel;
    }

    protected void setHeaderComponent(JComponent c) {
        boolean doRevalidate = false;
        if (this.myHeaderComponent != null) {
            this.myHeaderPanel.remove(this.myHeaderComponent);
            this.myHeaderComponent = null;
            doRevalidate = true;
        }
        if (c != null) {
            this.myHeaderPanel.add((Component)c, "Center");
            this.myHeaderComponent = c;
            if (this.isVisible()) {
                Dimension size2 = this.myContent.getSize();
                if (size2.height < c.getPreferredSize().height * 2) {
                    size2.height += c.getPreferredSize().height;
                    this.setSize(size2);
                }
            }
            doRevalidate = true;
        }
        if (doRevalidate) {
            this.myContent.revalidate();
        }
    }

    public void setWarning(@NlsContexts.Label @NotNull String text2) {
        if (text2 == null) {
            AbstractPopup.$$$reportNull$$$0(80);
        }
        this.myHeaderPanel.add((Component)this.createWarning(text2), "South");
    }

    @NotNull
    protected JComponent createWarning(@NlsContexts.Label @NotNull String text2) {
        if (text2 == null) {
            AbstractPopup.$$$reportNull$$$0(81);
        }
        JBLabel label2 = new JBLabel(text2, UIUtil.getBalloonWarningIcon(), 0);
        label2.setOpaque(true);
        Color color = HintUtil.getInformationColor();
        label2.setBackground(color);
        label2.setBorder(BorderFactory.createLineBorder(color, 3));
        JBLabel jBLabel = label2;
        if (jBLabel == null) {
            AbstractPopup.$$$reportNull$$$0(82);
        }
        return jBLabel;
    }

    public void addListener(@NotNull JBPopupListener listener2) {
        if (listener2 == null) {
            AbstractPopup.$$$reportNull$$$0(83);
        }
        this.myListeners.add(0, listener2);
    }

    public void removeListener(@NotNull JBPopupListener listener2) {
        if (listener2 == null) {
            AbstractPopup.$$$reportNull$$$0(84);
        }
        this.myListeners.remove(listener2);
    }

    protected void onSpeedSearchPatternChanged() {
    }

    public Component getOwner() {
        return this.myRequestorComponent;
    }

    public void setMinimumSize(Dimension size2) {
        Dimension sizeFromHeader = this.calcHeaderSize();
        if (size2 == null) {
            this.myMinSize = sizeFromHeader;
        } else {
            int width = Math.max(size2.width, sizeFromHeader.width);
            int height = Math.max(size2.height, sizeFromHeader.height);
            this.myMinSize = new Dimension(width, height);
        }
        if (this.myWindow != null) {
            Rectangle screenRectangle = ScreenUtil.getScreenRectangle((Point)this.myWindow.getLocation());
            int width = Math.min(screenRectangle.width, this.myMinSize.width);
            int height = Math.min(screenRectangle.height, this.myMinSize.height);
            this.myWindow.setMinimumSize(new Dimension(width, height));
        }
    }

    public Dimension getMinimumSize() {
        return this.myMinSize != null ? this.myMinSize : this.calcHeaderSize();
    }

    public void setStretchToOwnerWidth(boolean stretchToOwnerWidth) {
        this.myStretchToOwnerWidth = stretchToOwnerWidth;
    }

    public void setStretchToOwnerHeight(boolean stretchToOwnerHeight) {
        this.myStretchToOwnerHeight = stretchToOwnerHeight;
    }

    @NotNull
    private Dimension calcHeaderSize() {
        Dimension sizeFromHeader = this.myHeaderPanel.getPreferredSize();
        if (sizeFromHeader == null) {
            sizeFromHeader = this.myHeaderPanel.getMinimumSize();
        }
        if (sizeFromHeader == null) {
            int minimumSize = this.myWindow.getFontMetrics(this.myHeaderPanel.getFont()).getHeight();
            sizeFromHeader = new Dimension(minimumSize, minimumSize);
        }
        Dimension dimension = sizeFromHeader;
        if (dimension == null) {
            AbstractPopup.$$$reportNull$$$0(85);
        }
        return dimension;
    }

    public void setOkHandler(Runnable okHandler) {
        this.myOkHandler = okHandler;
    }

    public void setFinalRunnable(Runnable finalRunnable) {
        this.myFinalRunnable = finalRunnable;
    }

    public void setOk(boolean ok) {
        this.myOk = ok;
    }

    public void setDataProvider(@NotNull DataProvider dataProvider) {
        if (dataProvider == null) {
            AbstractPopup.$$$reportNull$$$0(86);
        }
        this.setUiDataProvider(Utils.wrapToUiDataProvider(dataProvider));
    }

    public void setUiDataProvider(@NotNull UiDataProvider dataProvider) {
        if (dataProvider == null) {
            AbstractPopup.$$$reportNull$$$0(87);
        }
        if (this.myContent != null) {
            this.myContent.setDataProvider(dataProvider);
        }
    }

    public boolean dispatchKeyEvent(@NotNull KeyEvent e) {
        BooleanFunction<? super KeyEvent> handler;
        if (e == null) {
            AbstractPopup.$$$reportNull$$$0(88);
        }
        if ((handler = this.myKeyEventHandler) != null && handler.fun((Object)e)) {
            return true;
        }
        if (AbstractPopup.isCloseRequest(e) && this.myCancelKeyEnabled && !this.mySpeedSearch.isHoldingFilter()) {
            if (this.mySpeedSearchFoundInRootComponent != null && this.mySpeedSearchFoundInRootComponent.isHoldingFilter()) {
                this.mySpeedSearchFoundInRootComponent.reset();
            } else {
                this.cancel(e);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public Dimension getHeaderPreferredSize() {
        Dimension dimension = this.myHeaderPanel.getPreferredSize();
        if (dimension == null) {
            AbstractPopup.$$$reportNull$$$0(89);
        }
        return dimension;
    }

    @NotNull
    public Dimension getFooterPreferredSize() {
        Dimension dimension = this.myAdComponent == null ? new Dimension(0, 0) : this.myAdComponent.getPreferredSize();
        if (dimension == null) {
            AbstractPopup.$$$reportNull$$$0(90);
        }
        return dimension;
    }

    public static boolean isCloseRequest(KeyEvent e) {
        if (e != null && e.getID() == 401) {
            KeymapManager keymapManager = KeymapManager.getInstance();
            if (keymapManager != null) {
                Shortcut[] shortcuts;
                for (Shortcut shortcut : shortcuts = keymapManager.getActiveKeymap().getShortcuts("EditorEscape")) {
                    int m2;
                    KeyboardShortcut keyboardShortcut;
                    if (!(shortcut instanceof KeyboardShortcut) || (keyboardShortcut = (KeyboardShortcut)shortcut).getFirstKeyStroke().getKeyCode() != e.getKeyCode() || keyboardShortcut.getSecondKeyStroke() != null) continue;
                    int m1 = keyboardShortcut.getFirstKeyStroke().getModifiers() & 0xF;
                    return m1 == (m2 = e.getModifiers());
                }
            }
            return e.getKeyCode() == 27 && e.getModifiers() == 0;
        }
        return false;
    }

    @NotNull
    private Point fixLocateByContent(@NotNull Point location, boolean save2) {
        Dimension size2;
        if (location == null) {
            AbstractPopup.$$$reportNull$$$0(91);
        }
        Dimension dimension = size2 = !this.myLocateByContent ? null : this.myHeaderPanel.getPreferredSize();
        if (size2 != null) {
            location.y = location.y - (save2 ? -size2.height : size2.height);
        }
        Point point = location;
        if (point == null) {
            AbstractPopup.$$$reportNull$$$0(92);
        }
        return point;
    }

    protected boolean isBusy() {
        return this.myResizeListener != null && this.myResizeListener.isBusy() || this.myMoveListener != null && this.myMoveListener.isBusy();
    }

    private static Component getFrameOrDialog(Component component2) {
        while (component2 != null) {
            if (component2 instanceof Window) {
                return component2;
            }
            component2 = UIUtil.getParent((Component)component2);
        }
        return null;
    }

    @Nullable
    private static Point getLocationOnScreen(@Nullable Component component2) {
        return component2 == null || !component2.isShowing() ? null : component2.getLocationOnScreen();
    }

    @Nullable
    private static Rectangle getBoundsOnScreen(@Nullable Component component2) {
        Point point = AbstractPopup.getLocationOnScreen(component2);
        return point == null ? null : new Rectangle(point, component2.getSize());
    }

    public static @Unmodifiable @NotNull List<JBPopup> getChildPopups(@NotNull Component component2) {
        if (component2 == null) {
            AbstractPopup.$$$reportNull$$$0(93);
        }
        List list2 = ContainerUtil.filter((Collection)all.toStrongList(), popup2 -> {
            for (Component owner = popup2.getOwner(); owner != null; owner = owner.getParent()) {
                if (!owner.equals(component2)) continue;
                return true;
            }
            return false;
        });
        if (list2 == null) {
            AbstractPopup.$$$reportNull$$$0(94);
        }
        return list2;
    }

    public boolean canShow() {
        return this.myState == State.INIT;
    }

    @Override
    @NotNull
    public Rectangle getConsumedScreenBounds() {
        Rectangle rectangle = this.myWindow.getBounds();
        if (rectangle == null) {
            AbstractPopup.$$$reportNull$$$0(95);
        }
        return rectangle;
    }

    @Override
    public Window getUnderlyingWindow() {
        return this.myWindow.getOwner();
    }

    public void addResizeListener(@NotNull Runnable runnable2, @NotNull Disposable parentDisposable) {
        if (runnable2 == null) {
            AbstractPopup.$$$reportNull$$$0(96);
        }
        if (parentDisposable == null) {
            AbstractPopup.$$$reportNull$$$0(97);
        }
        this.myResizeListeners.add(runnable2);
        Disposer.register((Disposable)parentDisposable, () -> this.myResizeListeners.remove(runnable2));
    }

    private boolean isCancelNeeded(@NotNull WindowEvent event, @Nullable Window popup2) {
        Window window;
        if (event == null) {
            AbstractPopup.$$$reportNull$$$0(98);
        }
        if ((window = event.getWindow()) == null || popup2 == null) {
            return true;
        }
        if (SwingUtilities.isDescendingFrom(window, popup2) || !this.myFocusable && SwingUtilities.isDescendingFrom(popup2, window)) {
            return false;
        }
        if (StartupUiUtil.isWaylandToolkit()) {
            Window popupOwner = popup2.getOwner();
            return !Objects.equals(window, popupOwner);
        }
        return true;
    }

    @Nullable
    private Point getStoredLocation() {
        if (this.myDimensionServiceKey == null) {
            return null;
        }
        return AbstractPopup.getWindowStateService(this.getProjectDependingOnKey(this.myDimensionServiceKey)).getLocation(this.myDimensionServiceKey);
    }

    @Nullable
    private Dimension getStoredSize() {
        if (this.myDimensionServiceKey == null) {
            return null;
        }
        return AbstractPopup.getWindowStateService(this.getProjectDependingOnKey(this.myDimensionServiceKey)).getSize(this.myDimensionServiceKey);
    }

    @NotNull
    private static WindowStateService getWindowStateService(@Nullable Project project2) {
        WindowStateService windowStateService = project2 == null ? WindowStateService.getInstance() : WindowStateService.getInstance((Project)project2);
        if (windowStateService == null) {
            AbstractPopup.$$$reportNull$$$0(99);
        }
        return windowStateService;
    }

    private static <T> T findInComponentHierarchy(@NotNull Component component2, Function<? super @NotNull Component, ? extends @Nullable T> mapper) {
        Object found;
        if (component2 == null) {
            AbstractPopup.$$$reportNull$$$0(100);
        }
        if ((found = mapper.fun((Object)component2)) != null) {
            return (T)found;
        }
        if (component2 instanceof JComponent) {
            for (Component child : ((JComponent)component2).getComponents()) {
                found = AbstractPopup.findInComponentHierarchy(child, mapper);
                if (found == null) continue;
                return (T)found;
            }
        }
        return null;
    }

    @Nullable
    private JScrollBar findHorizontalScrollBar() {
        JScrollPane pane2 = ScrollUtil.findScrollPane((JComponent)this.myContent);
        if (pane2 == null || 31 == pane2.getHorizontalScrollBarPolicy()) {
            return null;
        }
        return pane2.getHorizontalScrollBar();
    }

    private void forHorizontalScrollBar(@NotNull Consumer<? super JScrollBar> consumer) {
        JScrollBar bar2;
        if (consumer == null) {
            AbstractPopup.$$$reportNull$$$0(101);
        }
        if ((bar2 = this.findHorizontalScrollBar()) != null) {
            consumer.consume((Object)bar2);
        }
    }

    public final boolean dispatchInputMethodEvent(@NotNull InputMethodEvent event) {
        boolean isText;
        SpeedSearchSupply supply;
        Object prop;
        if (event == null) {
            AbstractPopup.$$$reportNull$$$0(102);
        }
        if (this.anyModalWindowsAbovePopup()) {
            return false;
        }
        if (this.myComponent != null && (prop = this.myComponent.getClientProperty("EnableIMEForwardingInPopup")) != null && ((Boolean)prop).booleanValue()) {
            return event.isConsumed();
        }
        JComponent comp = this.myPreferredFocusedComponent == null ? this.myComponent : this.myPreferredFocusedComponent;
        SpeedSearchSupply speedSearchSupply = supply = comp == null ? null : SpeedSearchSupply.getSupply((JComponent)comp, (boolean)true);
        if (!event.isConsumed() && supply instanceof SpeedSearchBase) {
            ((SpeedSearchBase)supply).processInputMethodEvent(event);
        }
        if (!event.isConsumed() && comp instanceof ListWithFilter) {
            ((ListWithFilter)comp).processInputMethodEvent(event);
        }
        boolean bl = isText = comp instanceof EditorTextField || comp instanceof JTextComponent;
        if (!event.isConsumed() && !isText && this.mySpeedSearchPatternField != null) {
            this.mySpeedSearchPatternField.getTextEditor().dispatchEvent((AWTEvent)event);
            this.mySpeedSearch.updatePattern(this.mySpeedSearchPatternField.getText());
            this.mySpeedSearch.update();
        }
        return event.isConsumed();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9, 12, 13, 18, 32, 33, 36, 41, 45, 46, 49, 52, 53, 54, 64, 67, 70, 79, 82, 85, 89, 90, 92, 94, 95, 99 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "states";
                break;
            }
            case 2: 
            case 93: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyboardActions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "focusOwners";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 18: 
            case 32: 
            case 33: 
            case 36: 
            case 41: 
            case 45: 
            case 46: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 64: 
            case 67: 
            case 70: 
            case 79: 
            case 82: 
            case 85: 
            case 89: 
            case 90: 
            case 92: 
            case 94: 
            case 95: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/popup/AbstractPopup";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "border";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aContainer";
                break;
            }
            case 15: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentSize";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aComponent";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 26: 
            case 40: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenPoint";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPoint";
                break;
            }
            case 29: 
            case 55: 
            case 56: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 31: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalLocation";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupSize";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layeredPane";
                break;
            }
            case 48: 
            case 59: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 51: 
            case 71: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showOptions";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screen";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchTextField";
                break;
            }
            case 65: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userData";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userDataClass";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 80: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 83: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 86: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 98: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/popup/AbstractPopup";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "init";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPopupBorder";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapToSize";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCenterOf";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getBestPositionFor";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "relativePointByQuickSearch";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "toRelativePoint";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationAboveEditorLineIfPopupIsClippedAtTheBottom";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "relativePointWithDominantRectangle";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredContentSize";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentSize";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationOnScreen";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "createWarning";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "calcHeaderSize";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderPreferredSize";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getFooterPreferredSize";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "fixLocateByContent";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildPopups";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsumedScreenBounds";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "getWindowStateService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "debugState";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 18: 
            case 32: 
            case 33: 
            case 36: 
            case 41: 
            case 45: 
            case 46: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 64: 
            case 67: 
            case 70: 
            case 79: 
            case 82: 
            case 85: 
            case 89: 
            case 90: 
            case 92: 
            case 94: 
            case 95: 
            case 99: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createContentPanel";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setAdText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "wrapToSize";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCenterOf";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "showCenteredInCurrentWindow";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentWindow";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "showInCenterOf";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "showUnderneathOf";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "defaultPointUnderneathOf";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "pointUnderneathOfAlignedHorizontally";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "fitXToComponentScreen";
                break;
            }
            case 28: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "showInScreenCoordinates";
                break;
            }
            case 31: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getBestPositionFor";
                break;
            }
            case 34: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "showInBestPositionFor";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "relativePointByQuickSearch";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "guessBestPopupLocation";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "toRelativePoint";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getLocationAboveEditorLineIfPopupIsClippedAtTheBottom";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "relativePointWithDominantRectangle";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "fitToScreenAdjustingVertically";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "showImpl";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "adjustForAnchor";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "installWindowHook";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "customizeSearchFieldLook";
                break;
            }
            case 65: 
            case 66: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "setLocation";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getContentWindow";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "setSize";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "setBounds";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "stretchContentToOwnerIfNecessary";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "setCaption";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "setUserData";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "isFocused";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "setWarning";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "createWarning";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "setDataProvider";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "setUiDataProvider";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "dispatchKeyEvent";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "fixLocateByContent";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "getChildPopups";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "addResizeListener";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "isCancelNeeded";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "findInComponentHierarchy";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "forHorizontalScrollBar";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "dispatchInputMethodEvent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9, 12, 13, 18, 32, 33, 36, 41, 45, 46, 49, 52, 53, 54, 64, 67, 70, 79, 82, 85, 89, 90, 92, 94, 95, 99 -> new IllegalStateException(string);
        };
    }

    private static enum State {
        NEW,
        INIT,
        SHOWING,
        SHOWN,
        CANCEL,
        DISPOSE;

    }

    public static class MyContentPanel
    extends JPanel
    implements UiCompatibleDataProvider {
        @Nullable
        private UiDataProvider myDataProvider;

        public MyContentPanel(@NotNull PopupBorder border) {
            if (border == null) {
                MyContentPanel.$$$reportNull$$$0(0);
            }
            super(new BorderLayout());
            MnemonicHelper.init((Component)this);
            this.putClientProperty(UIUtil.TEXT_COPY_ROOT, Boolean.TRUE);
            this.setBorder((Border)border);
        }

        public Dimension computePreferredSize() {
            if (this.isPreferredSizeSet()) {
                Dimension setSize = this.getPreferredSize();
                this.setPreferredSize(null);
                Dimension result2 = this.getPreferredSize();
                this.setPreferredSize(setSize);
                return result2;
            }
            return this.getPreferredSize();
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                MyContentPanel.$$$reportNull$$$0(1);
            }
            DataSink.uiDataSnapshot((DataSink)sink, (Object)this.myDataProvider);
        }

        public void setDataProvider(@Nullable UiDataProvider dataProvider) {
            this.myDataProvider = dataProvider;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "border";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/popup/AbstractPopup$MyContentPanel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "uiDataSnapshot";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private record AppliedAdjustments(boolean adjustedHeight) {
    }

    private final class Canceller
    implements AWTEventListener {
        private boolean myEverEntered;

        private Canceller() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            switch (event.getID()) {
                case 205: 
                case 207: {
                    if (!AbstractPopup.this.myCancelOnWindow || AbstractPopup.this.myPopup == null || !AbstractPopup.this.isCancelNeeded((WindowEvent)event, AbstractPopup.this.myPopup.getWindow())) break;
                    ApplicationManager.getApplication().invokeLater(() -> AbstractPopup.this.cancel());
                    break;
                }
                case 504: {
                    if (!this.withinPopup(event)) break;
                    this.myEverEntered = true;
                    break;
                }
                case 501: 
                case 503: {
                    if (AbstractPopup.this.myCancelOnMouseOutCallback == null || !this.myEverEntered || this.withinPopup(event) || !AbstractPopup.this.myCancelOnMouseOutCallback.check((MouseEvent)event)) break;
                    AbstractPopup.this.cancel();
                }
            }
        }

        private boolean withinPopup(@NotNull AWTEvent event) {
            if (event == null) {
                Canceller.$$$reportNull$$$0(0);
            }
            MouseEvent mouse = (MouseEvent)event;
            Rectangle bounds = AbstractPopup.getBoundsOnScreen(AbstractPopup.this.myContent);
            return bounds != null && bounds.contains(mouse.getLocationOnScreen());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ui/popup/AbstractPopup$Canceller", "withinPopup"));
        }
    }

    private final class MyWindowListener
    extends WindowAdapter {
        private MyWindowListener() {
        }

        @Override
        public void windowOpened(WindowEvent e) {
            AbstractPopup.this.updateMaskAndAlpha(AbstractPopup.this.myWindow);
        }

        @Override
        public void windowClosing(WindowEvent e) {
            AbstractPopup.this.resetWindow();
            AbstractPopup.this.cancel();
        }
    }
}

