/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.LafIconLookup;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ActionStepBuilder {
    private final List<PopupFactoryImpl.ActionItem> myListModel;
    private final DataContext myDataContext;
    private final boolean myShowNumbers;
    private final boolean myUseAlphaAsNumbers;
    private final PresentationFactory myPresentationFactory;
    private final boolean myShowDisabled;
    private int myCurrentNumber;
    private boolean myPrependWithSeparator;
    private @NlsContexts.Separator String mySeparatorText;
    private final boolean myHonorActionMnemonics;
    private final String myActionPlace;
    private final ActionUiKind myUiKind;
    private int myMaxIconWidth;
    private int myMaxIconHeight;

    ActionStepBuilder(@NotNull DataContext dataContext2, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabled, boolean honorActionMnemonics, @NotNull String actionPlace, @NotNull ActionUiKind uiKind, @Nullable PresentationFactory presentationFactory) {
        if (dataContext2 == null) {
            ActionStepBuilder.$$$reportNull$$$0(0);
        }
        if (actionPlace == null) {
            ActionStepBuilder.$$$reportNull$$$0(1);
        }
        if (uiKind == null) {
            ActionStepBuilder.$$$reportNull$$$0(2);
        }
        this.myMaxIconWidth = -1;
        this.myMaxIconHeight = -1;
        this.myUseAlphaAsNumbers = useAlphaAsNumbers;
        this.myPresentationFactory = presentationFactory == null ? new PresentationFactory() : presentationFactory;
        this.myListModel = new ArrayList<PopupFactoryImpl.ActionItem>();
        this.myDataContext = dataContext2;
        this.myShowNumbers = showNumbers;
        this.myShowDisabled = showDisabled;
        this.myCurrentNumber = 0;
        this.myPrependWithSeparator = false;
        this.mySeparatorText = null;
        this.myHonorActionMnemonics = honorActionMnemonics;
        this.myActionPlace = actionPlace;
        this.myUiKind = uiKind;
    }

    @NotNull
    public List<PopupFactoryImpl.ActionItem> getItems() {
        List<PopupFactoryImpl.ActionItem> list2 = this.myListModel;
        if (list2 == null) {
            ActionStepBuilder.$$$reportNull$$$0(3);
        }
        return list2;
    }

    public void buildGroup(@NotNull ActionGroup actionGroup) {
        if (actionGroup == null) {
            ActionStepBuilder.$$$reportNull$$$0(4);
        }
        this.appendActionsFromGroup(actionGroup);
        if (this.myListModel.isEmpty()) {
            this.myListModel.add(new PopupFactoryImpl.ActionItem(Utils.EMPTY_MENU_FILLER, Objects.requireNonNull(Utils.EMPTY_MENU_FILLER.getTemplateText())));
        }
    }

    private void calcMaxIconSize(@NotNull List<? extends AnAction> actions) {
        if (actions == null) {
            ActionStepBuilder.$$$reportNull$$$0(5);
        }
        for (AnAction anAction : actions) {
            Icon icon2;
            if (anAction instanceof Separator) continue;
            Presentation presentation2 = this.myPresentationFactory.getPresentation(anAction);
            Pair<Icon, Icon> icons = ActionStepBuilder.calcRawIcons(anAction, presentation2, true);
            Icon icon3 = icon2 = icons.first == null ? (Icon)icons.second : (Icon)icons.first;
            if (icon2 == null) continue;
            int width = icon2.getIconWidth();
            int height = icon2.getIconHeight();
            if (this.myMaxIconWidth < width) {
                this.myMaxIconWidth = width;
            }
            if (this.myMaxIconHeight >= height) continue;
            this.myMaxIconHeight = height;
        }
    }

    private void appendActionsFromGroup(@NotNull ActionGroup actionGroup) {
        if (actionGroup == null) {
            ActionStepBuilder.$$$reportNull$$$0(6);
        }
        List newVisibleActions = Utils.expandActionGroup(actionGroup, this.myPresentationFactory, this.myDataContext, this.myActionPlace, this.myUiKind);
        List filtered = this.myShowDisabled ? newVisibleActions : ContainerUtil.filter(newVisibleActions, o -> o instanceof Separator || this.myPresentationFactory.getPresentation((AnAction)o).isEnabled());
        this.calcMaxIconSize(filtered);
        for (AnAction action2 : filtered) {
            if (action2 instanceof Separator) {
                this.myPrependWithSeparator = true;
                this.mySeparatorText = ((Separator)action2).getText();
                continue;
            }
            this.appendAction(action2);
        }
    }

    private void appendAction(@NotNull AnAction action2) {
        if (action2 == null) {
            ActionStepBuilder.$$$reportNull$$$0(7);
        }
        Character mnemonic = null;
        if (this.myShowNumbers) {
            if (this.myCurrentNumber < 9) {
                mnemonic = Character.valueOf(Character.forDigit(this.myCurrentNumber + 1, 10));
            } else if (this.myCurrentNumber == 9) {
                mnemonic = Character.valueOf('0');
            } else if (this.myUseAlphaAsNumbers) {
                mnemonic = Character.valueOf((char)(65 + this.myCurrentNumber - 10));
            }
            ++this.myCurrentNumber;
        }
        boolean prependSeparator = (!this.myListModel.isEmpty() || this.mySeparatorText != null) && this.myPrependWithSeparator;
        PopupFactoryImpl.ActionItem actionItem = new PopupFactoryImpl.ActionItem(action2, mnemonic, this.myShowNumbers, this.myHonorActionMnemonics, this.myMaxIconWidth, this.myMaxIconHeight, prependSeparator, this.mySeparatorText);
        actionItem.updateFromPresentation(this.myPresentationFactory, this.myActionPlace);
        this.myListModel.add(actionItem);
        this.myPrependWithSeparator = false;
        this.mySeparatorText = null;
    }

    @NotNull
    static Pair<Icon, Icon> calcRawIcons(@NotNull AnAction action2, @NotNull Presentation presentation2, boolean forceChecked) {
        String actionId;
        Icon disabledIcon;
        boolean hideIcon;
        if (action2 == null) {
            ActionStepBuilder.$$$reportNull$$$0(8);
        }
        if (presentation2 == null) {
            ActionStepBuilder.$$$reportNull$$$0(9);
        }
        Icon icon2 = (hideIcon = Boolean.TRUE.equals(presentation2.getClientProperty(MenuItemPresentationFactory.HIDE_ICON))) ? null : presentation2.getIcon();
        Icon selectedIcon = hideIcon ? null : presentation2.getSelectedIcon();
        Icon icon3 = disabledIcon = hideIcon ? null : presentation2.getDisabledIcon();
        if (icon2 == null && selectedIcon == null && ((actionId = ActionManager.getInstance().getId(action2)) == null || !actionId.startsWith("QuickList.")) && action2 instanceof Toggleable && (Toggleable.isSelected((Presentation)presentation2) || forceChecked)) {
            icon2 = LafIconLookup.getIcon((String)"checkmark");
            selectedIcon = LafIconLookup.getSelectedIcon((String)"checkmark");
            disabledIcon = LafIconLookup.getDisabledIcon((String)"checkmark");
        }
        if (!presentation2.isEnabled()) {
            icon2 = disabledIcon != null || icon2 == null ? disabledIcon : IconLoader.getDisabledIcon((Icon)icon2);
            selectedIcon = disabledIcon != null || selectedIcon == null ? disabledIcon : IconLoader.getDisabledIcon((Icon)selectedIcon);
        }
        return new Pair((Object)icon2, (Object)selectedIcon);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionPlace";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiKind";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/popup/ActionStepBuilder";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/popup/ActionStepBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildGroup";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calcMaxIconSize";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendActionsFromGroup";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendAction";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calcRawIcons";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

