/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.popup.IdePopupEventDispatcher;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.StackingPopupDispatcher;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.containers.Stack;
import com.intellij.util.containers.WeakList;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class StackingPopupDispatcherImpl
extends StackingPopupDispatcher
implements AWTEventListener,
KeyEventDispatcher {
    private final Stack<JBPopup> myStack = new Stack();
    private final Collection<JBPopup> myPersistentPopups = new WeakList();
    private final Collection<JBPopup> myAllPopups = new WeakList();

    private StackingPopupDispatcherImpl() {
    }

    public void onPopupShown(JBPopup popup2, boolean inStack) {
        if (inStack) {
            this.myStack.push((Object)popup2);
            if (ApplicationManager.getApplication() != null) {
                IdeEventQueue.getInstance().getPopupManager().push((IdePopupEventDispatcher)StackingPopupDispatcherImpl.getInstance());
            }
        } else if (popup2.isPersistent()) {
            this.myPersistentPopups.add(popup2);
        }
        this.myAllPopups.add(popup2);
    }

    public void onPopupHidden(JBPopup popup2) {
        boolean wasInStack = this.myStack.remove((Object)popup2);
        this.myPersistentPopups.remove(popup2);
        if (wasInStack && this.myStack.isEmpty() && ApplicationManager.getApplication() != null) {
            IdeEventQueue.getInstance().getPopupManager().remove((IdePopupEventDispatcher)this);
        }
        this.myAllPopups.remove(popup2);
    }

    public void hidePersistentPopups() {
        for (JBPopup each : this.myPersistentPopups) {
            if (!each.isNativePopup()) continue;
            each.setUiVisible(false);
        }
    }

    public void restorePersistentPopups() {
        for (JBPopup each : this.myPersistentPopups) {
            if (!each.isNativePopup()) continue;
            each.setUiVisible(true);
        }
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        this.dispatchMouseEvent(event);
    }

    private boolean dispatchMouseEvent(AWTEvent event) {
        if (event.getID() != 501) {
            return false;
        }
        if (this.myStack.isEmpty()) {
            return false;
        }
        AbstractPopup popup2 = (AbstractPopup)this.findPopup();
        MouseEvent mouseEvent = (MouseEvent)event;
        Point point = (Point)mouseEvent.getPoint().clone();
        SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
        boolean needStopFurtherEventProcessing = false;
        while (true) {
            if (popup2 != null && !popup2.isDisposed()) {
                Rectangle bounds;
                Window window = ComponentUtil.getWindow((Component)mouseEvent.getComponent());
                if (window != null && window != popup2.getPopupWindow() && SwingUtilities.isDescendingFrom(window, popup2.getPopupWindow())) {
                    return false;
                }
                JComponent content2 = popup2.getContent();
                if (!UIUtil.isShowing((Component)content2)) {
                    popup2.cancel();
                    return false;
                }
                if (!StartupUiUtil.isWaylandToolkit() ? (bounds = new Rectangle(content2.getLocationOnScreen(), content2.getSize())).contains(point) || !popup2.isCancelOnClickOutside() : window == popup2.getPopupWindow() || !popup2.isCancelOnClickOutside()) {
                    return false;
                }
                if (!popup2.canClose()) {
                    return false;
                }
                if (MenuSelectionManager.defaultManager().getSelectedPath().length > 0) {
                    return false;
                }
                if (StackingPopupDispatcherImpl.needStopFurtherEventProcessing(popup2, mouseEvent)) {
                    needStopFurtherEventProcessing = true;
                }
                popup2.cancel(mouseEvent);
            }
            if (this.myStack.isEmpty() || needStopFurtherEventProcessing) {
                return needStopFurtherEventProcessing;
            }
            popup2 = (AbstractPopup)this.myStack.peek();
            if (popup2 != null && !popup2.isDisposed()) continue;
            this.myStack.pop();
        }
    }

    @ApiStatus.Internal
    @Nullable
    public JBPopup findPopup() {
        while (!this.myStack.isEmpty()) {
            AbstractPopup each = (AbstractPopup)this.myStack.peek();
            if (each != null && !each.isDisposed()) {
                return each;
            }
            this.myStack.pop();
        }
        return null;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        JBPopup popup2;
        boolean closeRequest = AbstractPopup.isCloseRequest(e);
        JBPopup jBPopup = popup2 = closeRequest ? this.findPopup() : this.getFocusedPopup();
        if (popup2 == null) {
            return false;
        }
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if (window instanceof Dialog && ((Dialog)window).isModal() && !SwingUtilities.isDescendingFrom(popup2.getContent(), window)) {
            return false;
        }
        return popup2.dispatchKeyEvent(e);
    }

    public boolean dispatchInputMethodEvent(InputMethodEvent e) {
        JBPopup popup2 = this.getFocusedPopup();
        if (popup2 == null) {
            return false;
        }
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if (window instanceof Dialog && ((Dialog)window).isModal() && !SwingUtilities.isDescendingFrom(popup2.getContent(), window)) {
            return false;
        }
        return popup2.dispatchInputMethodEvent(e);
    }

    @Nullable
    public Component getComponent() {
        return this.myStack.isEmpty() || ((JBPopup)this.myStack.peek()).isDisposed() ? null : ((JBPopup)this.myStack.peek()).getContent();
    }

    @NotNull
    public Stream<JBPopup> getPopupStream() {
        Stream stream = this.myStack.stream();
        if (stream == null) {
            StackingPopupDispatcherImpl.$$$reportNull$$$0(0);
        }
        return stream;
    }

    public boolean dispatch(AWTEvent event) {
        if (event instanceof KeyEvent) {
            return this.dispatchKeyEvent((KeyEvent)event);
        }
        if (event instanceof MouseEvent) {
            return this.dispatchMouseEvent(event);
        }
        if (event instanceof InputMethodEvent) {
            return this.dispatchInputMethodEvent((InputMethodEvent)event);
        }
        return false;
    }

    public boolean requestFocus() {
        if (this.myStack.isEmpty()) {
            return false;
        }
        AbstractPopup popup2 = (AbstractPopup)this.myStack.peek();
        return popup2.requestFocus();
    }

    public boolean close() {
        int next;
        if (!this.closeActivePopup()) {
            return false;
        }
        int size2 = this.myStack.size();
        while (this.closeActivePopup() && size2 != (next = this.myStack.size())) {
            size2 = next;
        }
        return true;
    }

    public void setRestoreFocusSilently() {
        if (this.myStack.isEmpty()) {
            return;
        }
        for (JBPopup each : this.myAllPopups) {
            if (!(each instanceof AbstractPopup)) continue;
            ((AbstractPopup)each).setOk(true);
        }
    }

    public boolean closeActivePopup() {
        if (this.myStack.isEmpty()) {
            return false;
        }
        AbstractPopup popup2 = (AbstractPopup)this.myStack.peek();
        if (popup2 != null && popup2.isVisible() && popup2.isCancelOnWindowDeactivation() && popup2.canClose()) {
            popup2.cancel();
            return !popup2.isVisible();
        }
        return false;
    }

    public boolean isPopupFocused() {
        return this.getFocusedPopup() != null;
    }

    @Nullable
    public JBPopup getFocusedPopup() {
        for (JBPopup each : this.myAllPopups) {
            if (each == null || !each.isFocused()) continue;
            return each;
        }
        return null;
    }

    private static boolean needStopFurtherEventProcessing(@NotNull AbstractPopup popup2, @NotNull MouseEvent mouseEvent) {
        if (popup2 == null) {
            StackingPopupDispatcherImpl.$$$reportNull$$$0(1);
        }
        if (mouseEvent == null) {
            StackingPopupDispatcherImpl.$$$reportNull$$$0(2);
        }
        if (popup2.isDisposed()) {
            return false;
        }
        int modifiers = mouseEvent.getModifiersEx() & 0x3C0;
        if (mouseEvent.getButton() != 1 || modifiers != 0) {
            return false;
        }
        Component toggleButton = PopupUtil.getPopupToggleComponent((JBPopup)popup2);
        Component c = mouseEvent.getComponent();
        if (toggleButton == null || c == null) {
            return false;
        }
        Point pointRelativeToButton = SwingUtilities.convertPoint(c, mouseEvent.getX(), mouseEvent.getY(), toggleButton);
        return toggleButton.contains(pointRelativeToButton);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/popup/StackingPopupDispatcherImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mouseEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPopupStream";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/popup/StackingPopupDispatcherImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "needStopFurtherEventProcessing";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

