/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.ValidateableNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.tree.ChildrenProvider;
import com.intellij.ui.tree.LeafState;
import com.intellij.ui.tree.Reference;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.CachingTreePath;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.AbstractTreeModel;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class StructureTreeModel<Structure extends AbstractTreeStructure>
extends AbstractTreeModel
implements Disposable,
InvokerSupplier,
ChildrenProvider<TreeNode> {
    private static final TreePath ROOT_INVALIDATED = new CachingTreePath((Object)new DefaultMutableTreeNode());
    private static final Logger LOG = Logger.getInstance(StructureTreeModel.class);
    private final Reference<Node> root;
    private final String description;
    private final Invoker invoker;
    @NotNull
    private final Structure structure;
    private volatile Comparator<? super Node> comparator;
    private final ThreadLocal<Reference<FreshChildrenSet>> freshChildrenSet;

    public StructureTreeModel(@NotNull Structure structure, @NotNull Disposable parent) {
        if (structure == null) {
            StructureTreeModel.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            StructureTreeModel.$$$reportNull$$$0(1);
        }
        this(structure, null, parent);
    }

    public StructureTreeModel(@NotNull Structure structure, @Nullable Comparator<? super NodeDescriptor<?>> comparator, @NotNull Disposable parent) {
        if (structure == null) {
            StructureTreeModel.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            StructureTreeModel.$$$reportNull$$$0(3);
        }
        this(structure, comparator, Invoker.forBackgroundThreadWithReadAction((Disposable)parent), parent);
    }

    public StructureTreeModel(@NotNull Structure structure, @Nullable Comparator<? super NodeDescriptor<?>> comparator, @NotNull Invoker invoker, @NotNull Disposable parent) {
        if (structure == null) {
            StructureTreeModel.$$$reportNull$$$0(4);
        }
        if (invoker == null) {
            StructureTreeModel.$$$reportNull$$$0(5);
        }
        if (parent == null) {
            StructureTreeModel.$$$reportNull$$$0(6);
        }
        this.root = new Reference();
        this.freshChildrenSet = ThreadLocal.withInitial(Reference::new);
        this.structure = structure;
        this.description = StructureTreeModel.format(structure.toString());
        this.invoker = invoker;
        this.comparator = comparator == null ? null : StructureTreeModel.wrapToNodeComparator(comparator);
        Disposer.register((Disposable)this, (Disposable)invoker);
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    @NotNull
    public Structure getTreeStructure() {
        Structure Structure2 = this.structure;
        if (Structure2 == null) {
            StructureTreeModel.$$$reportNull$$$0(7);
        }
        return Structure2;
    }

    @NotNull
    private static Comparator<? super Node> wrapToNodeComparator(@NotNull Comparator<? super NodeDescriptor<?>> comparator) {
        if (comparator == null) {
            StructureTreeModel.$$$reportNull$$$0(8);
        }
        Comparator comparator2 = (node1, node2) -> comparator.compare((NodeDescriptor<?>)node1.getDescriptor(), (NodeDescriptor<?>)node2.getDescriptor());
        if (comparator2 == null) {
            StructureTreeModel.$$$reportNull$$$0(9);
        }
        return comparator2;
    }

    public final void setComparator(@Nullable Comparator<? super NodeDescriptor<?>> comparator) {
        if (this.disposed) {
            return;
        }
        if (comparator != null) {
            this.comparator = StructureTreeModel.wrapToNodeComparator(comparator);
            this.invalidateAsync();
        } else if (this.comparator != null) {
            this.comparator = null;
            this.invalidateAsync();
        }
    }

    public void dispose() {
        this.comparator = null;
        Node node = this.root.set(null);
        if (node != null) {
            node.dispose();
        }
        this.treeStructureChanged(null, null, null);
        super.dispose();
    }

    @ApiStatus.Internal
    @NotNull
    public final Invoker getInvoker() {
        Invoker invoker = this.invoker;
        if (invoker == null) {
            StructureTreeModel.$$$reportNull$$$0(10);
        }
        return invoker;
    }

    private boolean isValidThread() {
        if (this.invoker.isValidThread()) {
            return true;
        }
        LOG.warn((Throwable)new IllegalStateException("StructureTreeModel is used from unexpected thread"));
        return false;
    }

    @NotNull
    private <Result> CompletableFuture<Result> onValidThread(@NotNull Function<? super Structure, ? extends Result> function) {
        if (function == null) {
            StructureTreeModel.$$$reportNull$$$0(11);
        }
        CompletableFuture future = new CompletableFuture();
        this.invoker.compute(() -> {
            Object result2;
            if (!this.disposed && (result2 = function.apply((Structure)this.structure)) != null) {
                future.complete(result2);
            }
            if (!future.isDone()) {
                future.completeExceptionally(AsyncPromise.CANCELED);
            }
            return null;
        }).onError(future::completeExceptionally);
        CompletableFuture completableFuture = future;
        if (completableFuture == null) {
            StructureTreeModel.$$$reportNull$$$0(12);
        }
        return completableFuture;
    }

    @NotNull
    private <Result> CompletableFuture<Result> onValidThread(@NotNull TreePath path, @NotNull Function<? super Node, ? extends Result> function) {
        Object component2;
        if (path == null) {
            StructureTreeModel.$$$reportNull$$$0(13);
        }
        if (function == null) {
            StructureTreeModel.$$$reportNull$$$0(14);
        }
        if ((component2 = path.getLastPathComponent()) instanceof Node) {
            Node node = (Node)component2;
            return this.onValidThread(__ -> this.disposed || this.isNodeRemoved(node) ? null : function.apply(node));
        }
        CompletableFuture cancelledFuture = new CompletableFuture();
        cancelledFuture.completeExceptionally(Promises.createError((String)("unexpected node: " + String.valueOf(component2))));
        CompletableFuture completableFuture = cancelledFuture;
        if (completableFuture == null) {
            StructureTreeModel.$$$reportNull$$$0(15);
        }
        return completableFuture;
    }

    @NotNull
    private <Result> CompletableFuture<Result> onValidThread(@NotNull Object element, @NotNull Function<? super Node, ? extends Result> function) {
        if (element == null) {
            StructureTreeModel.$$$reportNull$$$0(16);
        }
        if (function == null) {
            StructureTreeModel.$$$reportNull$$$0(17);
        }
        return this.onValidThread(struct -> {
            Node node = this.root.get();
            if (node == null) {
                return null;
            }
            if (node.matches(element)) {
                return function.apply(node);
            }
            ArrayDeque<Object> stack = new ArrayDeque<Object>();
            Object e = element;
            while (e != null) {
                stack.push(e);
                e = struct.getParentElement(e);
            }
            if (!node.matches(stack.pop())) {
                return null;
            }
            while (!stack.isEmpty()) {
                if ((node = node.findChild(stack.pop())) != null) continue;
                return null;
            }
            return function.apply(node);
        });
    }

    @Deprecated
    @NotNull
    public final Promise<?> invalidate() {
        Promise promise = Promises.asPromise(this.invalidateAsync());
        if (promise == null) {
            StructureTreeModel.$$$reportNull$$$0(18);
        }
        return promise;
    }

    @NotNull
    public final CompletableFuture<?> invalidateAsync() {
        return this.onValidThread(__ -> this.invalidateInternal(null, true));
    }

    @NotNull
    public final Promise<TreePath> invalidate(@NotNull TreePath path, boolean structure) {
        if (path == null) {
            StructureTreeModel.$$$reportNull$$$0(19);
        }
        Promise promise = Promises.asPromise(this.onValidThread(path, (? super Node node) -> this.invalidateInternal((Node)node, structure)));
        if (promise == null) {
            StructureTreeModel.$$$reportNull$$$0(20);
        }
        return promise;
    }

    @NotNull
    public final Promise<TreePath> invalidate(@NotNull Object element, boolean structure) {
        if (element == null) {
            StructureTreeModel.$$$reportNull$$$0(21);
        }
        Promise promise = Promises.asPromise(this.invalidateAsync(element, structure));
        if (promise == null) {
            StructureTreeModel.$$$reportNull$$$0(22);
        }
        return promise;
    }

    @NotNull
    public final CompletableFuture<TreePath> invalidateAsync(@NotNull Object element, boolean structure) {
        if (element == null) {
            StructureTreeModel.$$$reportNull$$$0(23);
        }
        return this.onValidThread(element, (? super Node node) -> this.invalidateInternal((Node)node, structure));
    }

    @Nullable
    private TreePath invalidateInternal(@Nullable Node node, boolean structure) {
        assert (this.invoker.isValidThread());
        while (node != null && !this.isValid(node)) {
            if (LOG.isTraceEnabled()) {
                LOG.debug("invalid element cannot be updated: ", new Object[]{node});
            }
            node = (Node)node.getParent();
            structure = true;
        }
        if (node == null) {
            node = this.root.get();
            if (node != null) {
                node.invalidate();
            }
            this.root.invalidate();
            if (LOG.isTraceEnabled()) {
                LOG.debug("root invalidated: ", new Object[]{node});
            }
            this.treeStructureChanged(null, null, null);
            return ROOT_INVALIDATED;
        }
        boolean updated = node.update();
        if (structure) {
            node.invalidate();
            TreePath path = TreePathUtil.pathToTreeNode(node);
            this.treeStructureChanged(path, null, null);
            return path;
        }
        if (updated) {
            TreePath path = TreePathUtil.pathToTreeNode(node);
            this.treeNodesChanged(path, null, null);
            return path;
        }
        return null;
    }

    public final void expand(@NotNull Object element, @NotNull JTree tree2, @NotNull Consumer<? super TreePath> consumer) {
        if (element == null) {
            StructureTreeModel.$$$reportNull$$$0(24);
        }
        if (tree2 == null) {
            StructureTreeModel.$$$reportNull$$$0(25);
        }
        if (consumer == null) {
            StructureTreeModel.$$$reportNull$$$0(26);
        }
        this.promiseVisitor(element).onSuccess(visitor -> TreeUtil.expand((JTree)tree2, (TreeVisitor)visitor, (Consumer)consumer));
    }

    public final void makeVisible(@NotNull Object element, @NotNull JTree tree2, @NotNull Consumer<? super TreePath> consumer) {
        if (element == null) {
            StructureTreeModel.$$$reportNull$$$0(27);
        }
        if (tree2 == null) {
            StructureTreeModel.$$$reportNull$$$0(28);
        }
        if (consumer == null) {
            StructureTreeModel.$$$reportNull$$$0(29);
        }
        this.promiseVisitor(element).onSuccess(visitor -> TreeUtil.makeVisible((JTree)tree2, (TreeVisitor)visitor, (Consumer)consumer));
    }

    public final void select(@NotNull Object element, @NotNull JTree tree2, @NotNull Consumer<? super TreePath> consumer) {
        if (element == null) {
            StructureTreeModel.$$$reportNull$$$0(30);
        }
        if (tree2 == null) {
            StructureTreeModel.$$$reportNull$$$0(31);
        }
        if (consumer == null) {
            StructureTreeModel.$$$reportNull$$$0(32);
        }
        this.promiseVisitor(element).onSuccess(visitor -> TreeUtil.promiseSelect((JTree)tree2, (TreeVisitor)visitor).onSuccess(consumer));
    }

    @NotNull
    public final Promise<TreeVisitor> promiseVisitor(@NotNull Object element) {
        if (element == null) {
            StructureTreeModel.$$$reportNull$$$0(33);
        }
        Promise promise = Promises.asPromise(this.onValidThread(struct -> new TreeVisitor.ByTreePath(TreePathUtil.pathToCustomNode(element, arg_0 -> ((AbstractTreeStructure)struct).getParentElement(arg_0)), node -> node instanceof Node ? ((Node)node).getElement() : null)));
        if (promise == null) {
            StructureTreeModel.$$$reportNull$$$0(34);
        }
        return promise;
    }

    public final TreeNode getRoot() {
        if (this.disposed || !this.isValidThread()) {
            return null;
        }
        if (!this.root.isValid()) {
            Node newRoot = this.getValidRoot();
            this.root.set(newRoot);
            if (LOG.isTraceEnabled()) {
                LOG.debug("root updated: ", new Object[]{newRoot});
            }
        }
        return this.root.get();
    }

    private Node getNode(Object object, boolean validateChildren) {
        Node node;
        block6: {
            block5: {
                if (this.disposed || !(object instanceof Node)) break block5;
                node = (Node)object;
                if (this.isValidThread()) break block6;
            }
            return null;
        }
        if (this.isNodeRemoved(node)) {
            return null;
        }
        if (validateChildren) {
            this.validateChildren(node);
        }
        return node;
    }

    private void validateChildren(@NotNull Node node) {
        if (node == null) {
            StructureTreeModel.$$$reportNull$$$0(35);
        }
        if (!node.children.isValid()) {
            List<Node> newChildren = this.getValidChildren(node);
            List<Node> oldChildren = node.children.set(newChildren);
            if (oldChildren != null) {
                oldChildren.forEach(child -> child.setParent(null));
            }
            if (newChildren != null) {
                newChildren.forEach(child -> child.setParent(node));
            }
            if (LOG.isTraceEnabled()) {
                LOG.debug("children updated: ", new Object[]{node});
            }
        }
    }

    private boolean isNodeRemoved(@NotNull Node node) {
        if (node == null) {
            StructureTreeModel.$$$reportNull$$$0(36);
        }
        return !node.isNodeAncestor(this.root.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<TreeNode> getChildren(Object object) {
        FreshChildrenSet freshChildren = this.acquireFreshChildrenSet();
        try {
            List<Node> list2;
            Node node = this.getNode(object, true);
            List<Node> list3 = list2 = node == null ? null : node.children.get();
            if (list2 == null || list2.isEmpty()) {
                List<TreeNode> list4 = Collections.emptyList();
                return list4;
            }
            for (Node child : list2) {
                if (freshChildren.isFresh(child)) continue;
                child.update();
            }
            List<Node> list5 = Collections.unmodifiableList(list2);
            return list5;
        }
        finally {
            freshChildren.release();
        }
    }

    public final int getChildCount(Object object) {
        Node node = this.getNode(object, true);
        return node == null ? 0 : node.getChildCount();
    }

    public final TreeNode getChild(Object object, int index) {
        Node node = this.getNode(object, true);
        return node == null ? null : node.getChildAt(index);
    }

    public final boolean isLeaf(Object object) {
        Node node = this.getNode(object, false);
        return node == null || node.isModelLeaf(this::validateChildren);
    }

    public final int getIndexOfChild(Object object, Object child) {
        return object instanceof Node && child instanceof Node ? ((Node)object).getIndex((TreeNode)child) : -1;
    }

    private boolean isValid(@NotNull Node node) {
        if (node == null) {
            StructureTreeModel.$$$reportNull$$$0(37);
        }
        return StructureTreeModel.isValid(this.structure, node.getElement());
    }

    private static boolean isValid(@NotNull AbstractTreeStructure structure, Object element) {
        AbstractTreeNode node;
        if (structure == null) {
            StructureTreeModel.$$$reportNull$$$0(38);
        }
        if (element == null) {
            return false;
        }
        if (element instanceof AbstractTreeNode && null == (node = (AbstractTreeNode)element).getValue()) {
            return false;
        }
        if (element instanceof ValidateableNode && !(node = (ValidateableNode)element).isValid()) {
            return false;
        }
        return structure.isValid(element);
    }

    @Nullable
    private Node getValidRoot() {
        Object element = this.structure.getRootElement();
        if (!StructureTreeModel.isValid(this.structure, element)) {
            return null;
        }
        Node newNode = new Node((AbstractTreeStructure)this.structure, element, null);
        Node oldNode = this.root.get();
        if (oldNode != null && oldNode.canReuse(newNode, element)) {
            return oldNode;
        }
        return newNode;
    }

    @Nullable
    private List<Node> getValidChildren(@NotNull Node node) {
        NodeDescriptor<?> descriptor2;
        if (node == null) {
            StructureTreeModel.$$$reportNull$$$0(39);
        }
        if ((descriptor2 = node.getDescriptor()) == null) {
            return null;
        }
        Object parent = descriptor2.getElement();
        if (!StructureTreeModel.isValid(this.structure, parent)) {
            return null;
        }
        Object[] elements = this.structure.getChildElements(parent);
        if (elements.length == 0) {
            return null;
        }
        ArrayList<Node> list2 = new ArrayList<Node>(elements.length);
        FreshChildrenSet freshChildren = this.freshChildrenSet.get().get();
        for (Object object : elements) {
            ProgressManager.checkCanceled();
            if (!StructureTreeModel.isValid(this.structure, object)) continue;
            Node newChild = new Node((AbstractTreeStructure)this.structure, object, descriptor2);
            if (freshChildren != null) {
                freshChildren.add(newChild);
            }
            list2.add(newChild);
        }
        Comparator<? super Node> comparator = this.comparator;
        if (comparator != null) {
            try {
                list2.sort(comparator);
            }
            catch (IllegalArgumentException exception) {
                StringBuilder sb = new StringBuilder("unexpected sorting failed in ");
                sb.append(this);
                for (Node next : list2) {
                    sb.append('\n').append(next);
                }
                LOG.error(sb.toString(), (Throwable)exception);
            }
        }
        HashMap map2 = new HashMap();
        node.getChildren().forEach(child -> {
            ProgressManager.checkCanceled();
            Object element = child.getElement();
            if (element != null) {
                map2.put(element, child);
            }
        });
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            ProgressManager.checkCanceled();
            Node node2 = (Node)list2.get(i2);
            Node oldNode = (Node)map2.get(node2.getElement());
            if (oldNode == null || !oldNode.canReuse(node2, null)) continue;
            list2.set(i2, oldNode);
        }
        return list2;
    }

    @NotNull
    private FreshChildrenSet acquireFreshChildrenSet() {
        Reference<FreshChildrenSet> ref2 = this.freshChildrenSet.get();
        FreshChildrenSet result2 = ref2.get();
        if (result2 == null) {
            result2 = new FreshChildrenSet();
            ref2.set(result2);
        } else {
            result2.acquire();
        }
        FreshChildrenSet freshChildrenSet = result2;
        if (freshChildrenSet == null) {
            StructureTreeModel.$$$reportNull$$$0(40);
        }
        return freshChildrenSet;
    }

    @Deprecated(forRemoval=true)
    public final TreeNode getRootImmediately() {
        if (!this.root.isValid()) {
            this.root.set(this.getValidRoot());
        }
        return this.root.get();
    }

    public String toString() {
        return this.description;
    }

    @NotNull
    private static String format(@NotNull String prefix) {
        if (prefix == null) {
            StructureTreeModel.$$$reportNull$$$0(41);
        }
        for (StackTraceElement element : new Exception().getStackTrace()) {
            if (StructureTreeModel.class.getName().equals(element.getClassName())) continue;
            String string = prefix + " @ " + element.getFileName() + " : " + element.getLineNumber();
            if (string == null) {
                StructureTreeModel.$$$reportNull$$$0(42);
            }
            return string;
        }
        String string = prefix;
        if (string == null) {
            StructureTreeModel.$$$reportNull$$$0(43);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 9, 10, 12, 15, 18, 20, 22, 34, 40, 42, 43 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invoker";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 34: 
            case 40: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tree/StructureTreeModel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 16: 
            case 21: 
            case 23: 
            case 24: 
            case 27: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 25: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 26: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tree/StructureTreeModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeStructure";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapToNodeComparator";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvoker";
                break;
            }
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "onValidThread";
                break;
            }
            case 18: 
            case 20: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "invalidate";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseVisitor";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "acquireFreshChildrenSet";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 34: 
            case 40: 
            case 42: 
            case 43: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "wrapToNodeComparator";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "onValidThread";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "invalidate";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "invalidateAsync";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "makeVisible";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "promiseVisitor";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "validateChildren";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isNodeRemoved";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getValidChildren";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 9, 10, 12, 15, 18, 20, 22, 34, 40, 42, 43 -> new IllegalStateException(string);
        };
    }

    private static final class Node
    extends DefaultMutableTreeNode
    implements LeafState.Supplier {
        private final Reference<List<Node>> children;
        private LeafState leafState;
        private final int hashCode;

        Node(@NotNull AbstractTreeStructure structure, @NotNull Object element, NodeDescriptor<?> parent) {
            if (structure == null) {
                Node.$$$reportNull$$$0(0);
            }
            if (element == null) {
                Node.$$$reportNull$$$0(1);
            }
            this(structure.createDescriptor(element, parent), structure.getLeafState(element), element.hashCode());
        }

        Node(@NotNull NodeDescriptor descriptor2, @NotNull LeafState leafState, int hashCode) {
            if (descriptor2 == null) {
                Node.$$$reportNull$$$0(2);
            }
            if (leafState == null) {
                Node.$$$reportNull$$$0(3);
            }
            super(descriptor2, leafState != LeafState.ALWAYS);
            this.children = new Reference();
            this.hashCode = hashCode;
            this.setLeafState(leafState);
            this.update();
        }

        private void dispose() {
            this.setParent(null);
            List list2 = this.children.set(null);
            if (list2 != null) {
                list2.forEach(Node::dispose);
            }
        }

        private boolean canReuse(@NotNull Node node, Object element) {
            if (node == null) {
                Node.$$$reportNull$$$0(4);
            }
            if (this.allowsChildren != node.allowsChildren || this.hashCode != node.hashCode) {
                return false;
            }
            if (element != null && !this.matches(element)) {
                return false;
            }
            this.userObject = node.userObject;
            this.setLeafState(this.leafState);
            return true;
        }

        private boolean update() {
            NodeDescriptor<?> descriptor2 = this.getDescriptor();
            return descriptor2 != null && descriptor2.update();
        }

        private void invalidate() {
            if (this.leafState != LeafState.ALWAYS) {
                this.getChildren().forEach(Node::invalidate);
                this.children.invalidate();
                if (LOG.isTraceEnabled()) {
                    LOG.debug("node invalidated: ", new Object[]{this});
                }
            }
        }

        private boolean matches(@NotNull Object element) {
            if (element == null) {
                Node.$$$reportNull$$$0(5);
            }
            return this.matches(element, element.hashCode());
        }

        private boolean matches(@NotNull Object element, int hashCode) {
            if (element == null) {
                Node.$$$reportNull$$$0(6);
            }
            return this.hashCode == hashCode && element.equals(this.getElement());
        }

        private Node findChild(@NotNull Object element) {
            List<Node> list2;
            if (element == null) {
                Node.$$$reportNull$$$0(7);
            }
            if ((list2 = this.children.get()) != null) {
                int hashCode;
                Node result2;
                if (!list2.isEmpty() && (result2 = (Node)ContainerUtil.find(list2, arg_0 -> Node.lambda$findChild$0(element, hashCode = element.hashCode(), arg_0))) != null) {
                    return result2;
                }
                if (LOG.isTraceEnabled()) {
                    LOG.debug("node '", new Object[]{this.getElement(), "' have no child: ", element});
                }
            } else if (LOG.isTraceEnabled()) {
                LOG.debug("node '", new Object[]{this.getElement(), "' have no loaded children"});
            }
            return null;
        }

        @NotNull
        private List<Node> getChildren() {
            List<Node> list2 = this.children.get();
            List<Node> list3 = list2 != null ? list2 : Collections.emptyList();
            if (list3 == null) {
                Node.$$$reportNull$$$0(8);
            }
            return list3;
        }

        private NodeDescriptor<?> getDescriptor() {
            Object object = this.getUserObject();
            return object instanceof NodeDescriptor ? (NodeDescriptor)object : null;
        }

        private Object getElement() {
            NodeDescriptor<?> descriptor2 = this.getDescriptor();
            return descriptor2 == null ? null : descriptor2.getElement();
        }

        @Override
        public void setUserObject(Object object) {
            throw new UnsupportedOperationException("cannot modify node");
        }

        @Override
        public void setAllowsChildren(boolean value) {
            throw new UnsupportedOperationException("cannot modify node");
        }

        @Override
        public Object clone() {
            throw new UnsupportedOperationException("cannot clone node");
        }

        @Override
        public void insert(MutableTreeNode child, int index) {
            throw new UnsupportedOperationException("cannot insert node");
        }

        @Override
        public void remove(int index) {
            throw new UnsupportedOperationException("cannot remove node");
        }

        public Enumeration children() {
            return Collections.enumeration(this.getChildren());
        }

        @Override
        public TreeNode getChildAt(int index) {
            List<Node> list2 = this.getChildren();
            return 0 <= index && index < list2.size() ? (TreeNode)list2.get(index) : null;
        }

        @Override
        public int getChildCount() {
            return this.getChildren().size();
        }

        boolean isModelLeaf(@Nullable Consumer<? super Node> validator2) {
            if (null == this.getParent()) {
                return false;
            }
            if (this.leafState == LeafState.ALWAYS) {
                return true;
            }
            if (this.leafState == LeafState.NEVER) {
                return false;
            }
            if (this.leafState == LeafState.DEFAULT && validator2 != null) {
                validator2.accept(this);
            }
            return this.children.isValid() && super.isLeaf();
        }

        private void setLeafState(@NotNull LeafState leafState) {
            if (leafState == null) {
                Node.$$$reportNull$$$0(9);
            }
            this.leafState = leafState;
            if (leafState == LeafState.ALWAYS) {
                this.children.set(null);
            }
        }

        @Override
        public int getIndex(@NotNull TreeNode child) {
            if (child == null) {
                Node.$$$reportNull$$$0(10);
            }
            return child instanceof Node && this.isNodeChild(child) ? this.getChildren().indexOf(child) : -1;
        }

        @NotNull
        public LeafState getLeafState() {
            LeafState leafState = this.leafState;
            if (leafState == null) {
                Node.$$$reportNull$$$0(11);
            }
            return leafState;
        }

        private static /* synthetic */ boolean lambda$findChild$0(Object element, int hashCode, Node node) {
            return node.matches(element, hashCode);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "structure";
                    break;
                }
                case 1: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leafState";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/StructureTreeModel$Node";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/StructureTreeModel$Node";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLeafState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "canReuse";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "matches";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "findChild";
                    break;
                }
                case 8: 
                case 11: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "setLeafState";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getIndex";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 8, 11 -> new IllegalStateException(string);
            };
        }
    }

    private class FreshChildrenSet {
        private final AtomicInteger depth = new AtomicInteger(1);
        private final IdentityHashMap<Node, Boolean> set = new IdentityHashMap();

        private FreshChildrenSet() {
        }

        void acquire() {
            this.depth.incrementAndGet();
        }

        void release() {
            if (this.depth.decrementAndGet() == 0) {
                StructureTreeModel.this.freshChildrenSet.get().set(null);
            }
        }

        void add(@NotNull Node child) {
            if (child == null) {
                FreshChildrenSet.$$$reportNull$$$0(0);
            }
            this.set.put(child, Boolean.TRUE);
        }

        boolean isFresh(@NotNull Node child) {
            if (child == null) {
                FreshChildrenSet.$$$reportNull$$$0(1);
            }
            return this.set.containsKey(child);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "child";
            objectArray2[1] = "com/intellij/ui/tree/StructureTreeModel$FreshChildrenSet";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isFresh";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

