/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.animation;

import com.intellij.openapi.Disposable;
import com.intellij.util.animation.ShowHideAnimator;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0006\u0010\u000bJ\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010!\u001a\u00020%J\u0016\u0010&\u001a\u00020\"2\u0006\u0010#\u001a\u00020'2\u0006\u0010!\u001a\u00020%R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000bR\"\u0010\u0010\u001a\u0004\u0018\u00010\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R$\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00188F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006("}, d2={"Lcom/intellij/util/animation/AlphaAnimationContext;", "", "base", "Ljava/awt/AlphaComposite;", "consumer", "Ljava/util/function/Consumer;", "<init>", "(Ljava/awt/AlphaComposite;Ljava/util/function/Consumer;)V", "(Ljava/util/function/Consumer;)V", "component", "Ljava/awt/Component;", "(Ljava/awt/Component;)V", "getComponent", "()Ljava/awt/Component;", "setComponent", "value", "composite", "getComposite", "()Ljava/awt/AlphaComposite;", "animator", "Lcom/intellij/util/animation/ShowHideAnimator;", "getAnimator", "()Lcom/intellij/util/animation/ShowHideAnimator;", "visible", "", "isVisible", "()Z", "setVisible", "(Z)V", "disposable", "Lcom/intellij/openapi/Disposable;", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "paint", "", "g", "Ljava/awt/Graphics;", "Ljava/lang/Runnable;", "paintWithComposite", "Ljava/awt/Graphics2D;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class AlphaAnimationContext {
    @NotNull
    private final AlphaComposite base;
    @NotNull
    private final Consumer<AlphaComposite> consumer;
    @Nullable
    private Component component;
    @Nullable
    private AlphaComposite composite;
    @NotNull
    private final ShowHideAnimator animator;

    public AlphaAnimationContext(@NotNull AlphaComposite base, @NotNull Consumer<AlphaComposite> consumer) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.base = base;
        this.consumer = consumer;
        this.animator = new ShowHideAnimator(arg_0 -> AlphaAnimationContext.animator$lambda$0(this, arg_0));
    }

    public AlphaAnimationContext(@NotNull Consumer<AlphaComposite> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        AlphaComposite alphaComposite = AlphaComposite.SrcOver;
        Intrinsics.checkNotNullExpressionValue((Object)alphaComposite, (String)"SrcOver");
        this(alphaComposite, consumer);
    }

    public AlphaAnimationContext(@NotNull Component component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        this(arg_0 -> AlphaAnimationContext._init_$lambda$0(component2, arg_0));
        this.component = component2;
    }

    @Nullable
    public final Component getComponent() {
        return this.component;
    }

    public final void setComponent(@Nullable Component component2) {
        this.component = component2;
    }

    @Nullable
    public final AlphaComposite getComposite() {
        return this.composite;
    }

    @NotNull
    public final ShowHideAnimator getAnimator() {
        return this.animator;
    }

    public final boolean isVisible() {
        return this.composite != null;
    }

    public final void setVisible(boolean visible) {
        ShowHideAnimator.setVisible$default(this.animator, visible, null, () -> AlphaAnimationContext._set_isVisible_$lambda$0(this, visible), 2, null);
    }

    @NotNull
    public final Disposable getDisposable() {
        return this.animator.getDisposable();
    }

    public final void paint(@NotNull Graphics g, @NotNull Runnable paint) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        if (g instanceof Graphics2D) {
            this.paintWithComposite((Graphics2D)g, paint);
        } else if (this.composite != null) {
            paint.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paintWithComposite(@NotNull Graphics2D g, @NotNull Runnable paint) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        AlphaComposite alphaComposite = this.composite;
        if (alphaComposite != null) {
            AlphaComposite it = alphaComposite;
            boolean bl = false;
            Composite old = g.getComposite();
            try {
                g.setComposite(it);
                paint.run();
            }
            finally {
                g.setComposite(old);
            }
        }
    }

    private static final void _init_$lambda$0(Component $component, AlphaComposite it) {
        if ($component.isShowing()) {
            $component.repaint();
        }
    }

    private static final void animator$lambda$0(AlphaAnimationContext this$0, double it) {
        this$0.composite = it <= 0.0 ? null : (it >= 1.0 ? this$0.base : this$0.base.derive((float)it));
        this$0.consumer.accept(this$0.composite);
    }

    private static final Unit _set_isVisible_$lambda$0(AlphaAnimationContext this$0, boolean $visible) {
        block0: {
            Component component2 = this$0.component;
            if (component2 == null) break block0;
            component2.setVisible($visible);
        }
        return Unit.INSTANCE;
    }
}

