/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.socketConnection.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.io.socketConnection.AbstractResponse;
import com.intellij.util.io.socketConnection.AbstractResponseHandler;
import com.intellij.util.io.socketConnection.AbstractResponseToRequestHandler;
import com.intellij.util.io.socketConnection.ResponseReader;
import com.intellij.util.io.socketConnection.ResponseToRequest;
import com.intellij.util.io.socketConnection.SocketConnection;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public final class ResponseProcessor<R extends AbstractResponse> {
    private static final Logger LOG = Logger.getInstance(ResponseProcessor.class);
    private final Int2ObjectMap<AbstractResponseToRequestHandler<?>> myHandlers;
    private final MultiValuesMap<Class<? extends R>, AbstractResponseHandler<? extends R>> myClassHandlers;
    private final Int2ObjectMap<TimeoutHandler> myTimeoutHandlers;
    private boolean myStopped;
    private final Object myLock;
    private Thread myThread;
    private final Alarm myTimeoutAlarm;

    public ResponseProcessor(@NotNull SocketConnection<?, R> connection) {
        if (connection == null) {
            ResponseProcessor.$$$reportNull$$$0(0);
        }
        this.myHandlers = new Int2ObjectOpenHashMap();
        this.myClassHandlers = new MultiValuesMap();
        this.myTimeoutHandlers = new Int2ObjectOpenHashMap();
        this.myLock = new Object();
        this.myTimeoutAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, connection);
    }

    public void startReading(ResponseReader<? extends R> reader) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            this.myThread = Thread.currentThread();
            try {
                Object r2;
                while ((r2 = reader.readResponse()) != null) {
                    if (r2 instanceof ResponseToRequest) {
                        int requestId = ((ResponseToRequest)r2).getRequestId();
                        this.processResponse(requestId, r2);
                        continue;
                    }
                    this.processResponse(r2);
                }
            }
            catch (InterruptedException r2) {
                Object r2 = this.myLock;
                synchronized (r2) {
                    this.myStopped = true;
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
            finally {
                Object object = this.myLock;
                synchronized (object) {
                    this.myStopped = true;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResponse(int requestId, R response) {
        AbstractResponseToRequestHandler handler;
        Object object = this.myLock;
        synchronized (object) {
            this.myTimeoutHandlers.remove(requestId);
        }
        Object object2 = this.myLock;
        synchronized (object2) {
            handler = (AbstractResponseToRequestHandler)this.myHandlers.remove(requestId);
            if (handler == null) {
                return;
            }
        }
        if (!handler.processResponse(response)) {
            object2 = this.myLock;
            synchronized (object2) {
                this.myHandlers.put(requestId, (Object)handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResponse(R response) {
        SmartList handlers;
        Class<?> responseClass = response.getClass();
        Iterator iterator = this.myLock;
        synchronized (iterator) {
            Collection<AbstractResponseHandler<? extends R>> responseHandlers = this.myClassHandlers.get(responseClass);
            if (responseHandlers == null) {
                return;
            }
            handlers = new SmartList(responseHandlers);
        }
        for (AbstractResponseHandler handler : handlers) {
            handler.processResponse(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopReading() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myStopped) {
                return;
            }
            this.myStopped = true;
        }
        if (this.myThread != null) {
            this.myThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends R> void registerHandler(@NotNull Class<? extends T> responseClass, @NotNull AbstractResponseHandler<T> handler) {
        if (responseClass == null) {
            ResponseProcessor.$$$reportNull$$$0(1);
        }
        if (handler == null) {
            ResponseProcessor.$$$reportNull$$$0(2);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myClassHandlers.put(responseClass, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHandler(int id2, @NotNull AbstractResponseToRequestHandler<?> handler) {
        if (handler == null) {
            ResponseProcessor.$$$reportNull$$$0(3);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myHandlers.put(id2, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkTimeout() {
        LOG.debug("Checking timeout");
        ArrayList<TimeoutHandler> timedOut = new ArrayList<TimeoutHandler>();
        Iterator iterator = this.myLock;
        synchronized (iterator) {
            long time = System.currentTimeMillis();
            ObjectIterator iterator2 = this.myTimeoutHandlers.int2ObjectEntrySet().iterator();
            while (iterator2.hasNext()) {
                Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator2.next();
                TimeoutHandler b = (TimeoutHandler)entry.getValue();
                if (time <= b.myLastTime) continue;
                timedOut.add(b);
                iterator2.remove();
            }
        }
        for (TimeoutHandler handler : timedOut) {
            LOG.debug("performing timeout action: " + String.valueOf(handler.myAction));
            handler.myAction.run();
        }
        this.scheduleTimeoutCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleTimeoutCheck() {
        Ref nextTime = Ref.create((Object)Long.MAX_VALUE);
        Object object = this.myLock;
        synchronized (object) {
            if (this.myTimeoutHandlers.isEmpty()) {
                return;
            }
            for (TimeoutHandler value : this.myTimeoutHandlers.values()) {
                nextTime.set((Object)Math.min((Long)nextTime.get(), value.myLastTime));
            }
        }
        int delay = (int)((Long)nextTime.get() - System.currentTimeMillis() + 100L);
        LOG.debug("schedule timeout check in " + delay + "ms");
        if (delay > 10) {
            this.myTimeoutAlarm.cancelAllRequests();
            this.myTimeoutAlarm.addRequest(() -> this.checkTimeout(), delay);
        } else {
            this.checkTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTimeoutHandler(int commandId, int timeout, Runnable onTimeout) {
        Object object = this.myLock;
        synchronized (object) {
            this.myTimeoutHandlers.put(commandId, (Object)new TimeoutHandler(onTimeout, System.currentTimeMillis() + (long)timeout));
        }
        this.scheduleTimeoutCheck();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "responseClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/socketConnection/impl/ResponseProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "registerHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class TimeoutHandler {
        private final Runnable myAction;
        private final long myLastTime;

        private TimeoutHandler(Runnable action2, long lastTime) {
            this.myAction = action2;
            this.myLastTime = lastTime;
        }
    }
}

