/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.OrderedSet;
import com.intellij.util.ui.CollectionItemEditor;
import com.intellij.util.ui.ElementProducer;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import javax.swing.ListSelectionModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CollectionModelEditor<T, E extends CollectionItemEditor<T>>
implements ElementProducer<T> {
    protected static final Logger LOG = Logger.getInstance(CollectionModelEditor.class);
    protected final E itemEditor;
    protected final ModelHelper helper;

    protected CollectionModelEditor(@NotNull E itemEditor2) {
        if (itemEditor2 == null) {
            CollectionModelEditor.$$$reportNull$$$0(0);
        }
        this.helper = new ModelHelper();
        this.itemEditor = itemEditor2;
    }

    public T createElement() {
        return (T)ReflectionUtil.newInstance(this.itemEditor.getItemClass());
    }

    public boolean canCreateElement() {
        return true;
    }

    @NotNull
    protected abstract List<T> getItems();

    public void reset(@NotNull List<? extends T> originalItems) {
        if (originalItems == null) {
            CollectionModelEditor.$$$reportNull$$$0(1);
        }
        this.helper.reset(originalItems);
    }

    public final boolean isModified() {
        List<T> items2 = this.getItems();
        OrderedSet oldItems = this.helper.originalItems;
        if (items2.size() != oldItems.size()) {
            return true;
        }
        int size2 = items2.size();
        for (int i2 = 0; i2 < size2; ++i2) {
            if (items2.get(i2).equals(oldItems.get(i2))) continue;
            return true;
        }
        return false;
    }

    public void processModifiedItems(@NotNull BiPredicate<? super T, ? super T> processor2) {
        if (processor2 == null) {
            CollectionModelEditor.$$$reportNull$$$0(2);
        }
        this.helper.process(processor2);
    }

    @NotNull
    public final T getMutable(@NotNull T item) {
        if (item == null) {
            CollectionModelEditor.$$$reportNull$$$0(3);
        }
        Object t = this.helper.getMutable(item, -1);
        if (t == null) {
            CollectionModelEditor.$$$reportNull$$$0(4);
        }
        return t;
    }

    protected boolean isEditable(@NotNull T item) {
        if (item == null) {
            CollectionModelEditor.$$$reportNull$$$0(5);
        }
        return true;
    }

    protected void silentlyReplaceItem(@NotNull T oldItem, @NotNull T newItem, int index) {
        if (oldItem == null) {
            CollectionModelEditor.$$$reportNull$$$0(6);
        }
        if (newItem == null) {
            CollectionModelEditor.$$$reportNull$$$0(7);
        }
        List<T> items2 = this.getItems();
        items2.set(index == -1 ? ContainerUtil.indexOfIdentity(items2, oldItem) : index, newItem);
    }

    protected final boolean areSelectedItemsRemovable(@NotNull ListSelectionModel selectionMode) {
        if (selectionMode == null) {
            CollectionModelEditor.$$$reportNull$$$0(8);
        }
        int minSelectionIndex = selectionMode.getMinSelectionIndex();
        int maxSelectionIndex = selectionMode.getMaxSelectionIndex();
        if (minSelectionIndex < 0 || maxSelectionIndex < 0) {
            return false;
        }
        List<T> items2 = this.getItems();
        for (int i2 = minSelectionIndex; i2 <= maxSelectionIndex; ++i2) {
            if (!this.itemEditor.isRemovable(items2.get(i2))) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalItems";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/CollectionModelEditor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldItem";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newItem";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/CollectionModelEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processModifiedItems";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMutable";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isEditable";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "silentlyReplaceItem";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "areSelectedItemsRemovable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    protected final class ModelHelper {
        final OrderedSet<T> originalItems = new OrderedSet(HashingStrategy.identity());
        private final Map<T, T> modifiedToOriginal = new IdentityHashMap();
        private final Map<T, T> originalToModified = new IdentityHashMap();

        protected ModelHelper() {
        }

        public void reset(@Nullable List<? extends T> newOriginalItems) {
            if (newOriginalItems != null) {
                this.originalItems.clear();
                this.originalItems.addAll(newOriginalItems);
            }
            this.modifiedToOriginal.clear();
            this.originalToModified.clear();
        }

        public void remove(@NotNull T item) {
            Object original;
            if (item == null) {
                ModelHelper.$$$reportNull$$$0(0);
            }
            if ((original = this.modifiedToOriginal.remove(item)) != null) {
                this.originalToModified.remove(original);
            }
        }

        public boolean isMutable(@NotNull T item) {
            if (item == null) {
                ModelHelper.$$$reportNull$$$0(1);
            }
            return this.modifiedToOriginal.containsKey(item) || !this.originalItems.contains(item);
        }

        @NotNull
        public T getMutable(@NotNull T item, int index) {
            if (item == null) {
                ModelHelper.$$$reportNull$$$0(2);
            }
            if (this.isMutable(item) || !CollectionModelEditor.this.isEditable(item)) {
                Object t = item;
                if (t == null) {
                    ModelHelper.$$$reportNull$$$0(3);
                }
                return t;
            }
            Object mutable = this.originalToModified.get(item);
            if (mutable == null) {
                mutable = CollectionModelEditor.this.itemEditor.clone(item, false);
                this.modifiedToOriginal.put(mutable, item);
                this.originalToModified.put(item, mutable);
                CollectionModelEditor.this.silentlyReplaceItem(item, mutable, index);
            }
            Object t = mutable;
            if (t == null) {
                ModelHelper.$$$reportNull$$$0(4);
            }
            return t;
        }

        public boolean hasModifiedItems() {
            return !this.modifiedToOriginal.isEmpty();
        }

        public void process(@NotNull BiPredicate<? super T, ? super T> procedure) {
            Object value;
            Map.Entry entry;
            Object key;
            if (procedure == null) {
                ModelHelper.$$$reportNull$$$0(5);
            }
            Iterator iterator = this.modifiedToOriginal.entrySet().iterator();
            while (iterator.hasNext() && procedure.test(key = (entry = iterator.next()).getKey(), value = entry.getValue())) {
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/ui/CollectionModelEditor$ModelHelper";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "procedure";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/ui/CollectionModelEditor$ModelHelper";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMutable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isMutable";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getMutable";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

