/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.ide.BrowserUtil;
import com.intellij.internal.Module;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\"\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0001\u001a\"\u0010\t\u001a\u00020\n2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"BASE_URL", "", "showSources", "", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/internal/Module;", "fileName", "openInIdeaProject", "", "intellij.platform.ide.internal"})
@ApiStatus.Internal
public final class InternalUtilKt {
    @NotNull
    private static final String BASE_URL = "https://github.com/JetBrains/intellij-community/blob/master/";

    @ApiStatus.Internal
    public static final void showSources(@Nullable Project project, @NotNull Module module, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)((Object)module), (String)"module");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (!InternalUtilKt.openInIdeaProject(project, module, fileName)) {
            BrowserUtil.browse((String)(BASE_URL + module.getModuleSrc() + "/" + fileName));
        }
    }

    private static final boolean openInIdeaProject(Project project, Module module, String fileName) {
        if (project == null) {
            return false;
        }
        ModuleManager moduleManager = ModuleManager.Companion.getInstance(project);
        com.intellij.openapi.module.Module module2 = moduleManager.findModuleByName(module.getModuleName());
        if (module2 == null) {
            return false;
        }
        VirtualFile[] virtualFileArray = ProjectUtil.getRootManager((com.intellij.openapi.module.Module)module2).getContentRoots();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
        for (VirtualFile contentRoot : virtualFileArray) {
            VirtualFile file;
            VirtualFile virtualFile = file = contentRoot.findFileByRelativePath(fileName);
            boolean bl = virtualFile != null ? virtualFile.isValid() : false;
            if (!bl) continue;
            new OpenFileDescriptor(project, file).navigate(true);
            return true;
        }
        Intrinsics.checkNotNull(null);
        Object a = null;
        a.getBasePath();
        return false;
    }
}

