/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.anomalies;

import com.intellij.internal.InternalActionsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.Pair;
import java.awt.Component;
import java.awt.Window;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TopAnomaliesAction
extends ActionGroup {
    private static final int LIMIT = 10;

    TopAnomaliesAction() {
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            TopAnomaliesAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        if (Holder.CHILDREN == null) {
            TopAnomaliesAction.$$$reportNull$$$0(1);
        }
        return Holder.CHILDREN;
    }

    private static <K, V> void trimToLimit(Set<Pair<K, V>> top, int limit) {
        int k = 0;
        Iterator<Pair<K, V>> iterator2 = top.iterator();
        while (iterator2.hasNext()) {
            iterator2.next();
            if (++k < limit) continue;
            iterator2.remove();
        }
    }

    private static <K, V extends Integer> String getChange(Set<? extends Pair<K, V>> old, K key, int newResult) {
        for (Pair<K, V> oldPair : old) {
            if (oldPair.first != key) continue;
            int oldResult = (Integer)oldPair.second;
            if (oldResult == newResult) break;
            return (oldResult > newResult ? " -" : " +") + Math.abs(newResult - oldResult);
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/internal/anomalies/TopAnomaliesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static final class Holder {
        private static final Comparator<Pair<?, Integer>> COMPARATOR = (o1, o2) -> {
            int i = (Integer)o2.getSecond() - (Integer)o1.getSecond();
            if (i != 0) {
                return i;
            }
            return Integer.compare(o1.hashCode(), o2.hashCode());
        };
        private static final ResettableAction TOP_PARENTS = new ResettableAction(InternalActionsBundle.messagePointer((String)"action.Anonymous.text.parents", (Object[])new Object[0])){
            final TreeSet<Pair<JComponent, Integer>> top = new TreeSet(COMPARATOR);
            TreeSet<Pair<JComponent, Integer>> old = new TreeSet(COMPARATOR);

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                e.getPresentation().setText("Top 10 Component Parents");
            }

            @Override
            void reset() {
                this.top.clear();
                this.old.clear();
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.old = new TreeSet<Pair<JComponent, Integer>>((SortedSet<Pair<JComponent, Integer>>)this.top);
                this.top.clear();
                Window[] windows = Window.getWindows();
                for (Window window : windows) {
                    if (!window.isVisible() || !(window instanceof JFrame)) continue;
                    JFrame f = (JFrame)window;
                    1.checkParents((JComponent)f.getContentPane(), this.top, 10);
                }
                System.out.println("Top 10 component parents");
                for (Pair pair : this.top) {
                    System.out.println(((JComponent)pair.first).getClass().getName() + " (" + String.valueOf(pair.second) + " children)" + TopAnomaliesAction.getChange(this.old, (JComponent)pair.first, (Integer)pair.second));
                }
            }

            private static void checkParents(JComponent component, Set<Pair<JComponent, Integer>> top, int limit) {
                top.add((Pair<JComponent, Integer>)Pair.create((Object)component, (Object)component.getComponentCount()));
                TopAnomaliesAction.trimToLimit(top, limit);
                for (int i = 0; i < component.getComponentCount(); ++i) {
                    Component child = component.getComponent(i);
                    if (!(child instanceof JComponent)) continue;
                    1.checkParents((JComponent)child, top, limit);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/internal/anomalies/TopAnomaliesAction$Holder$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        private static final ResettableAction TOP_UI_PROPERTIES = new ResettableAction(InternalActionsBundle.messagePointer((String)"action.Anonymous.text.clientproperties", (Object[])new Object[0])){
            final TreeSet<Pair<JComponent, Integer>> top = new TreeSet(COMPARATOR);
            TreeSet<Pair<JComponent, Integer>> old = new TreeSet(COMPARATOR);

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                e.getPresentation().setText("Top 10 ClientProperties");
            }

            @Override
            void reset() {
                this.top.clear();
                this.old.clear();
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                this.old = new TreeSet<Pair<JComponent, Integer>>((SortedSet<Pair<JComponent, Integer>>)this.top);
                this.top.clear();
                Window[] windows = Window.getWindows();
                for (Window window : windows) {
                    if (!window.isVisible() || !(window instanceof JFrame)) continue;
                    JFrame f = (JFrame)window;
                    2.checkClientProperties((JComponent)f.getContentPane(), this.top, 10);
                }
                System.out.println("Top 10 ClientProperties");
                for (Pair pair : this.top) {
                    System.out.println(((JComponent)pair.first).getClass().getName() + " (" + String.valueOf(pair.second) + " properties)" + TopAnomaliesAction.getChange(this.old, (JComponent)pair.first, (Integer)pair.second));
                }
            }

            private static void checkClientProperties(JComponent component, Set<Pair<JComponent, Integer>> top, int limit) {
                try {
                    Field clientProperties = JComponent.class.getDeclaredField("clientProperties");
                    clientProperties.setAccessible(true);
                    Object o = clientProperties.get(component);
                    if (o != null) {
                        Method size = o.getClass().getMethod("size", new Class[0]);
                        size.setAccessible(true);
                        Object sizeResult = size.invoke(o, new Object[0]);
                        if (sizeResult instanceof Integer) {
                            top.add((Pair<JComponent, Integer>)Pair.create((Object)component, (Object)((Integer)sizeResult)));
                            TopAnomaliesAction.trimToLimit(top, limit);
                        }
                    }
                }
                catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException clientProperties) {
                    // empty catch block
                }
                for (int i = 0; i < component.getComponentCount(); ++i) {
                    Component child = component.getComponent(i);
                    if (!(child instanceof JComponent)) continue;
                    2.checkClientProperties((JComponent)child, top, limit);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/internal/anomalies/TopAnomaliesAction$Holder$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        private static final ResettableAction RESET_THEM_ALL = new ResettableAction(() -> InternalActionsBundle.message((String)"action.Anonymous.text.reset.statistics", (Object[])new Object[0])){

            @Override
            void reset() {
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                for (ResettableAction action2 : CHILDREN) {
                    action2.reset();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/anomalies/TopAnomaliesAction$Holder$3", "actionPerformed"));
            }
        };
        private static final ResettableAction[] CHILDREN = new ResettableAction[]{TOP_PARENTS, TOP_UI_PROPERTIES, RESET_THEM_ALL};

        private Holder() {
        }
    }

    private static abstract class ResettableAction
    extends AnAction {
        protected ResettableAction(@NotNull Supplier<String> dynamicText) {
            if (dynamicText == null) {
                ResettableAction.$$$reportNull$$$0(0);
            }
            super(dynamicText);
        }

        abstract void reset();

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ResettableAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dynamicText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/anomalies/TopAnomaliesAction$ResettableAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/anomalies/TopAnomaliesAction$ResettableAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

