/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
@VisibleForTesting
public final class IconsLoadTime
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(IconsLoadTime.class);
    private static final IntList svgStats = new IntArrayList();
    private static final IntList pngStats = new IntArrayList();

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            IconsLoadTime.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            IconsLoadTime.$$$reportNull$$$0(1);
        }
        IconsLoadTime.log(false);
    }

    public static void log(boolean measureStartupLoad) {
        IconsLoadTime.log(measureStartupLoad, false);
        IconsLoadTime.log(measureStartupLoad, true);
    }

    private static void log(boolean measureStartupLoad, boolean isSvg) {
        StatData data = IconsLoadTime.getStatData(measureStartupLoad, isSvg);
        if (data != null) {
            LOG.info(data.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static StatData getStatData(boolean measureStartupLoad, boolean isSvg) {
        IntList stats = IconsLoadTime.getStats(isSvg);
        if (stats.isEmpty()) {
            return null;
        }
        IntList intList = stats;
        synchronized (intList) {
            int size = stats.size();
            int sum = stats.stream().mapToInt(Integer::intValue).sum();
            int average = sum / size;
            int median = size % 2 == 0 ? (Integer)stats.get(size / 2 - 1) + (Integer)stats.get(size / 2) : (Integer)stats.get(size / 2);
            return new StatData(isSvg, measureStartupLoad, sum, average, median, size);
        }
    }

    @NotNull
    private static IntList getStats(boolean isSvg) {
        IntList intList = isSvg ? svgStats : pngStats;
        if (intList == null) {
            IconsLoadTime.$$$reportNull$$$0(2);
        }
        return intList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/IconsLoadTime";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/IconsLoadTime";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStats";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    public static final class StatData {
        public final boolean isSvg;
        public final boolean startup;
        public final int count;
        public final float totalTime;
        public final float averageTime;
        public final float medianTime;

        private StatData(boolean isSvg, boolean startup, int totalTime, int averageTime, int medianTime, int count) {
            this.isSvg = isSvg;
            this.startup = startup;
            this.count = count;
            this.totalTime = (float)totalTime / 1000000.0f;
            this.averageTime = (float)averageTime / 1000000.0f;
            this.medianTime = (float)medianTime / 1000000.0f;
        }

        public String toString() {
            return "load time: " + (this.startup ? "ide_startup=" : "total=") + String.format("%.02fms", Float.valueOf(this.totalTime)) + ", average=" + String.format("%.02fms", Float.valueOf(this.averageTime)) + ", median=" + String.format("%.02fms", Float.valueOf(this.medianTime)) + ", isSvg=" + this.isSvg + "; number of icons: " + this.count;
        }
    }
}

