/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.cachedValueProfiler;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValueProfiler;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.io.URLUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CachedValueProfilerDumpHelper {
    private static final Logger LOG = Logger.getInstance(CachedValueProfilerDumpHelper.class);
    private static final int VERSION = 1;
    private static final String FILE_EXTENSION = "cvperf";
    private static final LightVirtualFile LIVE_PROFILING_FILE;
    private static final String _VERSION = "version";
    private static final String _DATA = "data";
    private static final String _FRAME_ENTER = "enter";
    private static final String _FRAME_EXIT = "exit";
    private static final String _VALUE_COMPUTED = "computed";
    private static final String _VALUE_USED = "used";
    private static final String _VALUE_INVALIDATED = "invalidated";
    private static final String _VALUE_REJECTED = "rejected";
    private static final String _TYPE = "e";
    private static final String _FRAME_ID = "fid";
    private static final String _FRAME_PID = "fpid";
    private static final String _PLACE = "p";
    private static final String _T1 = "t1";
    private static final String _T2 = "t2";
    private static final String _T3 = "t3";

    private CachedValueProfilerDumpHelper() {
    }

    static void toggleProfiling(@NotNull Project project) {
        CachedValueProfiler.EventConsumer prev;
        if (project == null) {
            CachedValueProfilerDumpHelper.$$$reportNull$$$0(0);
        }
        if ((prev = CachedValueProfiler.setEventConsumer(null)) == null) {
            CachedValueProfiler.EventConsumer viewer = CachedValueProfilerDumpHelper.openDumpViewer(project);
            try {
                File tmpFile = CachedValueProfilerDumpHelper.newFile(true);
                CachedValueProfiler.setEventConsumer((CachedValueProfiler.EventConsumer)new FileEventConsumer(tmpFile, viewer));
            }
            catch (IOException ex) {
                CachedValueProfilerDumpHelper.notifyFailure(project, ex);
            }
        } else if (prev instanceof FileEventConsumer) {
            File tmpFile = ((FileEventConsumer)prev).file;
            try {
                ((FileEventConsumer)prev).close();
                ((FileEventConsumer)prev).future.get();
                File file = CachedValueProfilerDumpHelper.newFile(false);
                FileUtil.rename((File)tmpFile, (File)file);
                CachedValueProfilerDumpHelper.notifySuccess(project, file);
            }
            catch (Exception ex) {
                CachedValueProfilerDumpHelper.notifyFailure(project, ex);
                FileUtil.delete((File)tmpFile);
            }
        }
    }

    @Nullable
    private static CachedValueProfiler.EventConsumer openDumpViewer(@NotNull Project project) {
        if (project == null) {
            CachedValueProfilerDumpHelper.$$$reportNull$$$0(1);
        }
        LightVirtualFile file = LIVE_PROFILING_FILE;
        List providers = FileEditorProviderManager.getInstance().getProviderList(project, (VirtualFile)file);
        if (providers.size() == 1 && "cvp-editor".equals(((FileEditorProvider)providers.get(0)).getEditorTypeId())) {
            FileEditor editor;
            FileEditor[] editors = FileEditorManager.getInstance((Project)project).openFile((VirtualFile)file, true, false);
            FileEditor fileEditor = editor = editors.length > 0 ? editors[0] : null;
            if (editor instanceof EventConsumerFactory) {
                return ((EventConsumerFactory)editor).createEventConsumer();
            }
        }
        return null;
    }

    @NotNull
    private static File newFile(boolean tmp) {
        String fileName = "caches-" + new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date(System.currentTimeMillis())) + ".cvperf" + (tmp ? ".tmp" : "");
        return new File(new File(PathManager.getLogPath()), fileName);
    }

    @NotNull
    private static MyWriter newFileWriter(File file) throws IOException {
        return new MyWriter(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(file))));
    }

    private static String placeToString(StackTraceElement place) {
        return place.getClassName() + "|" + place.getMethodName() + "|" + place.getFileName() + "|" + place.getLineNumber();
    }

    private static StackTraceElement placeFromString(String place) {
        List split = StringUtil.split((String)place, (String)"|", (boolean)true, (boolean)false);
        return new StackTraceElement((String)split.get(0), (String)split.get(1), (String)split.get(2), Integer.parseInt((String)split.get(3)));
    }

    private static void notifySuccess(final Project project, File file) {
        String url = FileUtil.getUrl((File)file);
        boolean fileTypeAvailable = "CVP".equals(FileTypeRegistry.getInstance().getFileTypeByFileName(file.getName()).getName());
        String message = MessageFormat.format("Cached values snapshot is captured to<br>{0}.<br>" + (fileTypeAvailable ? "<a href=\"editor:{1}\">Open in Editor</a><br/>" : "") + "<a href=\"{1}\">{2}</a>", file.getPath(), url, RevealFileAction.getActionName());
        NotificationGroupManager.getInstance().getNotificationGroup("Cached value profiling").createNotification(message, NotificationType.INFORMATION).setListener((NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (e.getDescription().startsWith("editor:")) {
                    VirtualFile virtualFile;
                    VirtualFile virtualFile2 = virtualFile = project.isDisposed() ? null : LocalFileSystem.getInstance().findFileByPath(VfsUtilCore.urlToPath((String)VfsUtilCore.fixURLforIDEA((String)URLUtil.unescapePercentSequences((String)e.getDescription().substring(7)))));
                    if (virtualFile != null) {
                        new OpenFileDescriptor(project, virtualFile).navigate(true);
                    }
                } else {
                    RevealFileAction.FILE_SELECTING_LISTENER.hyperlinkUpdate(notification, e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = CachedValueProfilerDumpHelper._TYPE;
                        break;
                    }
                }
                objectArray[1] = "com/intellij/internal/cachedValueProfiler/CachedValueProfilerDumpHelper$1";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).notify(project);
    }

    private static void notifyFailure(@NotNull Project project, @NotNull Throwable exception) {
        if (project == null) {
            CachedValueProfilerDumpHelper.$$$reportNull$$$0(2);
        }
        if (exception == null) {
            CachedValueProfilerDumpHelper.$$$reportNull$$$0(3);
        }
        if (exception instanceof IOException) {
            NotificationGroupManager.getInstance().getNotificationGroup("Cached value profiling").createNotification("Failed to capture snapshot: " + exception.getMessage(), NotificationType.ERROR).notify(project);
            LOG.warn(exception);
        } else {
            LOG.error(exception);
        }
    }

    @NotNull
    static CachedValueProfiler.EventPlace eventPlace(final @Nullable StackTraceElement place) {
        return new CachedValueProfiler.EventPlace(){

            public StackTraceElement getStackFrame() {
                return place;
            }

            public StackTraceElement @Nullable [] getStackTrace() {
                return null;
            }
        };
    }

    public static void loadDump(@NotNull File file, @NotNull CachedValueProfiler.EventConsumer consumer) throws IOException {
        if (file == null) {
            CachedValueProfilerDumpHelper.$$$reportNull$$$0(4);
        }
        if (consumer == null) {
            CachedValueProfilerDumpHelper.$$$reportNull$$$0(5);
        }
        try (JsonReader reader = new JsonReader((Reader)new InputStreamReader((InputStream)new GZIPInputStream(new BufferedInputStream(new FileInputStream(file))), StandardCharsets.UTF_8));){
            reader.beginObject();
            int version = 0;
            while (reader.hasNext()) {
                String name = reader.nextName();
                if (_VERSION.equals(name)) {
                    version = reader.nextInt();
                }
                if (!_DATA.equals(name)) continue;
                break;
            }
            if (version != 1) {
                throw new IOException("Unsupported version: " + version + " (1 required)");
            }
            reader.beginArray();
            String type = "";
            Map places = FactoryMap.create(o -> CachedValueProfilerDumpHelper.placeFromString(o));
            while (reader.hasNext()) {
                StackTraceElement place = null;
                long frame = 0L;
                long parent = 0L;
                long t1 = 0L;
                long t2 = 0L;
                long t3 = 0L;
                reader.beginObject();
                while (reader.hasNext()) {
                    String name = reader.nextName();
                    if (_TYPE.equals(name)) {
                        type = reader.nextString();
                        continue;
                    }
                    if (_PLACE.equals(name)) {
                        place = (StackTraceElement)places.get(reader.nextString());
                        continue;
                    }
                    if (_FRAME_ID.equals(name)) {
                        frame = reader.nextLong();
                        continue;
                    }
                    if (_FRAME_PID.equals(name)) {
                        parent = reader.nextLong();
                        continue;
                    }
                    if (_T1.equals(name)) {
                        t1 = reader.nextLong();
                        continue;
                    }
                    if (_T2.equals(name)) {
                        t2 = reader.nextLong();
                        continue;
                    }
                    if (_T3.equals(name)) {
                        t3 = reader.nextLong();
                        continue;
                    }
                    throw new IOException("unexpected: " + name);
                }
                reader.endObject();
                if (_FRAME_ENTER.equals(type)) {
                    consumer.onFrameEnter(frame, CachedValueProfilerDumpHelper.eventPlace(place), parent, t1);
                    continue;
                }
                if (_FRAME_EXIT.equals(type)) {
                    consumer.onFrameExit(frame, t1, t2, t3);
                    continue;
                }
                if (_VALUE_COMPUTED.equals(type)) {
                    consumer.onValueComputed(frame, CachedValueProfilerDumpHelper.eventPlace(place), t1, t2);
                    continue;
                }
                if (_VALUE_USED.equals(type)) {
                    consumer.onValueUsed(frame, CachedValueProfilerDumpHelper.eventPlace(place), t1, t2);
                    continue;
                }
                if (_VALUE_INVALIDATED.equals(type)) {
                    consumer.onValueInvalidated(frame, CachedValueProfilerDumpHelper.eventPlace(place), t1, t2);
                    continue;
                }
                if (!_VALUE_REJECTED.equals(type)) continue;
                consumer.onValueRejected(frame, CachedValueProfilerDumpHelper.eventPlace(place), t1, t2, t3);
            }
            reader.endArray();
        }
    }

    static {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByExtension(FILE_EXTENSION);
        LIVE_PROFILING_FILE = new LightVirtualFile("Live Caches Profiling", fileType, (CharSequence)"");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/cachedValueProfiler/CachedValueProfilerDumpHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "toggleProfiling";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "openDumpViewer";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyFailure";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "loadDump";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class FileEventConsumer
    extends ExecutorEventConsumer {
        final File file;
        final Future<?> future;

        FileEventConsumer(File file, CachedValueProfiler.EventConsumer second) throws IOException {
            super(new MyQueueExecutor(), second == null ? CachedValueProfilerDumpHelper.newFileWriter(file) : new CompositeEventConsumer(CachedValueProfilerDumpHelper.newFileWriter(file), second));
            this.file = file;
            this.future = ProcessIOExecutorService.INSTANCE.submit((MyQueueExecutor)this.executor);
        }

        @Override
        public void close() {
            try {
                super.close();
            }
            finally {
                ((MyQueueExecutor)this.executor).closed = true;
            }
        }
    }

    public static interface EventConsumerFactory {
        @NotNull
        public CachedValueProfiler.EventConsumer createEventConsumer();
    }

    private static final class MyWriter
    implements CachedValueProfiler.EventConsumer,
    Closeable {
        final JsonWriter myWriter;

        MyWriter(OutputStream out) throws IOException {
            this.myWriter = new JsonWriter((Writer)new OutputStreamWriter(out, StandardCharsets.UTF_8));
            this.myWriter.beginObject();
            this.myWriter.name(CachedValueProfilerDumpHelper._VERSION).value(1L);
            this.myWriter.name(CachedValueProfilerDumpHelper._DATA);
            this.myWriter.beginArray();
        }

        @Override
        public void close() throws IOException {
            try {
                this.myWriter.endArray();
                this.myWriter.endObject();
            }
            finally {
                this.myWriter.close();
            }
        }

        public void onFrameEnter(long frameId, CachedValueProfiler.EventPlace place, long parentId, long time) {
            this.writeImpl(CachedValueProfilerDumpHelper._FRAME_ENTER, frameId, place, 1, time, parentId, -1L);
        }

        public void onFrameExit(long frameId, long start, long computed, long time) {
            this.writeImpl(CachedValueProfilerDumpHelper._FRAME_EXIT, frameId, null, 3, start, computed, time);
        }

        public void onValueComputed(long frameId, CachedValueProfiler.EventPlace place, long start, long time) {
            this.writeImpl(CachedValueProfilerDumpHelper._VALUE_COMPUTED, frameId, place, 2, start, time, -1L);
        }

        public void onValueUsed(long frameId, CachedValueProfiler.EventPlace place, long computed, long time) {
            this.writeImpl(CachedValueProfilerDumpHelper._VALUE_USED, frameId, place, 2, computed, time, -1L);
        }

        public void onValueInvalidated(long frameId, CachedValueProfiler.EventPlace place, long used, long time) {
            this.writeImpl(CachedValueProfilerDumpHelper._VALUE_INVALIDATED, frameId, place, 2, used, time, -1L);
        }

        public void onValueRejected(long frameId, CachedValueProfiler.EventPlace place, long start, long computed, long time) {
            this.writeImpl(CachedValueProfilerDumpHelper._VALUE_REJECTED, frameId, place, 3, start, computed, time);
        }

        private void writeImpl(String type, long frameId, CachedValueProfiler.EventPlace place, int t_num, long t1, long t2, long t3) {
            try {
                this.myWriter.beginObject();
                this.myWriter.name(CachedValueProfilerDumpHelper._TYPE).value(type);
                this.myWriter.name(CachedValueProfilerDumpHelper._FRAME_ID).value(frameId);
                if (Strings.areSameInstance((String)type, (String)CachedValueProfilerDumpHelper._FRAME_ENTER)) {
                    this.myWriter.name(CachedValueProfilerDumpHelper._FRAME_PID).value(t2);
                }
                if (place != null) {
                    StackTraceElement frame = place.getStackFrame();
                    this.myWriter.name(CachedValueProfilerDumpHelper._PLACE).value(frame == null ? null : CachedValueProfilerDumpHelper.placeToString(frame));
                }
                if (t_num > 0) {
                    this.myWriter.name(CachedValueProfilerDumpHelper._T1).value(t1);
                }
                if (t_num > 1) {
                    this.myWriter.name(CachedValueProfilerDumpHelper._T2).value(t2);
                }
                if (t_num > 2) {
                    this.myWriter.name(CachedValueProfilerDumpHelper._T3).value(t3);
                }
                this.myWriter.endObject();
            }
            catch (IOException e) {
                ExceptionUtil.rethrow((Throwable)e);
            }
        }
    }

    static final class CompositeEventConsumer
    implements CachedValueProfiler.EventConsumer,
    Closeable {
        final CachedValueProfiler.EventConsumer first;
        final CachedValueProfiler.EventConsumer second;

        CompositeEventConsumer(@NotNull CachedValueProfiler.EventConsumer first, @NotNull CachedValueProfiler.EventConsumer second) {
            if (first == null) {
                CompositeEventConsumer.$$$reportNull$$$0(0);
            }
            if (second == null) {
                CompositeEventConsumer.$$$reportNull$$$0(1);
            }
            this.first = first;
            this.second = second;
        }

        public void onFrameEnter(long frameId, CachedValueProfiler.EventPlace place, long parentId, long time) {
            this.first.onFrameEnter(frameId, place, parentId, time);
            this.second.onFrameEnter(frameId, place, parentId, time);
        }

        public void onFrameExit(long frameId, long start, long computed, long time) {
            this.first.onFrameExit(frameId, start, computed, time);
            this.second.onFrameExit(frameId, start, computed, time);
        }

        public void onValueComputed(long frameId, CachedValueProfiler.EventPlace place, long start, long time) {
            this.first.onValueComputed(frameId, place, start, time);
            this.second.onValueComputed(frameId, place, start, time);
        }

        public void onValueUsed(long frameId, CachedValueProfiler.EventPlace place, long computed, long time) {
            this.first.onValueUsed(frameId, place, computed, time);
            this.second.onValueUsed(frameId, place, computed, time);
        }

        public void onValueInvalidated(long frameId, CachedValueProfiler.EventPlace place, long used, long time) {
            this.first.onValueInvalidated(frameId, place, used, time);
            this.second.onValueInvalidated(frameId, place, used, time);
        }

        public void onValueRejected(long frameId, CachedValueProfiler.EventPlace place, long start, long computed, long time) {
            this.first.onValueRejected(frameId, place, start, computed, time);
            this.second.onValueRejected(frameId, place, start, computed, time);
        }

        @Override
        public void close() throws IOException {
            Throwable error = null;
            for (CachedValueProfiler.EventConsumer c : (CachedValueProfiler.EventConsumer[])ContainerUtil.ar((Object[])new CachedValueProfiler.EventConsumer[]{this.first, this.second})) {
                if (!(c instanceof Closeable)) continue;
                try {
                    ((Closeable)c).close();
                }
                catch (Throwable ex) {
                    if (error != null) continue;
                    error = ex;
                }
            }
            if (error instanceof IOException) {
                throw (IOException)error;
            }
            ExceptionUtil.rethrowAllAsUnchecked(error);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "first";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "second";
                    break;
                }
            }
            objectArray[1] = "com/intellij/internal/cachedValueProfiler/CachedValueProfilerDumpHelper$CompositeEventConsumer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ExecutorEventConsumer
    implements CachedValueProfiler.EventConsumer,
    Closeable {
        final Executor executor;
        final CachedValueProfiler.EventConsumer consumer;
        volatile boolean closed;

        ExecutorEventConsumer(@NotNull Executor executor, @NotNull CachedValueProfiler.EventConsumer consumer) {
            if (executor == null) {
                ExecutorEventConsumer.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                ExecutorEventConsumer.$$$reportNull$$$0(1);
            }
            this.executor = executor;
            this.consumer = consumer;
        }

        @Override
        public void close() {
            try {
                if (this.consumer instanceof Closeable) {
                    this.executeImpl(() -> {
                        try {
                            ((Closeable)this.consumer).close();
                        }
                        catch (IOException ex) {
                            ExceptionUtil.rethrow((Throwable)ex);
                        }
                    });
                }
            }
            finally {
                this.closed = true;
            }
        }

        void executeImpl(Runnable runnable) {
            if (this.closed) {
                return;
            }
            this.executor.execute(runnable);
        }

        public void onFrameEnter(long frameId, CachedValueProfiler.EventPlace place, long parentId, long time) {
            this.executeImpl(() -> this.consumer.onFrameEnter(frameId, place, parentId, time));
        }

        public void onFrameExit(long frameId, long start, long computed, long time) {
            this.executeImpl(() -> this.consumer.onFrameExit(frameId, start, computed, time));
        }

        public void onValueComputed(long frameId, CachedValueProfiler.EventPlace place, long start, long time) {
            this.executeImpl(() -> this.consumer.onValueComputed(frameId, place, start, time));
        }

        public void onValueUsed(long frameId, CachedValueProfiler.EventPlace place, long computed, long time) {
            this.executeImpl(() -> this.consumer.onValueUsed(frameId, place, computed, time));
        }

        public void onValueInvalidated(long frameId, CachedValueProfiler.EventPlace place, long used, long time) {
            this.executeImpl(() -> this.consumer.onValueInvalidated(frameId, place, used, time));
        }

        public void onValueRejected(long frameId, CachedValueProfiler.EventPlace place, long start, long computed, long time) {
            this.executeImpl(() -> this.consumer.onValueRejected(frameId, place, start, computed, time));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "executor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/internal/cachedValueProfiler/CachedValueProfilerDumpHelper$ExecutorEventConsumer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class MyQueueExecutor
    extends ConcurrentLinkedQueue<Runnable>
    implements Executor,
    Runnable {
        volatile boolean closed;

        MyQueueExecutor() {
        }

        @Override
        public void execute(@NotNull Runnable command) {
            if (command == null) {
                MyQueueExecutor.$$$reportNull$$$0(0);
            }
            if (this.closed) {
                return;
            }
            this.offer(command);
        }

        @Override
        public void run() {
            while (true) {
                Runnable r;
                if ((r = (Runnable)this.poll()) != null) {
                    r.run();
                    continue;
                }
                if (this.closed) break;
                TimeoutUtil.sleep((long)1L);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/internal/cachedValueProfiler/CachedValueProfilerDumpHelper$MyQueueExecutor", "execute"));
        }
    }
}

