/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ml.catboost;

import com.intellij.internal.ml.InconsistentMetadataException;
import com.intellij.internal.ml.ResourcesModelMetadataReader;
import com.intellij.internal.ml.catboost.CatBoostModelMetadataReader;
import com.intellij.internal.ml.catboost.NaiveCatBoostModel;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/internal/ml/catboost/CatBoostResourcesModelMetadataReader;", "Lcom/intellij/internal/ml/ResourcesModelMetadataReader;", "Lcom/intellij/internal/ml/catboost/CatBoostModelMetadataReader;", "metadataHolder", "Ljava/lang/Class;", "featuresDirectory", "", "modelDirectory", "<init>", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)V", "loadModel", "Lcom/intellij/internal/ml/catboost/NaiveCatBoostModel;", "intellij.platform.ide.internal"})
public final class CatBoostResourcesModelMetadataReader
extends ResourcesModelMetadataReader
implements CatBoostModelMetadataReader {
    @NotNull
    private final String modelDirectory;

    public CatBoostResourcesModelMetadataReader(@NotNull Class<?> metadataHolder, @NotNull String featuresDirectory, @NotNull String modelDirectory) {
        Intrinsics.checkNotNullParameter(metadataHolder, (String)"metadataHolder");
        Intrinsics.checkNotNullParameter((Object)featuresDirectory, (String)"featuresDirectory");
        Intrinsics.checkNotNullParameter((Object)modelDirectory, (String)"modelDirectory");
        super(metadataHolder, featuresDirectory);
        this.modelDirectory = modelDirectory;
    }

    @Override
    @NotNull
    public NaiveCatBoostModel loadModel() {
        String resource = this.modelDirectory + "/model.bin";
        InputStream inputStream = this.getMetadataHolder().getClassLoader().getResourceAsStream(resource);
        if (inputStream == null) {
            throw new InconsistentMetadataException("Metadata file not found: " + resource + ". Resources holder: " + this.getMetadataHolder().getName());
        }
        InputStream fileStream = inputStream;
        NaiveCatBoostModel naiveCatBoostModel = NaiveCatBoostModel.loadModel(fileStream);
        Intrinsics.checkNotNullExpressionValue((Object)naiveCatBoostModel, (String)"loadModel(...)");
        return naiveCatBoostModel;
    }
}

