/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.rulerguide;

import com.intellij.internal.rulerguide.ComponentBounds;
import com.intellij.ui.Graphics2DDelegate;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

final class SneakyGraphics2D
extends Graphics2DDelegate {
    private final Collection<ComponentBounds> poi;

    SneakyGraphics2D(Graphics2D g2d) {
        super(g2d);
        this.poi = new LinkedHashSet<ComponentBounds>();
    }

    private SneakyGraphics2D(Graphics2D g2d, Collection<ComponentBounds> poi) {
        super(g2d);
        this.poi = poi;
    }

    public Collection<ComponentBounds> getPOI() {
        return Collections.unmodifiableCollection(this.poi);
    }

    public void drawChars(char[] data, int offset, int length, int x, int y) {
        super.drawChars(data, offset, length, x, y);
        if (data.length > 0) {
            this.updateBaselines(x, y);
        }
    }

    public void drawString(AttributedCharacterIterator iterator2, float x, float y) {
        super.drawString(iterator2, x, y);
        this.updateBaselines(x, y);
    }

    public void drawString(AttributedCharacterIterator iterator2, int x, int y) {
        super.drawString(iterator2, x, y);
        this.updateBaselines(x, y);
    }

    public void drawString(String s, float x, float y) {
        super.drawString(s, x, y);
        if (!s.isEmpty()) {
            this.updateBaselines(x, y);
        }
    }

    public void drawString(String str, int x, int y) {
        super.drawString(str, x, y);
        if (!str.isEmpty()) {
            this.updateBaselines(x, y);
        }
    }

    private void updateBaselines(float x, float y) {
        Point text = (Point)this.getTransform().transform(new Point2D.Float(x, y), new Point());
        Rectangle cb2 = this.getClipBounds();
        Point start = (Point)this.getTransform().transform(new Point(cb2.x, cb2.y), new Point());
        Point end = (Point)this.getTransform().transform(new Point(cb2.x + cb2.width, cb2.y + cb2.height), new Point());
        int minX = Math.min(start.x, end.x);
        int minY = Math.min(start.y, end.y);
        int maxX = Math.max(start.x, end.x);
        int maxY = Math.max(start.y, end.y);
        ComponentBounds bounds = new ComponentBounds(minX, minY, maxX - minX, maxY - minY, -1, -1);
        bounds.horizontalBaseline = text.y - bounds.y;
        bounds.verticalBaseline = text.x - bounds.x;
        this.poi.add(bounds);
    }

    @NotNull
    public Graphics create() {
        return new SneakyGraphics2D((Graphics2D)super.create(), this.poi);
    }
}

